/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.Session;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.ReorderJoins;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestReorderJoins
extends BasePlanTest {
    private RuleTester tester;
    private FunctionResolution functionResolution;
    private static final ImmutableList<List<RowExpression>> TWO_ROWS = ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of());
    private static final QualifiedName RANDOM = QualifiedName.of((String)"random");

    @DataProvider
    public static Object[][] tableSpecificationPermutations() {
        return new Object[][]{{"supplier s, partsupp ps, customer c, orders o"}, {"supplier s, partsupp ps, orders o, customer c"}, {"supplier s, customer c, partsupp ps, orders o"}, {"supplier s, customer c, orders o, partsupp ps"}, {"supplier s, orders o, partsupp ps, customer c"}, {"supplier s, orders o, customer c, partsupp ps"}, {"partsupp ps, supplier s, customer c, orders o"}, {"partsupp ps, supplier s, orders o, customer c"}, {"partsupp ps, customer c, supplier s, orders o"}, {"partsupp ps, customer c, orders o, supplier s"}, {"partsupp ps, orders o, supplier s, customer c"}, {"partsupp ps, orders o, customer c, supplier s"}, {"customer c, supplier s, partsupp ps, orders o"}, {"customer c, supplier s, orders o, partsupp ps"}, {"customer c, partsupp ps, supplier s, orders o"}, {"customer c, partsupp ps, orders o, supplier s"}, {"customer c, orders o, supplier s, partsupp ps"}, {"customer c, orders o, partsupp ps, supplier s"}, {"orders o, supplier s, partsupp ps, customer c"}, {"orders o, supplier s, customer c, partsupp ps"}, {"orders o, partsupp ps, supplier s, customer c"}, {"orders o, partsupp ps, customer c, supplier s"}, {"orders o, customer c, supplier s, partsupp ps"}, {"orders o, customer c, partsupp ps, supplier s"}};
    }

    @BeforeClass
    public void setUp() {
        this.tester = new RuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of((Object)"join_distribution_type", (Object)FeaturesConfig.JoinDistributionType.AUTOMATIC.name(), (Object)"join_reordering_strategy", (Object)FeaturesConfig.JoinReorderingStrategy.AUTOMATIC.name(), (Object)"handle_complex_equi_joins", (Object)"true"), Optional.of(4));
        this.functionResolution = new FunctionResolution(this.tester.getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.tester});
        this.tester = null;
    }

    @Test
    public void testKeepsOutputSymbols() {
        this.assertReorderJoins().on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A2")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(5000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0), (Object)Expressions.variable((String)"A2", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).withExactOutputs("A2"));
    }

    @Test
    public void testHighConfidenceLeftAndLowConfidenceRight() {
        this.assertReorderJoins().setSystemProperty("confidence_based_broadcast_enabled", "TRUE").on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2", (Type)BigintType.BIGINT), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.HIGH).setOutputRowCount(40.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.LOW).setOutputRowCount(10.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1))));
    }

    @Test
    public void testFactConfidenceLeftAndHighConfidenceRight() {
        this.assertReorderJoins().setSystemProperty("confidence_based_broadcast_enabled", "TRUE").on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2", (Type)BigintType.BIGINT), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.FACT).setOutputRowCount(40.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.HIGH).setOutputRowCount(10.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1))));
    }

    @Test
    public void testLowConfidenceLeftAndHighConfidenceRight() {
        this.assertReorderJoins().setSystemProperty("confidence_based_broadcast_enabled", "TRUE").on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2", (Type)BigintType.BIGINT), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.LOW).setOutputRowCount(40.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.HIGH).setOutputRowCount(70.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testHighConfidenceLeftAndFactConfidenceRight() {
        this.assertReorderJoins().setSystemProperty("confidence_based_broadcast_enabled", "TRUE").on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2", (Type)BigintType.BIGINT), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.HIGH).setOutputRowCount(40.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.FACT).setOutputRowCount(70.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testLeftAndRightHighConfidenceRightSmaller() {
        this.assertReorderJoins().setSystemProperty("confidence_based_broadcast_enabled", "TRUE").on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2", (Type)BigintType.BIGINT), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.HIGH).setOutputRowCount(40.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.HIGH).setOutputRowCount(30.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testLeftAndRightHighConfidenceLeftSmaller() {
        this.assertReorderJoins().setSystemProperty("confidence_based_broadcast_enabled", "TRUE").on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("A2", (Type)BigintType.BIGINT), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.HIGH).setOutputRowCount(20.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setConfidence(SourceInfo.ConfidenceLevel.HIGH).setOutputRowCount(30.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1))));
    }

    @Test
    public void testReplicatesAndFlipsWhenOneTableMuchSmaller() {
        this.assertReorderJoins().setSystemProperty("join_max_broadcast_table_size", "1PB").on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionsWhenRequiredBySession() {
        this.assertReorderJoins().on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionsWhenBothTablesEqual() {
        this.assertReorderJoins().on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatesUnrestrictedWhenRequiredBySession() {
        this.assertReorderJoins().on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).setSystemProperty("join_max_broadcast_table_size", "1kB").setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatedScalarJoinEvenWhereSessionRequiresRepartitioned() {
        PlanMatchPattern expectedPlan = PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)));
        PlanNodeStatsEstimate valuesA = PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build();
        PlanNodeStatsEstimate valuesB = PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), p.variable("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", valuesA).overrideStats("valuesB", valuesB).matches(expectedPlan);
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesA"), p.variable("A1")), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1"), (Object)p.variable("A1")), Optional.empty())).overrideStats("valuesA", valuesA).overrideStats("valuesB", valuesB).matches(expectedPlan);
    }

    @Test
    public void testDoesNotFireForCrossJoin() {
        this.assertReorderJoins().on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithNoStats() {
        this.assertReorderJoins().on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), p.variable("B1")), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).doesNotFire();
    }

    @Test
    public void testDoesNotFireForNonDeterministicFilter() {
        this.assertReorderJoins().on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), p.variable("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), p.variable("B1")), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.of(this.comparisonRowExpression(OperatorType.LESS_THAN, (RowExpression)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (RowExpression)Expressions.call((String)RANDOM.toString(), (FunctionHandle)this.tester.getMetadata().getFunctionAndTypeManager().resolveFunction(Optional.empty(), Optional.empty(), FunctionAndTypeManager.qualifyObjectName((QualifiedName)RANDOM), (List)ImmutableList.of()), (Type)BigintType.BIGINT, (List)ImmutableList.of()))))).doesNotFire();
    }

    @Test
    public void testPredicatesPushedDown() {
        this.assertReorderJoins().on(p -> p.join(JoinType.INNER, (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1"), (Object)p.variable("B2")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of(), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1"), (Object)p.variable("B2")), Optional.empty()), (PlanNode)p.values(new PlanNodeId("valuesC"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("C1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("B2"), p.variable("C1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), Optional.of(this.comparisonRowExpression(OperatorType.EQUAL, (RowExpression)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (RowExpression)Expressions.variable((String)"B1", (Type)BigintType.BIGINT))))).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(5.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0), (Object)Expressions.variable((String)"B2", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"C1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C1", "B2")), PlanMatchPattern.values("C1"), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), PlanMatchPattern.values("A1"), PlanMatchPattern.values("B1", "B2"))));
    }

    @Test
    public void testSmallerJoinFirst() {
        this.assertReorderJoins().on(p -> p.join(JoinType.INNER, (PlanNode)p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), (List<List<RowExpression>>)TWO_ROWS), (PlanNode)p.values(new PlanNodeId("valuesB"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("B1"), (Object)p.variable("B2")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1"), (Object)p.variable("B2")), Optional.empty()), (PlanNode)p.values(new PlanNodeId("valuesC"), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("C1")), (List<List<RowExpression>>)TWO_ROWS), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("B2"), p.variable("C1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1")), Optional.of(this.comparisonRowExpression(OperatorType.EQUAL, (RowExpression)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (RowExpression)Expressions.variable((String)"B1", (Type)BigintType.BIGINT))))).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(40.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0), (Object)Expressions.variable((String)"B2", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"C1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(99.0, 199.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), PlanMatchPattern.values("A1"), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C1", "B2")), PlanMatchPattern.values("C1"), PlanMatchPattern.values("B1", "B2"))));
    }

    @Test
    public void testReplicatesWhenNotRestricted() {
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        PlanNodeStatsEstimate buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1")), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").on(p -> p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.variable("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.variable("B1")), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("A1"), p.variable("B1"))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("A1"), (Object)p.variable("B1")), Optional.empty())).overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReorderAndReplicate() {
        int aRows = 10;
        int bRows = 10000;
        PlanNodeStatsEstimate probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"A1", (Type)VarcharType.VARCHAR), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        PlanNodeStatsEstimate buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addVariableStatistics((Map)ImmutableMap.of((Object)Expressions.variable((String)"B1", (Type)VarcharType.VARCHAR), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "10MB").on(p -> {
            VariableReferenceExpression a1 = p.variable("A1", (Type)VarcharType.VARCHAR);
            VariableReferenceExpression b1 = p.variable("B1", (Type)VarcharType.VARCHAR);
            return p.join(JoinType.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(a1, b1)), (List<VariableReferenceExpression>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test(dataProvider="tableSpecificationPermutations")
    public void testComplexEquiJoinCriteria(String tableSpecificationOrder) {
        String query = "select 1 from " + tableSpecificationOrder + " where s.suppkey = ps.suppkey and c.custkey = o.custkey and s.acctbal = c.acctbal + o.totalprice";
        PlanMatchPattern expectedPlan = PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("PS_SUPPKEY", "S_SUPPKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"PS_SUPPKEY", (Object)"suppkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("SUM", "S_ACCTBAL")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"SUM", (Object)PlanMatchPattern.expression("C_ACCTBAL + O_TOTALPRICE")), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_CUSTKEY", "C_CUSTKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_CUSTKEY", (Object)"custkey", (Object)"O_TOTALPRICE", (Object)"totalprice"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"C_CUSTKEY", (Object)"custkey", (Object)"C_ACCTBAL", (Object)"acctbal")))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"S_ACCTBAL", (Object)"acctbal", (Object)"S_SUPPKEY", (Object)"suppkey")))))));
        this.assertPlan(query, this.tester.getSession(), expectedPlan);
        String fullQuery = "select 1 from (supplier s inner join partsupp ps on s.suppkey = ps.suppkey) inner join (orders o inner join customer c on c.custkey = o.custkey)  on  s.acctbal = c.acctbal + o.totalprice";
        this.assertPlan(fullQuery, this.tester.getSession(), expectedPlan);
    }

    @Test
    public void testComplexEquiJoinCriteriaForDisjointGraphs() {
        this.assertPlan("select 1 from supplier s, partsupp ps, customer c, orders o  where s.suppkey = ps.suppkey and c.custkey = o.custkey and s.acctbal - c.acctbal = o.totalprice", this.tester.getSession(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C_CUSTKEY", "O_CUSTKEY"), PlanMatchPattern.equiJoinClause("SUBTRACT", "O_TOTALPRICE")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"SUBTRACT", (Object)PlanMatchPattern.expression("S_ACCTBAL - C_ACCTBAL")), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("PS_SUPPKEY", "S_SUPPKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"PS_SUPPKEY", (Object)"suppkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"S_ACCTBAL", (Object)"acctbal", (Object)"S_SUPPKEY", (Object)"suppkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"C_CUSTKEY", (Object)"custkey", (Object)"C_ACCTBAL", (Object)"acctbal")))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_CUSTKEY", (Object)"custkey", (Object)"O_TOTALPRICE", (Object)"totalprice"))))));
        this.assertPlan("select 1 from orders o, customer c, supplier s, partsupp ps where s.suppkey = ps.suppkey and c.custkey = o.custkey and s.acctbal - c.acctbal = o.totalprice", this.tester.getSession(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("PS_SUPPKEY", "S_SUPPKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"PS_SUPPKEY", (Object)"suppkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_TOTALPRICE = S_ACCTBAL - C_ACCTBAL", PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_CUSTKEY", "C_CUSTKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_CUSTKEY", (Object)"custkey", (Object)"O_TOTALPRICE", (Object)"totalprice"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"C_CUSTKEY", (Object)"custkey", (Object)"C_ACCTBAL", (Object)"acctbal")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"S_ACCTBAL", (Object)"acctbal", (Object)"S_SUPPKEY", (Object)"suppkey")))))))));
        this.assertPlan("select 1 from orders o, customer c, supplier s, partsupp ps, part p where s.suppkey = ps.suppkey     and c.custkey = o.custkey     and s.acctbal = c.acctbal + o.totalprice    and ps.partkey - p.partkey = 0 ", this.tester.getSession(), PlanMatchPattern.anyTree(PlanMatchPattern.filter("PS_PARTKEY - P_PARTKEY = 0", PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("PS_SUPPKEY", "S_SUPPKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("partsupp", (Map<String, String>)ImmutableMap.of((Object)"PS_SUPPKEY", (Object)"suppkey", (Object)"PS_PARTKEY", (Object)"partkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("SUM", "S_ACCTBAL")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"SUM", (Object)PlanMatchPattern.expression("C_ACCTBAL + O_TOTALPRICE")), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_CUSTKEY", "C_CUSTKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_CUSTKEY", (Object)"custkey", (Object)"O_TOTALPRICE", (Object)"totalprice"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"C_CUSTKEY", (Object)"custkey", (Object)"C_ACCTBAL", (Object)"acctbal")))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"S_ACCTBAL", (Object)"acctbal", (Object)"S_SUPPKEY", (Object)"suppkey")))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"P_PARTKEY", (Object)"partkey")))))));
    }

    @Test
    public void testComplexEquiJoinCriteriaForJoinsWithUSINGClause() {
        String usingQueryWithStarProjection = "select * from orders join lineitem USING (orderkey) join customer USING (custkey)";
        Session session = Session.builder((Session)this.tester.getSession()).setSystemProperty("handle_complex_equi_joins", "false").build();
        this.assertPlan(usingQueryWithStarProjection, session, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_CUSTKEY", "C_CUSTKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("L_ORDERKEY", "O_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_CUSTKEY", (Object)"custkey", (Object)"O_ORDERKEY", (Object)"orderkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"C_CUSTKEY", (Object)"custkey"))))));
        session = Session.builder((Session)this.tester.getSession()).setSystemProperty("handle_complex_equi_joins", "true").build();
        this.assertPlan(usingQueryWithStarProjection, session, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("L_ORDERKEY", "O_ORDERKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_CUSTKEY", "C_CUSTKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_CUSTKEY", (Object)"custkey", (Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"C_CUSTKEY", (Object)"custkey"))))))));
    }

    private RuleAssert assertReorderJoins() {
        return this.tester.assertThat((Rule)new ReorderJoins(new CostComparator(1.0, 1.0, 1.0), this.tester.getMetadata()));
    }

    private RowExpression comparisonRowExpression(OperatorType type, RowExpression left, RowExpression right) {
        return Expressions.call((String)type.name(), (FunctionHandle)this.functionResolution.comparisonFunction(type, left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{left, right});
    }
}

