/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.RuntimeReorderJoinSides;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleAssert;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestRuntimeReorderJoinSides {
    private static final int NODES_COUNT = 4;
    private RuleTester tester;
    private TableHandle nationTableHandle;
    private TableHandle supplierTableHandle;
    private ColumnHandle nationColumnHandle;
    private ColumnHandle suppColumnHandle;
    private ConnectorId connectorId;

    @BeforeClass
    public void setUp() {
        this.tester = new RuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of(), Optional.of(4));
        this.connectorId = this.tester.getCurrentConnectorId();
        TpchTableHandle nationTpchTableHandle = new TpchTableHandle("nation", 1.0);
        TpchTableHandle supplierTpchTableHandle = new TpchTableHandle("supplier", 1.0);
        this.nationTableHandle = new TableHandle(this.connectorId, (ConnectorTableHandle)nationTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(nationTpchTableHandle, TupleDomain.all())));
        this.supplierTableHandle = new TableHandle(this.connectorId, (ConnectorTableHandle)supplierTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(supplierTpchTableHandle, TupleDomain.all())));
        this.nationColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.suppColumnHandle = new TpchColumnHandle("suppkey", (Type)BigintType.BIGINT);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.tester.close();
        this.tester = null;
        this.nationTableHandle = null;
        this.supplierTableHandle = null;
        this.nationColumnHandle = null;
        this.suppColumnHandle = null;
        this.connectorId = null;
    }

    @Test
    public void testDoesNotFireWhenNoJoin() {
        this.assertReorderJoinSides().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).build()).on(p -> p.semiJoin((PlanNode)p.values(new PlanNodeId("valuesA"), 100, p.variable("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), 10000, p.variable("B1", (Type)BigintType.BIGINT)), p.variable("A1", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT), p.variable("A1", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty(), Optional.empty())).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenNonTableScanUnderJoin() {
        this.assertReorderJoinSides().on(p -> p.join(JoinType.INNER, (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle)), (PlanNode)p.values(new PlanNodeId("valuesB"), 10000, p.variable("B1", (Type)BigintType.BIGINT)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkey", (Type)BigintType.BIGINT), p.variable("B1", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkey", (Type)BigintType.BIGINT), (Object)p.variable("B1", (Type)BigintType.BIGINT)), Optional.empty())).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithoutBasicStatistics() {
        ArrayList nationNodeId = new ArrayList();
        ArrayList suppNodeId = new ArrayList();
        this.assertReorderJoinSides().on(p -> {
            TableScanNode nationNode = p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle));
            TableScanNode suppNode = p.tableScan(this.supplierTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle, (Object)p.variable("suppkey", (Type)BigintType.BIGINT), (Object)this.suppColumnHandle));
            nationNodeId.add(nationNode.getId().toString());
            suppNodeId.add(suppNode.getId().toString());
            return p.join(JoinType.INNER, (PlanNode)nationNode, (PlanNode)p.exchange(e -> e.addSource((PlanNode)suppNode).addInputsSet((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT))).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT)))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkeyN", (Type)BigintType.BIGINT), p.variable("nationkeyS", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), Optional.empty());
        }).overrideStats((String)nationNodeId.get(0), PlanNodeStatsEstimate.builder().setOutputRowCount(Double.NaN).build()).overrideStats((String)suppNodeId.get(0), PlanNodeStatsEstimate.builder().setOutputRowCount(Double.NaN).build()).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenProbeSideLarger() {
        ArrayList nationNodeId = new ArrayList();
        ArrayList suppNodeId = new ArrayList();
        this.assertReorderJoinSides().on(p -> {
            TableScanNode nationNode = p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle));
            TableScanNode suppNode = p.tableScan(this.supplierTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle, (Object)p.variable("suppkey", (Type)BigintType.BIGINT), (Object)this.suppColumnHandle));
            nationNodeId.add(nationNode.getId().toString());
            suppNodeId.add(suppNode.getId().toString());
            return p.join(JoinType.INNER, (PlanNode)nationNode, (PlanNode)p.exchange(e -> e.addSource((PlanNode)suppNode).addInputsSet((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT))).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT)))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkeyN", (Type)BigintType.BIGINT), p.variable("nationkeyS", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), Optional.empty());
        }).overrideStats((String)nationNodeId.get(0), PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "nationkeyN", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.0, 8.0, 100.0))).build()).overrideStats((String)suppNodeId.get(0), PlanNodeStatsEstimate.builder().setOutputRowCount(3000.0).addVariableStatistics((Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "nationkeyS", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.99, 8.0, 10.0), (Object)new VariableReferenceExpression(Optional.empty(), "suppkey", (Type)BigintType.BIGINT), (Object)new VariableStatsEstimate(0.0, 100.0, 0.99, 1.0, 10.0))).build()).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenSwappedJoinInvalid() {
        ArrayList nationNodeId = new ArrayList();
        ArrayList suppNodeId = new ArrayList();
        this.assertReorderJoinSides().on(p -> {
            TableScanNode nationNode = p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle));
            TableScanNode suppNode = p.tableScan(this.supplierTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle, (Object)p.variable("suppkey", (Type)BigintType.BIGINT), (Object)this.suppColumnHandle));
            nationNodeId.add(nationNode.getId().toString());
            suppNodeId.add(suppNode.getId().toString());
            return p.join(JoinType.LEFT, (PlanNode)nationNode, (PlanNode)p.exchange(e -> e.addSource((PlanNode)suppNode).addInputsSet((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT))).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT)))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkeyN", (Type)BigintType.BIGINT), p.variable("nationkeyS", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinDistributionType.REPLICATED), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        }).overrideStats((String)nationNodeId.get(0), PlanNodeStatsEstimate.builder().setOutputRowCount(25.0).build()).overrideStats((String)suppNodeId.get(0), PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).build()).doesNotFire();
    }

    @Test
    public void testFlipsAndAdjustExchangeWhenProbeSideSmaller() {
        ArrayList nationNodeId = new ArrayList();
        ArrayList suppNodeId = new ArrayList();
        this.assertReorderJoinSides().on(p -> {
            TableScanNode nationNode = p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle));
            TableScanNode suppNode = p.tableScan(this.supplierTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle, (Object)p.variable("suppkey", (Type)BigintType.BIGINT), (Object)this.suppColumnHandle));
            nationNodeId.add(nationNode.getId().toString());
            suppNodeId.add(suppNode.getId().toString());
            return p.join(JoinType.INNER, (PlanNode)nationNode, (PlanNode)p.exchange(e -> e.addSource((PlanNode)suppNode).addInputsSet((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT))).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT)))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkeyN", (Type)BigintType.BIGINT), p.variable("nationkeyS", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        }).overrideStats((String)nationNodeId.get(0), PlanNodeStatsEstimate.builder().setOutputRowCount(25.0).build()).overrideStats((String)suppNodeId.get(0), PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).build()).matches(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkeyS", "nationkeyN")), Optional.empty(), Optional.of(JoinDistributionType.PARTITIONED), PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"nationkeyS", (Object)"nationkey")), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkeyN", (Object)"nationkey")))));
    }

    private RuleAssert assertReorderJoinSides() {
        return this.tester.assertThat((Rule)new RuntimeReorderJoinSides(this.tester.getMetadata()));
    }
}

