/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyRowExpressions;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.Streams;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimplifyRowExpressions {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();
    private static final Map<String, Type> TYPES = Streams.concat((Stream[])new Stream[]{Stream.of("A", "B", "C", "D", "E", "F", "I", "V", "X", "Y", "Z"), IntStream.range(1, 61).boxed().map(i -> String.format("A%s", i))}).collect(Collectors.toMap(Function.identity(), string -> BooleanType.BOOLEAN));

    @Test
    public void testPushesDownNegations() {
        TestSimplifyRowExpressions.assertSimplifies("NOT X", "NOT X");
        TestSimplifyRowExpressions.assertSimplifies("NOT NOT X", "X");
        TestSimplifyRowExpressions.assertSimplifies("NOT NOT NOT X", "NOT X");
        TestSimplifyRowExpressions.assertSimplifies("NOT NOT NOT X", "NOT X");
        TestSimplifyRowExpressions.assertSimplifies("NOT (X > Y)", "X <= Y");
        TestSimplifyRowExpressions.assertSimplifies("NOT (X > (NOT NOT Y))", "X <= Y");
        TestSimplifyRowExpressions.assertSimplifies("X > (NOT NOT Y)", "X > Y");
        TestSimplifyRowExpressions.assertSimplifies("NOT (X AND Y AND (NOT (Z OR V)))", "(NOT X) OR (NOT Y) OR (Z OR V)");
        TestSimplifyRowExpressions.assertSimplifies("NOT (X OR Y OR (NOT (Z OR V)))", "(NOT X) AND (NOT Y) AND (Z OR V)");
        TestSimplifyRowExpressions.assertSimplifies("NOT (X OR Y OR (Z OR V))", "(NOT X) AND (NOT Y) AND ((NOT Z) AND (NOT V))");
        TestSimplifyRowExpressions.assertSimplifies("NOT (X IS DISTINCT FROM Y)", "NOT (X IS DISTINCT FROM Y)");
    }

    @Test
    public void testNestedExpressions() {
        TestSimplifyRowExpressions.assertSimplifies("(true and coalesce(X, true) IN (true, false)) IN (true, false)", "(coalesce(X, true) IN (true, false)) IN (true, false)");
    }

    @Test
    public void testExtractCommonPredicates() {
        TestSimplifyRowExpressions.assertSimplifies("TRUE", "TRUE");
        TestSimplifyRowExpressions.assertSimplifies("IF(X, X, Y)", "IF(X, X, Y)");
        TestSimplifyRowExpressions.assertSimplifies("X AND Y", "X AND Y");
        TestSimplifyRowExpressions.assertSimplifies("X OR Y", "X OR Y");
        TestSimplifyRowExpressions.assertSimplifies("X AND X", "X");
        TestSimplifyRowExpressions.assertSimplifies("true AND X", "X");
        TestSimplifyRowExpressions.assertSimplifies("X OR X", "X");
        TestSimplifyRowExpressions.assertSimplifies("(X OR Y) AND (X OR Y)", "X OR Y");
        TestSimplifyRowExpressions.assertSimplifies("(A AND V) OR V", "V");
        TestSimplifyRowExpressions.assertSimplifies("(A OR V) AND V", "V");
        TestSimplifyRowExpressions.assertSimplifies("(A OR B OR C) AND (A OR B)", "A OR B");
        TestSimplifyRowExpressions.assertSimplifies("(A AND B) OR (A AND B AND C)", "A AND B");
        TestSimplifyRowExpressions.assertSimplifies("I = ((A OR B) AND (A OR B OR C))", "I = (A OR B)");
        TestSimplifyRowExpressions.assertSimplifies("(X OR Y) AND (X OR Z)", "(X OR Y) AND (X OR Z)");
        TestSimplifyRowExpressions.assertSimplifies("(X AND Y AND V) OR (X AND Y AND Z)", "(X AND Y) AND (V OR Z)");
        TestSimplifyRowExpressions.assertSimplifies("((X OR Y OR V) AND (X OR Y OR Z)) = I", "((X OR Y) OR (V AND Z)) = I");
        TestSimplifyRowExpressions.assertSimplifies("((X OR V) AND V) OR ((X OR V) AND V)", "V");
        TestSimplifyRowExpressions.assertSimplifies("((X OR V) AND X) OR ((X OR V) AND V)", "X OR V");
        TestSimplifyRowExpressions.assertSimplifies("((X OR V) AND Z) OR ((X OR V) AND V)", "(X OR V) AND (Z OR V)");
        TestSimplifyRowExpressions.assertSimplifies("X AND ((Y AND Z) OR (Y AND V) OR (Y AND X))", "X AND Y");
        TestSimplifyRowExpressions.assertSimplifies("(A AND B AND C AND D) OR (A AND B AND E) OR (A AND F)", "A AND ((B AND C AND D) OR (B AND E) OR F)");
        TestSimplifyRowExpressions.assertSimplifies("((A AND B) OR (A AND C)) AND D", "A AND (B OR C) AND D");
        TestSimplifyRowExpressions.assertSimplifies("((A OR B) AND (A OR C)) OR D", "(A OR B OR D) AND (A OR C OR D)");
        TestSimplifyRowExpressions.assertSimplifies("(((A AND B) OR (A AND C)) AND D) OR E", "(A OR E) AND (B OR C OR E) AND (D OR E)");
        TestSimplifyRowExpressions.assertSimplifies("(((A OR B) AND (A OR C)) OR D) AND E", "(A OR (B AND C) OR D) AND E");
        TestSimplifyRowExpressions.assertSimplifies("(A AND B) OR (C AND D)", "(A OR C) AND (A OR D) AND (B OR C) AND (B OR D)");
        TestSimplifyRowExpressions.assertSimplifies("(A AND B) OR (C AND D) OR (E AND F)", "(A AND B) OR (C AND D) OR (E AND F)");
        TestSimplifyRowExpressions.assertSimplifies("(A1 AND A2) OR (A3 AND A4) OR (A5 AND A6) OR (A7 AND A8) OR (A9 AND A10) OR (A11 AND A12) OR (A13 AND A14) OR (A15 AND A16) OR (A17 AND A18) OR (A19 AND A20) OR (A21 AND A22) OR (A23 AND A24) OR (A25 AND A26) OR (A27 AND A28) OR (A29 AND A30) OR (A31 AND A32) OR (A33 AND A34) OR (A35 AND A36) OR (A37 AND A38) OR (A39 AND A40) OR (A41 AND A42) OR (A43 AND A44) OR (A45 AND A46) OR (A47 AND A48) OR (A49 AND A50) OR (A51 AND A52) OR (A53 AND A54) OR (A55 AND A56) OR (A57 AND A58) OR (A59 AND A60)", "(A1 AND A2) OR (A3 AND A4) OR (A5 AND A6) OR (A7 AND A8) OR (A9 AND A10) OR (A11 AND A12) OR (A13 AND A14) OR (A15 AND A16) OR (A17 AND A18) OR (A19 AND A20) OR (A21 AND A22) OR (A23 AND A24) OR (A25 AND A26) OR (A27 AND A28) OR (A29 AND A30) OR (A31 AND A32) OR (A33 AND A34) OR (A35 AND A36) OR (A37 AND A38) OR (A39 AND A40) OR (A41 AND A42) OR (A43 AND A44) OR (A45 AND A46) OR (A47 AND A48) OR (A49 AND A50) OR (A51 AND A52) OR (A53 AND A54) OR (A55 AND A56) OR (A57 AND A58) OR (A59 AND A60)");
    }

    @Test
    public void testCastBigintToBoundedVarchar() {
        TestSimplifyRowExpressions.assertSimplifies("CAST(12300000000 AS varchar(11))", "'12300000000'");
        try {
            TestSimplifyRowExpressions.assertSimplifies("CAST(12300000000 AS varchar(3))", "CAST(12300000000 AS varchar(3))");
            Assert.fail((String)"Expected to throw an PrestoException exception");
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)"Value 12300000000 cannot be represented as varchar(3)");
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
        try {
            TestSimplifyRowExpressions.assertSimplifies("CAST(-12300000000 AS varchar(3))", "CAST(-12300000000 AS varchar(3))");
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)"Value -12300000000 cannot be represented as varchar(3)");
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    private static void assertSimplifies(String expression, String rowExpressionExpected) {
        Expression actualExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expression));
        TestingRowExpressionTranslator translator = new TestingRowExpressionTranslator((Metadata)METADATA);
        RowExpression actualRowExpression = translator.translate(actualExpression, TypeProvider.viewOf(TYPES));
        RowExpression simplifiedRowExpression = SimplifyRowExpressions.rewrite((RowExpression)actualRowExpression, (Metadata)METADATA, (ConnectorSession)SessionTestUtils.TEST_SESSION.toConnectorSession());
        Expression expectedByRowExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(rowExpressionExpected));
        RowExpression simplifiedByExpression = translator.translate(expectedByRowExpression, TypeProvider.viewOf(TYPES));
        Assert.assertEquals((Object)TestSimplifyRowExpressions.normalize(simplifiedRowExpression), (Object)TestSimplifyRowExpressions.normalize(simplifiedByExpression));
    }

    private static RowExpression normalize(RowExpression expression) {
        return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new NormalizeRowExpressionRewriter(), (RowExpression)expression);
    }

    private static class NormalizeRowExpressionRewriter
    extends RowExpressionRewriter<Void> {
        private NormalizeRowExpressionRewriter() {
        }

        public RowExpression rewriteSpecialForm(SpecialFormExpression node, Void context, RowExpressionTreeRewriter<Void> treeRewriter) {
            if (!node.getForm().equals((Object)SpecialFormExpression.Form.AND) && !node.getForm().equals((Object)SpecialFormExpression.Form.OR)) {
                return null;
            }
            List predicates = LogicalRowExpressions.extractPredicates((SpecialFormExpression.Form)node.getForm(), (RowExpression)node).stream().map(p -> treeRewriter.rewrite(p, (Object)context)).sorted(Comparator.comparing(RowExpression::toString)).collect(Collectors.toList());
            return Expressions.specialForm((SpecialFormExpression.Form)node.getForm(), (Type)node.getType(), predicates);
        }
    }
}

