/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule.test;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.IndexHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.CteProducerNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.ExceptNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TestingConnectorIndexHandle;
import com.facebook.presto.sql.planner.TestingConnectorTransactionHandle;
import com.facebook.presto.sql.planner.TestingWriterTarget;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.ApplyNodeUtil;
import com.facebook.presto.sql.planner.optimizations.SetOperationNodeUtils;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.util.MoreLists;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class PlanBuilder {
    private final Session session;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Map<String, Type> variables = new HashMap<String, Type>();

    public PlanBuilder(Session session, PlanNodeIdAllocator idAllocator, Metadata metadata) {
        this.session = session;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
    }

    public static Assignments assignment(VariableReferenceExpression variable, RowExpression expression) {
        return Assignments.builder().put(variable, expression).build();
    }

    public static Assignments assignment(VariableReferenceExpression variable1, RowExpression expression1, VariableReferenceExpression variable2, RowExpression expression2) {
        return Assignments.builder().put(variable1, expression1).put(variable2, expression2).build();
    }

    public OutputNode output(List<String> columnNames, List<VariableReferenceExpression> variables, PlanNode source) {
        return new OutputNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, columnNames, variables);
    }

    public OutputNode output(Consumer<OutputBuilder> outputBuilderConsumer) {
        OutputBuilder outputBuilder = new OutputBuilder();
        outputBuilderConsumer.accept(outputBuilder);
        return outputBuilder.build();
    }

    public ValuesNode values() {
        return this.values(this.idAllocator.getNextId(), (List<VariableReferenceExpression>)ImmutableList.of(), (List<List<RowExpression>>)ImmutableList.of());
    }

    public ValuesNode values(VariableReferenceExpression ... columns) {
        return this.values(this.idAllocator.getNextId(), 0, columns);
    }

    public ValuesNode values(PlanNodeId id, VariableReferenceExpression ... columns) {
        return this.values(id, 0, columns);
    }

    public ValuesNode values(int rows, VariableReferenceExpression ... columns) {
        return this.values(this.idAllocator.getNextId(), rows, columns);
    }

    public ValuesNode values(PlanNodeId id, int rows, VariableReferenceExpression ... columns) {
        ImmutableList variables = ImmutableList.copyOf((Object[])columns);
        return this.values(id, (List<VariableReferenceExpression>)variables, MoreLists.nElements((int)rows, arg_0 -> PlanBuilder.lambda$values$1(columns, (List)variables, arg_0)));
    }

    public ValuesNode values(List<VariableReferenceExpression> variables, List<List<RowExpression>> rows) {
        return this.values(this.idAllocator.getNextId(), variables, rows);
    }

    public ValuesNode values(PlanNodeId id, List<VariableReferenceExpression> variables, List<List<RowExpression>> rows) {
        return new ValuesNode(Optional.empty(), id, variables, rows, Optional.empty());
    }

    public EnforceSingleRowNode enforceSingleRow(PlanNode source) {
        return new EnforceSingleRowNode(source.getSourceLocation(), this.idAllocator.getNextId(), source);
    }

    public SortNode sort(List<VariableReferenceExpression> orderBy, PlanNode source) {
        return new SortNode(orderBy.get(0).getSourceLocation(), this.idAllocator.getNextId(), source, new OrderingScheme((List)orderBy.stream().map(variable -> new Ordering(variable, SortOrder.ASC_NULLS_FIRST)).collect(ImmutableList.toImmutableList())), false);
    }

    public OffsetNode offset(long rowCount, PlanNode source) {
        return new OffsetNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, rowCount);
    }

    public LimitNode limit(long limit, PlanNode source) {
        return new LimitNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, limit, LimitNode.Step.FINAL);
    }

    public TopNNode topN(long count, List<VariableReferenceExpression> orderBy, PlanNode source) {
        return new TopNNode(orderBy.get(0).getSourceLocation(), this.idAllocator.getNextId(), source, count, new OrderingScheme((List)orderBy.stream().map(variable -> new Ordering(variable, SortOrder.ASC_NULLS_FIRST)).collect(ImmutableList.toImmutableList())), TopNNode.Step.SINGLE);
    }

    public DistinctLimitNode distinctLimit(long count, List<VariableReferenceExpression> distinctSymbols, PlanNode source) {
        return new DistinctLimitNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, count, false, distinctSymbols, Optional.empty(), 0);
    }

    public SampleNode sample(double sampleRatio, SampleNode.Type type, PlanNode source) {
        return new SampleNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, sampleRatio, type);
    }

    public ProjectNode project(PlanNode source, Assignments assignments) {
        return new ProjectNode(this.idAllocator.getNextId(), source, assignments);
    }

    public ProjectNode project(Assignments assignments, PlanNode source) {
        return new ProjectNode(this.idAllocator.getNextId(), source, assignments);
    }

    public MarkDistinctNode markDistinct(VariableReferenceExpression markerVariable, List<VariableReferenceExpression> distinctVariables, PlanNode source) {
        return new MarkDistinctNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, markerVariable, distinctVariables, Optional.empty());
    }

    public MarkDistinctNode markDistinct(VariableReferenceExpression markerVariable, List<VariableReferenceExpression> distinctVariables, VariableReferenceExpression hashVariable, PlanNode source) {
        return new MarkDistinctNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, markerVariable, distinctVariables, Optional.of(hashVariable));
    }

    public FilterNode filter(RowExpression predicate, PlanNode source) {
        return this.filter(this.idAllocator.getNextId(), predicate, source);
    }

    public FilterNode filter(PlanNodeId planNodeId, RowExpression predicate, PlanNode source) {
        return new FilterNode(source.getSourceLocation(), planNodeId, source, predicate);
    }

    public AggregationNode aggregation(Consumer<AggregationBuilder> aggregationBuilderConsumer) {
        AggregationBuilder aggregationBuilder = new AggregationBuilder(this.getTypes());
        aggregationBuilderConsumer.accept(aggregationBuilder);
        return aggregationBuilder.build();
    }

    public RemoteSourceNode remoteSource(List<PlanFragmentId> sourceFragmentIds) {
        return this.remoteSource(this.idAllocator.getNextId(), sourceFragmentIds, (List<VariableReferenceExpression>)ImmutableList.of());
    }

    public RemoteSourceNode remoteSource(PlanNodeId planNodeId, List<PlanFragmentId> sourceFragmentIds, List<VariableReferenceExpression> outputVariables) {
        return new RemoteSourceNode(Optional.empty(), planNodeId, sourceFragmentIds, outputVariables, false, Optional.empty(), ExchangeNode.Type.REPARTITION);
    }

    public RemoteSourceNode remoteSource(List<PlanFragmentId> sourceFragmentIds, PlanNode statsEquivalentPlanNode) {
        return new RemoteSourceNode(Optional.empty(), this.idAllocator.getNextId(), Optional.of(statsEquivalentPlanNode), sourceFragmentIds, (List)ImmutableList.of(), false, Optional.empty(), ExchangeNode.Type.REPARTITION);
    }

    public CallExpression binaryOperation(OperatorType operatorType, RowExpression left, RowExpression right) {
        FunctionHandle functionHandle = new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()).arithmeticFunction(operatorType, left.getType(), right.getType());
        return Expressions.call((String)operatorType.getOperator(), (FunctionHandle)functionHandle, (Type)left.getType(), (RowExpression[])new RowExpression[]{left, right});
    }

    public CallExpression comparison(OperatorType operatorType, RowExpression left, RowExpression right) {
        FunctionHandle functionHandle = new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()).comparisonFunction(operatorType, left.getType(), right.getType());
        return Expressions.call((String)operatorType.getOperator(), (FunctionHandle)functionHandle, (Type)left.getType(), (RowExpression[])new RowExpression[]{left, right});
    }

    public ApplyNode apply(Assignments subqueryAssignments, List<VariableReferenceExpression> correlation, PlanNode input, PlanNode subquery) {
        return this.apply(subqueryAssignments, correlation, input, subquery, false);
    }

    public ApplyNode apply(Assignments subqueryAssignments, List<VariableReferenceExpression> correlation, PlanNode input, PlanNode subquery, boolean mayParticipateInAntiJoin) {
        ApplyNodeUtil.verifySubquerySupported((Assignments)subqueryAssignments);
        return new ApplyNode(subquery.getSourceLocation(), this.idAllocator.getNextId(), input, subquery, subqueryAssignments, correlation, "", mayParticipateInAntiJoin);
    }

    public AssignUniqueId assignUniqueId(VariableReferenceExpression variable, PlanNode source) {
        return new AssignUniqueId(source.getSourceLocation(), this.idAllocator.getNextId(), source, variable);
    }

    public LateralJoinNode lateral(List<VariableReferenceExpression> correlation, PlanNode input, PlanNode subquery) {
        return new LateralJoinNode(subquery.getSourceLocation(), this.idAllocator.getNextId(), input, subquery, correlation, LateralJoinNode.Type.INNER, "");
    }

    public TableScanNode tableScan(String catalogName, List<VariableReferenceExpression> variables, Map<VariableReferenceExpression, ColumnHandle> assignments) {
        TableHandle tableHandle = new TableHandle(new ConnectorId(catalogName), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        return this.tableScan(tableHandle, variables, assignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    public TableScanNode tableScan(List<VariableReferenceExpression> variables, Map<VariableReferenceExpression, ColumnHandle> assignments) {
        return this.tableScan("testConnector", variables, assignments);
    }

    public TableScanNode tableScan(TableHandle tableHandle, List<VariableReferenceExpression> variables, Map<VariableReferenceExpression, ColumnHandle> assignments) {
        return this.tableScan(tableHandle, variables, assignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    public TableScanNode tableScan(TableHandle tableHandle, List<VariableReferenceExpression> variables, Map<VariableReferenceExpression, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint) {
        return new TableScanNode(Optional.empty(), this.idAllocator.getNextId(), tableHandle, variables, assignments, (List)ImmutableList.of(), currentConstraint, enforcedConstraint);
    }

    public TableScanNode tableScan(TableHandle tableHandle, List<VariableReferenceExpression> variables, Map<VariableReferenceExpression, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint, TupleDomain<ColumnHandle> enforcedConstraint, List<TableConstraint<ColumnHandle>> tableConstraints) {
        return new TableScanNode(Optional.empty(), this.idAllocator.getNextId(), tableHandle, variables, assignments, tableConstraints, currentConstraint, enforcedConstraint);
    }

    public TableFinishNode tableDelete(SchemaTableName schemaTableName, PlanNode deleteSource, VariableReferenceExpression deleteRowId) {
        TableWriterNode.DeleteHandle deleteHandle = new TableWriterNode.DeleteHandle(new TableHandle(new ConnectorId("testConnector"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty()), schemaTableName);
        return new TableFinishNode(deleteSource.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)this.exchange(e -> e.addSource((PlanNode)new DeleteNode(deleteSource.getSourceLocation(), this.idAllocator.getNextId(), deleteSource, deleteRowId, (List)ImmutableList.of((Object)deleteRowId))).addInputsSet(deleteRowId).singleDistributionPartitioningScheme(deleteRowId)), Optional.of(deleteHandle), deleteRowId, Optional.empty(), Optional.empty());
    }

    public ExchangeNode gatheringExchange(ExchangeNode.Scope scope, PlanNode child) {
        return this.exchange(builder -> builder.type(ExchangeNode.Type.GATHER).scope(scope).singleDistributionPartitioningScheme(child.getOutputVariables()).addSource(child).addInputsSet(child.getOutputVariables()));
    }

    public SemiJoinNode semiJoin(VariableReferenceExpression sourceJoinVariable, VariableReferenceExpression filteringSourceJoinVariable, VariableReferenceExpression semiJoinOutput, Optional<VariableReferenceExpression> sourceHashVariable, Optional<VariableReferenceExpression> filteringSourceHashVariable, PlanNode source, PlanNode filteringSource) {
        return this.semiJoin(source, filteringSource, sourceJoinVariable, filteringSourceJoinVariable, semiJoinOutput, sourceHashVariable, filteringSourceHashVariable, Optional.empty());
    }

    public SemiJoinNode semiJoin(PlanNode source, PlanNode filteringSource, VariableReferenceExpression sourceJoinVariable, VariableReferenceExpression filteringSourceJoinVariable, VariableReferenceExpression semiJoinOutput, Optional<VariableReferenceExpression> sourceHashVariable, Optional<VariableReferenceExpression> filteringSourceHashVariable, Optional<SemiJoinNode.DistributionType> distributionType) {
        return new SemiJoinNode(filteringSource.getSourceLocation(), this.idAllocator.getNextId(), source, filteringSource, sourceJoinVariable, filteringSourceJoinVariable, semiJoinOutput, sourceHashVariable, filteringSourceHashVariable, distributionType, (Map)ImmutableMap.of());
    }

    public IndexSourceNode indexSource(TableHandle tableHandle, Set<VariableReferenceExpression> lookupVariables, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments, TupleDomain<ColumnHandle> effectiveTupleDomain) {
        return new IndexSourceNode(Optional.empty(), this.idAllocator.getNextId(), new IndexHandle(tableHandle.getConnectorId(), (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, (ConnectorIndexHandle)TestingConnectorIndexHandle.INSTANCE), tableHandle, lookupVariables, outputVariables, assignments, effectiveTupleDomain);
    }

    public ExchangeNode exchange(Consumer<ExchangeBuilder> exchangeBuilderConsumer) {
        ExchangeBuilder exchangeBuilder = new ExchangeBuilder();
        exchangeBuilderConsumer.accept(exchangeBuilder);
        return exchangeBuilder.build();
    }

    public JoinNode join(JoinType joinType, PlanNode left, PlanNode right, EquiJoinClause ... criteria) {
        return this.join(joinType, left, right, Optional.empty(), criteria);
    }

    public JoinNode join(JoinType joinType, PlanNode left, PlanNode right, RowExpression filter, EquiJoinClause ... criteria) {
        return this.join(joinType, left, right, Optional.of(filter), criteria);
    }

    private JoinNode join(JoinType joinType, PlanNode left, PlanNode right, Optional<RowExpression> filter, EquiJoinClause ... criteria) {
        return this.join(joinType, left, right, (List<EquiJoinClause>)ImmutableList.copyOf((Object[])criteria), (List<VariableReferenceExpression>)ImmutableList.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build(), filter, Optional.empty(), Optional.empty());
    }

    public JoinNode join(JoinType type, PlanNode left, PlanNode right, List<EquiJoinClause> criteria, List<VariableReferenceExpression> outputVariables, Optional<RowExpression> filter) {
        return this.join(type, left, right, criteria, outputVariables, filter, Optional.empty(), Optional.empty());
    }

    public JoinNode join(JoinType type, PlanNode left, PlanNode right, List<EquiJoinClause> criteria, List<VariableReferenceExpression> outputVariables, Optional<RowExpression> filter, Optional<VariableReferenceExpression> leftHashVariable, Optional<VariableReferenceExpression> rightHashVariable) {
        return this.join(type, left, right, criteria, outputVariables, filter, leftHashVariable, rightHashVariable, Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
    }

    public JoinNode join(JoinType type, PlanNode left, PlanNode right, List<EquiJoinClause> criteria, List<VariableReferenceExpression> outputVariables, Optional<RowExpression> filter, Optional<VariableReferenceExpression> leftHashVariable, Optional<VariableReferenceExpression> rightHashVariable, Map<String, VariableReferenceExpression> dynamicFilters) {
        return this.join(type, left, right, criteria, outputVariables, filter, leftHashVariable, rightHashVariable, Optional.empty(), dynamicFilters);
    }

    public JoinNode join(JoinType type, PlanNode left, PlanNode right, List<EquiJoinClause> criteria, List<VariableReferenceExpression> outputVariables, Optional<RowExpression> filter, Optional<VariableReferenceExpression> leftHashVariable, Optional<VariableReferenceExpression> rightHashVariable, Optional<JoinDistributionType> distributionType, Map<String, VariableReferenceExpression> dynamicFilters) {
        return new JoinNode(Optional.empty(), this.idAllocator.getNextId(), type, left, right, criteria, outputVariables, filter, leftHashVariable, rightHashVariable, distributionType, dynamicFilters);
    }

    public PlanNode indexJoin(IndexJoinNode.Type type, TableScanNode probe, TableScanNode index) {
        return new IndexJoinNode(Optional.empty(), this.idAllocator.getNextId(), type, (PlanNode)probe, (PlanNode)index, Collections.emptyList(), Optional.empty(), Optional.empty());
    }

    public CteProducerNode cteProducerNode(String ctename, VariableReferenceExpression rowCountVar, List<VariableReferenceExpression> outputVars, PlanNode source) {
        return new CteProducerNode(Optional.empty(), this.idAllocator.getNextId(), source, ctename, rowCountVar, outputVars);
    }

    public UnionNode union(ListMultimap<VariableReferenceExpression, VariableReferenceExpression> outputsToInputs, List<PlanNode> sources) {
        Map mapping = SetOperationNodeUtils.fromListMultimap(outputsToInputs);
        return new UnionNode(Optional.empty(), this.idAllocator.getNextId(), sources, (List)ImmutableList.copyOf(mapping.keySet()), mapping);
    }

    public IntersectNode intersect(ListMultimap<VariableReferenceExpression, VariableReferenceExpression> outputsToInputs, List<PlanNode> sources) {
        Map mapping = SetOperationNodeUtils.fromListMultimap(outputsToInputs);
        return new IntersectNode(Optional.empty(), this.idAllocator.getNextId(), sources, (List)ImmutableList.copyOf(mapping.keySet()), mapping);
    }

    public ExceptNode except(ListMultimap<VariableReferenceExpression, VariableReferenceExpression> outputsToInputs, List<PlanNode> sources) {
        Map mapping = SetOperationNodeUtils.fromListMultimap(outputsToInputs);
        return new ExceptNode(Optional.empty(), this.idAllocator.getNextId(), sources, (List)ImmutableList.copyOf(mapping.keySet()), mapping);
    }

    public TableWriterNode tableWriter(List<VariableReferenceExpression> columns, List<String> columnNames, PlanNode source) {
        return new TableWriterNode(Optional.empty(), this.idAllocator.getNextId(), source, Optional.of(new TestingWriterTarget()), this.variable("partialrows", (Type)BigintType.BIGINT), this.variable("fragment", (Type)VarbinaryType.VARBINARY), this.variable("tablecommitcontext", (Type)VarbinaryType.VARBINARY), columns, columnNames, (Set)ImmutableSet.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public VariableReferenceExpression variable(String name) {
        return this.variable(name, (Type)BigintType.BIGINT);
    }

    public VariableReferenceExpression variable(VariableReferenceExpression variable) {
        return this.variable(variable.getName(), variable.getType());
    }

    public VariableReferenceExpression variable(String name, Type type) {
        Type old = this.variables.put(name, type);
        if (old != null && !old.equals(type)) {
            throw new IllegalArgumentException(String.format("Variable '%s' already registered with type '%s'", name, old));
        }
        if (old == null) {
            this.variables.put(name, type);
        }
        return new VariableReferenceExpression(Optional.empty(), name, type);
    }

    public PlanBuilder registerVariable(VariableReferenceExpression expression) {
        this.variable(expression);
        return this;
    }

    public WindowNode window(WindowNode.Specification specification, Map<VariableReferenceExpression, WindowNode.Function> functions, PlanNode source) {
        return new WindowNode(Optional.empty(), this.idAllocator.getNextId(), source, specification, (Map)ImmutableMap.copyOf(functions), Optional.empty(), (Set)ImmutableSet.of(), 0);
    }

    public WindowNode window(WindowNode.Specification specification, Map<VariableReferenceExpression, WindowNode.Function> functions, VariableReferenceExpression hashVariable, PlanNode source) {
        return new WindowNode(Optional.empty(), this.idAllocator.getNextId(), source, specification, (Map)ImmutableMap.copyOf(functions), Optional.of(hashVariable), (Set)ImmutableSet.of(), 0);
    }

    public RowNumberNode rowNumber(List<VariableReferenceExpression> partitionBy, Optional<Integer> maxRowCountPerPartition, VariableReferenceExpression rowNumberVariable, PlanNode source) {
        return new RowNumberNode(Optional.empty(), this.idAllocator.getNextId(), source, partitionBy, rowNumberVariable, maxRowCountPerPartition, false, Optional.empty());
    }

    public UnnestNode unnest(PlanNode source, List<VariableReferenceExpression> replicateVariables, Map<VariableReferenceExpression, List<VariableReferenceExpression>> unnestVariables, Optional<VariableReferenceExpression> ordinalityVariable) {
        return new UnnestNode(Optional.empty(), this.idAllocator.getNextId(), source, replicateVariables, unnestVariables, ordinalityVariable);
    }

    public static Expression expression(String sql) {
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(sql));
    }

    public static Expression expression(String sql, ParsingOptions.DecimalLiteralTreatment decimalLiteralTreatment) {
        ParsingOptions.Builder builder = ParsingOptions.builder();
        builder.setDecimalLiteralTreatment(decimalLiteralTreatment);
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(sql, builder.build()));
    }

    public RowExpression rowExpression(String sql) {
        return this.rowExpression(PlanBuilder.expression(sql));
    }

    public RowExpression rowExpression(String sql, ParsingOptions.DecimalLiteralTreatment decimalLiteralTreatment) {
        return this.rowExpression(PlanBuilder.expression(sql, decimalLiteralTreatment));
    }

    private RowExpression rowExpression(Expression expression) {
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)this.session, (Metadata)this.metadata, (SqlParser)new SqlParser(), (TypeProvider)this.getTypes(), (Expression)expression, (Map)ImmutableMap.of(), (WarningCollector)WarningCollector.NOOP);
        return SqlToRowExpressionTranslator.translate((Expression)expression, (Map)expressionTypes, (Map)ImmutableMap.of(), (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (Session)this.session);
    }

    public static Expression expression(String sql, ParsingOptions options) {
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(sql, options));
    }

    public static List<Expression> expressions(String ... expressions) {
        return (List)Stream.of(expressions).map(PlanBuilder::expression).collect(ImmutableList.toImmutableList());
    }

    public static List<RowExpression> constantExpressions(Type type, Object ... values) {
        return (List)Stream.of(values).map(value -> Expressions.constant((Object)value, (Type)type)).collect(ImmutableList.toImmutableList());
    }

    public TypeProvider getTypes() {
        return TypeProvider.viewOf(this.variables);
    }

    public PlanNodeIdAllocator getIdAllocator() {
        return this.idAllocator;
    }

    private static /* synthetic */ List lambda$values$1(VariableReferenceExpression[] columns, List variables, int row) {
        return MoreLists.nElements((int)columns.length, cell -> Expressions.constantNull((Optional)((VariableReferenceExpression)variables.get(cell)).getSourceLocation(), (Type)UnknownType.UNKNOWN));
    }

    public class ExchangeBuilder {
        private ExchangeNode.Type type = ExchangeNode.Type.GATHER;
        private ExchangeNode.Scope scope = ExchangeNode.Scope.REMOTE_STREAMING;
        private PartitioningScheme partitioningScheme;
        private boolean ensureSourceOrdering;
        private OrderingScheme orderingScheme;
        private List<PlanNode> sources = new ArrayList<PlanNode>();
        private List<List<VariableReferenceExpression>> inputs = new ArrayList<List<VariableReferenceExpression>>();

        public ExchangeBuilder type(ExchangeNode.Type type) {
            this.type = type;
            return this;
        }

        public ExchangeBuilder scope(ExchangeNode.Scope scope) {
            this.scope = scope;
            return this;
        }

        public ExchangeBuilder singleDistributionPartitioningScheme(VariableReferenceExpression ... outputVariables) {
            return this.singleDistributionPartitioningScheme(Arrays.asList(outputVariables));
        }

        public ExchangeBuilder singleDistributionPartitioningScheme(List<VariableReferenceExpression> outputVariables) {
            return this.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), outputVariables));
        }

        public ExchangeBuilder fixedHashDistributionPartitioningScheme(List<VariableReferenceExpression> outputVariables, List<VariableReferenceExpression> partitioningVariables) {
            return this.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (Collection)ImmutableList.copyOf(partitioningVariables)), (List)ImmutableList.copyOf(outputVariables)));
        }

        public ExchangeBuilder fixedHashDistributionPartitioningScheme(List<VariableReferenceExpression> outputVariables, List<VariableReferenceExpression> partitioningVariables, VariableReferenceExpression hashVariable) {
            return this.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (Collection)ImmutableList.copyOf(partitioningVariables)), (List)ImmutableList.copyOf(outputVariables), Optional.of(hashVariable)));
        }

        public ExchangeBuilder partitioningScheme(PartitioningScheme partitioningScheme) {
            this.partitioningScheme = partitioningScheme;
            return this;
        }

        public ExchangeBuilder addSource(PlanNode source) {
            this.sources.add(source);
            return this;
        }

        public ExchangeBuilder addInputsSet(VariableReferenceExpression ... inputs) {
            return this.addInputsSet(Arrays.asList(inputs));
        }

        public ExchangeBuilder addInputsSet(List<VariableReferenceExpression> inputs) {
            this.inputs.add(inputs);
            return this;
        }

        public ExchangeBuilder setEnsureSourceOrdering(boolean ensureSourceOrdering) {
            this.ensureSourceOrdering = ensureSourceOrdering;
            return this;
        }

        public ExchangeBuilder orderingScheme(OrderingScheme orderingScheme) {
            this.orderingScheme = orderingScheme;
            return this;
        }

        protected ExchangeNode build() {
            return new ExchangeNode(Optional.empty(), PlanBuilder.this.idAllocator.getNextId(), this.type, this.scope, this.partitioningScheme, this.sources, this.inputs, this.ensureSourceOrdering, Optional.ofNullable(this.orderingScheme));
        }
    }

    public class AggregationBuilder {
        private final TypeProvider types;
        private PlanNode source;
        private PlanNodeId planNodeId;
        private Map<VariableReferenceExpression, AggregationNode.Aggregation> assignments = new LinkedHashMap<VariableReferenceExpression, AggregationNode.Aggregation>();
        private AggregationNode.GroupingSetDescriptor groupingSets;
        private List<VariableReferenceExpression> preGroupedVariables = new ArrayList<VariableReferenceExpression>();
        private AggregationNode.Step step = AggregationNode.Step.SINGLE;
        private Optional<VariableReferenceExpression> hashVariable = Optional.empty();
        private Optional<VariableReferenceExpression> groupIdVariable = Optional.empty();
        private Session session = TestingSession.testSessionBuilder().build();

        public AggregationBuilder(TypeProvider types) {
            this.types = types;
        }

        public AggregationBuilder source(PlanNode source) {
            this.source = source;
            return this;
        }

        public AggregationBuilder setPlanNodeId(PlanNodeId planNodeId) {
            this.planNodeId = planNodeId;
            return this;
        }

        public AggregationBuilder addAggregation(VariableReferenceExpression output, RowExpression expression) {
            return this.addAggregation(output, expression, false);
        }

        public AggregationBuilder addAggregation(VariableReferenceExpression output, RowExpression expression, boolean isDistinct) {
            return this.addAggregation(output, expression, Optional.empty(), Optional.empty(), isDistinct, Optional.empty());
        }

        public AggregationBuilder addAggregation(VariableReferenceExpression output, RowExpression expression, Optional<RowExpression> filter, Optional<OrderingScheme> orderingScheme, boolean isDistinct, Optional<VariableReferenceExpression> mask) {
            Preconditions.checkArgument((boolean)(expression instanceof CallExpression));
            CallExpression call = (CallExpression)expression;
            return this.addAggregation(output, new AggregationNode.Aggregation(call, filter, orderingScheme, isDistinct, mask));
        }

        public AggregationBuilder addAggregation(VariableReferenceExpression output, AggregationNode.Aggregation aggregation) {
            this.assignments.put(output, aggregation);
            return this;
        }

        public AggregationBuilder globalGrouping() {
            this.groupingSets(AggregationNode.singleGroupingSet((List)ImmutableList.of()));
            return this;
        }

        public AggregationBuilder singleGroupingSet(VariableReferenceExpression ... variables) {
            this.groupingSets(AggregationNode.singleGroupingSet((List)ImmutableList.copyOf((Object[])variables)));
            return this;
        }

        public AggregationBuilder groupingSets(AggregationNode.GroupingSetDescriptor groupingSets) {
            Preconditions.checkState((this.groupingSets == null ? 1 : 0) != 0, (Object)"groupingSets already defined");
            this.groupingSets = groupingSets;
            return this;
        }

        public AggregationBuilder preGroupedVariables(VariableReferenceExpression ... variables) {
            Preconditions.checkState((boolean)this.preGroupedVariables.isEmpty(), (Object)"preGroupedVariables already defined");
            this.preGroupedVariables = ImmutableList.copyOf((Object[])variables);
            return this;
        }

        public AggregationBuilder step(AggregationNode.Step step) {
            this.step = step;
            return this;
        }

        public AggregationBuilder hashVariable(VariableReferenceExpression hashVariable) {
            this.hashVariable = Optional.of(hashVariable);
            return this;
        }

        public AggregationBuilder groupIdVariable(VariableReferenceExpression groupIdVariable) {
            this.groupIdVariable = Optional.of(groupIdVariable);
            return this;
        }

        protected AggregationNode build() {
            Preconditions.checkState((this.groupingSets != null ? 1 : 0) != 0, (Object)"No grouping sets defined; use globalGrouping/groupingKeys method");
            return new AggregationNode(this.source.getSourceLocation(), this.planNodeId == null ? PlanBuilder.this.idAllocator.getNextId() : this.planNodeId, this.source, this.assignments, this.groupingSets, this.preGroupedVariables, this.step, this.hashVariable, this.groupIdVariable, Optional.empty());
        }
    }

    public class OutputBuilder {
        private PlanNode source;
        private List<String> columnNames = new ArrayList<String>();
        private List<VariableReferenceExpression> outputVariables = new ArrayList<VariableReferenceExpression>();

        public OutputBuilder source(PlanNode source) {
            this.source = source;
            return this;
        }

        public OutputBuilder column(VariableReferenceExpression variable, String columnName) {
            this.outputVariables.add(variable);
            this.columnNames.add(columnName);
            return this;
        }

        protected OutputNode build() {
            return new OutputNode(this.source.getSourceLocation(), PlanBuilder.this.idAllocator.getNextId(), this.source, this.columnNames, this.outputVariables);
        }
    }
}

