/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule.test;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Match;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Memo;
import com.facebook.presto.sql.planner.iterative.PlanNodeMatcher;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesImpl;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesProviderImpl;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.testng.Assert;

public class RuleAssert {
    private final Metadata metadata;
    private final TestingStatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final Rule<?> rule;
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private Session session;
    private TypeProvider types;
    private PlanNode plan;
    private Optional<LogicalPropertiesProvider> logicalPropertiesProvider;

    public RuleAssert(Metadata metadata, StatsCalculator statsCalculator, CostCalculator costCalculator, Session session, Rule rule, TransactionManager transactionManager, AccessControl accessControl) {
        this(metadata, statsCalculator, costCalculator, session, rule, transactionManager, accessControl, Optional.empty());
    }

    public RuleAssert(Metadata metadata, StatsCalculator statsCalculator, CostCalculator costCalculator, Session session, Rule rule, TransactionManager transactionManager, AccessControl accessControl, Optional<LogicalPropertiesProvider> logicalPropertiesProvider) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.statsCalculator = new TestingStatsCalculator(Objects.requireNonNull(statsCalculator, "statsCalculator is null"));
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.rule = Objects.requireNonNull(rule, "rule is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.logicalPropertiesProvider = Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider is null");
    }

    public RuleAssert setSystemProperty(String key, String value) {
        return this.withSession(Session.builder((Session)this.session).setSystemProperty(key, value).build());
    }

    public RuleAssert withSession(Session session) {
        this.session = session;
        return this;
    }

    public RuleAssert overrideStats(String nodeId, PlanNodeStatsEstimate nodeStats) {
        this.statsCalculator.setNodeStats(new PlanNodeId(nodeId), nodeStats);
        return this;
    }

    public RuleAssert on(Function<PlanBuilder, PlanNode> planProvider) {
        Preconditions.checkState((this.plan == null ? 1 : 0) != 0, (Object)"plan has already been set");
        PlanBuilder builder = new PlanBuilder(this.session, this.idAllocator, this.metadata);
        this.plan = planProvider.apply(builder);
        this.types = builder.getTypes();
        return this;
    }

    public PlanNode get() {
        RuleApplication ruleApplication = this.applyRule();
        TypeProvider types = ruleApplication.types;
        if (!ruleApplication.wasRuleApplied()) {
            Assert.fail((String)String.format("%s did not fire for:\n%s", this.rule.getClass().getName(), this.formatPlan(this.plan, types)));
        }
        return ruleApplication.getTransformedPlan();
    }

    public void doesNotFire() {
        RuleApplication ruleApplication = this.applyRule();
        if (ruleApplication.wasRuleApplied()) {
            Assert.fail((String)String.format("Expected %s to not fire for:\n%s", this.rule.getClass().getName(), this.inTransaction(session -> PlanPrinter.textLogicalPlan((PlanNode)this.plan, (TypeProvider)ruleApplication.types, (StatsAndCosts)StatsAndCosts.empty(), (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (Session)session, (int)2))));
        }
    }

    public void matches(PlanMatchPattern pattern) {
        PlanNode actual;
        RuleApplication ruleApplication = this.applyRule();
        TypeProvider types = ruleApplication.types;
        if (!ruleApplication.wasRuleApplied()) {
            Assert.fail((String)String.format("%s did not fire for:\n%s", this.rule.getClass().getName(), this.formatPlan(this.plan, types)));
        }
        if ((actual = ruleApplication.getTransformedPlan()) == this.plan) {
            Assert.fail((String)String.format("%s: rule fired but return the original plan:\n%s", this.rule.getClass().getName(), this.formatPlan(this.plan, types)));
        }
        if (!ImmutableSet.copyOf((Collection)this.plan.getOutputVariables()).equals((Object)ImmutableSet.copyOf((Collection)actual.getOutputVariables()))) {
            Assert.fail((String)String.format("%s: output schema of transformed and original plans are not equivalent\n\texpected: %s\n\tactual:   %s", this.rule.getClass().getName(), this.plan.getOutputVariables(), actual.getOutputVariables()));
        }
        this.inTransaction(session -> {
            PlanAssert.assertPlan(session, this.metadata, ruleApplication.statsProvider, new Plan(actual, types, StatsAndCosts.empty()), ruleApplication.lookup, pattern, planNode -> planNode);
            return null;
        });
    }

    public void matches(LogicalProperties expectedLogicalProperties) {
        LogicalProperties rootNodeLogicalProperties;
        RuleApplication ruleApplication = this.applyRule();
        TypeProvider types = ruleApplication.types;
        if (!ruleApplication.wasRuleApplied()) {
            Assert.fail((String)String.format("%s did not fire for:\n%s", this.rule.getClass().getName(), this.formatPlan(this.plan, types)));
        }
        if (!((LogicalPropertiesImpl)(rootNodeLogicalProperties = (LogicalProperties)ruleApplication.getMemo().getLogicalProperties(ruleApplication.getMemo().getRootGroup()).get())).equals((LogicalPropertiesImpl)expectedLogicalProperties)) {
            Assert.fail((String)String.format("Logical properties of root node doesn't match expected logical properties\n\texpected: %s\n\tactual:   %s", expectedLogicalProperties, rootNodeLogicalProperties));
        }
    }

    private RuleApplication applyRule() {
        VariableAllocator variableAllocator = new VariableAllocator((Collection)this.types.allVariables());
        Memo memo = new Memo(this.idAllocator, this.plan, this.logicalPropertiesProvider);
        Lookup lookup = Lookup.from(planNode -> Stream.of(memo.resolve(planNode)));
        PlanNode memoRoot = memo.getNode(memo.getRootGroup());
        return this.inTransaction(session -> RuleAssert.applyRule(this.rule, memoRoot, this.ruleContext(this.statsCalculator, this.costCalculator, variableAllocator, memo, lookup, (Session)session), memo));
    }

    private static <T> RuleApplication applyRule(Rule<T> rule, PlanNode planNode, Rule.Context context, Memo memo) {
        PlanNodeMatcher matcher = new PlanNodeMatcher(context.getLookup());
        Match match = matcher.match(rule.getPattern(), (Object)planNode);
        Rule.Result result = !rule.isEnabled(context.getSession()) || match.isEmpty() ? Rule.Result.empty() : rule.apply(match.value(), match.captures(), context);
        return new RuleApplication(context.getLookup(), context.getStatsProvider(), TypeProvider.viewOf((Map)context.getVariableAllocator().getVariables()), memo, result);
    }

    private String formatPlan(PlanNode plan, TypeProvider types) {
        CachingStatsProvider statsProvider = new CachingStatsProvider((StatsCalculator)this.statsCalculator, this.session, types);
        CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, (StatsProvider)statsProvider, this.session);
        return this.inTransaction(arg_0 -> this.lambda$formatPlan$5(plan, types, (StatsProvider)statsProvider, (CostProvider)costProvider, arg_0));
    }

    private <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)this.accessControl).singleStatement().execute(this.session, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }

    private Rule.Context ruleContext(StatsCalculator statsCalculator, CostCalculator costCalculator, final VariableAllocator variableAllocator, Memo memo, final Lookup lookup, final Session session) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, Optional.of(memo), lookup, session, TypeProvider.viewOf((Map)variableAllocator.getVariables()));
        CachingCostProvider costProvider = new CachingCostProvider(costCalculator, (StatsProvider)statsProvider, Optional.of(memo), session);
        LogicalPropertiesProviderImpl logicalPropertiesProvider = new LogicalPropertiesProviderImpl(new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()));
        return new Rule.Context((StatsProvider)statsProvider, (CostProvider)costProvider, (LogicalPropertiesProvider)logicalPropertiesProvider){
            final /* synthetic */ StatsProvider val$statsProvider;
            final /* synthetic */ CostProvider val$costProvider;
            final /* synthetic */ LogicalPropertiesProvider val$logicalPropertiesProvider;
            {
                this.val$statsProvider = statsProvider;
                this.val$costProvider = costProvider;
                this.val$logicalPropertiesProvider = logicalPropertiesProvider;
            }

            public Lookup getLookup() {
                return lookup;
            }

            public PlanNodeIdAllocator getIdAllocator() {
                return RuleAssert.this.idAllocator;
            }

            public VariableAllocator getVariableAllocator() {
                return variableAllocator;
            }

            public Session getSession() {
                return session;
            }

            public StatsProvider getStatsProvider() {
                return this.val$statsProvider;
            }

            public CostProvider getCostProvider() {
                return this.val$costProvider;
            }

            public void checkTimeoutNotExhausted() {
            }

            public WarningCollector getWarningCollector() {
                return WarningCollector.NOOP;
            }

            public Optional<LogicalPropertiesProvider> getLogicalPropertiesProvider() {
                return Optional.of(this.val$logicalPropertiesProvider);
            }
        };
    }

    private /* synthetic */ String lambda$formatPlan$5(PlanNode plan, TypeProvider types, StatsProvider statsProvider, CostProvider costProvider, Session session) {
        return PlanPrinter.textLogicalPlan((PlanNode)plan, (TypeProvider)types, (StatsAndCosts)StatsAndCosts.create((PlanNode)plan, (StatsProvider)statsProvider, (CostProvider)costProvider, (Session)session), (FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager(), (Session)session, (int)2, (boolean)false, (boolean)SystemSessionProperties.isVerboseOptimizerInfoEnabled((Session)session));
    }

    public static class TestingStatsCalculator
    implements StatsCalculator {
        private final StatsCalculator delegate;
        private final Map<PlanNodeId, PlanNodeStatsEstimate> stats = new HashMap<PlanNodeId, PlanNodeStatsEstimate>();

        public TestingStatsCalculator(StatsCalculator delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
            if (this.stats.containsKey(node.getId())) {
                return this.stats.get(node.getId());
            }
            return this.delegate.calculateStats(node, sourceStats, lookup, session, types);
        }

        public void setNodeStats(PlanNodeId nodeId, PlanNodeStatsEstimate nodeStats) {
            this.stats.put(nodeId, nodeStats);
        }
    }

    private static class RuleApplication {
        private final Lookup lookup;
        private final StatsProvider statsProvider;
        private final TypeProvider types;
        private final Rule.Result result;
        private final Memo memo;

        public RuleApplication(Lookup lookup, StatsProvider statsProvider, TypeProvider types, Memo memo, Rule.Result result) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
            this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.result = Objects.requireNonNull(result, "result is null");
            this.memo = Objects.requireNonNull(memo, "memo is null");
        }

        private boolean wasRuleApplied() {
            return !this.result.isEmpty();
        }

        public PlanNode getTransformedPlan() {
            return (PlanNode)this.result.getTransformedPlan().orElseThrow(() -> new IllegalStateException("Rule did not produce transformed plan"));
        }

        private Memo getMemo() {
            return this.memo;
        }
    }
}

