/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCardinalityExtractorPlanVisitor {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();

    @Test
    public void testLimitOnTopOfValues() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), METADATA);
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.limit(3L, (PlanNode)planBuilder.values(Collections.emptyList(), (List<List<RowExpression>>)ImmutableList.of(Collections.emptyList())))), (Object)Range.singleton((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.limit(3L, (PlanNode)planBuilder.values(Collections.emptyList(), (List<List<RowExpression>>)ImmutableList.of(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList())))), (Object)Range.singleton((Comparable)Long.valueOf(3L)));
    }

    @Test
    public void testGlobalAggregation() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), METADATA);
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.addAggregation(planBuilder.variable("count", (Type)BigintType.BIGINT), planBuilder.rowExpression("count()")).globalGrouping().source((PlanNode)planBuilder.values(planBuilder.variable("x", (Type)BigintType.BIGINT), planBuilder.variable("y", (Type)BigintType.BIGINT), planBuilder.variable("z", (Type)BigintType.BIGINT))))), (Object)Range.singleton((Comparable)Long.valueOf(1L)));
    }

    @Test
    public void testSimpleGroupedAggregation() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), METADATA);
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.addAggregation(planBuilder.variable("count", (Type)BigintType.BIGINT), planBuilder.rowExpression("count()")).singleGroupingSet(planBuilder.variable("y", (Type)BigintType.BIGINT), planBuilder.variable("z", (Type)BigintType.BIGINT)).source((PlanNode)planBuilder.values(planBuilder.variable("x", (Type)BigintType.BIGINT), planBuilder.variable("y", (Type)BigintType.BIGINT), planBuilder.variable("z", (Type)BigintType.BIGINT))))), (Object)Range.atLeast((Comparable)Long.valueOf(0L)));
    }

    @Test
    public void testMultipleGlobalGroupingSets() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), METADATA);
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.addAggregation(planBuilder.variable("count", (Type)BigintType.BIGINT), planBuilder.rowExpression("count()")).groupingSets(new AggregationNode.GroupingSetDescriptor((List)ImmutableList.of(), 2, (Set)ImmutableSet.of((Object)0, (Object)1))).source((PlanNode)planBuilder.values(planBuilder.variable("x", (Type)BigintType.BIGINT), planBuilder.variable("y", (Type)BigintType.BIGINT), planBuilder.variable("z", (Type)BigintType.BIGINT))))), (Object)Range.singleton((Comparable)Long.valueOf(2L)));
    }

    @Test
    public void testEmptyAndNonEmptyGroupingSets() {
        PlanBuilder planBuilder = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), METADATA);
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.addAggregation(planBuilder.variable("count", (Type)BigintType.BIGINT), planBuilder.rowExpression("count()")).groupingSets(new AggregationNode.GroupingSetDescriptor((List)ImmutableList.of((Object)planBuilder.variable("y", (Type)BigintType.BIGINT)), 2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)planBuilder.values(planBuilder.variable("x", (Type)BigintType.BIGINT), planBuilder.variable("y", (Type)BigintType.BIGINT), planBuilder.variable("z", (Type)BigintType.BIGINT))))), (Object)Range.atLeast((Comparable)Long.valueOf(1L)));
    }
}

