/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.InlineProjections;
import com.facebook.presto.sql.planner.iterative.rule.PruneProjectColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneRedundantProjectionAssignments;
import com.facebook.presto.sql.planner.iterative.rule.PruneTableScanColumns;
import com.facebook.presto.sql.planner.iterative.rule.RemoveIdentityProjectionsBelowProjection;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.optimizations.CteProjectionAndPredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.LogicalCteOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.TestLogicalCteOptimizer;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.testng.annotations.Test;

public class TestCteProjectionAndPredicatePushdown
extends BasePlanTest {
    @Test
    public void testProjectionPushdown() {
        this.assertCtePlan("WITH  temp as (SELECT * FROM ORDERS) select * from (SELECT orderkey FROM temp) t JOIN (select custkey from temp) t2 ON true ", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders"))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0))))));
    }

    @Test
    public void testFilterPushdown() {
        this.assertCtePlan("WITH  temp as (SELECT * FROM ORDERS) select * from (SELECT * FROM temp where custkey=2) t JOIN (select * from temp where orderkey=1) t2 ON true ", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0), PlanMatchPattern.filter("custkey = 2 OR orderkey = 1", PlanMatchPattern.tableScan("orders", TestCteProjectionAndPredicatePushdown.identityMap("custkey", "orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0))))));
    }

    @Test
    public void testComplexQueryFilterPushdown() {
        String testQuery = "WITH  nation_region AS (                 SELECT n.name, r.comment AS region_comment, n.comment AS nation_comment                FROM region r join nation n on (r.regionkey=n.regionkey)) select * from nation_region where name = 'abc' union all select * from nation_region where name = 'bcd'";
        this.assertCtePlan(testQuery, PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("nation_region", 0), PlanMatchPattern.project(PlanMatchPattern.filter("name = 'abc' or name = 'bcd'", PlanMatchPattern.join(PlanMatchPattern.tableScan("region"), PlanMatchPattern.tableScan("nation", TestCteProjectionAndPredicatePushdown.identityMap("name", "comment", "regionkey")))))), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("nation_region", 0))))));
    }

    @Test
    public void testNoFilterPushdown() {
        this.assertCtePlan("WITH  temp as (SELECT * FROM ORDERS) select * from (SELECT * FROM temp where custkey=2) t JOIN (select * from temp) t2 ON true ", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0), PlanMatchPattern.tableScan("orders")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.anyTree(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0))), PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0)))))));
    }

    @Test
    public void testNoProjectionPushdown() {
        this.assertCtePlan("WITH  temp as (SELECT * FROM ORDERS) select * from (SELECT custkey FROM temp) t JOIN (select * from temp) t2 ON true ", PlanMatchPattern.anyTree(PlanMatchPattern.sequence(PlanMatchPattern.cteProducer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0), PlanMatchPattern.tableScan("orders")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.project(PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0))), PlanMatchPattern.cteConsumer(TestLogicalCteOptimizer.addQueryScopeDelimiter("temp", 0)))))));
    }

    private void assertCtePlan(String sql, PlanMatchPattern pattern) {
        Metadata metadata = this.getQueryRunner().getMetadata();
        ImmutableList optimizers = ImmutableList.of((Object)new LogicalCteOptimizer(metadata), (Object)new PruneUnreferencedOutputs(), (Object)new UnaliasSymbolReferences(metadata.getFunctionAndTypeManager()), (Object)new IterativeOptimizer(metadata, new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getCostCalculator(), (Set)ImmutableSet.of((Object)new InlineProjections(metadata.getFunctionAndTypeManager()), (Object)new PruneProjectColumns(), (Object)new PruneTableScanColumns(), (Object)new RemoveRedundantIdentityProjections(), (Object)new RemoveIdentityProjectionsBelowProjection(), (Object)new PruneRedundantProjectionAssignments(), (Object[])new Rule[0])), (Object)new PruneUnreferencedOutputs(), (Object)new CteProjectionAndPredicatePushDown(metadata));
        this.assertPlan(sql, this.getSession(), Optimizer.PlanStage.OPTIMIZED, pattern, (List<PlanOptimizer>)optimizers);
    }

    private Session getSession() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("cte_materialization_strategy", "ALL").setSystemProperty("cte_filter_and_projection_pushdown_enabled", "true").build();
    }

    private static Map<String, String> identityMap(String ... values) {
        return (Map)Arrays.stream(values).collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), (Function)Functions.identity()));
    }
}

