/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.optimizations.AddExchanges;
import com.facebook.presto.sql.planner.optimizations.AddLocalExchanges;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestEliminateSorts
extends BasePlanTest {
    private static final String QUANTITY_ALIAS = "QUANTITY";
    private static final String TAX_ALIAS = "TAX";
    private static final ExpectedValueProvider<WindowNode.Specification> windowSpec = PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"QUANTITY"), (Map<String, SortOrder>)ImmutableMap.of((Object)"QUANTITY", (Object)SortOrder.ASC_NULLS_LAST));
    private static final PlanMatchPattern LINEITEM_TABLESCAN_Q_BASIC = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity"));
    private static final PlanMatchPattern LINEITEM_TABLESCAN_Q = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity", (Object)"TAX", (Object)"tax"));

    @Test
    public void testEliminateSortsBasic() {
        String sql = "SELECT quantity, row_number() OVER (ORDER BY quantity) FROM lineitem ORDER BY quantity";
        PlanMatchPattern pattern = PlanMatchPattern.output(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowSpec).addFunction(PlanMatchPattern.functionCall("row_number", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN_Q_BASIC)));
        this.assertUnitPlan(sql, pattern);
    }

    @Test
    public void testDoesNotEliminateSortsWithFilter() {
        String sql = "SELECT * FROM (SELECT quantity, count(tax) OVER (ORDER BY quantity) AS c  FROM lineitem) WHERE c > 3 ORDER BY quantity";
        PlanMatchPattern pattern = PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.sort(PlanMatchPattern.filter("C > 3", PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowSpec).addFunction("C", PlanMatchPattern.functionCall("count", Optional.empty(), (List<String>)ImmutableList.of((Object)TAX_ALIAS))), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN_Q)))))));
        this.assertUnitPlan(sql, pattern);
    }

    @Test
    public void testNotEliminateSorts() {
        String sql = "SELECT quantity, row_number() OVER (ORDER BY quantity) FROM lineitem ORDER BY tax";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort(PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowSpec).addFunction(PlanMatchPattern.functionCall("row_number", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN_Q)))));
        this.assertUnitPlan(sql, pattern);
    }

    public void assertUnitPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(this.getMetadata().getFunctionAndTypeManager()), (Object)new PruneUnreferencedOutputs(), (Object)new IterativeOptimizer(this.getMetadata(), new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), (Object)new AddExchanges(this.getQueryRunner().getMetadata(), new PartitioningProviderManager(), false), (Object)new AddLocalExchanges(this.getMetadata(), false), (Object)new UnaliasSymbolReferences(this.getMetadata().getFunctionAndTypeManager()), (Object)new PruneUnreferencedOutputs(), (Object)new IterativeOptimizer(this.getMetadata(), new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())));
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("task_concurrency", "4").build();
        this.assertPlan(sql, session, Optimizer.PlanStage.OPTIMIZED, pattern, (List<PlanOptimizer>)optimizers);
    }
}

