/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.ExpectedValueProvider;
import com.facebook.presto.sql.planner.assertions.ExpressionMatcher;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.iterative.rule.test.RuleTester;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.ReplaceConstantVariableReferencesWithConstants;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestReplaceConstantVariableReferencesWithConstants
extends BasePlanTest {
    private Session enableOptimization() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("rewrite_expression_with_constant_expression", "true").build();
    }

    @Test
    public void testAggregation() {
        this.assertPlan("select orderkey, orderpriority, avg(totalprice) from orders where orderpriority='3-MEDIUM' group by 1, 2", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"expr_12", (Object)"avg"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_12", (Object)PlanMatchPattern.expression("'3-MEDIUM'")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"avg", PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"totalprice"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderpriority = '3-MEDIUM'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"orderpriority", (Object)"orderpriority", (Object)"totalprice", (Object)"totalprice"))))))));
    }

    @Test
    public void testUnnest() {
        this.assertPlan("select orderkey, orderpriority, idx from orders cross join unnest(array[1, 2]) t(idx) where orderpriority='3-MEDIUM'", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"expr_9", (Object)"field"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_9", (Object)PlanMatchPattern.expression("'3-MEDIUM'")), PlanMatchPattern.unnest((Map<String, List<String>>)ImmutableMap.of((Object)"expr", (Object)ImmutableList.of((Object)"field")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("array[1, 2]")), PlanMatchPattern.filter("orderpriority = '3-MEDIUM'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"orderpriority", (Object)"orderpriority"))))))));
    }

    @Test
    public void testInnerJoin() {
        this.assertPlan("select o.orderkey, o.orderpriority, l.tax from lineitem l join orders o on o.orderkey = l.orderkey where o.orderpriority='3-MEDIUM'", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey_0", (Object)"expr_14", (Object)"tax"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_14", (Object)PlanMatchPattern.expression("'3-MEDIUM'")), PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderkey", "orderkey_0")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"tax", (Object)"tax"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderpriority = '3-MEDIUM'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey_0", (Object)"orderkey", (Object)"orderpriority", (Object)"orderpriority"))))))));
    }

    @Test
    public void testLeftJoinNotTrigger() {
        this.assertPlan("select o.orderkey, o.orderpriority, l.tax from lineitem l left join (select orderkey, orderpriority from orders where orderpriority='3-MEDIUM') o on o.orderkey = l.orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey_0", (Object)"expr_9", (Object)"tax"), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderkey", "orderkey_0")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"tax", (Object)"tax"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_9", (Object)PlanMatchPattern.expression("'3-MEDIUM'")), PlanMatchPattern.filter("orderpriority = '3-MEDIUM'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey_0", (Object)"orderkey", (Object)"orderpriority", (Object)"orderpriority"))))))));
    }

    @Test
    public void testLeftJoinTrigger() {
        this.assertPlan("select o.orderkey, l.linestatus, l.tax from (select tax, linestatus, orderkey from lineitem where linestatus ='O') l left join orders o on o.orderkey = l.orderkey", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey_0", (Object)"expr_26", (Object)"tax"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_26", (Object)PlanMatchPattern.expression("'O'")), PlanMatchPattern.join(JoinType.LEFT, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderkey", "orderkey_0")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("linestatus = 'O'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"tax", (Object)"tax", (Object)"linestatus", (Object)"linestatus")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey_0", (Object)"orderkey")))))));
    }

    @Test
    public void testSemiJoin() {
        this.assertPlan("select orderpriority, orderkey from orders where orderpriority='3-MEDIUM' and orderkey in (select orderkey from lineitem)", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"expr_15", (Object)"orderkey"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_15", (Object)PlanMatchPattern.expression("'3-MEDIUM'")), PlanMatchPattern.filter("expr_8", PlanMatchPattern.project(PlanMatchPattern.semiJoin("orderkey", "orderkey_1", "expr_8", PlanMatchPattern.project(PlanMatchPattern.filter("orderpriority = '3-MEDIUM'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"orderpriority", (Object)"orderpriority")))), PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_1", (Object)"orderkey"))))))))));
    }

    @Test
    public void testSimpleFilter() {
        this.assertPlan("select orderkey, orderpriority from orders where orderpriority='3-MEDIUM'", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey", (Object)"expr_6"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_6", (Object)PlanMatchPattern.expression("'3-MEDIUM'")), PlanMatchPattern.filter("orderpriority = '3-MEDIUM'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"orderpriority", (Object)"orderpriority"))))));
    }

    @Test
    public void testFilterOnSameVariable() {
        this.assertPlan("select orderkey, orderpriority from orders where orderpriority='3-MEDIUM' and orderpriority='5-HIGH'", this.enableOptimization(), PlanMatchPattern.output(PlanMatchPattern.values("orderkey", "orderpriority")));
    }

    @Test
    public void testJoinWithFilter() {
        this.assertPlan("with t1 as (select orderkey, orderstatus from orders where orderkey = 10) select l.orderkey, partkey, orderstatus from t1 join lineitem l on t1.orderkey = l.orderkey where partkey in (select suppkey from lineitem)", this.enableOptimization(), PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"orderkey_9", (Object)"partkey", (Object)"orderstatus"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey_9", (Object)PlanMatchPattern.expression("10")), PlanMatchPattern.filter("expr_37", PlanMatchPattern.project(PlanMatchPattern.semiJoin("partkey", "suppkey_17", "expr_37", PlanMatchPattern.project(PlanMatchPattern.join(JoinType.INNER, (List<ExpectedValueProvider<EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderkey = 10", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"orderkey", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderkey_9 = 10", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey_9", (Object)"orderkey", (Object)"partkey", (Object)"partkey")))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"suppkey_17", (Object)"suppkey")))))))));
    }

    @Test
    public void testConstantRowExpression() {
        this.assertPlan("select orderkey+1 as nk from lineitem where orderkey=1", this.enableOptimization(), PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("2")), PlanMatchPattern.filter("orderkey=1", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
    }

    @Test
    public void testSort() {
        this.assertPlan("select orderkey, orderpriority from orders where orderpriority='3-MEDIUM' order by orderpriority", this.enableOptimization(), PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("orderkey"), (Object)"orderpriority", (Object)PlanMatchPattern.expression("'3-MEDIUM'")), PlanMatchPattern.filter("orderpriority='3-MEDIUM'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderpriority", (Object)"orderpriority", (Object)"orderkey", (Object)"orderkey"))))));
    }

    @Test
    public void testSortOnMultipleKey() {
        ImmutableList orderBy = ImmutableList.of((Object)PlanMatchPattern.sort("orderkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST));
        this.assertPlan("select orderkey, orderpriority from orders where orderpriority='3-MEDIUM' order by orderpriority, orderkey", this.enableOptimization(), PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("orderkey"), (Object)"orderpriority", (Object)PlanMatchPattern.expression("'3-MEDIUM'")), PlanMatchPattern.anyTree(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("orderkey")), PlanMatchPattern.filter("orderpriority='3-MEDIUM'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderpriority", (Object)"orderpriority", (Object)"orderkey", (Object)"orderkey"))))))))));
    }

    @Test
    public void testTopN() {
        this.assertPlan("select orderkey, orderpriority from orders where orderpriority='3-MEDIUM' order by orderpriority limit 10", this.enableOptimization(), PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("orderkey"), (Object)"orderpriority", (Object)PlanMatchPattern.expression("'3-MEDIUM'")), PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderpriority='3-MEDIUM'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderpriority", (Object)"orderpriority", (Object)"orderkey", (Object)"orderkey"))))))));
    }

    @Test
    public void testTopNSortOnMultipleKey() {
        ImmutableList orderBy = ImmutableList.of((Object)PlanMatchPattern.sort("orderkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST));
        this.assertPlan("select orderkey, orderpriority from orders where orderpriority='3-MEDIUM' order by orderpriority, orderkey limit 10", this.enableOptimization(), PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("orderkey"), (Object)"orderpriority", (Object)PlanMatchPattern.expression("'3-MEDIUM'")), PlanMatchPattern.topN(10L, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.anyTree(PlanMatchPattern.topN(10L, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("orderkey")), PlanMatchPattern.filter("orderpriority='3-MEDIUM'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderpriority", (Object)"orderpriority", (Object)"orderkey", (Object)"orderkey"))))))))));
    }

    @Test
    public void testUnionAllWithSameConstant() {
        this.assertPlan("select orderkey, price, count(*) from (select orderkey, extendedprice as price from lineitem where orderkey=5 union all select orderkey, totalprice as price from orders where orderkey=5) group by orderkey, price", this.enableOptimization(), PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey_11", (Object)PlanMatchPattern.expression("5")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"count_29"))), PlanMatchPattern.exchange(PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_29", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.filter("orderkey = 5", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"extendedprice", (Object)"extendedprice", (Object)"orderkey", (Object)"orderkey")))))), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_29", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.filter("orderkey_4 = 5", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey_4", (Object)"orderkey", (Object)"totalprice", (Object)"totalprice")))))))))));
    }

    @Test
    public void testUnionAllWithDifferentConstant() {
        this.assertPlan("select orderkey, price, count(*) from (select orderkey, extendedprice as price from lineitem where orderkey=5 union all select orderkey, totalprice as price from orders where orderkey=2) group by orderkey, price", this.enableOptimization(), PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey_11", (Object)PlanMatchPattern.expression("orderkey_11")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"count_29"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey_11", (Object)PlanMatchPattern.expression("orderkey")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_29", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("5")), PlanMatchPattern.filter("orderkey = 5", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"extendedprice", (Object)"extendedprice")))))))), PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey_11", (Object)PlanMatchPattern.expression("orderkey_4")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_29", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey_4", (Object)PlanMatchPattern.expression("2")), PlanMatchPattern.filter("orderkey_4 = 2", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey_4", (Object)"orderkey", (Object)"totalprice", (Object)"totalprice")))))))))))));
    }

    @Test
    public void testUnionAllWithOneConstant() {
        this.assertPlan("select orderkey, price, count(*) from (select orderkey, extendedprice as price from lineitem where orderkey=5 union all select orderkey, totalprice as price from orders) group by orderkey, price", this.enableOptimization(), PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey_11", (Object)PlanMatchPattern.expression("orderkey_11")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"count_29"))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey_11", (Object)PlanMatchPattern.expression("orderkey")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_29", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey", (Object)PlanMatchPattern.expression("5")), PlanMatchPattern.filter("orderkey = 5", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"extendedprice", (Object)"extendedprice")))))))), PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"orderkey_11", (Object)PlanMatchPattern.expression("orderkey_4")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_29", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey_4", (Object)"orderkey", (Object)"totalprice", (Object)"totalprice")))))))))));
    }

    @Test
    public void testExtractConstantFromFilter() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression count = planBuilder.variable("cnt");
            return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.filter(planBuilder.rowExpression("key1= 3"), (PlanNode)planBuilder.values(key1, key2))).singleGroupingSet(key1, key2).addAggregation(count, planBuilder.rowExpression("count()")));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"cnt", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("3")), PlanMatchPattern.filter("key1=3", PlanMatchPattern.values("key1", "key2")))));
    }

    @Test
    public void testJoinPlanChange() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            return planBuilder.join(JoinType.INNER, (PlanNode)planBuilder.filter(planBuilder.rowExpression("key1= 3"), (PlanNode)planBuilder.values(key1)), (PlanNode)planBuilder.filter(planBuilder.rowExpression("key2= 5"), (PlanNode)planBuilder.values(key2)), new EquiJoinClause[0]);
        }).matches(PlanMatchPattern.join(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("3")), PlanMatchPattern.filter("key1=3", PlanMatchPattern.values("key1"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key2", (Object)PlanMatchPattern.expression("5")), PlanMatchPattern.filter("key2=5", PlanMatchPattern.values("key2")))));
    }

    @Test
    public void testUnionPlanChange() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression input1Source1 = planBuilder.variable("input1_source1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression input2Source1 = planBuilder.variable("input2_source1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression input1Source2 = planBuilder.variable("input1_source2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression input2Source2 = planBuilder.variable("input2_source2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression output1 = planBuilder.variable("output1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression output2 = planBuilder.variable("output2", (Type)IntegerType.INTEGER);
            return planBuilder.union((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)ImmutableListMultimap.builder().putAll((Object)output1, (Object[])new VariableReferenceExpression[]{input1Source1, input1Source2}).putAll((Object)output2, (Object[])new VariableReferenceExpression[]{input2Source1, input2Source2}).build(), (List<PlanNode>)ImmutableList.of((Object)planBuilder.filter(planBuilder.rowExpression("input1_source1 = 3"), (PlanNode)planBuilder.values(input1Source1, input2Source1)), (Object)planBuilder.filter(planBuilder.rowExpression("input1_source2 = 3"), (PlanNode)planBuilder.values(input1Source2, input2Source2))));
        }).matches(PlanMatchPattern.union(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"input1_source1", (Object)PlanMatchPattern.expression("3"), (Object)"input2_source1", (Object)PlanMatchPattern.expression("input2_source1")), PlanMatchPattern.filter("input1_source1=3", PlanMatchPattern.values("input1_source1", "input2_source1"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"input1_source2", (Object)PlanMatchPattern.expression("3"), (Object)"input2_source2", (Object)PlanMatchPattern.expression("input2_source2")), PlanMatchPattern.filter("input1_source2=3", PlanMatchPattern.values("input1_source2", "input2_source2")))));
    }

    @Test
    public void testConflictFilter() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression count = planBuilder.variable("cnt");
            return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.filter(planBuilder.rowExpression("key1=2"), (PlanNode)planBuilder.filter(planBuilder.rowExpression("key1= 3"), (PlanNode)planBuilder.values(key1, key2)))).singleGroupingSet(key1, key2).addAggregation(count, planBuilder.rowExpression("count()")));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"cnt", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.filter("key1=2", PlanMatchPattern.filter("key1=3", PlanMatchPattern.values("key1", "key2")))));
    }

    @Test
    public void testConflictFilterConjunct() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression count = planBuilder.variable("cnt");
            return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.filter(planBuilder.rowExpression("key1=2 and key2=5"), (PlanNode)planBuilder.filter(planBuilder.rowExpression("key1= 3"), (PlanNode)planBuilder.values(key1, key2)))).singleGroupingSet(key1, key2).addAggregation(count, planBuilder.rowExpression("count()")));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"cnt", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.filter("key1=2 and key2=5", PlanMatchPattern.filter("key1=3", PlanMatchPattern.values("key1", "key2")))));
    }

    @Test
    public void testNonConflictFilter() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression count = planBuilder.variable("cnt");
            return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.filter(planBuilder.rowExpression("key1=3"), (PlanNode)planBuilder.filter(planBuilder.rowExpression("key1= 3"), (PlanNode)planBuilder.values(key1, key2)))).singleGroupingSet(key1, key2).addAggregation(count, planBuilder.rowExpression("count()")));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"cnt", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("3")), PlanMatchPattern.filter("3=3", PlanMatchPattern.filter("key1=3", PlanMatchPattern.values("key1", "key2"))))));
    }

    @Test
    public void testNonConflictFilterConjunct() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression count = planBuilder.variable("cnt");
            return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.filter(planBuilder.rowExpression("key1=3 and key2=5"), (PlanNode)planBuilder.filter(planBuilder.rowExpression("key1= 3"), (PlanNode)planBuilder.values(key1, key2)))).singleGroupingSet(key1, key2).addAggregation(count, planBuilder.rowExpression("count()")));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"cnt", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("3"), (Object)"key2", (Object)PlanMatchPattern.expression("5")), PlanMatchPattern.filter("3=3 and key2=5", PlanMatchPattern.filter("key1=3", PlanMatchPattern.values("key1", "key2"))))));
    }

    @Test
    public void testFilterOnExpression() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression count = planBuilder.variable("cnt");
            return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.filter(planBuilder.rowExpression("key2=key1+2"), (PlanNode)planBuilder.filter(planBuilder.rowExpression("key1= 3"), (PlanNode)planBuilder.values(key1, key2)))).singleGroupingSet(key1, key2).addAggregation(count, planBuilder.rowExpression("count()")));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"cnt", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("3"), (Object)"key2", (Object)PlanMatchPattern.expression("key2")), PlanMatchPattern.filter("key2=3+2", PlanMatchPattern.filter("key1=3", PlanMatchPattern.values("key1", "key2"))))));
    }

    @Test
    public void testFilterAndProjectOnExpression() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression count = planBuilder.variable("cnt");
            return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.project(PlanBuilder.assignment(key2, planBuilder.rowExpression("key1+2"), key1, planBuilder.rowExpression("key1")), (PlanNode)planBuilder.filter(planBuilder.rowExpression("key1= 3"), (PlanNode)planBuilder.values(key1, key2)))).singleGroupingSet(key1, key2).addAggregation(count, planBuilder.rowExpression("count()")));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"cnt", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("3"), (Object)"key2", (Object)PlanMatchPattern.expression("key2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key2", (Object)PlanMatchPattern.expression("3+2"), (Object)"key1", (Object)PlanMatchPattern.expression("3")), PlanMatchPattern.filter("key1=3", PlanMatchPattern.values("key1", "key2"))))));
    }

    @Test
    public void testConflictFilterAndProject() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression count = planBuilder.variable("cnt");
            return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.filter(planBuilder.rowExpression("key1= 3"), (PlanNode)planBuilder.project(PlanBuilder.assignment(key1, planBuilder.rowExpression("2"), key2, planBuilder.rowExpression("key2")), (PlanNode)planBuilder.values(key1, key2)))).singleGroupingSet(key1, key2).addAggregation(count, planBuilder.rowExpression("count()")));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"cnt", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.filter("key1=3", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("2")), PlanMatchPattern.values("key1", "key2")))));
    }

    @Test
    public void testExtractConstantFromProject() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression count = planBuilder.variable("cnt");
            return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.filter(planBuilder.rowExpression("key2 <> 3"), (PlanNode)planBuilder.project(PlanBuilder.assignment(key1, planBuilder.rowExpression("3"), key2, planBuilder.rowExpression("key2")), (PlanNode)planBuilder.values(key1, key2)))).singleGroupingSet(key1, key2).addAggregation(count, planBuilder.rowExpression("count()")));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"cnt", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("3")), PlanMatchPattern.filter("key2 <> 3", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("3"), (Object)"key2", (Object)PlanMatchPattern.expression("key2")), PlanMatchPattern.values("key1", "key2"))))));
    }

    @Test
    public void testConflictConstantFromProject() {
        RuleTester tester = new RuleTester();
        tester.assertThat((PlanOptimizer)new ReplaceConstantVariableReferencesWithConstants(FunctionAndTypeManager.createTestFunctionAndTypeManager())).on(planBuilder -> {
            VariableReferenceExpression key1 = planBuilder.variable("key1", (Type)IntegerType.INTEGER);
            VariableReferenceExpression key2 = planBuilder.variable("key2", (Type)IntegerType.INTEGER);
            VariableReferenceExpression count = planBuilder.variable("cnt");
            return planBuilder.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)planBuilder.filter(planBuilder.rowExpression("key2 <> 3"), (PlanNode)planBuilder.project(PlanBuilder.assignment(key1, planBuilder.rowExpression("5"), key2, planBuilder.rowExpression("key2")), (PlanNode)planBuilder.project(PlanBuilder.assignment(key1, planBuilder.rowExpression("3"), key2, planBuilder.rowExpression("key2")), (PlanNode)planBuilder.values(key1, key2))))).singleGroupingSet(key1, key2).addAggregation(count, planBuilder.rowExpression("count()")));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"cnt", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("5")), PlanMatchPattern.filter("key2 <> 3", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("5"), (Object)"key2", (Object)PlanMatchPattern.expression("key2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key1", (Object)PlanMatchPattern.expression("3"), (Object)"key2", (Object)PlanMatchPattern.expression("key2")), PlanMatchPattern.values("key1", "key2")))))));
    }
}

