/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.SetFlatteningOptimizer;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.testng.annotations.Test;

public class TestSetFlatteningOptimizer
extends BasePlanTest {
    @Test
    public void testFlattensUnion() {
        this.assertPlan("(SELECT * FROM nation UNION SELECT * FROM nation)UNION (SELECT * FROM nation UNION SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testFlattensUnionAll() {
        this.assertPlan("(SELECT * FROM nation UNION ALL SELECT * FROM nation)UNION ALL (SELECT * FROM nation UNION ALL SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testFlattensUnionAndUnionAllWhenAllowed() {
        this.assertPlan("SELECT * FROM nation UNION ALL (SELECT * FROM nation UNION (SELECT * FROM nation UNION ALL select * FROM nation))", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))))));
    }

    @Test
    public void testFlattensIntersect() {
        this.assertPlan("(SELECT * FROM nation INTERSECT SELECT * FROM nation)INTERSECT (SELECT * FROM nation INTERSECT SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.intersect(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testFlattensOnlyFirstInputOfExcept() {
        this.assertPlan("(SELECT * FROM nation EXCEPT SELECT * FROM nation)EXCEPT (SELECT * FROM nation EXCEPT SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.except(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.except(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation")))));
    }

    @Test
    public void testDoesNotFlattenDifferentSetOperations() {
        this.assertPlan("(SELECT * FROM nation EXCEPT SELECT * FROM nation)UNION (SELECT * FROM nation INTERSECT SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.except(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation")), PlanMatchPattern.intersect(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation")))));
    }

    @Override
    public void assertPlan(String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(this.getMetadata().getFunctionAndTypeManager()), (Object)new PruneUnreferencedOutputs(), (Object)new IterativeOptimizer(this.getMetadata(), new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getEstimatedExchangesCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), (Object)new SetFlatteningOptimizer());
        this.assertPlan(sql, pattern, (List<PlanOptimizer>)optimizers);
    }
}

