/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.metadata.AbstractMockMetadata;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.StageExecutionDescriptor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.testing.TestingHandle;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPlanPrinter {
    private static final PlanBuilder PLAN_BUILDER = new PlanBuilder(SessionTestUtils.TEST_SESSION, new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    private static final VariableReferenceExpression COLUMN_VARIABLE = new VariableReferenceExpression(Optional.empty(), "column", (Type)VarcharType.VARCHAR);
    private static final ColumnHandle COLUMN_HANDLE = new TestingMetadata.TestingColumnHandle("column");
    private static final TableHandle TABLE_HANDLE_WITH_LAYOUT = new TableHandle(new ConnectorId("testConnector"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(TestingHandle.INSTANCE));

    private String domainToPrintedScan(VariableReferenceExpression variable, ColumnHandle colHandle, Domain domain) {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)colHandle, (Object)domain).build());
        TableScanNode scanNode = PLAN_BUILDER.tableScan(TABLE_HANDLE_WITH_LAYOUT, (List<VariableReferenceExpression>)ImmutableList.of((Object)variable), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)variable, (Object)colHandle), (TupleDomain<ColumnHandle>)tupleDomain, (TupleDomain<ColumnHandle>)tupleDomain);
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId(0), (PlanNode)scanNode, (Set)ImmutableSet.of((Object)variable), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)scanNode.getId()), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SOURCE_DISTRIBUTION, (Collection)ImmutableList.of()), (List)ImmutableList.of((Object)variable)), StageExecutionDescriptor.ungroupedExecution(), false, Optional.of(StatsAndCosts.empty()), Optional.empty());
        return PlanPrinter.textPlanFragment((PlanFragment)testFragment, (FunctionAndTypeManager)FUNCTION_AND_TYPE_MANAGER, (Session)SessionTestUtils.TEST_SESSION, (boolean)false);
    }

    private void assertDomainFormat(VariableReferenceExpression variable, ColumnHandle colHandle, Domain domain, String expected) {
        String printed = this.domainToPrintedScan(variable, colHandle, domain);
        Assert.assertTrue((boolean)printed.contains(":: " + expected));
    }

    private void assertDomainFormat(Domain domain, String expected) {
        this.assertDomainFormat(COLUMN_VARIABLE, COLUMN_HANDLE, domain, expected);
    }

    @Test
    public void testDomainTextFormatting() {
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.all((Type)VarcharType.VARCHAR), (boolean)false), "[(<min>, <max>)]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"some string"), (Object[])new Object[0]), (boolean)false), "[[\"some string\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"here's a quote: \""), (Object[])new Object[0]), (boolean)false), "[[\"here's a quote: \\\"\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)""), (Object[])new Object[0]), (boolean)false), "[[\"\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"string with \"quotes\" inside")).intersect(Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"this string's quote is here -> \""))), (Range[])new Range[0]), (boolean)false), "[[\"string with \\\"quotes\\\" inside\", \"this string's quote is here -> \\\"\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"string with \"quotes\" inside")).intersect(Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"this string's quote is here -> \""))), (Range[])new Range[0]), (boolean)false), "[(\"string with \\\"quotes\\\" inside\", \"this string's quote is here -> \\\"\")]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"<min>"), (Object[])new Object[0]), (boolean)false), "[[\"<min>\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"<max>"), (Object[])new Object[0]), (boolean)false), "[[\"<max>\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"<min>, <max>"), (Object[])new Object[0]), (boolean)false), "[[\"<min>, <max>\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a")).intersect(Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"b"))), (Range[])new Range[0]), (boolean)false), "[[\"a\", \"b\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a, b"), (Object[])new Object[0]), (boolean)false), "[[\"a, b\"]]");
        this.assertDomainFormat(Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"xyz"), (Object[])new Object[0]), (boolean)true), "[NULL, [\"xyz\"]]");
        this.assertDomainFormat(Domain.onlyNull((Type)VarcharType.VARCHAR), "[NULL]");
    }
}

