/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.sanity.CheckUnsupportedPrestissimoTypes;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.type.IpAddressType;
import java.util.function.Function;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCheckUnsupportedPrestissimoTypes
extends BasePlanTest {
    private Session testSession;
    private Metadata metadata;
    private PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private FeaturesConfig featuresConfig = new FeaturesConfig();

    @BeforeClass
    public void setup() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny");
        this.testSession = sessionBuilder.build();
        this.metadata = this.getQueryRunner().getMetadata();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.testSession = null;
        this.metadata = null;
        this.idAllocator = null;
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Timestamp with Timezone type is not supported in Prestissimo")
    public void testValidateTimestampTZProjectFail() {
        this.validatePlan(p -> {
            VariableReferenceExpression col = p.variable("col", (Type)VarcharType.VARCHAR);
            VariableReferenceExpression col2 = p.variable("col2", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
            return p.project(PlanBuilder.assignment(col2, p.rowExpression("cast(col as timestamp with time zone)")), (PlanNode)p.values(col));
        });
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Timestamp with Timezone type is not supported in Prestissimo")
    public void testValidateTimestampTZProjectAssignmentFail() {
        this.validatePlan(p -> {
            VariableReferenceExpression col = p.variable("col", (Type)VarcharType.VARCHAR);
            VariableReferenceExpression col1 = p.variable("col1", (Type)VarcharType.VARCHAR);
            VariableReferenceExpression col2 = p.variable("col2", (Type)BooleanType.BOOLEAN);
            return p.project(PlanBuilder.assignment(col2, p.rowExpression("cast(col as timestamp with time zone) > cast(col1 as timestamp with time zone)")), (PlanNode)p.values(col, col1));
        });
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Timestamp with Timezone type is not supported in Prestissimo")
    public void testValidateTimestampTZValueFail() {
        this.validatePlan(p -> {
            VariableReferenceExpression col = p.variable("col", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
            VariableReferenceExpression col2 = p.variable("col2", (Type)VarcharType.VARCHAR);
            return p.project(PlanBuilder.assignment(col2, p.rowExpression("cast(col as varchar)")), (PlanNode)p.values(col));
        });
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="IPAddress type is not supported in Prestissimo")
    public void testValidateIPAddressProjectFail() {
        this.validatePlan(p -> {
            VariableReferenceExpression col = p.variable("col", (Type)VarcharType.VARCHAR);
            VariableReferenceExpression col2 = p.variable("col2", (Type)IpAddressType.IPADDRESS);
            return p.project(PlanBuilder.assignment(col2, p.rowExpression("cast(col as ipaddress)")), (PlanNode)p.values(col));
        });
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="IPAddress type is not supported in Prestissimo")
    public void testValidateIPAddressProjectAssignmentFail() {
        this.validatePlan(p -> {
            VariableReferenceExpression col = p.variable("col", (Type)VarcharType.VARCHAR);
            VariableReferenceExpression col1 = p.variable("col1", (Type)VarcharType.VARCHAR);
            VariableReferenceExpression col2 = p.variable("col2", (Type)BooleanType.BOOLEAN);
            return p.project(PlanBuilder.assignment(col2, p.rowExpression("cast(col as ipaddress) > cast(col1 as ipaddress)")), (PlanNode)p.values(col, col1));
        });
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="IPAddress type is not supported in Prestissimo")
    public void testValidateIPAddressValueFail() {
        this.validatePlan(p -> {
            VariableReferenceExpression col = p.variable("col", (Type)IpAddressType.IPADDRESS);
            VariableReferenceExpression col2 = p.variable("col2", (Type)VarcharType.VARCHAR);
            return p.project(PlanBuilder.assignment(col2, p.rowExpression("cast(col as varchar)")), (PlanNode)p.values(col));
        });
    }

    private void validatePlan(Function<PlanBuilder, PlanNode> planProvider) {
        PlanBuilder builder = new PlanBuilder(SessionTestUtils.TEST_SESSION, this.idAllocator, this.metadata);
        PlanNode planNode = planProvider.apply(builder);
        TypeProvider types = builder.getTypes();
        this.getQueryRunner().inTransaction(this.testSession, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new CheckUnsupportedPrestissimoTypes(this.featuresConfig).validate(planNode, session, this.metadata, WarningCollector.NOOP);
            return null;
        });
    }
}

