/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.FunctionsConfig;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.sanity.ValidateStreamingJoins;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.facebook.presto.tracing.TracingConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestValidateStreamingJoins
extends BasePlanTest {
    private Session defaultSession;
    private Session spillSession;
    private Metadata metadata;
    private PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private TableHandle nationTableHandle;
    private TableHandle supplierTableHandle;
    private ColumnHandle nationColumnHandle;
    private ColumnHandle suppColumnHandle;

    @BeforeClass
    public void setup() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny");
        this.defaultSession = sessionBuilder.build();
        this.spillSession = TestingSession.testSessionBuilder((SessionPropertyManager)SessionPropertyManager.createTestingSessionPropertyManager((SystemSessionProperties)new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), new FeaturesConfig().setSpillerSpillPaths("/path/to/nowhere"), new FunctionsConfig(), new NodeMemoryConfig(), new WarningCollectorConfig(), new NodeSchedulerConfig(), new NodeSpillConfig(), new TracingConfig(), new CompilerConfig(), new HistoryBasedOptimizationConfig()))).setCatalog("local").setSchema("tiny").setSystemProperty("spill_enabled", "true").setSystemProperty("join_spill_enabled", "true").build();
        this.metadata = this.getQueryRunner().getMetadata();
        TpchTableHandle nationTpchTableHandle = new TpchTableHandle("nation", 1.0);
        TpchTableHandle supplierTpchTableHandle = new TpchTableHandle("supplier", 1.0);
        ConnectorId connectorId = this.getCurrentConnectorId();
        this.nationTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)nationTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(nationTpchTableHandle, TupleDomain.all())));
        this.supplierTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)supplierTpchTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(new TpchTableLayoutHandle(supplierTpchTableHandle, TupleDomain.all())));
        this.nationColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.suppColumnHandle = new TpchColumnHandle("suppkey", (Type)BigintType.BIGINT);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.defaultSession = null;
        this.spillSession = null;
        this.metadata = null;
        this.idAllocator = null;
        this.nationTableHandle = null;
        this.supplierTableHandle = null;
    }

    @Test
    public void testValidateSuccessful() {
        this.validatePlan(p -> p.join(JoinType.INNER, (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle)), (PlanNode)p.exchange(e -> e.scope(ExchangeNode.Scope.LOCAL).type(ExchangeNode.Type.REPARTITION).addSource((PlanNode)p.tableScan(this.supplierTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle, (Object)p.variable("suppkey", (Type)BigintType.BIGINT), (Object)this.suppColumnHandle))).addInputsSet((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT))).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT)))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkeyN", (Type)BigintType.BIGINT), p.variable("nationkeyS", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), Optional.empty()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Build side needs an additional local exchange for join: [0-9]*")
    public void testValidateFailed() {
        this.validatePlan(p -> p.join(JoinType.INNER, (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle)), (PlanNode)p.tableScan(this.supplierTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle, (Object)p.variable("suppkey", (Type)BigintType.BIGINT), (Object)this.suppColumnHandle)), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkeyN", (Type)BigintType.BIGINT), p.variable("nationkeyS", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), Optional.empty()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Probe side needs an additional local exchange for join: [0-9]*")
    public void testValidateFailsForJavaSpillEnabled() {
        this.validatePlan(p -> p.join(JoinType.INNER, (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle)), (PlanNode)p.exchange(e -> e.scope(ExchangeNode.Scope.LOCAL).type(ExchangeNode.Type.REPARTITION).addSource((PlanNode)p.tableScan(this.supplierTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle, (Object)p.variable("suppkey", (Type)BigintType.BIGINT), (Object)this.suppColumnHandle))).addInputsSet((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT))).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT)))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkeyN", (Type)BigintType.BIGINT), p.variable("nationkeyS", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), Optional.empty()), false, this.spillSession);
    }

    @Test
    public void testValidateSucceedsForNativeSpillEnabled() {
        this.validatePlan(p -> p.join(JoinType.INNER, (PlanNode)p.tableScan(this.nationTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle)), (PlanNode)p.exchange(e -> e.scope(ExchangeNode.Scope.LOCAL).type(ExchangeNode.Type.REPARTITION).addSource((PlanNode)p.tableScan(this.supplierTableHandle, (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (Map<VariableReferenceExpression, ColumnHandle>)ImmutableMap.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)this.nationColumnHandle, (Object)p.variable("suppkey", (Type)BigintType.BIGINT), (Object)this.suppColumnHandle))).addInputsSet((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT))).fixedHashDistributionPartitioningScheme((List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyS", (Type)BigintType.BIGINT)))), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(p.variable("nationkeyN", (Type)BigintType.BIGINT), p.variable("nationkeyS", (Type)BigintType.BIGINT))), (List<VariableReferenceExpression>)ImmutableList.of((Object)p.variable("nationkeyN", (Type)BigintType.BIGINT), (Object)p.variable("nationkeyS", (Type)BigintType.BIGINT), (Object)p.variable("suppkey", (Type)BigintType.BIGINT)), Optional.empty()), true, this.spillSession);
    }

    private void validatePlan(Function<PlanBuilder, PlanNode> planProvider) {
        this.validatePlan(planProvider, false, this.defaultSession);
    }

    private void validatePlan(Function<PlanBuilder, PlanNode> planProvider, boolean nativeExecutionEnabled, Session testSession) {
        PlanBuilder builder = new PlanBuilder(testSession, this.idAllocator, this.metadata);
        PlanNode planNode = planProvider.apply(builder);
        this.getQueryRunner().inTransaction(testSession, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new ValidateStreamingJoins(new FeaturesConfig().setNativeExecutionEnabled(nativeExecutionEnabled)).validate(planNode, session, this.metadata, WarningCollector.NOOP);
            return null;
        });
    }
}

