/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.RealComparisonOperators;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRealOperators
extends AbstractTestFunctions {
    @Test
    public void testTypeConstructor() {
        this.assertFunction("REAL'12.2'", (Type)RealType.REAL, Float.valueOf(12.2f));
        this.assertFunction("REAL'-17.76'", (Type)RealType.REAL, Float.valueOf(-17.76f));
        this.assertFunction("REAL'NaN'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'Infinity'", (Type)RealType.REAL, Float.valueOf(Float.POSITIVE_INFINITY));
        this.assertFunction("REAL'-Infinity'", (Type)RealType.REAL, Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    @Test
    public void testAdd() {
        this.assertFunction("REAL'12.34' + REAL'56.78'", (Type)RealType.REAL, Float.valueOf(69.119995f));
        this.assertFunction("REAL'-17.34' + REAL'-22.891'", (Type)RealType.REAL, Float.valueOf(-40.231003f));
        this.assertFunction("REAL'-89.123' + REAL'754.0'", (Type)RealType.REAL, Float.valueOf(664.877f));
        this.assertFunction("REAL'-0.0' + REAL'0.0'", (Type)RealType.REAL, Float.valueOf(0.0f));
    }

    @Test
    public void testSubtract() {
        this.assertFunction("REAL'12.34' - REAL'56.78'", (Type)RealType.REAL, Float.valueOf(-44.44f));
        this.assertFunction("REAL'-17.34' - REAL'-22.891'", (Type)RealType.REAL, Float.valueOf(5.5510006f));
        this.assertFunction("REAL'-89.123' - REAL'754.0'", (Type)RealType.REAL, Float.valueOf(-843.123f));
        this.assertFunction("REAL'-0.0' - REAL'0.0'", (Type)RealType.REAL, Float.valueOf(-0.0f));
    }

    @Test
    public void testMultiply() {
        this.assertFunction("REAL'12.34' * REAL'56.78'", (Type)RealType.REAL, Float.valueOf(700.6652f));
        this.assertFunction("REAL'-17.34' * REAL'-22.891'", (Type)RealType.REAL, Float.valueOf(396.92996f));
        this.assertFunction("REAL'-89.123' * REAL'754.0'", (Type)RealType.REAL, Float.valueOf(-67198.74f));
        this.assertFunction("REAL'-0.0' * REAL'0.0'", (Type)RealType.REAL, Float.valueOf(-0.0f));
        this.assertFunction("REAL'-17.71' * REAL'-1.0'", (Type)RealType.REAL, Float.valueOf(17.71f));
    }

    @Test
    public void testDivide() {
        this.assertFunction("REAL'12.34' / REAL'56.78'", (Type)RealType.REAL, Float.valueOf(0.21733005f));
        this.assertFunction("REAL'-17.34' / REAL'-22.891'", (Type)RealType.REAL, Float.valueOf(0.7575029f));
        this.assertFunction("REAL'-89.123' / REAL'754.0'", (Type)RealType.REAL, Float.valueOf(-0.118200265f));
        this.assertFunction("REAL'-0.0' / REAL'0.0'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'-17.71' / REAL'-1.0'", (Type)RealType.REAL, Float.valueOf(17.71f));
    }

    @Test
    public void testModulus() {
        this.assertFunction("REAL'12.34' % REAL'56.78'", (Type)RealType.REAL, Float.valueOf(12.34f));
        this.assertFunction("REAL'-17.34' % REAL'-22.891'", (Type)RealType.REAL, Float.valueOf(-17.34f));
        this.assertFunction("REAL'-89.123' % REAL'754.0'", (Type)RealType.REAL, Float.valueOf(-89.123f));
        this.assertFunction("REAL'-0.0' % REAL'0.0'", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("REAL'-17.71' % REAL'-1.0'", (Type)RealType.REAL, Float.valueOf(-0.7099991f));
    }

    @Test
    public void testNegation() {
        this.assertFunction("-REAL'12.34'", (Type)RealType.REAL, Float.valueOf(-12.34f));
        this.assertFunction("-REAL'-17.34'", (Type)RealType.REAL, Float.valueOf(17.34f));
        this.assertFunction("-REAL'-0.0'", (Type)RealType.REAL, Float.valueOf(0.0f));
    }

    @Test
    public void testEqual() {
        this.assertFunction("REAL'12.34' = REAL'12.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'12.340' = REAL'12.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-17.34' = REAL'-17.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'71.17' = REAL'23.45'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-0.0' = REAL'0.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(nan() AS REAL) = CAST(nan() AS REAL)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("REAL'12.34' <> REAL'12.34'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'12.34' <> REAL'12.340'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-17.34' <> REAL'-17.34'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'71.17' <> REAL'23.45'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-0.0' <> REAL'0.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(nan() AS REAL) <> CAST(nan() AS REAL)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("REAL'12.34' < REAL'754.123'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-17.34' < REAL'-16.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'71.17' < REAL'23.45'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-0.0' < REAL'0.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("-CAST(nan() AS REAL) < -CAST(INFINITY() AS REAL)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("REAL'12.34' <= REAL'754.123'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-17.34' <= REAL'-17.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'71.17' <= REAL'23.45'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-0.0' <= REAL'0.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("-CAST(nan() AS REAL) <= -CAST(INFINITY() AS REAL)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(nan() AS REAL) <= CAST(nan() AS REAL)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("REAL'12.34' > REAL'754.123'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-17.34' > REAL'-17.34'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'71.17' > REAL'23.45'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-0.0' > REAL'0.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(nan() AS REAL) > CAST(infinity() AS REAL)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("REAL'12.34' >= REAL'754.123'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'-17.34' >= REAL'-17.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'71.17' >= REAL'23.45'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-0.0' >= REAL'0.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(nan() AS REAL) >= CAST(infinity() AS REAL)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(nan() AS REAL) >= CAST(nan() AS REAL)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testBetween() {
        this.assertFunction("REAL'12.34' BETWEEN REAL'9.12' AND REAL'25.89'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-17.34' BETWEEN REAL'-17.34' AND REAL'-16.57'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'-17.34' BETWEEN REAL'-18.98' AND REAL'-17.34'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'0.0' BETWEEN REAL'-1.2' AND REAL'2.3'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'56.78' BETWEEN REAL'12.34' AND REAL'34.56'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'56.78' BETWEEN REAL'78.89' AND REAL'98.765'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL '0.0' BETWEEN REAL '-0.0' AND REAL '-0.0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(nan() AS REAL) BETWEEN CAST(nan() AS REAL) AND CAST(nan() AS REAL)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("CAST(REAL'754.1985' as VARCHAR)", (Type)VarcharType.VARCHAR, "754.1985");
        this.assertFunction("CAST(REAL'-754.2008' as VARCHAR)", (Type)VarcharType.VARCHAR, "-754.2008");
        this.assertFunction("CAST(REAL'Infinity' as VARCHAR)", (Type)VarcharType.VARCHAR, "Infinity");
        this.assertFunction("CAST(REAL'0.0' / REAL'0.0' as VARCHAR)", (Type)VarcharType.VARCHAR, "NaN");
    }

    @Test
    public void testCastToBigInt() {
        this.assertFunction("CAST(REAL'754.1985' as BIGINT)", (Type)BigintType.BIGINT, 754L);
        this.assertFunction("CAST(REAL'-754.2008' as BIGINT)", (Type)BigintType.BIGINT, -754L);
        this.assertFunction("CAST(REAL'1.98' as BIGINT)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("CAST(REAL'-0.0' as BIGINT)", (Type)BigintType.BIGINT, 0L);
        this.assertInvalidFunction("CAST(cast(nan() AS REAL) as BIGINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast NaN to bigint");
        this.assertInvalidFunction("CAST(cast(infinity() AS REAL) as BIGINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast Infinity to bigint");
        this.assertInvalidFunction("CAST(cast(-infinity() AS REAL) as BIGINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast -Infinity to bigint");
        this.assertInvalidFunction("CAST(REAL '3.4028235E38' as BIGINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast 3.4028235E38 to bigint");
    }

    @Test
    public void testCastToInteger() {
        this.assertFunction("CAST(REAL'754.2008' AS INTEGER)", (Type)IntegerType.INTEGER, 754);
        this.assertFunction("CAST(REAL'-754.1985' AS INTEGER)", (Type)IntegerType.INTEGER, -754);
        this.assertFunction("CAST(REAL'9.99' AS INTEGER)", (Type)IntegerType.INTEGER, 10);
        this.assertFunction("CAST(REAL'-0.0' AS INTEGER)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("cast(REAL '" + Math.nextDown(2.1474836E9f) + "' as integer)", (Type)IntegerType.INTEGER, (int)Math.nextDown(2.1474836E9f));
        this.assertInvalidFunction("cast(REAL '2.147483648E9' as integer)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(REAL '" + Math.nextUp(2.1474836E9f) + "' as integer)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(REAL '" + Math.nextDown(-2.1474836E9f) + "' as integer)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(REAL '-2.147483648E9' as integer)", (Type)IntegerType.INTEGER, Integer.MIN_VALUE);
        this.assertFunction("cast(REAL '" + Math.nextUp(-2.1474836E9f) + "' as integer)", (Type)IntegerType.INTEGER, (int)Math.nextUp(-2.1474836E9f));
        this.assertInvalidFunction("cast(9.3E9 as integer)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast 9.3E9 to integer");
        this.assertInvalidFunction("cast(-9.3E9 as integer)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast -9.3E9 to integer");
        this.assertInvalidFunction("CAST(cast(nan() AS REAL) as INTEGER)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast NaN to integer");
        this.assertInvalidFunction("CAST(cast(infinity() AS REAL) as INTEGER)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast Infinity to integer");
        this.assertInvalidFunction("CAST(cast(-infinity() AS REAL) as INTEGER)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast -Infinity to integer");
        this.assertInvalidFunction("CAST(REAL '2.1474836476E9' as INTEGER)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast 2.14748365E9 to integer");
    }

    @Test
    public void testCastToSmallint() {
        this.assertFunction("CAST(REAL'754.2008' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)754);
        this.assertFunction("CAST(REAL'-754.1985' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)-754);
        this.assertFunction("CAST(REAL'9.99' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)10);
        this.assertFunction("CAST(REAL'-0.0' AS SMALLINT)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertInvalidFunction("CAST(cast(nan() AS REAL) as SMALLINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast NaN to smallint");
        this.assertInvalidFunction("CAST(cast(infinity() AS REAL) as SMALLINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast Infinity to smallint");
        this.assertInvalidFunction("CAST(cast(-infinity() AS REAL) as SMALLINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast -Infinity to smallint");
        this.assertInvalidFunction("CAST(REAL '32767.6' as SMALLINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast 32767.6 to smallint");
    }

    @Test
    public void testCastToTinyint() {
        this.assertFunction("CAST(REAL'127.45' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)127);
        this.assertFunction("CAST(REAL'-128.234' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)-128);
        this.assertFunction("CAST(REAL'9.99' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)10);
        this.assertFunction("CAST(REAL'-0.0' AS TINYINT)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertInvalidFunction("CAST(cast(nan() AS REAL) as TINYINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast NaN to tinyint");
        this.assertInvalidFunction("CAST(cast(infinity() AS REAL) as TINYINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast Infinity to tinyint");
        this.assertInvalidFunction("CAST(cast(-infinity() AS REAL) as TINYINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast -Infinity to tinyint");
        this.assertInvalidFunction("CAST(REAL '127.6' as TINYINT)", StandardErrorCode.INVALID_CAST_ARGUMENT, "Unable to cast 127.6 to tinyint");
    }

    @Test
    public void testCastToDouble() {
        this.assertFunction("CAST(REAL'754.1985' AS DOUBLE)", (Type)DoubleType.DOUBLE, 754.198486328125);
        this.assertFunction("CAST(REAL'-754.2008' AS DOUBLE)", (Type)DoubleType.DOUBLE, -754.2008056640625);
        this.assertFunction("CAST(REAL'0.0' AS DOUBLE)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("CAST(REAL'-0.0' AS DOUBLE)", (Type)DoubleType.DOUBLE, -0.0);
        this.assertFunction("CAST(CAST(REAL'754.1985' AS DOUBLE) AS REAL)", (Type)RealType.REAL, Float.valueOf(754.1985f));
    }

    @Test
    public void testCastToBoolean() {
        this.assertFunction("CAST(REAL'754.1985' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("CAST(REAL'0.0' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(REAL'-0.0' AS BOOLEAN)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS REAL) IS DISTINCT FROM CAST(NULL AS REAL)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'37.7' IS DISTINCT FROM REAL'37.7'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REAL'37.7' IS DISTINCT FROM REAL'37.8'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM REAL'37.7'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL'37.7' IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REAL '0.0' IS DISTINCT FROM REAL '-0.0'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("CAST(nan() AS REAL) IS DISTINCT FROM CAST(nan() AS REAL)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIndeterminate() throws Exception {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as real)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(-1.2 as real)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(1.2 as real)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(123 as real)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNanHash() {
        int[] nanRepresentations;
        for (int nanRepresentation : nanRepresentations = new int[]{Float.floatToIntBits(Float.NaN), -4194304, 2143289344, 2143294004, -4189644}) {
            Assert.assertTrue((boolean)Float.isNaN(Float.intBitsToFloat(nanRepresentation)));
            Assert.assertEquals((long)RealComparisonOperators.hashCode((long)nanRepresentation), (long)RealComparisonOperators.hashCode((long)nanRepresentations[0]));
        }
    }

    @Test
    public void testZeroHash() {
        Assert.assertEquals((long)RealComparisonOperators.hashCode((long)Float.floatToIntBits(0.0f)), (long)RealComparisonOperators.hashCode((long)Float.floatToIntBits(Float.parseFloat("-0.0"))));
    }
}

