/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.Random;
import java.util.Set;

public class ConnectorAwareNodeManager
implements NodeManager {
    private final InternalNodeManager nodeManager;
    private final String environment;
    private final ConnectorId connectorId;

    public ConnectorAwareNodeManager(InternalNodeManager nodeManager, String environment, ConnectorId connectorId) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public Set<Node> getAllNodes() {
        return ImmutableSet.builder().addAll(this.getWorkerNodes()).addAll(this.nodeManager.getCoordinators()).build();
    }

    public Set<Node> getWorkerNodes() {
        return ImmutableSet.copyOf(this.nodeManager.getActiveConnectorNodes(this.connectorId));
    }

    public Node getCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    public Node getSidecarNode() {
        Set<InternalNode> coordinatorSidecars = this.nodeManager.getCoordinatorSidecars();
        if (coordinatorSidecars.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_CPP_SIDECARS, "Expected exactly one coordinator sidecar, but found none");
        }
        return (Node)Iterables.get(coordinatorSidecars, (int)new Random().nextInt(coordinatorSidecars.size()));
    }

    public String getEnvironment() {
        return this.environment;
    }
}

