/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class VariableStatsEstimate {
    private static final VariableStatsEstimate UNKNOWN = new VariableStatsEstimate(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN, Double.NaN, Double.NaN);
    private static final VariableStatsEstimate ZERO = new VariableStatsEstimate(Double.NaN, Double.NaN, 1.0, 0.0, 0.0);
    private final double lowValue;
    private final double highValue;
    private final double nullsFraction;
    private final double averageRowSize;
    private final double distinctValuesCount;
    private final Optional<ConnectorHistogram> histogram;

    public static VariableStatsEstimate unknown() {
        return UNKNOWN;
    }

    public static VariableStatsEstimate zero() {
        return ZERO;
    }

    public VariableStatsEstimate(double lowValue, double highValue, double nullsFraction, double averageRowSize, double distinctValuesCount, Optional<ConnectorHistogram> histogram) {
        Preconditions.checkArgument((lowValue <= highValue || Double.isNaN(lowValue) && Double.isNaN(highValue) ? 1 : 0) != 0, (String)"low value must be less than or equal to high value or both values have to be NaN, got %s and %s respectively", (Object)lowValue, (Object)highValue);
        this.lowValue = lowValue;
        this.highValue = highValue;
        Preconditions.checkArgument((0.0 <= nullsFraction && nullsFraction <= 1.0 || Double.isNaN(nullsFraction) ? 1 : 0) != 0, (String)"Nulls fraction should be within [0, 1] or NaN, got: %s", (Object)nullsFraction);
        boolean isEmptyRange = Double.isNaN(lowValue) && Double.isNaN(highValue);
        this.nullsFraction = isEmptyRange ? 1.0 : nullsFraction;
        Preconditions.checkArgument((averageRowSize >= 0.0 || Double.isNaN(averageRowSize) ? 1 : 0) != 0, (String)"Average row size should be non-negative or NaN, got: %s", (Object)averageRowSize);
        this.averageRowSize = averageRowSize;
        Preconditions.checkArgument((distinctValuesCount >= 0.0 || Double.isNaN(distinctValuesCount) ? 1 : 0) != 0, (String)"Distinct values count should be non-negative, got: %s", (Object)distinctValuesCount);
        this.distinctValuesCount = distinctValuesCount;
        this.histogram = Objects.requireNonNull(histogram, "histogram is null");
    }

    @JsonCreator
    public VariableStatsEstimate(@JsonProperty(value="lowValue") double lowValue, @JsonProperty(value="highValue") double highValue, @JsonProperty(value="nullsFraction") double nullsFraction, @JsonProperty(value="averageRowSize") double averageRowSize, @JsonProperty(value="distinctValuesCount") double distinctValuesCount) {
        this(lowValue, highValue, nullsFraction, averageRowSize, distinctValuesCount, Optional.empty());
    }

    @JsonProperty
    public double getLowValue() {
        return this.lowValue;
    }

    @JsonProperty
    public double getHighValue() {
        return this.highValue;
    }

    @JsonProperty
    public double getNullsFraction() {
        return this.nullsFraction;
    }

    @JsonIgnore
    public Optional<ConnectorHistogram> getHistogram() {
        return this.histogram;
    }

    public StatisticRange statisticRange() {
        return new StatisticRange(this.lowValue, this.highValue, this.distinctValuesCount);
    }

    public double getValuesFraction() {
        return 1.0 - this.nullsFraction;
    }

    @JsonProperty
    public double getAverageRowSize() {
        return this.averageRowSize;
    }

    @JsonProperty
    public double getDistinctValuesCount() {
        return this.distinctValuesCount;
    }

    public VariableStatsEstimate mapNullsFraction(Function<Double, Double> mappingFunction) {
        return VariableStatsEstimate.buildFrom(this).setNullsFraction(mappingFunction.apply(this.nullsFraction)).build();
    }

    public VariableStatsEstimate mapDistinctValuesCount(Function<Double, Double> mappingFunction) {
        return VariableStatsEstimate.buildFrom(this).setDistinctValuesCount(mappingFunction.apply(this.distinctValuesCount)).build();
    }

    public boolean isUnknown() {
        return this.equals(UNKNOWN);
    }

    public boolean isSingleValue() {
        return this.distinctValuesCount == 1.0 && Double.compare(this.lowValue, this.highValue) == 0 && !Double.isInfinite(this.lowValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableStatsEstimate that = (VariableStatsEstimate)o;
        return Double.compare(this.nullsFraction, that.nullsFraction) == 0 && Double.compare(this.averageRowSize, that.averageRowSize) == 0 && Double.compare(this.distinctValuesCount, that.distinctValuesCount) == 0 && Double.compare(this.lowValue, that.lowValue) == 0 && Double.compare(this.highValue, that.highValue) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.lowValue, this.highValue, this.nullsFraction, this.averageRowSize, this.distinctValuesCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("range", (Object)String.format("[%s-%s]", this.lowValue, this.highValue)).add("nulls", this.nullsFraction).add("ndv", this.distinctValuesCount).add("rowSize", this.averageRowSize).add("histogram", this.histogram).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder buildFrom(VariableStatsEstimate other) {
        return VariableStatsEstimate.builder().setLowValue(other.getLowValue()).setHighValue(other.getHighValue()).setNullsFraction(other.getNullsFraction()).setAverageRowSize(other.getAverageRowSize()).setDistinctValuesCount(other.getDistinctValuesCount()).setHistogram(other.getHistogram());
    }

    public static final class Builder {
        private double lowValue = Double.NEGATIVE_INFINITY;
        private double highValue = Double.POSITIVE_INFINITY;
        private double nullsFraction = Double.NaN;
        private double averageRowSize = Double.NaN;
        private double distinctValuesCount = Double.NaN;
        private Optional<ConnectorHistogram> histogram = Optional.empty();

        public Builder setStatisticsRange(StatisticRange range) {
            return this.setLowValue(range.getLow()).setHighValue(range.getHigh()).setDistinctValuesCount(range.getDistinctValuesCount());
        }

        public Builder setLowValue(double lowValue) {
            this.lowValue = lowValue;
            return this;
        }

        public Builder setHighValue(double highValue) {
            this.highValue = highValue;
            return this;
        }

        public Builder setNullsFraction(double nullsFraction) {
            this.nullsFraction = nullsFraction;
            return this;
        }

        public Builder setAverageRowSize(double averageRowSize) {
            this.averageRowSize = averageRowSize;
            return this;
        }

        public Builder setDistinctValuesCount(double distinctValuesCount) {
            this.distinctValuesCount = distinctValuesCount;
            return this;
        }

        public Builder setHistogram(Optional<ConnectorHistogram> histogram) {
            this.histogram = histogram;
            return this;
        }

        public VariableStatsEstimate build() {
            return new VariableStatsEstimate(this.lowValue, this.highValue, this.nullsFraction, this.averageRowSize, this.distinctValuesCount, this.histogram);
        }
    }
}

