/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class QueryMonitorConfig {
    private DataSize maxOutputStageJsonSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private Duration queryProgressPublishInterval = new Duration(0.0, TimeUnit.MINUTES);

    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    @NotNull
    public DataSize getMaxOutputStageJsonSize() {
        return this.maxOutputStageJsonSize;
    }

    @Config(value="event.max-output-stage-size")
    public QueryMonitorConfig setMaxOutputStageJsonSize(DataSize maxOutputStageJsonSize) {
        this.maxOutputStageJsonSize = maxOutputStageJsonSize;
        return this;
    }

    public Duration getQueryProgressPublishInterval() {
        return this.queryProgressPublishInterval;
    }

    @Config(value="event.query-progress-publish-interval")
    @ConfigDescription(value="How frequently to publish query progress events. 0 duration disables the publication of these events.")
    public QueryMonitorConfig setQueryProgressPublishInterval(Duration queryProgressPublishInterval) {
        this.queryProgressPublishInterval = queryProgressPublishInterval;
        return this;
    }
}

