/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.eventlistener;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.eventlistener.EventListenerFactory;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryProgressEvent;
import com.facebook.presto.spi.eventlistener.QueryUpdatedEvent;
import com.facebook.presto.spi.eventlistener.SplitCompletedEvent;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class EventListenerManager {
    private static final Logger log = Logger.get(EventListenerManager.class);
    private static final File EVENT_LISTENER_CONFIGURATION = new File("etc/event-listener.properties");
    private static final String EVENT_LISTENER_PROPERTY_NAME = "event-listener.name";
    private final Map<String, EventListenerFactory> eventListenerFactories = new ConcurrentHashMap<String, EventListenerFactory>();
    private final AtomicReference<Optional<EventListener>> configuredEventListener = new AtomicReference(Optional.empty());

    public void addEventListenerFactory(EventListenerFactory eventListenerFactory) {
        Objects.requireNonNull(eventListenerFactory, "eventListenerFactory is null");
        if (this.eventListenerFactories.putIfAbsent(eventListenerFactory.getName(), eventListenerFactory) != null) {
            throw new IllegalArgumentException(String.format("Event listener '%s' is already registered", eventListenerFactory.getName()));
        }
    }

    public void loadConfiguredEventListener() throws Exception {
        if (EVENT_LISTENER_CONFIGURATION.exists()) {
            Map<String, String> properties = PropertiesUtil.loadProperties(EVENT_LISTENER_CONFIGURATION);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)properties.get(EVENT_LISTENER_PROPERTY_NAME)) ? 1 : 0) != 0, (String)"Access control configuration %s does not contain %s", (Object)EVENT_LISTENER_CONFIGURATION.getAbsoluteFile(), (Object)EVENT_LISTENER_PROPERTY_NAME);
            this.loadConfiguredEventListener(properties);
        }
    }

    public void loadConfiguredEventListener(Map<String, String> properties) {
        String eventListenerName = (properties = new HashMap<String, String>(properties)).remove(EVENT_LISTENER_PROPERTY_NAME);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)eventListenerName) ? 1 : 0) != 0, (Object)"event-listener.name property must be present");
        this.setConfiguredEventListener(eventListenerName, properties);
    }

    @VisibleForTesting
    protected void setConfiguredEventListener(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        log.info("-- Loading event listener --");
        EventListenerFactory eventListenerFactory = this.eventListenerFactories.get(name);
        Preconditions.checkState((eventListenerFactory != null ? 1 : 0) != 0, (String)"Event listener %s is not registered", (Object)name);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(eventListenerFactory.getClass().getClassLoader());){
            EventListener eventListener = eventListenerFactory.create((Map)ImmutableMap.copyOf(properties));
            this.configuredEventListener.set(Optional.of(eventListener));
        }
        log.info("-- Loaded event listener %s --", new Object[]{name});
    }

    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        this.configuredEventListener.get().ifPresent(eventListener -> eventListener.queryCompleted(queryCompletedEvent));
    }

    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        this.configuredEventListener.get().ifPresent(eventListener -> eventListener.queryCreated(queryCreatedEvent));
    }

    public void queryUpdated(QueryUpdatedEvent queryUpdatedEvent) {
        this.configuredEventListener.get().ifPresent(eventListener -> eventListener.queryUpdated(queryUpdatedEvent));
    }

    public void publishQueryProgress(QueryProgressEvent queryProgressEvent) {
        this.configuredEventListener.get().ifPresent(eventListener -> eventListener.publishQueryProgress(queryProgressEvent));
    }

    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        this.configuredEventListener.get().ifPresent(eventListener -> eventListener.splitCompleted(splitCompletedEvent));
    }
}

