/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.execution.BasicStageExecutionStats;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.Output;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateTimer;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.BasicQueryStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.sql.planner.CanonicalPlanWithInfo;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class QueryStateMachine {
    private static final Logger QUERY_STATE_LOG = Logger.get(QueryStateMachine.class);
    private final QueryId queryId;
    private final String query;
    private final Optional<String> preparedQuery;
    private final Session session;
    private final URI self;
    private final Optional<QueryType> queryType;
    private final ResourceGroupId resourceGroup;
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final QueryOutputManager outputManager;
    private final AtomicReference<VersionedMemoryPoolId> memoryPool = new AtomicReference<VersionedMemoryPoolId>(new VersionedMemoryPoolId(LocalMemoryManager.GENERAL_POOL, 0L));
    private final AtomicLong currentUserMemory = new AtomicLong();
    private final AtomicLong peakUserMemory = new AtomicLong();
    private final AtomicLong currentTotalMemory = new AtomicLong();
    private final AtomicLong peakTotalMemory = new AtomicLong();
    private final AtomicLong peakTaskUserMemory = new AtomicLong();
    private final AtomicLong peakTaskTotalMemory = new AtomicLong();
    private final AtomicLong peakNodeTotalMemory = new AtomicLong();
    private final AtomicInteger currentRunningTaskCount = new AtomicInteger();
    private final AtomicInteger peakRunningTaskCount = new AtomicInteger();
    private final QueryStateTimer queryStateTimer;
    private final StateMachine<QueryState> queryState;
    private final AtomicReference<String> setCatalog = new AtomicReference();
    private final AtomicReference<String> setSchema = new AtomicReference();
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final Map<String, SelectedRole> setRoles = new ConcurrentHashMap<String, SelectedRole>();
    private final Map<String, String> addedPreparedStatements = new ConcurrentHashMap<String, String>();
    private final Set<String> deallocatedPreparedStatements = Sets.newConcurrentHashSet();
    private final AtomicReference<TransactionId> startedTransactionId = new AtomicReference();
    private final AtomicBoolean clearTransactionId = new AtomicBoolean();
    private final AtomicReference<String> updateType = new AtomicReference();
    private final AtomicReference<ExecutionFailureInfo> failureCause = new AtomicReference();
    private final AtomicReference<StatsAndCosts> planStatsAndCosts = new AtomicReference();
    private final AtomicReference<Map<PlanNodeId, PlanNode>> planIdNodeMap = new AtomicReference();
    private final AtomicReference<List<CanonicalPlanWithInfo>> planCanonicalInfo = new AtomicReference();
    private final AtomicReference<Set<Input>> inputs = new AtomicReference<ImmutableSet>(ImmutableSet.of());
    private final AtomicReference<Optional<Output>> output = new AtomicReference(Optional.empty());
    private final StateMachine<Optional<QueryInfo>> finalQueryInfo;
    private final AtomicReference<Optional<String>> expandedQuery = new AtomicReference(Optional.empty());
    private final Map<SqlFunctionId, SqlInvokedFunction> addedSessionFunctions = new ConcurrentHashMap<SqlFunctionId, SqlInvokedFunction>();
    private final Set<SqlFunctionId> removedSessionFunctions = Sets.newConcurrentHashSet();
    private final WarningCollector warningCollector;
    private final AtomicReference<Set<String>> scalarFunctions = new AtomicReference<ImmutableSet>(ImmutableSet.of());
    private final AtomicReference<Set<String>> aggregateFunctions = new AtomicReference<ImmutableSet>(ImmutableSet.of());
    private final AtomicReference<Set<String>> windowFunctions = new AtomicReference<ImmutableSet>(ImmutableSet.of());

    private QueryStateMachine(String query, Optional<String> preparedQuery, Session session, URI self, ResourceGroupId resourceGroup, Optional<QueryType> queryType, TransactionManager transactionManager, Executor executor, Ticker ticker, Metadata metadata, WarningCollector warningCollector) {
        this.query = Objects.requireNonNull(query, "query is null");
        this.preparedQuery = Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.queryId = session.getQueryId();
        this.self = Objects.requireNonNull(self, "self is null");
        this.resourceGroup = Objects.requireNonNull(resourceGroup, "resourceGroup is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.queryStateTimer = new QueryStateTimer(ticker);
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.queryState = new StateMachine<QueryState>("query " + query, executor, QueryState.WAITING_FOR_PREREQUISITES, QueryState.TERMINAL_QUERY_STATES);
        this.finalQueryInfo = new StateMachine("finalQueryInfo-" + this.queryId, executor, Optional.empty());
        this.outputManager = new QueryOutputManager(executor);
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public static QueryStateMachine begin(String query, Optional<String> preparedQuery, Session session, URI self, ResourceGroupId resourceGroup, Optional<QueryType> queryType, boolean transactionControl, TransactionManager transactionManager, AccessControl accessControl, Executor executor, Metadata metadata, WarningCollector warningCollector) {
        return QueryStateMachine.beginWithTicker(query, preparedQuery, session, self, resourceGroup, queryType, transactionControl, transactionManager, accessControl, executor, Ticker.systemTicker(), metadata, warningCollector);
    }

    static QueryStateMachine beginWithTicker(String query, Optional<String> preparedQuery, Session session, URI self, ResourceGroupId resourceGroup, Optional<QueryType> queryType, boolean transactionControl, TransactionManager transactionManager, AccessControl accessControl, Executor executor, Ticker ticker, Metadata metadata, WarningCollector warningCollector) {
        if (!session.getTransactionId().isPresent() && !transactionControl) {
            TransactionId transactionId = transactionManager.beginTransaction(true);
            session = session.beginTransactionId(transactionId, transactionManager, accessControl);
        }
        QueryStateMachine queryStateMachine = new QueryStateMachine(query, preparedQuery, session, self, resourceGroup, queryType, transactionManager, executor, ticker, metadata, warningCollector);
        queryStateMachine.addStateChangeListener(newState -> {
            QUERY_STATE_LOG.debug("Query %s is %s", new Object[]{queryStateMachine.getQueryId(), newState});
            if (newState.isDone()) {
                queryStateMachine.getSession().getTransactionId().ifPresent(transactionManager::trySetInactive);
            }
        });
        return queryStateMachine;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Session getSession() {
        return this.session;
    }

    public long getPeakUserMemoryInBytes() {
        return this.peakUserMemory.get();
    }

    public long getPeakTotalMemoryInBytes() {
        return this.peakTotalMemory.get();
    }

    public long getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory.get();
    }

    public long getPeakTaskUserMemory() {
        return this.peakTaskUserMemory.get();
    }

    public long getPeakNodeTotalMemory() {
        return this.peakNodeTotalMemory.get();
    }

    public int getCurrentRunningTaskCount() {
        return this.currentRunningTaskCount.get();
    }

    public int incrementCurrentRunningTaskCount() {
        int runningTaskCount = this.currentRunningTaskCount.incrementAndGet();
        this.peakRunningTaskCount.accumulateAndGet(runningTaskCount, Math::max);
        return runningTaskCount;
    }

    public int decrementCurrentRunningTaskCount() {
        return this.currentRunningTaskCount.decrementAndGet();
    }

    public int getPeakRunningTaskCount() {
        return this.peakRunningTaskCount.get();
    }

    public WarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    public void updateMemoryUsage(long deltaUserMemoryInBytes, long deltaTotalMemoryInBytes, long taskUserMemoryInBytes, long taskTotalMemoryInBytes, long peakNodeTotalMemoryInBytes) {
        this.currentUserMemory.addAndGet(deltaUserMemoryInBytes);
        this.currentTotalMemory.addAndGet(deltaTotalMemoryInBytes);
        this.peakUserMemory.updateAndGet(currentPeakValue -> Math.max(this.currentUserMemory.get(), currentPeakValue));
        this.peakTotalMemory.updateAndGet(currentPeakValue -> Math.max(this.currentTotalMemory.get(), currentPeakValue));
        this.peakTaskUserMemory.accumulateAndGet(taskUserMemoryInBytes, Math::max);
        this.peakTaskTotalMemory.accumulateAndGet(taskTotalMemoryInBytes, Math::max);
        this.peakNodeTotalMemory.accumulateAndGet(peakNodeTotalMemoryInBytes, Math::max);
    }

    public BasicQueryInfo getBasicQueryInfo(Optional<BasicStageExecutionStats> rootStage) {
        QueryState state = this.queryState.get();
        BasicStageExecutionStats stageStats = rootStage.orElse(BasicStageExecutionStats.EMPTY_STAGE_STATS);
        BasicQueryStats queryStats = new BasicQueryStats(this.queryStateTimer.getCreateTime(), this.getEndTime().orElse(null), this.queryStateTimer.getWaitingForPrerequisitesTime(), this.queryStateTimer.getQueuedTime(), this.queryStateTimer.getElapsedTime(), this.queryStateTimer.getExecutionTime(), this.getCurrentRunningTaskCount(), this.getPeakRunningTaskCount(), stageStats.getTotalDrivers(), stageStats.getQueuedDrivers(), stageStats.getRunningDrivers(), stageStats.getCompletedDrivers(), stageStats.getRawInputDataSize(), stageStats.getRawInputPositions(), stageStats.getCumulativeUserMemory(), stageStats.getCumulativeTotalMemory(), stageStats.getUserMemoryReservation(), stageStats.getTotalMemoryReservation(), DataSize.succinctBytes((long)this.getPeakUserMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTotalMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTaskTotalMemory()), DataSize.succinctBytes((long)this.getPeakNodeTotalMemory()), stageStats.getTotalCpuTime(), stageStats.getTotalScheduledTime(), stageStats.isFullyBlocked(), stageStats.getBlockedReasons(), stageStats.getTotalAllocation(), stageStats.getProgressPercentage());
        return new BasicQueryInfo(this.queryId, this.session.toSessionRepresentation(), Optional.of(this.resourceGroup), state, this.memoryPool.get().getId(), stageStats.isScheduled(), this.self, this.query, queryStats, this.failureCause.get(), this.queryType, this.warningCollector.getWarnings(), this.preparedQuery);
    }

    public QueryInfo getQueryInfo(Optional<StageInfo> rootStage) {
        QueryState state = this.queryState.get();
        ExecutionFailureInfo failureCause = null;
        ErrorCode errorCode = null;
        if (state == QueryState.FAILED && (failureCause = this.failureCause.get()) != null) {
            errorCode = failureCause.getErrorCode();
        }
        List<StageInfo> allStages = StageInfo.getAllStages(rootStage);
        boolean finalInfo = state.isDone() && allStages.stream().allMatch(StageInfo::isFinalStageInfo);
        Optional<Object> failedTasks = state.isDone() ? Optional.of(allStages.stream().flatMap(stageInfo -> Streams.concat((Stream[])new Stream[]{ImmutableList.of((Object)stageInfo.getLatestAttemptExecutionInfo()).stream(), stageInfo.getPreviousAttemptsExecutionInfos().stream()})).flatMap(execution -> execution.getTasks().stream()).filter(taskInfo -> taskInfo.getTaskStatus().getState() == TaskState.FAILED).map(TaskInfo::getTaskId).collect(ImmutableList.toImmutableList())) : Optional.empty();
        List runtimeOptimizedStages = (List)allStages.stream().filter(StageInfo::isRuntimeOptimized).map(StageInfo::getStageId).collect(ImmutableList.toImmutableList());
        QueryStats queryStats = this.getQueryStats(rootStage, allStages);
        return new QueryInfo(this.queryId, this.session.toSessionRepresentation(), state, this.memoryPool.get().getId(), queryStats.isScheduled(), this.self, this.outputManager.getQueryOutputInfo().map(QueryExecution.QueryOutputInfo::getColumnNames).orElse((List)ImmutableList.of()), this.query, this.expandedQuery.get(), this.preparedQuery, queryStats, Optional.ofNullable(this.setCatalog.get()), Optional.ofNullable(this.setSchema.get()), this.setSessionProperties, this.resetSessionProperties, this.setRoles, this.addedPreparedStatements, this.deallocatedPreparedStatements, Optional.ofNullable(this.startedTransactionId.get()), this.clearTransactionId.get(), this.updateType.get(), rootStage, failureCause, errorCode, this.warningCollector.getWarnings(), this.inputs.get(), this.output.get(), finalInfo, Optional.of(this.resourceGroup), this.queryType, failedTasks, runtimeOptimizedStages.isEmpty() ? Optional.empty() : Optional.of(runtimeOptimizedStages), this.addedSessionFunctions, this.removedSessionFunctions, Optional.ofNullable(this.planStatsAndCosts.get()).orElseGet(StatsAndCosts::empty), this.session.getOptimizerInformationCollector().getOptimizationInfo(), this.session.getCteInformationCollector().getCTEInformationList(), this.scalarFunctions.get(), this.aggregateFunctions.get(), this.windowFunctions.get(), Optional.ofNullable(this.planCanonicalInfo.get()).orElseGet(ImmutableList::of), Optional.ofNullable(this.planIdNodeMap.get()).orElseGet(ImmutableMap::of), Optional.empty());
    }

    private QueryStats getQueryStats(Optional<StageInfo> rootStage, List<StageInfo> allStages) {
        return QueryStats.create(this.queryStateTimer, rootStage, allStages, this.getPeakRunningTaskCount(), DataSize.succinctBytes((long)this.getPeakUserMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTotalMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTaskUserMemory()), DataSize.succinctBytes((long)this.getPeakTaskTotalMemory()), DataSize.succinctBytes((long)this.getPeakNodeTotalMemory()), this.session.getRuntimeStats());
    }

    public VersionedMemoryPoolId getMemoryPool() {
        return this.memoryPool.get();
    }

    public void setMemoryPool(VersionedMemoryPoolId memoryPool) {
        this.memoryPool.set(Objects.requireNonNull(memoryPool, "memoryPool is null"));
    }

    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
        this.outputManager.addOutputInfoListener(listener);
    }

    public void setColumns(List<String> columnNames, List<Type> columnTypes) {
        this.outputManager.setColumns(columnNames, columnTypes);
    }

    public void updateOutputLocations(Map<URI, TaskId> newExchangeLocations, boolean noMoreExchangeLocations) {
        this.outputManager.updateOutputLocations(newExchangeLocations, noMoreExchangeLocations);
    }

    public void setInputs(List<Input> inputs) {
        Objects.requireNonNull(inputs, "inputs is null");
        this.inputs.set((Set<Input>)ImmutableSet.copyOf(inputs));
    }

    public void setPlanStatsAndCosts(StatsAndCosts statsAndCosts) {
        Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
        this.planStatsAndCosts.set(statsAndCosts);
    }

    public void setPlanIdNodeMap(Map<PlanNodeId, PlanNode> planIdNodeMap) {
        Objects.requireNonNull(planIdNodeMap, "planIdNodeMap is null");
        this.planIdNodeMap.set((Map<PlanNodeId, PlanNode>)ImmutableMap.copyOf(planIdNodeMap));
    }

    public void setPlanCanonicalInfo(List<CanonicalPlanWithInfo> planCanonicalInfo) {
        Objects.requireNonNull(planCanonicalInfo, "planCanonicalInfo is null");
        this.planCanonicalInfo.set(planCanonicalInfo);
    }

    public void setOutput(Optional<Output> output) {
        Objects.requireNonNull(output, "output is null");
        this.output.set(output);
    }

    public void setScalarFunctions(Set<String> scalarFunctions) {
        Objects.requireNonNull(scalarFunctions, "scalarFunctions is null");
        this.scalarFunctions.set((Set<String>)ImmutableSet.copyOf(scalarFunctions));
    }

    public void setAggregateFunctions(Set<String> aggregateFunctions) {
        Objects.requireNonNull(aggregateFunctions, "aggregateFunctions is null");
        this.aggregateFunctions.set((Set<String>)ImmutableSet.copyOf(aggregateFunctions));
    }

    public void setWindowFunctions(Set<String> windowFunctions) {
        Objects.requireNonNull(windowFunctions, "windowFunctions is null");
        this.windowFunctions.set((Set<String>)ImmutableSet.copyOf(windowFunctions));
    }

    private void addSerializedCommitOutputToOutput(ConnectorCommitHandle commitHandle) {
        if (!this.output.get().isPresent()) {
            return;
        }
        Output outputInfo = this.output.get().get();
        SchemaTableName table = new SchemaTableName(outputInfo.getSchema(), outputInfo.getTable());
        this.output.set(Optional.of(new Output(outputInfo.getConnectorId(), outputInfo.getSchema(), outputInfo.getTable(), commitHandle.getSerializedCommitOutputForWrite(table))));
    }

    private void addSerializedCommitOutputToInputs(List<?> commitHandles) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Input input : this.inputs.get()) {
            builder.add((Object)this.attachSerializedCommitOutput(input, commitHandles));
        }
        this.inputs.set((Set<Input>)builder.build());
    }

    private Input attachSerializedCommitOutput(Input input, List<?> commitHandles) {
        SchemaTableName table = new SchemaTableName(input.getSchema(), input.getTable());
        for (Object handle : commitHandles) {
            if (!(handle instanceof ConnectorCommitHandle)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Type ConnectorCommitHandle is expected");
            }
            ConnectorCommitHandle commitHandle = (ConnectorCommitHandle)handle;
            if (!commitHandle.hasCommitOutput(table)) continue;
            return new Input(input.getConnectorId(), input.getSchema(), input.getTable(), input.getConnectorInfo(), input.getColumns(), input.getStatistics(), commitHandle.getSerializedCommitOutputForRead(table));
        }
        return input;
    }

    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public void setSetCatalog(String catalog) {
        this.setCatalog.set(Objects.requireNonNull(catalog, "catalog is null"));
    }

    public void setSetSchema(String schema) {
        this.setSchema.set(Objects.requireNonNull(schema, "schema is null"));
    }

    public void addSetSessionProperties(String key, String value) {
        this.setSessionProperties.put(Objects.requireNonNull(key, "key is null"), Objects.requireNonNull(value, "value is null"));
    }

    public void addSetRole(String catalog, SelectedRole role) {
        this.setRoles.put(Objects.requireNonNull(catalog, "catalog is null"), Objects.requireNonNull(role, "role is null"));
    }

    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public void addResetSessionProperties(String name) {
        this.resetSessionProperties.add(Objects.requireNonNull(name, "name is null"));
    }

    public Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    public Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    public Map<SqlFunctionId, SqlInvokedFunction> getAddedSessionFunctions() {
        return this.addedSessionFunctions;
    }

    public Set<SqlFunctionId> getRemovedSessionFunctions() {
        return this.removedSessionFunctions;
    }

    public void addPreparedStatement(String key, String value) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        this.addedPreparedStatements.put(key, value);
    }

    public void removePreparedStatement(String key) {
        Objects.requireNonNull(key, "key is null");
        if (!this.session.getPreparedStatements().containsKey(key)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + key);
        }
        this.deallocatedPreparedStatements.add(key);
    }

    public void addSessionFunction(SqlFunctionId signature, SqlInvokedFunction function) {
        Objects.requireNonNull(signature, "signature is null");
        Objects.requireNonNull(function, "function is null");
        if (this.session.getSessionFunctions().containsKey(signature) || this.addedSessionFunctions.putIfAbsent(signature, function) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Session function %s has already been defined", signature));
        }
    }

    public void removeSessionFunction(SqlFunctionId signature, boolean suppressNotFoundException) {
        Objects.requireNonNull(signature, "signature is null");
        if (!this.session.getSessionFunctions().containsKey(signature)) {
            if (!suppressNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Session function %s not found", signature.getFunctionName()));
            }
        } else {
            this.removedSessionFunctions.add(signature);
        }
    }

    public void setStartedTransactionId(TransactionId startedTransactionId) {
        Preconditions.checkArgument((!this.clearTransactionId.get() ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.startedTransactionId.set(startedTransactionId);
    }

    public void clearTransactionId() {
        Preconditions.checkArgument((this.startedTransactionId.get() == null ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.clearTransactionId.set(true);
    }

    public void setUpdateType(String updateType) {
        this.updateType.set(updateType);
    }

    public void setExpandedQuery(Optional<String> expandedQuery) {
        this.expandedQuery.set(expandedQuery);
    }

    public QueryState getQueryState() {
        return this.queryState.get();
    }

    public boolean isDone() {
        return this.queryState.get().isDone();
    }

    public boolean transitionToQueued() {
        this.queryStateTimer.beginQueued();
        return this.queryState.setIf(QueryState.QUEUED, currentState -> currentState.ordinal() < QueryState.QUEUED.ordinal());
    }

    public boolean transitionToWaitingForResources() {
        this.queryStateTimer.beginWaitingForResources();
        return this.queryState.setIf(QueryState.WAITING_FOR_RESOURCES, currentState -> currentState.ordinal() < QueryState.WAITING_FOR_RESOURCES.ordinal());
    }

    public void beginSemanticAnalyzing() {
        this.queryStateTimer.beginSemanticAnalyzing();
    }

    public void beginColumnAccessPermissionChecking() {
        this.queryStateTimer.beginColumnAccessPermissionChecking();
    }

    public void endColumnAccessPermissionChecking() {
        this.queryStateTimer.endColumnAccessPermissionChecking();
    }

    public boolean transitionToDispatching() {
        this.queryStateTimer.beginDispatching();
        return this.queryState.setIf(QueryState.DISPATCHING, currentState -> currentState.ordinal() < QueryState.DISPATCHING.ordinal());
    }

    public boolean transitionToPlanning() {
        this.queryStateTimer.beginPlanning();
        return this.queryState.setIf(QueryState.PLANNING, currentState -> currentState.ordinal() < QueryState.PLANNING.ordinal());
    }

    public boolean transitionToStarting() {
        this.queryStateTimer.beginStarting();
        return this.queryState.setIf(QueryState.STARTING, currentState -> currentState.ordinal() < QueryState.STARTING.ordinal());
    }

    public boolean transitionToRunning() {
        this.queryStateTimer.beginRunning();
        return this.queryState.setIf(QueryState.RUNNING, currentState -> currentState.ordinal() < QueryState.RUNNING.ordinal());
    }

    public boolean transitionToFinishing() {
        this.queryStateTimer.beginFinishing();
        if (!this.queryState.setIf(QueryState.FINISHING, currentState -> currentState != QueryState.FINISHING && !currentState.isDone())) {
            return false;
        }
        Optional transaction = this.session.getTransactionId().flatMap(this.transactionManager::getOptionalTransactionInfo);
        if (transaction.isPresent() && ((TransactionInfo)transaction.get()).isAutoCommitContext()) {
            ListenableFuture<?> commitFuture = this.transactionManager.asyncCommit(((TransactionInfo)transaction.get()).getTransactionId());
            Futures.addCallback(commitFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object result) {
                    QueryStateMachine.this.transitionToFinished();
                    QueryStateMachine.this.processConnectorCommitHandle(result);
                }

                public void onFailure(Throwable throwable) {
                    QueryStateMachine.this.transitionToFailed(throwable, currentState -> !currentState.isDone());
                }
            }, (Executor)MoreExecutors.directExecutor());
        } else {
            this.transitionToFinished();
        }
        return true;
    }

    private void processConnectorCommitHandle(Object result) {
        if (result instanceof List) {
            this.addSerializedCommitOutputToInputs((List)result);
        }
        if (result instanceof ConnectorCommitHandle) {
            this.addSerializedCommitOutputToOutput((ConnectorCommitHandle)result);
            this.addSerializedCommitOutputToInputs((List<?>)ImmutableList.of((Object)result));
        }
    }

    private void transitionToFinished() {
        this.cleanupQueryQuietly();
        this.queryStateTimer.endQuery();
        this.queryState.setIf(QueryState.FINISHED, currentState -> !currentState.isDone());
    }

    public boolean transitionToFailed(Throwable throwable) {
        return this.transitionToFailed(throwable, currentState -> currentState != QueryState.FINISHING && !currentState.isDone());
    }

    private boolean transitionToFailed(Throwable throwable, Predicate<QueryState> predicate) {
        QueryState currentState = this.queryState.get();
        if (!predicate.test(currentState)) {
            QUERY_STATE_LOG.debug(throwable, "Failure is ignored as the query %s is the %s state, ", new Object[]{this.queryId, currentState});
            return false;
        }
        this.cleanupQueryQuietly();
        this.queryStateTimer.endQuery();
        Objects.requireNonNull(throwable, "throwable is null");
        this.failureCause.compareAndSet(null, Failures.toFailure(throwable));
        boolean failed = this.queryState.setIf(QueryState.FAILED, predicate);
        if (failed) {
            QUERY_STATE_LOG.debug(throwable, "Query %s failed", new Object[]{this.queryId});
            this.session.getTransactionId().flatMap(this.transactionManager::getOptionalTransactionInfo).ifPresent(transaction -> {
                if (transaction.isAutoCommitContext()) {
                    this.transactionManager.asyncAbort(transaction.getTransactionId());
                } else {
                    this.transactionManager.fail(transaction.getTransactionId());
                }
            });
        } else {
            QUERY_STATE_LOG.debug(throwable, "Failure after query %s finished", new Object[]{this.queryId});
        }
        return failed;
    }

    public boolean transitionToCanceled() {
        this.cleanupQueryQuietly();
        this.queryStateTimer.endQuery();
        this.failureCause.compareAndSet(null, Failures.toFailure(new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "Query was canceled")));
        boolean canceled = this.queryState.setIf(QueryState.FAILED, currentState -> !currentState.isDone());
        if (canceled) {
            this.session.getTransactionId().flatMap(this.transactionManager::getOptionalTransactionInfo).ifPresent(transaction -> {
                if (transaction.isAutoCommitContext()) {
                    this.transactionManager.asyncAbort(transaction.getTransactionId());
                } else {
                    this.transactionManager.fail(transaction.getTransactionId());
                }
            });
        }
        return canceled;
    }

    private void cleanupQueryQuietly() {
        try {
            this.metadata.cleanupQuery(this.session);
        }
        catch (Throwable t) {
            QUERY_STATE_LOG.error("Error cleaning up query: %s", new Object[]{t});
        }
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public void addQueryInfoStateChangeListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        AtomicBoolean done = new AtomicBoolean();
        StateMachine.StateChangeListener<Optional> fireOnceStateChangeListener = finalQueryInfo -> {
            if (finalQueryInfo.isPresent() && done.compareAndSet(false, true)) {
                stateChangeListener.stateChanged((QueryInfo)finalQueryInfo.get());
            }
        };
        this.finalQueryInfo.addStateChangeListener(fireOnceStateChangeListener);
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.queryState.getStateChange(currentState);
    }

    public void recordHeartbeat() {
        this.queryStateTimer.recordHeartbeat();
    }

    public void beginAnalysis() {
        this.queryStateTimer.beginAnalyzing();
    }

    public void endAnalysis() {
        this.queryStateTimer.endAnalysis();
    }

    public DateTime getCreateTime() {
        return this.queryStateTimer.getCreateTime();
    }

    public Optional<DateTime> getExecutionStartTime() {
        return this.queryStateTimer.getExecutionStartTime();
    }

    public DateTime getLastHeartbeat() {
        return this.queryStateTimer.getLastHeartbeat();
    }

    public Optional<DateTime> getEndTime() {
        return this.queryStateTimer.getEndTime();
    }

    public Optional<ExecutionFailureInfo> getFailureInfo() {
        if (this.queryState.get() != QueryState.FAILED) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.failureCause.get());
    }

    public Optional<QueryInfo> getFinalQueryInfo() {
        return this.finalQueryInfo.get();
    }

    public QueryInfo updateQueryInfo(Optional<StageInfo> stageInfo) {
        QueryInfo queryInfo = this.getQueryInfo(stageInfo);
        if (queryInfo.isFinalQueryInfo()) {
            this.finalQueryInfo.compareAndSet(Optional.empty(), Optional.of(queryInfo));
        }
        return queryInfo;
    }

    public void pruneQueryInfoExpired() {
        Optional<QueryInfo> finalInfo = this.finalQueryInfo.get();
        if (!finalInfo.isPresent() || !finalInfo.get().getOutputStage().isPresent()) {
            return;
        }
        QueryInfo queryInfo = finalInfo.get();
        QueryInfo prunedQueryInfo = QueryStateMachine.pruneExpiredQueryInfo(queryInfo, this.getMemoryPool());
        this.finalQueryInfo.compareAndSet(finalInfo, Optional.of(prunedQueryInfo));
    }

    public void pruneQueryInfoFinished() {
        Optional<QueryInfo> finalInfo = this.finalQueryInfo.get();
        if (!finalInfo.isPresent() || !finalInfo.get().getOutputStage().isPresent()) {
            return;
        }
        QueryInfo queryInfo = finalInfo.get();
        this.session.getPlanNodeStatsMap().clear();
        this.session.getPlanNodeCostMap().clear();
        this.inputs.getAndUpdate(QueryStateMachine::pruneInputHistograms);
        this.finalQueryInfo.clearEventListeners();
        this.planStatsAndCosts.getAndUpdate(stats -> Optional.ofNullable(stats).map(QueryStateMachine::pruneHistogramsFromStatsAndCosts).orElse(null));
        QueryInfo prunedQueryInfo = QueryStateMachine.pruneFinishedQueryInfo(queryInfo, this.inputs.get());
        this.finalQueryInfo.compareAndSet(finalInfo, Optional.of(prunedQueryInfo));
    }

    private static QueryInfo pruneFinishedQueryInfo(QueryInfo queryInfo, Set<Input> prunedInputs) {
        return new QueryInfo(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getState(), queryInfo.getMemoryPool(), queryInfo.isScheduled(), queryInfo.getSelf(), queryInfo.getFieldNames(), queryInfo.getQuery(), queryInfo.getExpandedQuery(), queryInfo.getPreparedQuery(), queryInfo.getQueryStats(), queryInfo.getSetCatalog(), queryInfo.getSetSchema(), queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), queryInfo.getSetRoles(), queryInfo.getAddedPreparedStatements(), queryInfo.getDeallocatedPreparedStatements(), queryInfo.getStartedTransactionId(), queryInfo.isClearTransactionId(), queryInfo.getUpdateType(), queryInfo.getOutputStage().map(QueryStateMachine::pruneStatsFromStageInfo), queryInfo.getFailureInfo(), queryInfo.getErrorCode(), queryInfo.getWarnings(), prunedInputs, queryInfo.getOutput(), queryInfo.isFinalQueryInfo(), queryInfo.getResourceGroupId(), queryInfo.getQueryType(), queryInfo.getFailedTasks(), queryInfo.getRuntimeOptimizedStages(), queryInfo.getAddedSessionFunctions(), queryInfo.getRemovedSessionFunctions(), QueryStateMachine.pruneHistogramsFromStatsAndCosts(queryInfo.getPlanStatsAndCosts()), queryInfo.getOptimizerInformation(), queryInfo.getCteInformationList(), queryInfo.getScalarFunctions(), queryInfo.getAggregateFunctions(), queryInfo.getWindowFunctions(), (List<CanonicalPlanWithInfo>)ImmutableList.of(), (Map<PlanNodeId, PlanNode>)ImmutableMap.of(), queryInfo.getPrestoSparkExecutionContext());
    }

    private static Set<Input> pruneInputHistograms(Set<Input> inputs) {
        return (Set)inputs.stream().map(input -> new Input(input.getConnectorId(), input.getSchema(), input.getTable(), input.getConnectorInfo(), input.getColumns(), input.getStatistics().map(tableStats -> TableStatistics.buildFrom((TableStatistics)tableStats).setColumnStatistics((Map)ImmutableMap.copyOf((Map)Maps.transformValues((Map)tableStats.getColumnStatistics(), columnStats -> ColumnStatistics.buildFrom((ColumnStatistics)columnStats).setHistogram(Optional.empty()).build()))).build()), input.getSerializedCommitOutput())).collect(ImmutableSet.toImmutableSet());
    }

    protected static StatsAndCosts pruneHistogramsFromStatsAndCosts(StatsAndCosts statsAndCosts) {
        Map newStats = (Map)statsAndCosts.getStats().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (PlanNodeId)entry.getKey(), entry -> PlanNodeStatsEstimate.buildFrom((PlanNodeStatsEstimate)entry.getValue()).addVariableStatistics((Map<VariableReferenceExpression, VariableStatsEstimate>)ImmutableMap.copyOf((Map)Maps.transformValues(((PlanNodeStatsEstimate)entry.getValue()).getVariableStatistics(), variableStats -> VariableStatsEstimate.buildFrom(variableStats).setHistogram(Optional.empty()).build()))).build()));
        return new StatsAndCosts(newStats, statsAndCosts.getCosts());
    }

    private static StageInfo pruneStatsFromStageInfo(StageInfo stage) {
        return new StageInfo(stage.getStageId(), stage.getSelf(), stage.getPlan().map(plan -> new PlanFragment(plan.getId(), plan.getRoot(), plan.getVariables(), plan.getPartitioning(), plan.getTableScanSchedulingOrder(), plan.getPartitioningScheme(), plan.getStageExecutionDescriptor(), plan.isOutputTableWriterFragment(), plan.getStatsAndCosts().map(QueryStateMachine::pruneHistogramsFromStatsAndCosts), plan.getJsonRepresentation())), stage.getLatestAttemptExecutionInfo(), stage.getPreviousAttemptsExecutionInfos(), (List)stage.getSubStages().stream().map(QueryStateMachine::pruneStatsFromStageInfo).collect(ImmutableList.toImmutableList()), stage.isRuntimeOptimized());
    }

    private static QueryInfo pruneExpiredQueryInfo(QueryInfo queryInfo, VersionedMemoryPoolId pool) {
        Optional<StageInfo> prunedOutputStage = queryInfo.getOutputStage().map(outputStage -> new StageInfo(outputStage.getStageId(), outputStage.getSelf(), Optional.empty(), QueryStateMachine.pruneStageExecutionInfo(outputStage.getLatestAttemptExecutionInfo()), (List<StageExecutionInfo>)ImmutableList.of(), (List<StageInfo>)ImmutableList.of(), outputStage.isRuntimeOptimized()));
        return new QueryInfo(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getState(), pool.getId(), queryInfo.isScheduled(), queryInfo.getSelf(), queryInfo.getFieldNames(), queryInfo.getQuery(), queryInfo.getExpandedQuery(), queryInfo.getPreparedQuery(), QueryStateMachine.pruneQueryStats(queryInfo.getQueryStats()), queryInfo.getSetCatalog(), queryInfo.getSetSchema(), queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), queryInfo.getSetRoles(), queryInfo.getAddedPreparedStatements(), queryInfo.getDeallocatedPreparedStatements(), queryInfo.getStartedTransactionId(), queryInfo.isClearTransactionId(), queryInfo.getUpdateType(), prunedOutputStage, queryInfo.getFailureInfo(), queryInfo.getErrorCode(), queryInfo.getWarnings(), queryInfo.getInputs(), queryInfo.getOutput(), queryInfo.isFinalQueryInfo(), queryInfo.getResourceGroupId(), queryInfo.getQueryType(), queryInfo.getFailedTasks(), queryInfo.getRuntimeOptimizedStages(), queryInfo.getAddedSessionFunctions(), queryInfo.getRemovedSessionFunctions(), StatsAndCosts.empty(), queryInfo.getOptimizerInformation(), queryInfo.getCteInformationList(), queryInfo.getScalarFunctions(), queryInfo.getAggregateFunctions(), queryInfo.getWindowFunctions(), (List<CanonicalPlanWithInfo>)ImmutableList.of(), (Map<PlanNodeId, PlanNode>)ImmutableMap.of(), queryInfo.getPrestoSparkExecutionContext());
    }

    private static StageExecutionInfo pruneStageExecutionInfo(StageExecutionInfo info) {
        return new StageExecutionInfo(info.getState(), info.getStats(), (List<TaskInfo>)ImmutableList.of(), info.getFailureCause());
    }

    private static QueryStats pruneQueryStats(QueryStats queryStats) {
        return new QueryStats(queryStats.getCreateTime(), queryStats.getExecutionStartTime(), queryStats.getLastHeartbeat(), queryStats.getEndTime(), queryStats.getElapsedTime(), queryStats.getWaitingForPrerequisitesTime(), queryStats.getQueuedTime(), queryStats.getResourceWaitingTime(), queryStats.getSemanticAnalyzingTime(), queryStats.getColumnAccessPermissionCheckingTime(), queryStats.getDispatchingTime(), queryStats.getExecutionTime(), queryStats.getAnalysisTime(), queryStats.getTotalPlanningTime(), queryStats.getFinishingTime(), queryStats.getTotalTasks(), queryStats.getRunningTasks(), queryStats.getCompletedTasks(), queryStats.getPeakRunningTasks(), queryStats.getTotalDrivers(), queryStats.getQueuedDrivers(), queryStats.getRunningDrivers(), queryStats.getBlockedDrivers(), queryStats.getCompletedDrivers(), queryStats.getCumulativeUserMemory(), queryStats.getCumulativeTotalMemory(), queryStats.getUserMemoryReservation(), queryStats.getTotalMemoryReservation(), queryStats.getPeakUserMemoryReservation(), queryStats.getPeakTotalMemoryReservation(), queryStats.getPeakTaskUserMemory(), queryStats.getPeakTaskTotalMemory(), queryStats.getPeakNodeTotalMemory(), queryStats.isScheduled(), queryStats.getTotalScheduledTime(), queryStats.getTotalCpuTime(), queryStats.getRetriedCpuTime(), queryStats.getTotalBlockedTime(), queryStats.isFullyBlocked(), queryStats.getBlockedReasons(), queryStats.getTotalAllocation(), queryStats.getRawInputDataSize(), queryStats.getRawInputPositions(), queryStats.getProcessedInputDataSize(), queryStats.getProcessedInputPositions(), queryStats.getShuffledDataSize(), queryStats.getShuffledPositions(), queryStats.getOutputDataSize(), queryStats.getOutputPositions(), queryStats.getWrittenOutputPositions(), queryStats.getWrittenOutputLogicalDataSize(), queryStats.getWrittenOutputPhysicalDataSize(), queryStats.getWrittenIntermediatePhysicalDataSize(), queryStats.getStageGcStatistics(), (List<OperatorStats>)ImmutableList.of(), queryStats.getRuntimeStats());
    }

    public static class QueryOutputManager {
        private final Executor executor;
        @GuardedBy(value="this")
        private final List<Consumer<QueryExecution.QueryOutputInfo>> outputInfoListeners = new ArrayList<Consumer<QueryExecution.QueryOutputInfo>>();
        @GuardedBy(value="this")
        private List<String> columnNames;
        @GuardedBy(value="this")
        private List<Type> columnTypes;
        @GuardedBy(value="this")
        private final Map<URI, TaskId> exchangeLocations = new LinkedHashMap<URI, TaskId>();
        @GuardedBy(value="this")
        private boolean noMoreExchangeLocations;

        public QueryOutputManager(Executor executor) {
            this.executor = Objects.requireNonNull(executor, "executor is null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(listener, "listener is null");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                this.outputInfoListeners.add(listener);
                queryOutputInfo = this.getQueryOutputInfo();
            }
            queryOutputInfo.ifPresent(info -> this.executor.execute(() -> listener.accept((QueryExecution.QueryOutputInfo)info)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setColumns(List<String> columnNames, List<Type> columnTypes) {
            ImmutableList outputInfoListeners;
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(columnNames, "columnNames is null");
            Objects.requireNonNull(columnTypes, "columnTypes is null");
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes must be the same size");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                Preconditions.checkState((this.columnNames == null && this.columnTypes == null ? 1 : 0) != 0, (Object)"output fields already set");
                this.columnNames = ImmutableList.copyOf(columnNames);
                this.columnTypes = ImmutableList.copyOf(columnTypes);
                queryOutputInfo = this.getQueryOutputInfo();
                outputInfoListeners = ImmutableList.copyOf(this.outputInfoListeners);
            }
            queryOutputInfo.ifPresent(arg_0 -> this.lambda$setColumns$2((List)outputInfoListeners, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateOutputLocations(Map<URI, TaskId> newExchangeLocations, boolean noMoreExchangeLocations) {
            ImmutableList outputInfoListeners;
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(newExchangeLocations, "newExchangeLocations is null");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                if (this.noMoreExchangeLocations) {
                    Preconditions.checkArgument((boolean)this.exchangeLocations.keySet().containsAll(newExchangeLocations.keySet()), (Object)"New locations added after no more locations set");
                    return;
                }
                this.exchangeLocations.putAll(newExchangeLocations);
                this.noMoreExchangeLocations = noMoreExchangeLocations;
                queryOutputInfo = this.getQueryOutputInfo();
                outputInfoListeners = ImmutableList.copyOf(this.outputInfoListeners);
            }
            queryOutputInfo.ifPresent(arg_0 -> this.lambda$updateOutputLocations$3((List)outputInfoListeners, arg_0));
        }

        private synchronized Optional<QueryExecution.QueryOutputInfo> getQueryOutputInfo() {
            if (this.columnNames == null || this.columnTypes == null) {
                return Optional.empty();
            }
            return Optional.of(new QueryExecution.QueryOutputInfo(this.columnNames, this.columnTypes, this.exchangeLocations, this.noMoreExchangeLocations));
        }

        private void fireStateChanged(QueryExecution.QueryOutputInfo queryOutputInfo, List<Consumer<QueryExecution.QueryOutputInfo>> outputInfoListeners) {
            for (Consumer<QueryExecution.QueryOutputInfo> outputInfoListener : outputInfoListeners) {
                this.executor.execute(() -> outputInfoListener.accept(queryOutputInfo));
            }
        }

        private /* synthetic */ void lambda$updateOutputLocations$3(List outputInfoListeners, QueryExecution.QueryOutputInfo info) {
            this.fireStateChanged(info, outputInfoListeners);
        }

        private /* synthetic */ void lambda$setColumns$2(List outputInfoListeners, QueryExecution.QueryOutputInfo info) {
            this.fireStateChanged(info, outputInfoListeners);
        }
    }
}

