/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.SetThreadName;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.analyzer.PreparedQuery;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsManager;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.ForEagerPlanValidation;
import com.facebook.presto.execution.ForQueryExecution;
import com.facebook.presto.execution.ForTimeoutThread;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.Output;
import com.facebook.presto.execution.PartialResultQueryManager;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TimeoutThread;
import com.facebook.presto.execution.TrackingRemoteTaskFactory;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.ExecutionPolicy;
import com.facebook.presto.execution.scheduler.SectionExecutionFactory;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.execution.scheduler.SqlQueryScheduler;
import com.facebook.presto.execution.scheduler.SqlQuerySchedulerInterface;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AnalyzerContext;
import com.facebook.presto.spi.analyzer.AnalyzerProvider;
import com.facebook.presto.spi.analyzer.QueryAnalysis;
import com.facebook.presto.spi.analyzer.QueryAnalyzer;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.resourceGroups.ResourceGroupQueryLimits;
import com.facebook.presto.split.CloseableSplitSourceProvider;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.InputExtractor;
import com.facebook.presto.sql.planner.OutputExtractor;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanCanonicalInfoProvider;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanNodeCanonicalInfo;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.planner.SplitSourceFactory;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.util.AnalyzerUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.joda.time.DateTime;

@ThreadSafe
public class SqlQueryExecution
implements QueryExecution {
    private static final OutputBuffers.OutputBufferId OUTPUT_BUFFER_ID = new OutputBuffers.OutputBufferId(0);
    private final QueryAnalyzer queryAnalyzer;
    private final QueryStateMachine stateMachine;
    private final String slug;
    private final int retryCount;
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final SplitManager splitManager;
    private final List<PlanOptimizer> planOptimizers;
    private final List<PlanOptimizer> runtimePlanOptimizers;
    private final PlanFragmenter planFragmenter;
    private final RemoteTaskFactory remoteTaskFactory;
    private final LocationFactory locationFactory;
    private final ExecutorService queryExecutor;
    private final ScheduledExecutorService timeoutThreadExecutor;
    private final SectionExecutionFactory sectionExecutionFactory;
    private final InternalNodeManager internalNodeManager;
    private final AtomicReference<SqlQuerySchedulerInterface> queryScheduler = new AtomicReference();
    private final AtomicReference<Plan> queryPlan = new AtomicReference();
    private final ExecutionPolicy executionPolicy;
    private final SplitSchedulerStats schedulerStats;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final PlanChecker planChecker;
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private final AtomicReference<VariableAllocator> variableAllocator = new AtomicReference();
    private final PartialResultQueryManager partialResultQueryManager;
    private final AtomicReference<Optional<ResourceGroupQueryLimits>> resourceGroupQueryLimits = new AtomicReference(Optional.empty());
    private final PlanCanonicalInfoProvider planCanonicalInfoProvider;
    private final QueryAnalysis queryAnalysis;
    private final AnalyzerContext analyzerContext;
    private final CompletableFuture<PlanRoot> planFuture;
    private final AtomicBoolean planFutureLocked = new AtomicBoolean();

    private SqlQueryExecution(QueryAnalyzer queryAnalyzer, PreparedQuery preparedQuery, QueryStateMachine stateMachine, String slug, int retryCount, Metadata metadata, SqlParser sqlParser, SplitManager splitManager, List<PlanOptimizer> planOptimizers, List<PlanOptimizer> runtimePlanOptimizers, PlanFragmenter planFragmenter, RemoteTaskFactory remoteTaskFactory, LocationFactory locationFactory, ExecutorService queryExecutor, ScheduledExecutorService timeoutThreadExecutor, SectionExecutionFactory sectionExecutionFactory, ExecutorService eagerPlanValidationExecutor, InternalNodeManager internalNodeManager, ExecutionPolicy executionPolicy, SplitSchedulerStats schedulerStats, StatsCalculator statsCalculator, CostCalculator costCalculator, PlanChecker planChecker, PartialResultQueryManager partialResultQueryManager, PlanCanonicalInfoProvider planCanonicalInfoProvider) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{stateMachine.getQueryId()});){
            this.queryAnalyzer = Objects.requireNonNull(queryAnalyzer, "queryAnalyzer is null");
            this.slug = Objects.requireNonNull(slug, "slug is null");
            this.retryCount = retryCount;
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
            this.runtimePlanOptimizers = Objects.requireNonNull(runtimePlanOptimizers, "runtimePlanOptimizers is null");
            this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.timeoutThreadExecutor = Objects.requireNonNull(timeoutThreadExecutor, "timeoutThreadExecutor is null");
            this.sectionExecutionFactory = Objects.requireNonNull(sectionExecutionFactory, "sectionExecutionFactory is null");
            this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
            this.executionPolicy = Objects.requireNonNull(executionPolicy, "executionPolicy is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
            this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
            this.planCanonicalInfoProvider = Objects.requireNonNull(planCanonicalInfoProvider, "planCanonicalInfoProvider is null");
            this.analyzerContext = AnalyzerUtil.getAnalyzerContext(queryAnalyzer, metadata.getMetadataResolver(stateMachine.getSession()), this.idAllocator, new VariableAllocator(), stateMachine.getSession());
            Objects.requireNonNull(preparedQuery, "preparedQuery is null");
            stateMachine.beginSemanticAnalyzing();
            TimeoutThread unused = new TimeoutThread(Thread.currentThread(), timeoutThreadExecutor, SystemSessionProperties.getQueryAnalyzerTimeout(this.getSession()));
            Object object = null;
            try {
                this.queryAnalysis = queryAnalyzer.analyze(this.analyzerContext, preparedQuery);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (unused != null) {
                    if (object != null) {
                        try {
                            unused.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        unused.close();
                    }
                }
            }
            stateMachine.setUpdateType(this.queryAnalysis.getUpdateType());
            stateMachine.setExpandedQuery(this.queryAnalysis.getExpandedQuery());
            stateMachine.beginColumnAccessPermissionChecking();
            AnalyzerUtil.checkAccessPermissions(this.queryAnalysis.getAccessControlReferences());
            stateMachine.endColumnAccessPermissionChecking();
            AtomicReference<SqlQuerySchedulerInterface> queryScheduler = this.queryScheduler;
            stateMachine.addStateChangeListener(state -> {
                if (!state.isDone()) {
                    return;
                }
                SqlQuerySchedulerInterface scheduler = (SqlQuerySchedulerInterface)queryScheduler.get();
                if (scheduler != null) {
                    scheduler.abort();
                }
            });
            this.remoteTaskFactory = new TrackingRemoteTaskFactory(Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null"), stateMachine);
            this.partialResultQueryManager = Objects.requireNonNull(partialResultQueryManager, "partialResultQueryManager is null");
            if (SystemSessionProperties.isLogInvokedFunctionNamesEnabled(this.getSession())) {
                for (Map.Entry entry : this.queryAnalysis.getInvokedFunctions().entrySet()) {
                    switch ((FunctionKind)entry.getKey()) {
                        case SCALAR: {
                            stateMachine.setScalarFunctions((Set)entry.getValue());
                            break;
                        }
                        case AGGREGATE: {
                            stateMachine.setAggregateFunctions((Set)entry.getValue());
                            break;
                        }
                        case WINDOW: {
                            stateMachine.setWindowFunctions((Set)entry.getValue());
                        }
                    }
                }
            }
            this.planFuture = SystemSessionProperties.isEagerPlanValidationEnabled(this.getSession()) ? CompletableFuture.supplyAsync(this::runCreateLogicalPlanAsync, eagerPlanValidationExecutor) : null;
        }
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public DataSize getUserMemoryReservation() {
        SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getUserMemoryReservation();
        }
        if (scheduler == null) {
            return new DataSize(0.0, DataSize.Unit.BYTE);
        }
        return DataSize.succinctBytes((long)scheduler.getUserMemoryReservation());
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalMemoryReservation();
        }
        if (scheduler == null) {
            return new DataSize(0.0, DataSize.Unit.BYTE);
        }
        return DataSize.succinctBytes((long)scheduler.getTotalMemoryReservation());
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalCpuTime();
        }
        if (scheduler == null) {
            return new Duration(0.0, TimeUnit.SECONDS);
        }
        return scheduler.getTotalCpuTime();
    }

    @Override
    public DataSize getRawInputDataSize() {
        SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getRawInputDataSize();
        }
        if (scheduler == null) {
            return new DataSize(0.0, DataSize.Unit.BYTE);
        }
        return scheduler.getRawInputDataSize();
    }

    @Override
    public DataSize getWrittenIntermediateDataSize() {
        SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getWrittenIntermediatePhysicalDataSize();
        }
        if (scheduler == null) {
            return new DataSize(0.0, DataSize.Unit.BYTE);
        }
        return scheduler.getWrittenIntermediateDataSize();
    }

    @Override
    public long getOutputPositions() {
        SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getOutputPositions();
        }
        if (scheduler == null) {
            return 0L;
        }
        return scheduler.getOutputPositions();
    }

    @Override
    public DataSize getOutputDataSize() {
        SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getOutputDataSize();
        }
        if (scheduler == null) {
            return new DataSize(0.0, DataSize.Unit.BYTE);
        }
        return scheduler.getOutputDataSize();
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().map(BasicQueryInfo::new).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.ofNullable(this.queryScheduler.get()).map(SqlQuerySchedulerInterface::getBasicStageStats)));
    }

    @Override
    public int getRunningTaskCount() {
        return this.stateMachine.getCurrentRunningTaskCount();
    }

    @Override
    public void start() {
        Throwable throwable;
        SetThreadName ignored;
        block37: {
            block38: {
                block39: {
                    PlanRoot plan;
                    block33: {
                        block34: {
                            block35: {
                                ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});
                                throwable = null;
                                if (this.stateMachine.transitionToPlanning()) break block33;
                                if (ignored == null) break block34;
                                if (throwable == null) break block35;
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block34;
                            }
                            ignored.close();
                        }
                        return;
                    }
                    try (TimeoutThread unused2 = new TimeoutThread(Thread.currentThread(), this.timeoutThreadExecutor, SystemSessionProperties.getQueryAnalyzerTimeout(this.getSession()));){
                        plan = this.planFuture != null && !this.planFutureLocked.compareAndSet(false, true) ? this.planFuture.get() : this.createLogicalPlanAndOptimize();
                    }
                    this.metadata.beginQuery(this.getSession(), plan.getConnectors());
                    this.planDistribution(plan);
                    if (this.stateMachine.transitionToStarting()) break block37;
                    if (ignored == null) break block38;
                    if (throwable == null) break block39;
                    try {
                        ignored.close();
                    }
                    catch (Throwable unused2) {
                        throwable.addSuppressed(unused2);
                    }
                    break block38;
                }
                ignored.close();
            }
            return;
        }
        try {
            try {
                SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
                if (!this.stateMachine.isDone()) {
                    scheduler.start();
                }
            }
            catch (Throwable e) {
                this.fail(e);
                Throwables.throwIfInstanceOf((Throwable)e, Error.class);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            this.stateMachine.addStateChangeListener(stateChangeListener);
        }
    }

    @Override
    public Optional<ResourceGroupQueryLimits> getResourceGroupQueryLimits() {
        return this.resourceGroupQueryLimits.get();
    }

    @Override
    public void setResourceGroupQueryLimits(ResourceGroupQueryLimits resourceGroupQueryLimits) {
        if (!this.resourceGroupQueryLimits.compareAndSet(Optional.empty(), Optional.of(Objects.requireNonNull(resourceGroupQueryLimits, "resourceGroupQueryLimits is null")))) {
            throw new IllegalStateException("Cannot set resourceGroupQueryLimits more than once");
        }
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    private PlanRoot createLogicalPlanAndOptimize() {
        try {
            this.stateMachine.beginAnalysis();
            PlanNode planNode = (PlanNode)this.stateMachine.getSession().getRuntimeStats().profileNanos("logicalPlannerTimeNanos", () -> this.queryAnalyzer.plan(this.analyzerContext, this.queryAnalysis));
            Optimizer optimizer = new Optimizer(this.stateMachine.getSession(), this.metadata, this.planOptimizers, this.planChecker, this.analyzerContext.getVariableAllocator(), this.idAllocator, this.stateMachine.getWarningCollector(), this.statsCalculator, this.costCalculator, false);
            Plan plan = (Plan)this.getSession().getRuntimeStats().profileNanos("optimizerTimeNanos", () -> optimizer.validateAndOptimizePlan(planNode, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED));
            this.queryPlan.set(plan);
            this.stateMachine.setPlanStatsAndCosts(plan.getStatsAndCosts());
            this.stateMachine.setPlanIdNodeMap(plan.getPlanIdNodeMap());
            List canonicalPlanWithInfos = (List)this.getSession().getRuntimeStats().profileNanos("getCanonicalInfoTimeNanos", () -> PlanNodeCanonicalInfo.getCanonicalInfo(this.getSession(), plan.getRoot(), this.planCanonicalInfoProvider));
            this.stateMachine.setPlanCanonicalInfo(canonicalPlanWithInfos);
            List<Input> inputs = new InputExtractor(this.metadata, this.stateMachine.getSession()).extractInputs(plan.getRoot());
            this.stateMachine.setInputs(inputs);
            Optional<Output> output = new OutputExtractor().extractOutput(plan.getRoot());
            this.stateMachine.setOutput(output);
            this.variableAllocator.set(new VariableAllocator(plan.getTypes().allVariables()));
            SubPlan fragmentedPlan = (SubPlan)this.getSession().getRuntimeStats().profileNanos("fragmentPlanTimeNanos", () -> this.planFragmenter.createSubPlans(this.stateMachine.getSession(), plan, false, this.idAllocator, this.variableAllocator.get(), this.stateMachine.getWarningCollector()));
            this.stateMachine.endAnalysis();
            boolean explainAnalyze = this.queryAnalysis.isExplainAnalyzeQuery();
            return new PlanRoot(fragmentedPlan, !explainAnalyze, this.queryAnalysis.extractConnectors());
        }
        catch (StackOverflowError e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "statement is too large (stack overflow during analysis)", (Throwable)e);
        }
    }

    private PlanRoot runCreateLogicalPlanAsync() {
        try {
            if (this.planFutureLocked.compareAndSet(false, true)) {
                return this.createLogicalPlanAndOptimize();
            }
            return null;
        }
        catch (Throwable e) {
            this.fail(e);
            throw e;
        }
    }

    private void planDistribution(PlanRoot plan) {
        CloseableSplitSourceProvider splitSourceProvider = new CloseableSplitSourceProvider(this.splitManager::getSplits);
        this.stateMachine.addStateChangeListener(state -> {
            if (state.isDone()) {
                splitSourceProvider.close();
            }
        });
        if (this.stateMachine.isDone()) {
            return;
        }
        SubPlan outputStagePlan = plan.getRoot();
        this.stateMachine.setColumns(((OutputNode)outputStagePlan.getFragment().getRoot()).getColumnNames(), outputStagePlan.getFragment().getTypes());
        PartitioningHandle partitioningHandle = outputStagePlan.getFragment().getPartitioningScheme().getPartitioning().getHandle();
        OutputBuffers rootOutputBuffers = SystemSessionProperties.isSpoolingOutputBufferEnabled(this.getSession()) ? OutputBuffers.createSpoolingOutputBuffers() : OutputBuffers.createInitialEmptyOutputBuffers(partitioningHandle).withBuffer(OUTPUT_BUFFER_ID, 0).withNoMoreBufferIds();
        SplitSourceFactory splitSourceFactory = new SplitSourceFactory(splitSourceProvider, this.stateMachine.getWarningCollector());
        SqlQueryScheduler scheduler = SqlQueryScheduler.createSqlQueryScheduler(this.locationFactory, this.executionPolicy, this.queryExecutor, this.schedulerStats, this.sectionExecutionFactory, this.remoteTaskFactory, splitSourceFactory, this.stateMachine.getSession(), this.metadata.getFunctionAndTypeManager(), this.stateMachine, outputStagePlan, rootOutputBuffers, plan.isSummarizeTaskInfos(), this.runtimePlanOptimizers, this.stateMachine.getWarningCollector(), this.idAllocator, this.variableAllocator.get(), this.planChecker, this.metadata, this.sqlParser, this.partialResultQueryManager);
        this.queryScheduler.set(scheduler);
        if (this.stateMachine.isDone()) {
            scheduler.abort();
            this.queryScheduler.set(null);
        }
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
            if (scheduler != null) {
                scheduler.cancelStage(stageId);
            }
        }
    }

    @Override
    public void fail(Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.stateMachine.transitionToFailed(cause);
        SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
        this.stateMachine.updateQueryInfo(Optional.ofNullable(scheduler).map(SqlQuerySchedulerInterface::getStageInfo));
    }

    @Override
    public boolean isDone() {
        return this.getState().isDone();
    }

    @Override
    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
        this.stateMachine.addOutputInfoListener(listener);
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.stateMachine.getStateChange(currentState);
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneExpiredQueryInfo() {
        this.stateMachine.pruneQueryInfoExpired();
    }

    @Override
    public void pruneFinishedQueryInfo() {
        this.queryPlan.getAndUpdate(nullablePlan -> Optional.ofNullable(nullablePlan).map(plan -> new Plan(plan.getRoot(), plan.getTypes(), QueryStateMachine.pruneHistogramsFromStatsAndCosts(plan.getStatsAndCosts()))).orElse(null));
        this.queryScheduler.set(null);
        this.stateMachine.pruneQueryInfoFinished();
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQuerySchedulerInterface scheduler = this.queryScheduler.get();
            QueryInfo queryInfo = this.stateMachine.getFinalQueryInfo().orElseGet(() -> this.buildQueryInfo(scheduler));
            return queryInfo;
        }
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    @Override
    public Plan getQueryPlan() {
        return this.queryPlan.get();
    }

    private QueryInfo buildQueryInfo(SqlQuerySchedulerInterface scheduler) {
        QueryInfo queryInfo;
        Optional<StageInfo> stageInfo = Optional.empty();
        if (scheduler != null) {
            stageInfo = Optional.of(scheduler.getStageInfo());
        }
        if ((queryInfo = this.stateMachine.updateQueryInfo(stageInfo)).isFinalQueryInfo()) {
            this.queryScheduler.set(null);
        }
        return queryInfo;
    }

    public static class SqlQueryExecutionFactory
    implements QueryExecution.QueryExecutionFactory<QueryExecution> {
        private final SplitSchedulerStats schedulerStats;
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final SplitManager splitManager;
        private final List<PlanOptimizer> planOptimizers;
        private final List<PlanOptimizer> runtimePlanOptimizers;
        private final PlanFragmenter planFragmenter;
        private final RemoteTaskFactory remoteTaskFactory;
        private final LocationFactory locationFactory;
        private final ScheduledExecutorService timeoutThreadExecutor;
        private final ExecutorService queryExecutor;
        private final SectionExecutionFactory sectionExecutionFactory;
        private final ExecutorService eagerPlanValidationExecutor;
        private final InternalNodeManager internalNodeManager;
        private final Map<String, ExecutionPolicy> executionPolicies;
        private final StatsCalculator statsCalculator;
        private final CostCalculator costCalculator;
        private final PlanChecker planChecker;
        private final PartialResultQueryManager partialResultQueryManager;
        private final HistoryBasedPlanStatisticsManager historyBasedPlanStatisticsManager;

        @Inject
        SqlQueryExecutionFactory(QueryManagerConfig config, Metadata metadata, SqlParser sqlParser, LocationFactory locationFactory, SplitManager splitManager, PlanOptimizers planOptimizers, PlanFragmenter planFragmenter, RemoteTaskFactory remoteTaskFactory, @ForQueryExecution ExecutorService queryExecutor, @ForTimeoutThread ScheduledExecutorService timeoutThreadExecutor, SectionExecutionFactory sectionExecutionFactory, @ForEagerPlanValidation ExecutorService eagerPlanValidationExecutor, InternalNodeManager internalNodeManager, Map<String, ExecutionPolicy> executionPolicies, SplitSchedulerStats schedulerStats, StatsCalculator statsCalculator, CostCalculator costCalculator, PlanChecker planChecker, PartialResultQueryManager partialResultQueryManager, HistoryBasedPlanStatisticsManager historyBasedPlanStatisticsManager) {
            Objects.requireNonNull(config, "config is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            Objects.requireNonNull(planOptimizers, "planOptimizers is null");
            this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
            this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.timeoutThreadExecutor = Objects.requireNonNull(timeoutThreadExecutor, "timeoutThreadExecutor is null");
            this.sectionExecutionFactory = Objects.requireNonNull(sectionExecutionFactory, "sectionExecutionFactory is null");
            this.eagerPlanValidationExecutor = Objects.requireNonNull(eagerPlanValidationExecutor, "eagerPlanValidationExecutor is null");
            this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
            this.executionPolicies = Objects.requireNonNull(executionPolicies, "schedulerPolicies is null");
            this.planOptimizers = planOptimizers.getPlanningTimeOptimizers();
            this.runtimePlanOptimizers = planOptimizers.getRuntimeOptimizers();
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
            this.partialResultQueryManager = Objects.requireNonNull(partialResultQueryManager, "partialResultQueryManager is null");
            this.historyBasedPlanStatisticsManager = Objects.requireNonNull(historyBasedPlanStatisticsManager, "historyBasedPlanStatisticsManager is null");
        }

        @Override
        public QueryExecution createQueryExecution(AnalyzerProvider analyzerProvider, PreparedQuery preparedQuery, QueryStateMachine stateMachine, String slug, int retryCount, WarningCollector warningCollector, Optional<QueryType> queryType) {
            String executionPolicyName = SystemSessionProperties.getExecutionPolicy(stateMachine.getSession());
            ExecutionPolicy executionPolicy = this.executionPolicies.get(executionPolicyName);
            Preconditions.checkArgument((executionPolicy != null ? 1 : 0) != 0, (String)"No execution policy %s", (Object)executionPolicy);
            return new SqlQueryExecution(analyzerProvider.getQueryAnalyzer(), preparedQuery, stateMachine, slug, retryCount, this.metadata, this.sqlParser, this.splitManager, this.planOptimizers, this.runtimePlanOptimizers, this.planFragmenter, this.remoteTaskFactory, this.locationFactory, this.queryExecutor, this.timeoutThreadExecutor, this.sectionExecutionFactory, this.eagerPlanValidationExecutor, this.internalNodeManager, executionPolicy, this.schedulerStats, this.statsCalculator, this.costCalculator, this.planChecker, this.partialResultQueryManager, this.historyBasedPlanStatisticsManager.getPlanCanonicalInfoProvider());
        }
    }

    private static class PlanRoot {
        private final SubPlan root;
        private final boolean summarizeTaskInfos;
        private final Set<ConnectorId> connectors;

        public PlanRoot(SubPlan root, boolean summarizeTaskInfos, Set<ConnectorId> connectors) {
            this.root = Objects.requireNonNull(root, "root is null");
            this.summarizeTaskInfos = summarizeTaskInfos;
            this.connectors = ImmutableSet.copyOf(connectors);
        }

        public SubPlan getRoot() {
            return this.root;
        }

        public boolean isSummarizeTaskInfos() {
            return this.summarizeTaskInfos;
        }

        public Set<ConnectorId> getConnectors() {
            return this.connectors;
        }
    }
}

