/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class OutputBuffers {
    public static final int BROADCAST_PARTITION_ID = 0;
    private static final OutputBuffers DISCARDING_OUTPUT_BUFFERS = OutputBuffers.createInitialEmptyOutputBuffers(BufferType.DISCARDING).withNoMoreBufferIds();
    private static final OutputBuffers SPOOLING_OUTPUT_BUFFERS = OutputBuffers.createInitialEmptyOutputBuffers(BufferType.SPOOLING).withBuffer(new OutputBufferId(0), 0).withNoMoreBufferIds();
    private final BufferType type;
    private final long version;
    private final boolean noMoreBufferIds;
    private final Map<OutputBufferId, Integer> buffers;

    public static OutputBuffers createInitialEmptyOutputBuffers(BufferType type) {
        return new OutputBuffers(type, 0L, false, (Map<OutputBufferId, Integer>)ImmutableMap.of());
    }

    public static OutputBuffers createInitialEmptyOutputBuffers(PartitioningHandle partitioningHandle) {
        BufferType type = partitioningHandle.equals((Object)SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION) ? BufferType.BROADCAST : (partitioningHandle.equals((Object)SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION) ? BufferType.ARBITRARY : BufferType.PARTITIONED);
        return new OutputBuffers(type, 0L, false, (Map<OutputBufferId, Integer>)ImmutableMap.of());
    }

    public static OutputBuffers createDiscardingOutputBuffers() {
        return DISCARDING_OUTPUT_BUFFERS;
    }

    public static OutputBuffers createSpoolingOutputBuffers() {
        return SPOOLING_OUTPUT_BUFFERS;
    }

    @JsonCreator
    public OutputBuffers(@JsonProperty(value="type") BufferType type, @JsonProperty(value="version") long version, @JsonProperty(value="noMoreBufferIds") boolean noMoreBufferIds, @JsonProperty(value="buffers") Map<OutputBufferId, Integer> buffers) {
        this.type = type;
        this.version = version;
        this.buffers = ImmutableMap.copyOf(Objects.requireNonNull(buffers, "buffers is null"));
        this.noMoreBufferIds = noMoreBufferIds;
    }

    @JsonProperty
    public BufferType getType() {
        return this.type;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public boolean isNoMoreBufferIds() {
        return this.noMoreBufferIds;
    }

    @JsonProperty
    public Map<OutputBufferId, Integer> getBuffers() {
        return this.buffers;
    }

    public void checkValidTransition(OutputBuffers newOutputBuffers) {
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        Preconditions.checkState((this.type == newOutputBuffers.getType() ? 1 : 0) != 0, (Object)"newOutputBuffers has a different type");
        if (this.noMoreBufferIds) {
            Preconditions.checkArgument((boolean)this.equals(newOutputBuffers), (Object)"Expected buffer to not change after no more buffers is set");
            return;
        }
        if (this.version > newOutputBuffers.version) {
            throw new IllegalArgumentException("newOutputBuffers version is older");
        }
        if (this.version == newOutputBuffers.version) {
            Preconditions.checkArgument((boolean)this.equals(newOutputBuffers), (Object)"newOutputBuffers is the same version but contains different information");
        }
        for (Map.Entry<OutputBufferId, Integer> entry : this.buffers.entrySet()) {
            if (entry.getValue().equals(newOutputBuffers.buffers.get(entry.getKey()))) continue;
            throw new IllegalArgumentException("newOutputBuffers has changed the assignment for task " + entry.getKey());
        }
    }

    public int hashCode() {
        return Objects.hash(this.version, this.noMoreBufferIds, this.buffers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OutputBuffers other = (OutputBuffers)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.noMoreBufferIds, other.noMoreBufferIds) && Objects.equals(this.buffers, other.buffers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("version", this.version).add("noMoreBufferIds", this.noMoreBufferIds).add("bufferIds", this.buffers).toString();
    }

    public OutputBuffers withBuffer(OutputBufferId bufferId, int partition) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        if (this.buffers.containsKey(bufferId)) {
            this.checkHasBuffer(bufferId, partition);
            return this;
        }
        Preconditions.checkState((!this.noMoreBufferIds ? 1 : 0) != 0, (Object)"No more buffer ids already set");
        return new OutputBuffers(this.type, this.version + 1L, false, (Map<OutputBufferId, Integer>)ImmutableMap.builder().putAll(this.buffers).put((Object)bufferId, (Object)partition).build());
    }

    public OutputBuffers withBuffers(Map<OutputBufferId, Integer> buffers) {
        Objects.requireNonNull(buffers, "buffers is null");
        HashMap<OutputBufferId, Integer> newBuffers = new HashMap<OutputBufferId, Integer>();
        for (Map.Entry<OutputBufferId, Integer> entry : buffers.entrySet()) {
            OutputBufferId bufferId = entry.getKey();
            int partition = entry.getValue();
            if (this.buffers.containsKey(bufferId)) {
                this.checkHasBuffer(bufferId, partition);
                continue;
            }
            newBuffers.put(bufferId, partition);
        }
        if (newBuffers.isEmpty()) {
            return this;
        }
        Preconditions.checkState((!this.noMoreBufferIds ? 1 : 0) != 0, (Object)"No more buffer ids already set");
        newBuffers.putAll(this.buffers);
        return new OutputBuffers(this.type, this.version + 1L, false, newBuffers);
    }

    public OutputBuffers withNoMoreBufferIds() {
        if (this.noMoreBufferIds) {
            return this;
        }
        return new OutputBuffers(this.type, this.version + 1L, true, this.buffers);
    }

    private void checkHasBuffer(OutputBufferId bufferId, int partition) {
        Preconditions.checkArgument((boolean)Objects.equals(this.buffers.get(bufferId), partition), (String)"OutputBuffers already contains task %s, but partition is set to %s not %s", (Object)bufferId, (Object)this.buffers.get(bufferId), (Object)partition);
    }

    @ThriftStruct
    public static class OutputBufferId {
        private final int id;

        public static OutputBufferId fromString(String id) {
            return new OutputBufferId(Integer.parseInt(id));
        }

        @ThriftConstructor
        @JsonCreator
        public OutputBufferId(int id) {
            Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id is negative");
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutputBufferId that = (OutputBufferId)o;
            return this.id == that.id;
        }

        @ThriftField(value=1)
        @JsonValue
        public int getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return String.valueOf(this.id);
        }
    }

    public static enum BufferType {
        PARTITIONED,
        BROADCAST,
        ARBITRARY,
        DISCARDING,
        SPOOLING;

    }
}

