/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class FunctionSignatureMatcher {
    private final FunctionAndTypeManager functionAndTypeManager;

    public FunctionSignatureMatcher(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
    }

    public Optional<Signature> match(Collection<? extends SqlFunction> candidates, List<TypeSignatureProvider> parameterTypes, boolean coercionAllowed) {
        List<SqlFunction> exactCandidates = candidates.stream().filter(function -> function.getSignature().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
        Optional<Signature> match = this.matchFunctionExact(exactCandidates, parameterTypes);
        if (match.isPresent()) {
            return match;
        }
        List<SqlFunction> genericCandidates = candidates.stream().filter(function -> !function.getSignature().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
        match = this.matchFunctionExact(genericCandidates, parameterTypes);
        if (match.isPresent()) {
            return match;
        }
        if (coercionAllowed && (match = this.matchFunctionWithCoercion(candidates, parameterTypes)).isPresent()) {
            return match;
        }
        return Optional.empty();
    }

    private Optional<Signature> matchFunctionExact(List<SqlFunction> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, false);
    }

    private Optional<Signature> matchFunctionWithCoercion(Collection<? extends SqlFunction> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, true);
    }

    private Optional<Signature> matchFunction(Collection<? extends SqlFunction> candidates, List<TypeSignatureProvider> parameters, boolean coercionAllowed) {
        List<ApplicableFunction> applicableFunctions = this.identifyApplicableFunctions(candidates, parameters, coercionAllowed);
        if (applicableFunctions.isEmpty()) {
            return Optional.empty();
        }
        if (coercionAllowed) {
            Preconditions.checkState((!(applicableFunctions = this.selectMostSpecificFunctions(applicableFunctions, parameters)).isEmpty() ? 1 : 0) != 0, (Object)"at least single function must be left");
        }
        if (applicableFunctions.size() == 1) {
            return Optional.of(((ApplicableFunction)Iterables.getOnlyElement(applicableFunctions)).getBoundSignature());
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Could not choose a best candidate operator. Explicit type casts must be added.\n");
        errorMessageBuilder.append("Candidates are:\n");
        for (ApplicableFunction function : applicableFunctions) {
            errorMessageBuilder.append("\t * ");
            errorMessageBuilder.append(function.getBoundSignature().toString());
            errorMessageBuilder.append("\n");
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, errorMessageBuilder.toString());
    }

    private List<ApplicableFunction> identifyApplicableFunctions(Collection<? extends SqlFunction> candidates, List<TypeSignatureProvider> actualParameters, boolean allowCoercion) {
        ImmutableList.Builder applicableFunctions = ImmutableList.builder();
        for (SqlFunction sqlFunction : candidates) {
            Signature declaredSignature = sqlFunction.getSignature();
            Optional<Signature> boundSignature = new SignatureBinder(this.functionAndTypeManager, declaredSignature, allowCoercion).bind(actualParameters);
            if (!boundSignature.isPresent()) continue;
            applicableFunctions.add((Object)new ApplicableFunction(declaredSignature, boundSignature.get(), sqlFunction.isCalledOnNullInput()));
        }
        return applicableFunctions.build();
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> applicableFunctions, List<TypeSignatureProvider> parameters) {
        Preconditions.checkArgument((!applicableFunctions.isEmpty() ? 1 : 0) != 0);
        List<ApplicableFunction> mostSpecificFunctions = this.selectMostSpecificFunctions(applicableFunctions);
        if (mostSpecificFunctions.size() <= 1) {
            return mostSpecificFunctions;
        }
        Optional<List<Type>> optionalParameterTypes = this.toTypes(parameters);
        if (!optionalParameterTypes.isPresent()) {
            return mostSpecificFunctions;
        }
        List<Type> parameterTypes = optionalParameterTypes.get();
        if (!FunctionSignatureMatcher.someParameterIsUnknown(parameterTypes)) {
            return mostSpecificFunctions;
        }
        List<ApplicableFunction> unknownOnlyCastFunctions = this.getUnknownOnlyCastFunctions(applicableFunctions, parameterTypes);
        if (!unknownOnlyCastFunctions.isEmpty() && (mostSpecificFunctions = unknownOnlyCastFunctions).size() == 1) {
            return mostSpecificFunctions;
        }
        if (this.returnTypeIsTheSame(mostSpecificFunctions) && FunctionSignatureMatcher.allReturnNullOnGivenInputTypes(mostSpecificFunctions, parameterTypes)) {
            ApplicableFunction selectedFunction = (ApplicableFunction)Ordering.usingToString().reverse().sortedCopy(mostSpecificFunctions).get(0);
            return ImmutableList.of((Object)selectedFunction);
        }
        return mostSpecificFunctions;
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> candidates) {
        ArrayList<ApplicableFunction> representatives = new ArrayList<ApplicableFunction>();
        for (ApplicableFunction current : candidates) {
            boolean found = false;
            for (int i = 0; i < representatives.size(); ++i) {
                ApplicableFunction representative = (ApplicableFunction)representatives.get(i);
                if (this.isMoreSpecificThan(current, representative)) {
                    representatives.set(i, current);
                }
                if (!this.isMoreSpecificThan(current, representative) && !this.isMoreSpecificThan(representative, current)) continue;
                found = true;
                break;
            }
            if (found) continue;
            representatives.add(current);
        }
        return representatives;
    }

    private List<ApplicableFunction> getUnknownOnlyCastFunctions(List<ApplicableFunction> applicableFunction, List<Type> actualParameters) {
        return (List)applicableFunction.stream().filter(function -> this.onlyCastsUnknown((ApplicableFunction)function, actualParameters)).collect(ImmutableList.toImmutableList());
    }

    private boolean onlyCastsUnknown(ApplicableFunction applicableFunction, List<Type> actualParameters) {
        List<Type> boundTypes = TypeUtils.resolveTypes(applicableFunction.getBoundSignature().getArgumentTypes(), this.functionAndTypeManager);
        Preconditions.checkState((actualParameters.size() == boundTypes.size() ? 1 : 0) != 0, (Object)"type lists are of different lengths");
        for (int i = 0; i < actualParameters.size(); ++i) {
            if (boundTypes.get(i).equals(actualParameters.get(i)) || actualParameters.get(i) == UnknownType.UNKNOWN) continue;
            return false;
        }
        return true;
    }

    private boolean returnTypeIsTheSame(List<ApplicableFunction> applicableFunctions) {
        Set returnTypes = applicableFunctions.stream().map(function -> this.functionAndTypeManager.getType(function.getBoundSignature().getReturnType())).collect(Collectors.toSet());
        return returnTypes.size() == 1;
    }

    private boolean isMoreSpecificThan(ApplicableFunction left, ApplicableFunction right) {
        List resolvedTypes = TypeSignatureProvider.fromTypeSignatures((List)left.getBoundSignature().getArgumentTypes());
        Optional<BoundVariables> boundVariables = new SignatureBinder(this.functionAndTypeManager, right.getDeclaredSignature(), true).bindVariables(resolvedTypes);
        return boundVariables.isPresent();
    }

    private Optional<List<Type>> toTypes(List<TypeSignatureProvider> typeSignatureProviders) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (TypeSignatureProvider typeSignatureProvider : typeSignatureProviders) {
            if (typeSignatureProvider.hasDependency()) {
                return Optional.empty();
            }
            resultBuilder.add((Object)this.functionAndTypeManager.getType(typeSignatureProvider.getTypeSignature()));
        }
        return Optional.of(resultBuilder.build());
    }

    private static boolean someParameterIsUnknown(List<Type> parameters) {
        return parameters.stream().anyMatch(type -> type.equals(UnknownType.UNKNOWN));
    }

    private static boolean allReturnNullOnGivenInputTypes(List<ApplicableFunction> applicableFunctions, List<Type> parameters) {
        return applicableFunctions.stream().allMatch(x -> FunctionSignatureMatcher.returnsNullOnGivenInputTypes(x, parameters));
    }

    private static boolean returnsNullOnGivenInputTypes(ApplicableFunction applicableFunction, List<Type> parameterTypes) {
        Signature boundSignature = applicableFunction.getBoundSignature();
        FunctionKind functionKind = boundSignature.getKind();
        if (functionKind != FunctionKind.SCALAR) {
            return true;
        }
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Type parameterType = parameterTypes.get(i);
            if (!parameterType.equals(UnknownType.UNKNOWN) || !applicableFunction.isCalledOnNullInput()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static String constructFunctionNotFoundErrorMessage(QualifiedObjectName functionName, List<TypeSignatureProvider> parameterTypes, Collection<? extends SqlFunction> candidates) {
        void var6_9;
        String name = FunctionSignatureMatcher.toConciseFunctionName(functionName);
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (SqlFunction sqlFunction : candidates) {
            expectedParameters.add(String.format("%s(%s) %s", name, Joiner.on((String)", ").join((Iterable)sqlFunction.getSignature().getArgumentTypes()), Joiner.on((String)", ").join((Iterable)sqlFunction.getSignature().getTypeVariableConstraints())));
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String string = String.format("Function %s not registered", name);
        if (!expectedParameters.isEmpty()) {
            String expected = Joiner.on((String)", ").join(expectedParameters);
            String string2 = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        }
        return var6_9;
    }

    private static String toConciseFunctionName(QualifiedObjectName functionName) {
        if (functionName.getCatalogSchemaName().equals((Object)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE)) {
            return functionName.getObjectName();
        }
        return functionName.toString();
    }

    private static class ApplicableFunction {
        private final Signature declaredSignature;
        private final Signature boundSignature;
        private final boolean calledOnNullInput;

        private ApplicableFunction(Signature declaredSignature, Signature boundSignature, boolean calledOnNullInput) {
            this.declaredSignature = declaredSignature;
            this.boundSignature = boundSignature;
            this.calledOnNullInput = calledOnNullInput;
        }

        public Signature getDeclaredSignature() {
            return this.declaredSignature;
        }

        public Signature getBoundSignature() {
            return this.boundSignature;
        }

        public boolean isCalledOnNullInput() {
            return this.calledOnNullInput;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaredSignature", (Object)this.declaredSignature).add("boundSignature", (Object)this.boundSignature).add("calledOnNullInput", this.calledOnNullInput).toString();
        }
    }
}

