/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class StatisticsWriterOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private final OperatorContext operatorContext;
    private final StatisticsWriter statisticsWriter;
    private final StatisticAggregationsDescriptor<Integer> descriptor;
    private final boolean rowCountEnabled;
    private State state = State.RUNNING;
    private final ImmutableList.Builder<ComputedStatistics> computedStatisticsBuilder = ImmutableList.builder();

    public StatisticsWriterOperator(OperatorContext operatorContext, StatisticsWriter statisticsWriter, StatisticAggregationsDescriptor<Integer> descriptor, boolean rowCountEnabled) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.statisticsWriter = Objects.requireNonNull(statisticsWriter, "statisticsWriter is null");
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        this.rowCountEnabled = rowCountEnabled;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        for (int position = 0; position < page.getPositionCount(); ++position) {
            this.computedStatisticsBuilder.add((Object)this.getComputedStatistics(page, position));
        }
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING) {
            return null;
        }
        this.state = State.FINISHED;
        ImmutableList computedStatistics = this.computedStatisticsBuilder.build();
        this.statisticsWriter.writeStatistics((Collection<ComputedStatistics>)computedStatistics);
        PageBuilder page = new PageBuilder(1, TYPES);
        page.declarePosition();
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        if (this.rowCountEnabled) {
            BigintType.BIGINT.writeLong(rowsBuilder, StatisticsWriterOperator.getRowCount((Collection<ComputedStatistics>)computedStatistics));
        } else {
            rowsBuilder.appendNull();
        }
        return page.build();
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    private ComputedStatistics getComputedStatistics(Page page, int position) {
        ImmutableList.Builder groupingColumns = ImmutableList.builder();
        ImmutableList.Builder groupingValues = ImmutableList.builder();
        this.descriptor.getGrouping().forEach((column, channel) -> {
            groupingColumns.add(column);
            groupingValues.add((Object)page.getBlock(channel.intValue()).getSingleValueBlock(position));
        });
        ComputedStatistics.Builder statistics = ComputedStatistics.builder((List)groupingColumns.build(), (List)groupingValues.build());
        this.descriptor.getTableStatistics().forEach((type, channel) -> statistics.addTableStatistic(type, page.getBlock(channel.intValue()).getSingleValueBlock(position)));
        this.descriptor.getColumnStatistics().forEach(descriptor -> statistics.addColumnStatistic(descriptor.getMetadata(), page.getBlock(((Integer)descriptor.getItem()).intValue()).getSingleValueBlock(position)));
        return statistics.build();
    }

    private static long getRowCount(Collection<ComputedStatistics> computedStatistics) {
        return computedStatistics.stream().map(statistics -> (Block)statistics.getTableStatistics().get(TableStatisticType.ROW_COUNT)).filter(Objects::nonNull).mapToLong(block -> BigintType.BIGINT.getLong(block, 0)).reduce((first, second) -> first + second).orElse(0L);
    }

    public static interface StatisticsWriter {
        public void writeStatistics(Collection<ComputedStatistics> var1);
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class StatisticsWriterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final StatisticsWriter statisticsWriter;
        private final boolean rowCountEnabled;
        private final StatisticAggregationsDescriptor<Integer> descriptor;
        private boolean closed;

        public StatisticsWriterOperatorFactory(int operatorId, PlanNodeId planNodeId, StatisticsWriter statisticsWriter, boolean rowCountEnabled, StatisticAggregationsDescriptor<Integer> descriptor) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.statisticsWriter = Objects.requireNonNull(statisticsWriter, "statisticsWriter is null");
            this.rowCountEnabled = rowCountEnabled;
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, StatisticsWriterOperator.class.getSimpleName());
            return new StatisticsWriterOperator(context, this.statisticsWriter, this.descriptor, this.rowCountEnabled);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new StatisticsWriterOperatorFactory(this.operatorId, this.planNodeId, this.statisticsWriter, this.rowCountEnabled, this.descriptor);
        }
    }
}

