/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.DoubleRegressionAggregation;
import com.facebook.presto.operator.aggregation.state.RegressionState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;

@AggregationFunction
public class RealRegressionAggregation {
    private RealRegressionAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState RegressionState state, @SqlType(value="real") long dependentValue, @SqlType(value="real") long independentValue) {
        DoubleRegressionAggregation.input(state, Float.intBitsToFloat((int)dependentValue), Float.intBitsToFloat((int)independentValue));
    }

    @CombineFunction
    public static void combine(@AggregationState RegressionState state, @AggregationState RegressionState otherState) {
        DoubleRegressionAggregation.combine(state, otherState);
    }

    @AggregationFunction(value="regr_slope")
    @OutputFunction(value="real")
    public static void regrSlope(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionSlope(state);
        if (Double.isFinite(result)) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_intercept")
    @OutputFunction(value="real")
    public static void regrIntercept(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionIntercept(state);
        if (Double.isFinite(result)) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_sxy")
    @OutputFunction(value="real")
    public static void regrSxy(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionSxy(state);
        double count = AggregationUtils.getRegressionCount(state);
        if (Double.isFinite(result) && Double.isFinite(count) && count > 0.0) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_sxx")
    @OutputFunction(value="real")
    public static void regrSxx(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionSxx(state);
        double count = AggregationUtils.getRegressionCount(state);
        if (Double.isFinite(result) && Double.isFinite(count) && count > 0.0) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_syy")
    @OutputFunction(value="real")
    public static void regrSyy(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionSyy(state);
        double count = AggregationUtils.getRegressionCount(state);
        if (Double.isFinite(result) && Double.isFinite(count) && count > 0.0) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_r2")
    @OutputFunction(value="real")
    public static void regrR2(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionR2(state);
        if (Double.isFinite(result)) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_count")
    @OutputFunction(value="real")
    public static void regrCount(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionCount(state);
        if (Double.isFinite(result) && result > 0.0) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_avgy")
    @OutputFunction(value="real")
    public static void regrAvgy(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionAvgy(state);
        double count = AggregationUtils.getRegressionCount(state);
        if (Double.isFinite(result) && Double.isFinite(count) && count > 0.0) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_avgx")
    @OutputFunction(value="real")
    public static void regrAvgx(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionAvgx(state);
        double count = AggregationUtils.getRegressionCount(state);
        if (Double.isFinite(result) && Double.isFinite(count) && count > 0.0) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }
}

