/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.approxmostfrequent;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.approxmostfrequent.ApproximateMostFrequentState;
import com.facebook.presto.operator.aggregation.approxmostfrequent.stream.StreamSummary;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;

@AggregationFunction(value="approx_most_frequent")
@Description(value="Computes the top frequent elements approximately")
public final class ApproximateMostFrequent {
    private ApproximateMostFrequent() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@TypeParameter(value="T") Type type, @AggregationState ApproximateMostFrequentState state, @SqlType(value="bigint") long buckets, @BlockPosition @SqlType(value="T") Block valueBlock, @BlockIndex int valueIndex, @SqlType(value="bigint") long capacity) {
        StreamSummary streamSummary = state.getStateSummary();
        if (streamSummary == null) {
            Failures.checkCondition(buckets > 1L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "approx_most_frequent bucket count must be greater than one, input bucket count: %s", buckets);
            streamSummary = new StreamSummary(type, Math.toIntExact(buckets), Math.toIntExact(capacity));
            state.setStateSummary(streamSummary);
        }
        streamSummary.add(valueBlock, valueIndex, 1L);
    }

    @CombineFunction
    public static void combine(@AggregationState ApproximateMostFrequentState state, @AggregationState ApproximateMostFrequentState otherState) {
        StreamSummary streamSummary = state.getStateSummary();
        if (streamSummary == null) {
            state.setStateSummary(otherState.getStateSummary());
        } else {
            streamSummary.merge(otherState.getStateSummary());
        }
    }

    @OutputFunction(value="map(T,bigint)")
    public static void output(@AggregationState ApproximateMostFrequentState state, BlockBuilder out) {
        if (state.getStateSummary() == null) {
            out.appendNull();
        } else {
            state.getStateSummary().topK(out);
        }
    }
}

