/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jol.info.ClassLayout;

public class UnweightedDoubleReservoirSample
implements Cloneable {
    public static final int MAX_SAMPLES_LIMIT = 1000000;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(UnweightedDoubleReservoirSample.class).instanceSize();
    private int seenCount;
    private double[] samples;

    public UnweightedDoubleReservoirSample(int maxSamples) {
        Preconditions.checkArgument((maxSamples > 0 ? 1 : 0) != 0, (Object)String.format("Maximum number of samples must be positive: %s", maxSamples));
        Preconditions.checkArgument((maxSamples <= 1000000 ? 1 : 0) != 0, (Object)String.format("Maximum number of samples must not exceed maximum: %s %s", maxSamples, 1000000));
        this.samples = new double[maxSamples];
    }

    private UnweightedDoubleReservoirSample(UnweightedDoubleReservoirSample other) {
        this.seenCount = other.seenCount;
        this.samples = Arrays.copyOf(Objects.requireNonNull(other.samples, "samples is null"), other.samples.length);
    }

    private UnweightedDoubleReservoirSample(int seenCount, double[] samples) {
        this.seenCount = seenCount;
        this.samples = samples;
    }

    public int getMaxSamples() {
        return this.samples.length;
    }

    public void add(double sample) {
        ++this.seenCount;
        if (this.seenCount <= this.samples.length) {
            this.samples[this.seenCount - 1] = sample;
            return;
        }
        int index = ThreadLocalRandom.current().nextInt(0, this.seenCount);
        if (index < this.samples.length) {
            this.samples[index] = sample;
        }
    }

    public void mergeWith(UnweightedDoubleReservoirSample other) {
        Preconditions.checkArgument((this.samples.length == other.samples.length ? 1 : 0) != 0, (Object)String.format("Maximum number of samples %s must be equal to that of other %s", this.samples.length, other.samples.length));
        if (other.seenCount < other.samples.length) {
            for (int i = 0; i < other.seenCount; ++i) {
                this.add(other.samples[i]);
            }
            return;
        }
        if (this.seenCount < this.samples.length) {
            UnweightedDoubleReservoirSample target = other.clone();
            for (int i = 0; i < this.seenCount; ++i) {
                target.add(this.samples[i]);
            }
            this.seenCount = target.seenCount;
            this.samples = target.samples;
            return;
        }
        UnweightedDoubleReservoirSample.shuffleArray(this.samples);
        UnweightedDoubleReservoirSample.shuffleArray(other.samples);
        int nextIndex = 0;
        int otherNextIndex = 0;
        double[] merged = new double[this.samples.length];
        for (int i = 0; i < this.samples.length; ++i) {
            merged[i] = ThreadLocalRandom.current().nextLong(0L, this.seenCount + other.seenCount) < (long)this.seenCount ? this.samples[nextIndex++] : other.samples[otherNextIndex++];
        }
        this.seenCount += other.seenCount;
        this.samples = merged;
    }

    public int getTotalPopulationCount() {
        return this.seenCount;
    }

    public UnweightedDoubleReservoirSample clone() {
        return new UnweightedDoubleReservoirSample(this);
    }

    public double[] getSamples() {
        return Arrays.copyOf(this.samples, Math.min(this.seenCount, this.samples.length));
    }

    private static void shuffleArray(double[] samples) {
        for (int i = samples.length - 1; i > 0; --i) {
            int index = ThreadLocalRandom.current().nextInt(0, i + 1);
            double sample = samples[index];
            samples[index] = samples[i];
            samples[i] = sample;
        }
    }

    public static UnweightedDoubleReservoirSample deserialize(SliceInput input) {
        int seenCount = input.readInt();
        int maxSamples = input.readInt();
        double[] samples = new double[maxSamples];
        input.readBytes(Slices.wrappedDoubleArray((double[])samples), Math.min(seenCount, samples.length) * 8);
        return new UnweightedDoubleReservoirSample(seenCount, samples);
    }

    public void serialize(SliceOutput output) {
        output.appendInt(this.seenCount);
        output.appendInt(this.samples.length);
        for (int i = 0; i < Math.min(this.seenCount, this.samples.length); ++i) {
            output.appendDouble(this.samples[i]);
        }
    }

    public int getRequiredBytesForSerialization() {
        return 8 + 8 * Math.min(this.seenCount, this.samples.length);
    }

    public long estimatedInMemorySize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((double[])this.samples);
    }
}

