/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.reservoirsample;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.reservoirsample.ReservoirSample;
import com.facebook.presto.operator.aggregation.reservoirsample.ReservoirSampleState;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class GroupedReservoirSampleState
extends AbstractGroupedAccumulatorState
implements ReservoirSampleState {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedReservoirSampleState.class).instanceSize();
    private final ObjectBigArray<ReservoirSample> samples = new ObjectBigArray();
    private long size;

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.size + this.samples.sizeOf();
    }

    public void ensureCapacity(long size) {
        this.samples.ensureCapacity(size);
    }

    @Override
    public ReservoirSample get() {
        return (ReservoirSample)this.samples.get(this.getGroupId());
    }

    @Override
    public void set(ReservoirSample value) {
        Objects.requireNonNull(value, "value is null");
        ReservoirSample previous = this.get();
        if (previous != null) {
            this.size -= previous.estimatedInMemorySize();
        }
        this.samples.set(this.getGroupId(), (Object)value);
        this.size += value.estimatedInMemorySize();
    }
}

