/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.OptimizedTypedSet;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_except")
@Description(value="Returns an array of elements that are in the first array but not the second, without duplicates.")
public final class ArrayExceptFunction {
    private ArrayExceptFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block except(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"E", "E"}) MethodHandle elementIsDistinctFrom, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (leftPositionCount == 0) {
            return leftArray;
        }
        OptimizedTypedSet typedSet = new OptimizedTypedSet(type, elementIsDistinctFrom, Math.max(leftPositionCount, rightPositionCount));
        typedSet.union(rightArray);
        typedSet.except(leftArray);
        return typedSet.getBlock();
    }
}

