/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

@Description(value="Returns the sum of all array elements, or 0 if the array is empty. Ignores null elements.")
@ScalarFunction(value="array_sum")
public final class ArraySumDoubleFunction {
    private ArraySumDoubleFunction() {
    }

    @SqlType(value="double")
    public static double arraySumDouble(@OperatorDependency(operator=OperatorType.ADD, argumentTypes={"double", "double"}) MethodHandle addFunction, @TypeParameter(value="double") Type elementType, @SqlType(value="array(double)") Block arrayBlock) {
        int positionCount = arrayBlock.getPositionCount();
        if (positionCount == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < positionCount; ++i) {
            if (arrayBlock.isNull(i)) continue;
            try {
                Object newValue = TypeUtils.readNativeValue((Type)elementType, (Block)arrayBlock, (int)i);
                sum = addFunction.invoke(sum, (Double)newValue);
                continue;
            }
            catch (Throwable throwable) {
                throw Failures.internalError(throwable);
            }
        }
        return sum;
    }
}

