/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;

public final class BitwiseFunctions {
    private static final int MAX_BITS = 64;
    private static final long TINYINT_MASK = 255L;
    private static final long TINYINT_SIGNED_BIT = 128L;
    private static final long SMALLINT_MASK = 65535L;
    private static final long SMALLINT_SIGNED_BIT = 32768L;
    private static final long INTEGER_MASK = 0xFFFFFFFFL;
    private static final long INTEGER_SIGNED_BIT = 0x80000000L;

    private BitwiseFunctions() {
    }

    @Description(value="count number of set bits in 2's complement representation")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitCount(@SqlType(value="bigint") long num, @SqlType(value="bigint") long bits) {
        if (bits == 64L) {
            return Long.bitCount(num);
        }
        if (bits <= 1L || bits > 64L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Bits specified in bit_count must be between 2 and 64, got " + bits);
        }
        long lowBitsMask = (1L << (int)(bits - 1L)) - 1L;
        if (num > lowBitsMask || num < (lowBitsMask ^ 0xFFFFFFFFFFFFFFFFL)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Number must be representable with the bits specified. " + num + " can not be represented with " + bits + " bits");
        }
        long mask = (1L << (int)bits) - 1L;
        return Long.bitCount(num & mask);
    }

    @Description(value="bitwise NOT in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseNot(@SqlType(value="bigint") long num) {
        return num ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Description(value="bitwise AND in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseAnd(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left & right;
    }

    @Description(value="bitwise OR in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseOr(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left | right;
    }

    @Description(value="bitwise XOR in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseXor(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left ^ right;
    }

    @Description(value="shift left operation with specified bits")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseShiftLeft(@SqlType(value="bigint") long number, @SqlType(value="bigint") long shift, @SqlType(value="bigint") long bits) {
        if (bits == 64L) {
            return number << (int)shift;
        }
        if (bits <= 1L || bits > 64L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Bits specified must be between 2 and 64, got " + bits);
        }
        if (shift < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Specified shift must be positive");
        }
        return number << (int)shift & (long)(Math.pow(2.0, bits) - 1.0);
    }

    @Description(value="logical shift right operation with specified bits")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseLogicalShiftRight(@SqlType(value="bigint") long number, @SqlType(value="bigint") long shift, @SqlType(value="bigint") long bits) {
        if (bits == 64L) {
            return number >>> (int)shift;
        }
        if (bits <= 1L || bits > 64L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Bits specified in must be between 2 and 64, got " + bits);
        }
        if (shift < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Specified shift must be positive");
        }
        return (number & (long)(Math.pow(2.0, bits) - 1.0)) >>> (int)shift;
    }

    @Description(value="arithmetic shift right operation")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseArithmeticShiftRight(@SqlType(value="bigint") long number, @SqlType(value="bigint") long shift) {
        if (shift < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Specified shift must be positive");
        }
        return number >> (int)shift;
    }

    @Description(value="bitwise left shift")
    @ScalarFunction(value="bitwise_left_shift")
    @SqlType(value="tinyint")
    public static long bitwiseLeftShiftTinyint(@SqlType(value="tinyint") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            return 0L;
        }
        long shifted = value << (int)shift;
        return BitwiseFunctions.preserveSign(shifted, 255L, 128L);
    }

    @Description(value="bitwise left shift")
    @ScalarFunction(value="bitwise_left_shift")
    @SqlType(value="smallint")
    public static long bitwiseLeftShiftSmallint(@SqlType(value="smallint") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            return 0L;
        }
        long shifted = value << (int)shift;
        return BitwiseFunctions.preserveSign(shifted, 65535L, 32768L);
    }

    @Description(value="bitwise left shift")
    @ScalarFunction(value="bitwise_left_shift")
    @SqlType(value="integer")
    public static long bitwiseLeftShiftInteger(@SqlType(value="integer") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            return 0L;
        }
        long shifted = value << (int)shift;
        return BitwiseFunctions.preserveSign(shifted, 0xFFFFFFFFL, 0x80000000L);
    }

    @Description(value="bitwise left shift")
    @ScalarFunction(value="bitwise_left_shift")
    @SqlType(value="bigint")
    public static long bitwiseLeftShiftBigint(@SqlType(value="bigint") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            return 0L;
        }
        return value << (int)shift;
    }

    private static long preserveSign(long shiftedValue, long mask, long signedBit) {
        if ((shiftedValue & signedBit) != 0L) {
            return shiftedValue | mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return shiftedValue & mask;
    }

    @Description(value="bitwise logical right shift")
    @ScalarFunction(value="bitwise_right_shift")
    @SqlType(value="tinyint")
    public static long bitwiseRightShiftTinyint(@SqlType(value="tinyint") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            return 0L;
        }
        if (shift == 0L) {
            return value;
        }
        return (value & 0xFFL) >>> (int)shift;
    }

    @Description(value="bitwise logical right shift")
    @ScalarFunction(value="bitwise_right_shift")
    @SqlType(value="smallint")
    public static long bitwiseRightShiftSmallint(@SqlType(value="smallint") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            return 0L;
        }
        if (shift == 0L) {
            return value;
        }
        return (value & 0xFFFFL) >>> (int)shift;
    }

    @Description(value="bitwise logical right shift")
    @ScalarFunction(value="bitwise_right_shift")
    @SqlType(value="integer")
    public static long bitwiseRightShiftInteger(@SqlType(value="integer") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            return 0L;
        }
        if (shift == 0L) {
            return value;
        }
        return (value & 0xFFFFFFFFL) >>> (int)shift;
    }

    @Description(value="bitwise logical right shift")
    @ScalarFunction(value="bitwise_right_shift")
    @SqlType(value="bigint")
    public static long bitwiseRightShiftBigint(@SqlType(value="bigint") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            return 0L;
        }
        return value >>> (int)shift;
    }

    @Description(value="bitwise arithmetic right shift")
    @ScalarFunction(value="bitwise_right_shift_arithmetic")
    @SqlType(value="tinyint")
    public static long bitwiseRightShiftArithmeticTinyint(@SqlType(value="tinyint") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            if (value >= 0L) {
                return 0L;
            }
            return -1L;
        }
        return BitwiseFunctions.preserveSign(value, 255L, 128L) >> (int)shift;
    }

    @Description(value="bitwise arithmetic right shift")
    @ScalarFunction(value="bitwise_right_shift_arithmetic")
    @SqlType(value="smallint")
    public static long bitwiseRightShiftArithmeticSmallint(@SqlType(value="smallint") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            if (value >= 0L) {
                return 0L;
            }
            return -1L;
        }
        return BitwiseFunctions.preserveSign(value, 65535L, 32768L) >> (int)shift;
    }

    @Description(value="bitwise arithmetic right shift")
    @ScalarFunction(value="bitwise_right_shift_arithmetic")
    @SqlType(value="integer")
    public static long bitwiseRightShiftArithmeticInteger(@SqlType(value="integer") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            if (value >= 0L) {
                return 0L;
            }
            return -1L;
        }
        return BitwiseFunctions.preserveSign(value, 0xFFFFFFFFL, 0x80000000L) >> (int)shift;
    }

    @Description(value="bitwise arithmetic right shift")
    @ScalarFunction(value="bitwise_right_shift_arithmetic")
    @SqlType(value="bigint")
    public static long bitwiseRightShiftArithmeticBigint(@SqlType(value="bigint") long value, @SqlType(value="integer") long shift) {
        if (shift >= 64L) {
            if (value >= 0L) {
                return 0L;
            }
            return -1L;
        }
        return value >> (int)shift;
    }
}

