/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;

public class KllSketchFunctions {
    private KllSketchFunctions() {
    }

    @ScalarFunction(value="sketch_kll_quantile")
    @Description(value="Calculates the quantile for a given value with the provided inclusivity. If inclusive is true, the given rank includes all quantiles \u2264 the quantile directly corresponding to the given rank. If false, the given rank includes all quantiles < the quantile directly corresponding to the given rank.")
    @SqlType(value="double")
    public static double sketchQuantileDouble(@SqlType(value="kllsketch(double)") Slice rawSketch, @SqlType(value="double") double rank, @SqlType(value="boolean") boolean inclusive) {
        KllItemsSketch sketch = KllItemsSketch.wrap((Memory)Memory.wrap((ByteBuffer)rawSketch.toByteBuffer(), (ByteOrder)ByteOrder.LITTLE_ENDIAN), Double::compareTo, (ArrayOfItemsSerDe)new ArrayOfDoublesSerDe());
        return (Double)sketch.getQuantile(rank, inclusive ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
    }

    @ScalarFunction(value="sketch_kll_quantile")
    @SqlType(value="double")
    public static double sketchQuantileDouble(@SqlType(value="kllsketch(double)") Slice rawSketch, @SqlType(value="double") double rank) {
        return KllSketchFunctions.sketchQuantileDouble(rawSketch, rank, true);
    }

    @ScalarFunction(value="sketch_kll_quantile")
    @SqlType(value="bigint")
    public static long sketchQuantileBigint(@SqlType(value="kllsketch(bigint)") Slice rawSketch, @SqlType(value="double") double rank, @SqlType(value="boolean") boolean inclusive) {
        KllItemsSketch sketch = KllItemsSketch.wrap((Memory)Memory.wrap((ByteBuffer)rawSketch.toByteBuffer(), (ByteOrder)ByteOrder.LITTLE_ENDIAN), Long::compareTo, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        return (Long)sketch.getQuantile(rank, inclusive ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
    }

    @ScalarFunction(value="sketch_kll_quantile")
    @SqlType(value="bigint")
    public static long sketchQuantileBigint(@SqlType(value="kllsketch(bigint)") Slice rawSketch, @SqlType(value="double") double rank) {
        return KllSketchFunctions.sketchQuantileBigint(rawSketch, rank, true);
    }

    @ScalarFunction(value="sketch_kll_quantile")
    @SqlType(value="varchar")
    public static Slice sketchQuantileString(@SqlType(value="kllsketch(varchar)") Slice rawSketch, @SqlType(value="double") double rank, @SqlType(value="boolean") boolean inclusive) {
        KllItemsSketch sketch = KllItemsSketch.wrap((Memory)Memory.wrap((ByteBuffer)rawSketch.toByteBuffer(), (ByteOrder)ByteOrder.LITTLE_ENDIAN), String::compareTo, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        return Slices.utf8Slice((String)((String)sketch.getQuantile(rank, inclusive ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE)));
    }

    @ScalarFunction(value="sketch_kll_quantile")
    @SqlType(value="varchar")
    public static Slice sketchQuantileString(@SqlType(value="kllsketch(varchar)") Slice rawSketch, @SqlType(value="double") double rank) {
        return KllSketchFunctions.sketchQuantileString(rawSketch, rank, true);
    }

    @ScalarFunction(value="sketch_kll_quantile")
    @SqlType(value="boolean")
    public static boolean sketchQuantileBoolean(@SqlType(value="kllsketch(boolean)") Slice rawSketch, @SqlType(value="double") double rank, @SqlType(value="boolean") boolean inclusive) {
        KllItemsSketch sketch = KllItemsSketch.wrap((Memory)Memory.wrap((ByteBuffer)rawSketch.toByteBuffer(), (ByteOrder)ByteOrder.LITTLE_ENDIAN), Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        return (Boolean)sketch.getQuantile(rank, inclusive ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
    }

    @ScalarFunction(value="sketch_kll_quantile")
    @SqlType(value="boolean")
    public static boolean sketchQuantileBoolean(@SqlType(value="kllsketch(boolean)") Slice rawSketch, @SqlType(value="double") double rank) {
        return KllSketchFunctions.sketchQuantileBoolean(rawSketch, rank, true);
    }

    @ScalarFunction(value="sketch_kll_rank")
    @Description(value="Calculates the rank of a quantile; An estimate of the value which occurs at a particular quantile in the distribution")
    @SqlType(value="double")
    public static double sketchRank(@SqlType(value="kllsketch(double)") Slice rawSketch, @SqlType(value="double") double quantile, @SqlType(value="boolean") boolean inclusive) {
        KllItemsSketch sketch = KllItemsSketch.wrap((Memory)Memory.wrap((ByteBuffer)rawSketch.toByteBuffer(), (ByteOrder)ByteOrder.LITTLE_ENDIAN), Double::compareTo, (ArrayOfItemsSerDe)new ArrayOfDoublesSerDe());
        return sketch.getRank((Object)quantile, inclusive ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
    }

    @ScalarFunction(value="sketch_kll_rank")
    @SqlType(value="double")
    public static double sketchRank(@SqlType(value="kllsketch(double)") Slice rawSketch, @SqlType(value="double") double quantile) {
        return KllSketchFunctions.sketchRank(rawSketch, quantile, true);
    }

    @ScalarFunction(value="sketch_kll_rank")
    @SqlType(value="double")
    public static double sketchRank(@SqlType(value="kllsketch(bigint)") Slice rawSketch, @SqlType(value="bigint") long quantile, @SqlType(value="boolean") boolean inclusive) {
        KllItemsSketch sketch = KllItemsSketch.wrap((Memory)Memory.wrap((ByteBuffer)rawSketch.toByteBuffer(), (ByteOrder)ByteOrder.LITTLE_ENDIAN), Long::compareTo, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        return sketch.getRank((Object)quantile, inclusive ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
    }

    @ScalarFunction(value="sketch_kll_rank")
    @SqlType(value="double")
    public static double sketchRank(@SqlType(value="kllsketch(bigint)") Slice rawSketch, @SqlType(value="bigint") long quantile) {
        return KllSketchFunctions.sketchRank(rawSketch, quantile, true);
    }

    @ScalarFunction(value="sketch_kll_rank")
    @SqlType(value="double")
    public static double sketchRank(@SqlType(value="kllsketch(varchar)") Slice rawSketch, @SqlType(value="varchar") Slice rank, @SqlType(value="boolean") boolean inclusive) {
        KllItemsSketch sketch = KllItemsSketch.wrap((Memory)Memory.wrap((ByteBuffer)rawSketch.toByteBuffer(), (ByteOrder)ByteOrder.LITTLE_ENDIAN), String::compareTo, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        return sketch.getRank((Object)rank.toStringUtf8(), inclusive ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
    }

    @ScalarFunction(value="sketch_kll_rank")
    @SqlType(value="double")
    public static double sketchRank(@SqlType(value="kllsketch(varchar)") Slice rawSketch, @SqlType(value="varchar") Slice quantile) {
        return KllSketchFunctions.sketchRank(rawSketch, quantile, true);
    }

    @ScalarFunction(value="sketch_kll_rank")
    @SqlType(value="double")
    public static double sketchRank(@SqlType(value="kllsketch(boolean)") Slice rawSketch, @SqlType(value="boolean") boolean rank, @SqlType(value="boolean") boolean inclusive) {
        KllItemsSketch sketch = KllItemsSketch.wrap((Memory)Memory.wrap((ByteBuffer)rawSketch.toByteBuffer(), (ByteOrder)ByteOrder.LITTLE_ENDIAN), Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        return sketch.getRank((Object)rank, inclusive ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE);
    }

    @ScalarFunction(value="sketch_kll_rank")
    @SqlType(value="double")
    public static double sketchRank(@SqlType(value="kllsketch(boolean)") Slice rawSketch, @SqlType(value="boolean") boolean quantile) {
        return KllSketchFunctions.sketchRank(rawSketch, quantile, true);
    }
}

