/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchAggregationUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;

public final class SfmSketchFunctions {
    private SfmSketchFunctions() {
    }

    @ScalarFunction
    @Description(value="estimated cardinality of an SfmSketch object")
    @SqlType(value="bigint")
    public static long cardinality(@SqlType(value="SfmSketch") Slice serializedSketch) {
        return SfmSketch.deserialize(serializedSketch).cardinality();
    }

    @ScalarFunction(value="merge_sfm", deterministic=false)
    @Description(value="merge the contents of an array of SfmSketch objects")
    @SqlType(value="SfmSketch")
    @SqlNullable
    public static Slice scalarMerge(@SqlType(value="array(SfmSketch)") Block block) {
        if (block.getPositionCount() == 0) {
            return null;
        }
        SfmSketch merged = null;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            SfmSketch sketch = SfmSketch.deserialize(block.getSlice(i, 0, block.getSliceLength(i)));
            if (merged == null) {
                merged = sketch;
                continue;
            }
            merged.mergeWith(sketch);
        }
        if (merged == null) {
            return null;
        }
        return merged.serialize();
    }

    @ScalarFunction(value="noisy_empty_approx_set_sfm", deterministic=false)
    @Description(value="an SfmSketch object representing an empty set")
    @SqlType(value="SfmSketch")
    public static Slice emptyApproxSet(@SqlType(value="double") double epsilon, @SqlType(value="bigint") long numberOfBuckets, @SqlType(value="bigint") long precision) {
        SfmSketchAggregationUtils.validateSketchParameters(epsilon, (int)numberOfBuckets, (int)precision);
        SfmSketch sketch = SfmSketch.create((int)numberOfBuckets, (int)precision);
        sketch.enablePrivacy(epsilon);
        return sketch.serialize();
    }

    @ScalarFunction(value="noisy_empty_approx_set_sfm", deterministic=false)
    @Description(value="an SfmSketch object representing an empty set")
    @SqlType(value="SfmSketch")
    public static Slice emptyApproxSet(@SqlType(value="double") double epsilon, @SqlType(value="bigint") long numberOfBuckets) {
        return SfmSketchFunctions.emptyApproxSet(epsilon, numberOfBuckets, 24L);
    }

    @ScalarFunction(value="noisy_empty_approx_set_sfm", deterministic=false)
    @Description(value="an SfmSketch object representing an empty set")
    @SqlType(value="SfmSketch")
    public static Slice emptyApproxSet(@SqlType(value="double") double epsilon) {
        return SfmSketchFunctions.emptyApproxSet(epsilon, 4096L, 24L);
    }
}

