/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.common.WarningHandlingLevel;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.execution.warnings.WarningCollectorFactory;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControlUtils;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.SessionSupplier;
import com.facebook.presto.server.security.SecurityConfig;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AuthorizedIdentity;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.SqlEnvironmentConfig;
import com.facebook.presto.transaction.TransactionManager;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class QuerySessionSupplier
implements SessionSupplier {
    private final Logger log = Logger.get(QuerySessionSupplier.class);
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;
    private final Optional<TimeZoneKey> forcedSessionTimeZone;
    private final SecurityConfig securityConfig;

    @Inject
    public QuerySessionSupplier(TransactionManager transactionManager, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, SqlEnvironmentConfig sqlEnvironmentConfig, SecurityConfig securityConfig) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        Objects.requireNonNull(sqlEnvironmentConfig, "sqlEnvironmentConfig is null");
        this.forcedSessionTimeZone = Objects.requireNonNull(sqlEnvironmentConfig.getForcedSessionTimeZone(), "forcedSessionTimeZone is null");
        this.securityConfig = Objects.requireNonNull(securityConfig, "securityConfig is null");
    }

    @Override
    public Session createSession(QueryId queryId, SessionContext context, WarningCollectorFactory warningCollectorFactory) {
        Session session = this.createSessionBuilder(queryId, context, warningCollectorFactory).build();
        if (context.getTransactionId().isPresent()) {
            session = session.beginTransactionId(context.getTransactionId().get(), this.transactionManager, this.accessControl);
        }
        return session;
    }

    @Override
    public Session.SessionBuilder createSessionBuilder(QueryId queryId, SessionContext context, WarningCollectorFactory warningCollectorFactory) {
        Session.SessionBuilder sessionBuilder = Session.builder(this.sessionPropertyManager).setQueryId(queryId).setIdentity(this.authenticateIdentity(queryId, context)).setSource(context.getSource()).setCatalog(context.getCatalog()).setSchema(context.getSchema()).setRemoteUserAddress(context.getRemoteUserAddress()).setUserAgent(context.getUserAgent()).setClientInfo(context.getClientInfo()).setClientTags(context.getClientTags()).setTraceToken(context.getTraceToken()).setResourceEstimates(context.getResourceEstimates()).setTracer(context.getTracer()).setRuntimeStats(context.getRuntimeStats());
        if (this.forcedSessionTimeZone.isPresent()) {
            sessionBuilder.setTimeZoneKey(this.forcedSessionTimeZone.get());
        } else if (context.getTimeZoneId() != null) {
            sessionBuilder.setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)context.getTimeZoneId()));
        }
        if (context.getLanguage() != null) {
            sessionBuilder.setLocale(Locale.forLanguageTag(context.getLanguage()));
        }
        for (Map.Entry<String, String> entry : context.getSystemProperties().entrySet()) {
            sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : context.getCatalogSessionProperties().entrySet()) {
            String catalog = entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                sessionBuilder.setCatalogSessionProperty(catalog, (String)entry2.getKey(), (String)entry2.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : context.getPreparedStatements().entrySet()) {
            sessionBuilder.addPreparedStatement(entry.getKey(), (String)entry.getValue());
        }
        if (context.supportClientTransaction()) {
            sessionBuilder.setClientTransactionSupport();
        }
        for (Map.Entry<String, Object> entry : context.getSessionFunctions().entrySet()) {
            sessionBuilder.addSessionFunction((SqlFunctionId)entry.getKey(), (SqlInvokedFunction)entry.getValue());
        }
        WarningCollector warningCollector = warningCollectorFactory.create(sessionBuilder.getSystemProperty("warning_handling", WarningHandlingLevel.class));
        sessionBuilder.setWarningCollector(warningCollector);
        return sessionBuilder;
    }

    private Identity authenticateIdentity(QueryId queryId, SessionContext context) {
        AccessControlUtils.checkPermissions(this.accessControl, this.securityConfig, queryId, context);
        Optional<AuthorizedIdentity> authorizedIdentity = context.getAuthorizedIdentity();
        authorizedIdentity = authorizedIdentity.isPresent() ? authorizedIdentity : AccessControlUtils.getAuthorizedIdentity(this.accessControl, this.securityConfig, queryId, context);
        return authorizedIdentity.map(identity -> new Identity(context.getIdentity().getUser(), context.getIdentity().getPrincipal(), context.getIdentity().getRoles(), context.getIdentity().getExtraCredentials(), context.getIdentity().getExtraAuthenticators(), Optional.of(identity.getUserName()), identity.getReasonForSelect())).orElseGet(context::getIdentity);
    }
}

