/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sessionpropertyproviders;

import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.session.WorkerSessionPropertyProvider;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;

@Deprecated
public class NativeWorkerSessionPropertyProvider
implements WorkerSessionPropertyProvider {
    public static final String NATIVE_SIMPLIFIED_EXPRESSION_EVALUATION_ENABLED = "native_simplified_expression_evaluation_enabled";
    public static final String NATIVE_EXPRESSION_MAX_ARRAY_SIZE_IN_REDUCE = "native_expression_max_array_size_in_reduce";
    public static final String NATIVE_MAX_SPILL_LEVEL = "native_max_spill_level";
    public static final String NATIVE_MAX_SPILL_FILE_SIZE = "native_max_spill_file_size";
    public static final String NATIVE_SPILL_COMPRESSION_CODEC = "native_spill_compression_codec";
    public static final String NATIVE_SPILL_WRITE_BUFFER_SIZE = "native_spill_write_buffer_size";
    public static final String NATIVE_SPILL_FILE_CREATE_CONFIG = "native_spill_file_create_config";
    public static final String NATIVE_JOIN_SPILL_ENABLED = "native_join_spill_enabled";
    public static final String NATIVE_WINDOW_SPILL_ENABLED = "native_window_spill_enabled";
    public static final String NATIVE_WRITER_SPILL_ENABLED = "native_writer_spill_enabled";
    public static final String NATIVE_WRITER_FLUSH_THRESHOLD_BYTES = "native_writer_flush_threshold_bytes";
    public static final String NATIVE_ROW_NUMBER_SPILL_ENABLED = "native_row_number_spill_enabled";
    public static final String NATIVE_TOPN_ROW_NUMBER_SPILL_ENABLED = "native_topn_row_number_spill_enabled";
    public static final String NATIVE_SPILLER_NUM_PARTITION_BITS = "native_spiller_num_partition_bits";
    public static final String NATIVE_DEBUG_VALIDATE_OUTPUT_FROM_OPERATORS = "native_debug_validate_output_from_operators";
    public static final String NATIVE_DEBUG_DISABLE_EXPRESSION_WITH_PEELING = "native_debug_disable_expression_with_peeling";
    public static final String NATIVE_DEBUG_DISABLE_COMMON_SUB_EXPRESSION = "native_debug_disable_common_sub_expressions";
    public static final String NATIVE_DEBUG_DISABLE_EXPRESSION_WITH_MEMOIZATION = "native_debug_disable_expression_with_memoization";
    public static final String NATIVE_DEBUG_DISABLE_EXPRESSION_WITH_LAZY_INPUTS = "native_debug_disable_expression_with_lazy_inputs";
    public static final String NATIVE_SELECTIVE_NIMBLE_READER_ENABLED = "native_selective_nimble_reader_enabled";
    public static final String NATIVE_MAX_PARTIAL_AGGREGATION_MEMORY = "native_max_partial_aggregation_memory";
    public static final String NATIVE_MAX_EXTENDED_PARTIAL_AGGREGATION_MEMORY = "native_max_extended_partial_aggregation_memory";
    public static final String NATIVE_MAX_SPILL_BYTES = "native_max_spill_bytes";
    public static final String NATIVE_MAX_PAGE_PARTITIONING_BUFFER_SIZE = "native_max_page_partitioning_buffer_size";
    public static final String NATIVE_MAX_OUTPUT_BUFFER_SIZE = "native_max_output_buffer_size";
    public static final String NATIVE_QUERY_TRACE_ENABLED = "native_query_trace_enabled";
    public static final String NATIVE_QUERY_TRACE_DIR = "native_query_trace_dir";
    public static final String NATIVE_QUERY_TRACE_NODE_IDS = "native_query_trace_node_ids";
    public static final String NATIVE_QUERY_TRACE_MAX_BYTES = "native_query_trace_max_bytes";
    public static final String NATIVE_QUERY_TRACE_REG_EXP = "native_query_trace_task_reg_exp";
    public static final String NATIVE_MAX_LOCAL_EXCHANGE_PARTITION_COUNT = "native_max_local_exchange_partition_count";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public NativeWorkerSessionPropertyProvider(FeaturesConfig featuresConfig) {
        boolean nativeExecution = Objects.requireNonNull(featuresConfig, "featuresConfig is null").isNativeExecutionEnabled();
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)NATIVE_SIMPLIFIED_EXPRESSION_EVALUATION_ENABLED, (String)"Native Execution only. Enable simplified path in expression evaluation", (Boolean)false, (!nativeExecution ? 1 : 0) != 0), (Object)PropertyMetadata.integerProperty((String)NATIVE_EXPRESSION_MAX_ARRAY_SIZE_IN_REDUCE, (String)"Native Execution only. Reduce() function will throw an error if it encounters an array of size greater than this value.", (Integer)100000, (!nativeExecution ? 1 : 0) != 0), (Object)PropertyMetadata.integerProperty((String)NATIVE_MAX_SPILL_LEVEL, (String)"Native Execution only. The maximum allowed spilling level for hash join build.\n0 is the initial spilling level, -1 means unlimited.", (Integer)4, (!nativeExecution ? 1 : 0) != 0), (Object)PropertyMetadata.integerProperty((String)NATIVE_MAX_SPILL_FILE_SIZE, (String)"The max allowed spill file size. If it is zero, then there is no limit.", (Integer)0, (!nativeExecution ? 1 : 0) != 0), (Object)PropertyMetadata.stringProperty((String)NATIVE_SPILL_COMPRESSION_CODEC, (String)"Native Execution only. The compression algorithm type to compress the spilled data.\n Supported compression codecs are: ZLIB, SNAPPY, LZO, ZSTD, LZ4 and GZIP. NONE means no compression.", (String)"zstd", (!nativeExecution ? 1 : 0) != 0), (Object)PropertyMetadata.longProperty((String)NATIVE_SPILL_WRITE_BUFFER_SIZE, (String)"Native Execution only. The maximum size in bytes to buffer the serialized spill data before writing to disk for IO efficiency.\nIf set to zero, buffering is disabled.", (Long)0x100000L, (!nativeExecution ? 1 : 0) != 0), (Object)PropertyMetadata.stringProperty((String)NATIVE_SPILL_FILE_CREATE_CONFIG, (String)"Native Execution only. Config used to create spill files. This config is \nprovided to underlying file system and the config is free form. The form should be\ndefined by the underlying file system.", (String)"", (!nativeExecution ? 1 : 0) != 0), (Object)PropertyMetadata.booleanProperty((String)NATIVE_JOIN_SPILL_ENABLED, (String)"Native Execution only. Enable join spilling on native engine", (Boolean)false, (!nativeExecution ? 1 : 0) != 0), (Object)PropertyMetadata.booleanProperty((String)NATIVE_WINDOW_SPILL_ENABLED, (String)"Native Execution only. Enable window spilling on native engine", (Boolean)false, (!nativeExecution ? 1 : 0) != 0), (Object)PropertyMetadata.booleanProperty((String)NATIVE_WRITER_SPILL_ENABLED, (String)"Native Execution only. Enable writer spilling on native engine", (Boolean)false, (!nativeExecution ? 1 : 0) != 0), (Object)PropertyMetadata.longProperty((String)NATIVE_WRITER_FLUSH_THRESHOLD_BYTES, (String)"Native Execution only. Minimum memory footprint size required to reclaim memory from a file writer by flushing its buffered data to disk.", (Long)0x6000000L, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)NATIVE_ROW_NUMBER_SPILL_ENABLED, (String)"Native Execution only. Enable row number spilling on native engine", (Boolean)false, (!nativeExecution ? 1 : 0) != 0), (Object[])new PropertyMetadata[]{PropertyMetadata.booleanProperty((String)NATIVE_TOPN_ROW_NUMBER_SPILL_ENABLED, (String)"Native Execution only. Enable topN row number spilling on native engine", (Boolean)false, (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.integerProperty((String)NATIVE_SPILLER_NUM_PARTITION_BITS, (String)"Native Execution only. The number of bits (N) used to calculate the spilling partition number for hash join and RowNumber: 2 ^ N", (Integer)3, (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.booleanProperty((String)NATIVE_DEBUG_VALIDATE_OUTPUT_FROM_OPERATORS, (String)"If set to true, then during execution of tasks, the output vectors of every operator are validated for consistency. This is an expensive check so should only be used for debugging. It can help debug issues where malformed vector cause failures or crashes by helping identify which operator is generating them.", (Boolean)false, (boolean)true), PropertyMetadata.booleanProperty((String)NATIVE_DEBUG_DISABLE_EXPRESSION_WITH_PEELING, (String)"If set to true, disables optimization in expression evaluation to peel common dictionary layer from inputs. Should only be used for debugging.", (Boolean)false, (boolean)true), PropertyMetadata.booleanProperty((String)NATIVE_DEBUG_DISABLE_COMMON_SUB_EXPRESSION, (String)"If set to true, disables optimization in expression evaluation to reuse cached results for common sub-expressions. Should only be used for debugging.", (Boolean)false, (boolean)true), PropertyMetadata.booleanProperty((String)NATIVE_DEBUG_DISABLE_EXPRESSION_WITH_MEMOIZATION, (String)"If set to true, disables optimization in expression evaluation to reuse cached results between subsequent input batches that are dictionary encoded and have the same alphabet(underlying flat vector). Should only be used for debugging.", (Boolean)false, (boolean)true), PropertyMetadata.booleanProperty((String)NATIVE_DEBUG_DISABLE_EXPRESSION_WITH_LAZY_INPUTS, (String)"If set to true, disables optimization in expression evaluation to delay loading of lazy inputs unless required. Should only be used for debugging.", (Boolean)false, (boolean)true), PropertyMetadata.booleanProperty((String)NATIVE_SELECTIVE_NIMBLE_READER_ENABLED, (String)"Temporary flag to control whether selective Nimble reader should be used in this query or not.  Will be removed after the selective Nimble reader is fully rolled out.", (Boolean)false, (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.longProperty((String)NATIVE_MAX_PARTIAL_AGGREGATION_MEMORY, (String)"The max partial aggregation memory when data reduction is not optimal.", (Long)0x1000000L, (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.longProperty((String)NATIVE_MAX_EXTENDED_PARTIAL_AGGREGATION_MEMORY, (String)"The max partial aggregation memory when data reduction is optimal.", (Long)0x4000000L, (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.longProperty((String)NATIVE_MAX_SPILL_BYTES, (String)"The max allowed spill bytes", (Long)0x1900000000L, (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.booleanProperty((String)NATIVE_QUERY_TRACE_ENABLED, (String)"Enables query tracing.", (Boolean)false, (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.stringProperty((String)NATIVE_QUERY_TRACE_DIR, (String)"Base dir of a query to store tracing data.", (String)"", (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.stringProperty((String)NATIVE_QUERY_TRACE_NODE_IDS, (String)"A comma-separated list of plan node ids whose input data will be traced. Empty string if only want to trace the query metadata.", (String)"", (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.longProperty((String)NATIVE_QUERY_TRACE_MAX_BYTES, (String)"The max trace bytes limit. Tracing is disabled if zero.", (Long)0L, (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.stringProperty((String)NATIVE_QUERY_TRACE_REG_EXP, (String)"The regexp of traced task id. We only enable trace on a task if its id matches.", (String)"", (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.longProperty((String)NATIVE_MAX_OUTPUT_BUFFER_SIZE, (String)"The maximum size in bytes for the task's buffered output. The buffer is shared among all drivers.", (Long)0xC800000L, (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.longProperty((String)NATIVE_MAX_PAGE_PARTITIONING_BUFFER_SIZE, (String)"The maximum bytes to buffer per PartitionedOutput operator to avoid creating tiny SerializedPages. For PartitionedOutputNode::Kind::kPartitioned, PartitionedOutput operator would buffer up to that number of bytes / number of destinations for each destination before producing a SerializedPage.", (Long)0x1800000L, (!nativeExecution ? 1 : 0) != 0), PropertyMetadata.integerProperty((String)NATIVE_MAX_LOCAL_EXCHANGE_PARTITION_COUNT, (String)"Maximum number of partitions created by a local exchange. Affects concurrency for pipelines containing LocalPartitionNode", null, (!nativeExecution ? 1 : 0) != 0)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }
}

