/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.sessionpropertyproviders.JavaWorkerSessionPropertyProvider;
import com.facebook.presto.spi.storage.TempDataOperationContext;
import com.facebook.presto.spi.storage.TempStorage;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.spiller.StandaloneSpillerFactory;
import com.facebook.presto.spiller.TempStorageStandaloneSpiller;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.storage.TempStorageManager;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class TempStorageStandaloneSpillerFactory
implements StandaloneSpillerFactory {
    private final TempStorageManager tempStorageManager;
    private final PagesSerdeFactory serdeFactory;
    private final String tempStorageName;
    private final SpillerStats spillerStats;

    @Inject
    public TempStorageStandaloneSpillerFactory(TempStorageManager tempStorageManager, BlockEncodingSerde blockEncodingSerde, NodeSpillConfig nodeSpillConfig, FeaturesConfig featuresConfig, SpillerStats spillerStats) {
        this.tempStorageManager = Objects.requireNonNull(tempStorageManager, "tempStorageManager is null");
        Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null");
        this.serdeFactory = new PagesSerdeFactory(blockEncodingSerde, nodeSpillConfig.isSpillCompressionEnabled());
        this.tempStorageName = Objects.requireNonNull(featuresConfig, "featuresConfig is null").getSpillerTempStorage();
        this.spillerStats = Objects.requireNonNull(spillerStats, "spillerStats can not be null");
    }

    @Override
    public TempStorageStandaloneSpiller create(Session session) {
        TempDataOperationContext tempDataOperationContext = new TempDataOperationContext(session.getSource(), session.getQueryId().getId(), session.getClientInfo(), Optional.of(session.getClientTags()), session.getIdentity());
        TempStorage tempStorage = this.tempStorageManager.getTempStorage(this.tempStorageName);
        return new TempStorageStandaloneSpiller(tempDataOperationContext, tempStorage, this.serdeFactory.createPagesSerde(), this.spillerStats, Math.toIntExact(JavaWorkerSessionPropertyProvider.getTempStorageSpillerBufferSize(session).toBytes()));
    }
}

