/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;

public final class MaterializedViewUtils {
    public static final QualifiedName MIN = QualifiedName.of((String)"MIN");
    public static final QualifiedName MAX = QualifiedName.of((String)"MAX");
    public static final QualifiedName SUM = QualifiedName.of((String)"SUM");
    public static final QualifiedName COUNT = QualifiedName.of((String)"COUNT");
    public static final QualifiedName AVG = QualifiedName.of((String)"AVG");
    public static final QualifiedName CARDINALITY = QualifiedName.of((String)"CARDINALITY");
    public static final QualifiedName MERGE = QualifiedName.of((String)"MERGE");
    public static final QualifiedName APPROX_DISTINCT = QualifiedName.of((String)"APPROX_DISTINCT");
    public static final QualifiedName APPROX_SET = QualifiedName.of((String)"APPROX_SET");
    public static final Set<QualifiedName> ASSOCIATIVE_REWRITE_FUNCTIONS = ImmutableSet.of((Object)MIN, (Object)MAX, (Object)SUM, (Object)COUNT);
    public static final Map<QualifiedName, NonAssociativeFunctionHandler> NON_ASSOCIATIVE_REWRITE_FUNCTIONS = ImmutableMap.of((Object)AVG, (Object)new AvgRewriteHandler(), (Object)APPROX_DISTINCT, (Object)new ApproxDistinctRewriteHandler());
    public static final Set<QualifiedName> SUPPORTED_FUNCTION_CALLS = Sets.union(ASSOCIATIVE_REWRITE_FUNCTIONS, NON_ASSOCIATIVE_REWRITE_FUNCTIONS.keySet());

    private MaterializedViewUtils() {
    }

    public static Session buildOwnerSession(Session session, Optional<String> owner, SessionPropertyManager sessionPropertyManager, String catalog, String schema) {
        Identity identity = MaterializedViewUtils.getOwnerIdentity(owner, session);
        return Session.builder(sessionPropertyManager).setQueryId(session.getQueryId()).setTransactionId(session.getTransactionId().orElse(null)).setIdentity(identity).setSource(session.getSource().orElse(null)).setCatalog(catalog).setSchema(schema).setTimeZoneKey(session.getTimeZoneKey()).setLocale(session.getLocale()).setRemoteUserAddress(session.getRemoteUserAddress().orElse(null)).setUserAgent(session.getUserAgent().orElse(null)).setClientInfo(session.getClientInfo().orElse(null)).setStartTime(session.getStartTime()).build();
    }

    public static Identity getOwnerIdentity(Optional<String> owner, Session session) {
        if (owner.isPresent() && !owner.get().equals(session.getIdentity().getUser())) {
            return new Identity(owner.get(), Optional.empty(), session.getIdentity().getExtraCredentials());
        }
        return session.getIdentity();
    }

    public static Map<SchemaTableName, Expression> generateBaseTablePredicates(Map<SchemaTableName, MaterializedViewStatus.MaterializedDataPredicates> predicatesFromBaseTables, Metadata metadata) {
        HashMap<SchemaTableName, Expression> baseTablePredicates = new HashMap<SchemaTableName, Expression>();
        for (SchemaTableName baseTable : predicatesFromBaseTables.keySet()) {
            MaterializedViewStatus.MaterializedDataPredicates predicatesInfo = predicatesFromBaseTables.get(baseTable);
            List partitionKeys = predicatesInfo.getColumnNames();
            ImmutableList keyExpressions = (ImmutableList)partitionKeys.stream().map(Identifier::new).collect(ImmutableList.toImmutableList());
            List predicateDisjuncts = predicatesInfo.getPredicateDisjuncts();
            BooleanLiteral disjunct = null;
            for (TupleDomain predicateDisjunct : predicateDisjuncts) {
                IsNullPredicate conjunct = null;
                Iterator keyExpressionsIterator = keyExpressions.stream().iterator();
                Map predicateKeyValue = (Map)TupleDomain.extractFixedValues((TupleDomain)predicateDisjunct).orElseThrow(() -> new IllegalStateException("predicateKeyValue is not present!"));
                for (String key : partitionKeys) {
                    IsNullPredicate expression;
                    NullableValue nullableValue = (NullableValue)predicateKeyValue.get(key);
                    if (nullableValue.isNull()) {
                        expression = new IsNullPredicate((Expression)keyExpressionsIterator.next());
                    } else {
                        LiteralEncoder literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
                        Expression valueExpression = literalEncoder.toExpression(nullableValue.getValue(), nullableValue.getType(), false);
                        expression = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)keyExpressionsIterator.next(), valueExpression);
                    }
                    conjunct = conjunct == null ? expression : new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, (Expression)conjunct, (Expression)expression);
                }
                disjunct = conjunct == null ? disjunct : (disjunct == null ? conjunct : new LogicalBinaryExpression(LogicalBinaryExpression.Operator.OR, (Expression)disjunct, conjunct));
            }
            if (disjunct == null) {
                disjunct = BooleanLiteral.FALSE_LITERAL;
            }
            baseTablePredicates.put(baseTable, (Expression)disjunct);
        }
        return baseTablePredicates;
    }

    public static Map<SchemaTableName, Expression> generateFalsePredicates(List<SchemaTableName> baseTables) {
        return (Map)baseTables.stream().collect(ImmutableMap.toImmutableMap(table -> table, table -> BooleanLiteral.FALSE_LITERAL));
    }

    public static <T> Map<T, Set<T>> transitiveClosure(Map<T, Set<T>> graph) {
        ImmutableMap.Builder closure = ImmutableMap.builder();
        for (T node : graph.keySet()) {
            HashSet visited = new HashSet();
            Stack stack = new Stack();
            stack.push(node);
            while (!stack.empty()) {
                Object current = stack.pop();
                if (visited.contains(current)) continue;
                visited.add(current);
                ((Set)graph.getOrDefault(current, (Set<T>)ImmutableSet.of())).forEach(neighbor -> stack.push(neighbor));
            }
            closure.put(node, visited);
        }
        return closure.build();
    }

    public static TupleDomain<String> getDomainFromFilter(Session session, DomainTranslator domainTranslator, RowExpression rowExpression) {
        DomainTranslator.ExtractionResult predicateFromBaseQuery = domainTranslator.fromPredicate(session.toConnectorSession(), rowExpression, (baseFilterExpression, domain) -> baseFilterExpression instanceof VariableReferenceExpression ? Optional.of(((VariableReferenceExpression)baseFilterExpression).getName()) : Optional.empty());
        return predicateFromBaseQuery.getTupleDomain();
    }

    public static Expression rewriteNonAssociativeFunction(FunctionCall functionCall, Map<Expression, Identifier> baseToViewColumnMap) {
        List expressions;
        if (!MaterializedViewUtils.validateNonAssociativeFunctionCallFields(functionCall)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)functionCall, "Nonassociative function call rewrite not supported function calls with fields other than name and arguments", new Object[0]);
        }
        QualifiedName functionName = functionCall.getName();
        if (!MaterializedViewUtils.validateNonAssociativeFunctionCallArguments(functionName, expressions = functionCall.getArguments())) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)functionCall, "Nonassociative function call rewrite not supported without single identifier as argument", new Object[0]);
        }
        Identifier baseTableColumn = (Identifier)expressions.get(0);
        return NON_ASSOCIATIVE_REWRITE_FUNCTIONS.get(functionName).rewrite(baseTableColumn, baseToViewColumnMap);
    }

    public static boolean validateNonAssociativeFunctionRewrite(FunctionCall functionCall, Map<Expression, Identifier> baseToViewColumnMap) {
        QualifiedName functionName = functionCall.getName();
        List expressions = functionCall.getArguments();
        return MaterializedViewUtils.validateNonAssociativeFunctionCallFields(functionCall) && MaterializedViewUtils.validateNonAssociativeFunctionCallArguments(functionName, expressions) && NON_ASSOCIATIVE_REWRITE_FUNCTIONS.get(functionName).validate((Identifier)functionCall.getArguments().get(0), baseToViewColumnMap);
    }

    private static boolean validateNonAssociativeFunctionCallFields(FunctionCall functionCall) {
        return !functionCall.isDistinct() && !functionCall.getWindow().isPresent() && !functionCall.getOrderBy().isPresent() && !functionCall.isIgnoreNulls() && !functionCall.getFilter().isPresent();
    }

    private static boolean validateNonAssociativeFunctionCallArguments(QualifiedName functionName, List<Expression> expressions) {
        return NON_ASSOCIATIVE_REWRITE_FUNCTIONS.containsKey(functionName) && expressions.size() == 1 && expressions.get(0) instanceof Identifier;
    }

    private static class ApproxDistinctRewriteHandler
    implements NonAssociativeFunctionHandler {
        private ApproxDistinctRewriteHandler() {
        }

        @Override
        public Expression rewrite(Identifier baseTableColumn, Map<Expression, Identifier> baseToViewColumnMap) {
            Cast cast = new Cast((Expression)new FunctionCall(APPROX_SET, (List)ImmutableList.of((Object)baseTableColumn)), "varbinary");
            if (!baseToViewColumnMap.containsKey(cast)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)baseTableColumn, "APPROX_DISTINCT rewrite not supported without approx set in base to view column map", new Object[0]);
            }
            Identifier identifier = baseToViewColumnMap.get(cast);
            Cast varbinaryToHll = new Cast((Expression)identifier, "HyperLogLog");
            FunctionCall mergedHll = new FunctionCall(MERGE, (List)ImmutableList.of((Object)varbinaryToHll));
            return new FunctionCall(CARDINALITY, (List)ImmutableList.of((Object)mergedHll));
        }

        @Override
        public boolean validate(Identifier baseTableColumn, Map<Expression, Identifier> baseToViewColumnMap) {
            return baseToViewColumnMap.containsKey(new Cast((Expression)new FunctionCall(APPROX_SET, (List)ImmutableList.of((Object)baseTableColumn)), "varbinary"));
        }
    }

    private static class AvgRewriteHandler
    implements NonAssociativeFunctionHandler {
        private AvgRewriteHandler() {
        }

        @Override
        public Expression rewrite(Identifier baseTableColumn, Map<Expression, Identifier> baseToViewColumnMap) {
            Optional<Identifier> sumDerived = this.getDerivedFromFunctionCall(SUM, baseTableColumn, baseToViewColumnMap);
            Optional<Identifier> countDerived = this.getDerivedFromFunctionCall(COUNT, baseTableColumn, baseToViewColumnMap);
            if (!sumDerived.isPresent() || !countDerived.isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)baseTableColumn, "Avg rewrite not supported without COUNT and SUM", new Object[0]);
            }
            FunctionCall sum = new FunctionCall(SUM, (List)ImmutableList.of((Object)sumDerived.get()));
            FunctionCall count = new FunctionCall(SUM, (List)ImmutableList.of((Object)countDerived.get()));
            return new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)sum, (Expression)count);
        }

        @Override
        public boolean validate(Identifier baseTableColumn, Map<Expression, Identifier> baseToViewColumnMap) {
            Optional<Identifier> sumDerived = this.getDerivedFromFunctionCall(SUM, baseTableColumn, baseToViewColumnMap);
            Optional<Identifier> countDerived = this.getDerivedFromFunctionCall(COUNT, baseTableColumn, baseToViewColumnMap);
            return sumDerived.isPresent() && countDerived.isPresent();
        }

        private Optional<Identifier> getDerivedFromFunctionCall(QualifiedName functionName, Identifier baseTableColumn, Map<Expression, Identifier> baseToViewColumnMap) {
            return Optional.ofNullable(baseToViewColumnMap.get(new FunctionCall(functionName, (List)ImmutableList.of((Object)baseTableColumn))));
        }
    }

    private static interface NonAssociativeFunctionHandler {
        public Expression rewrite(Identifier var1, Map<Expression, Identifier> var2);

        public boolean validate(Identifier var1, Map<Expression, Identifier> var2);
    }
}

