/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.eventlistener.PlanOptimizerInformation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.OptimizerRuntimeTrackUtil;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Optimizer {
    private final List<PlanOptimizer> planOptimizers;
    private final PlanChecker planChecker;
    private final Session session;
    private final Metadata metadata;
    private final VariableAllocator variableAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final WarningCollector warningCollector;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final boolean explain;

    public Optimizer(Session session, Metadata metadata, List<PlanOptimizer> planOptimizers, PlanChecker planChecker, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector, StatsCalculator statsCalculator, CostCalculator costCalculator, boolean explain) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.explain = explain;
    }

    public Plan validateAndOptimizePlan(PlanNode root, PlanStage stage) {
        this.planChecker.validateIntermediatePlan(root, this.session, this.metadata, this.warningCollector);
        boolean enableVerboseRuntimeStats = SystemSessionProperties.isVerboseRuntimeStatsEnabled(this.session);
        if (stage.ordinal() >= PlanStage.OPTIMIZED.ordinal()) {
            for (PlanOptimizer optimizer : this.planOptimizers) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_PLANNING_TIMEOUT, String.format("The query optimizer exceeded the timeout of %s.", SystemSessionProperties.getQueryAnalyzerTimeout(this.session).toString()));
                }
                long start = System.nanoTime();
                PlanOptimizerResult optimizerResult = optimizer.optimize(root, this.session, TypeProvider.viewOf(this.variableAllocator.getVariables()), this.variableAllocator, this.idAllocator, this.warningCollector);
                Objects.requireNonNull(optimizerResult, String.format("%s returned a null plan", optimizer.getClass().getName()));
                if (enableVerboseRuntimeStats || OptimizerRuntimeTrackUtil.trackOptimizerRuntime(this.session, optimizer)) {
                    this.session.getRuntimeStats().addMetricValue(String.format("optimizer%sTimeNanos", OptimizerRuntimeTrackUtil.getOptimizerNameForLog(optimizer)), RuntimeUnit.NANO, System.nanoTime() - start);
                }
                TypeProvider types = TypeProvider.viewOf(this.variableAllocator.getVariables());
                this.collectOptimizerInformation(optimizer, root, optimizerResult, types);
                root = optimizerResult.getPlanNode();
            }
        }
        if (stage.ordinal() >= PlanStage.OPTIMIZED_AND_VALIDATED.ordinal()) {
            this.planChecker.validateFinalPlan(root, this.session, this.metadata, this.warningCollector);
        }
        TypeProvider types = TypeProvider.viewOf(this.variableAllocator.getVariables());
        return new Plan(root, types, this.computeStats(root, types));
    }

    private StatsAndCosts computeStats(PlanNode root, TypeProvider types) {
        if (this.explain || SystemSessionProperties.isPrintStatsForNonJoinQuery(this.session) || PlanNodeSearcher.searchFrom(root).where(node -> node instanceof JoinNode || node instanceof SemiJoinNode).matches()) {
            CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator, this.session, types);
            CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, statsProvider, Optional.empty(), this.session);
            return StatsAndCosts.create(root, statsProvider, costProvider, this.session);
        }
        return StatsAndCosts.empty();
    }

    private void collectOptimizerInformation(PlanOptimizer optimizer, PlanNode oldNode, PlanOptimizerResult planOptimizerResult, TypeProvider types) {
        if (optimizer instanceof IterativeOptimizer) {
            return;
        }
        String optimizerName = OptimizerRuntimeTrackUtil.getOptimizerNameForLog(optimizer);
        boolean isTriggered = planOptimizerResult.isOptimizerTriggered();
        boolean isApplicable = isTriggered || !optimizer.isEnabled(this.session) && SystemSessionProperties.isVerboseOptimizerInfoEnabled(this.session) && optimizer.isApplicable(oldNode, this.session, TypeProvider.viewOf(this.variableAllocator.getVariables()), this.variableAllocator, this.idAllocator, this.warningCollector);
        boolean isCostBased = isTriggered && optimizer.isCostBased(this.session);
        String statsSource = optimizer.getStatsSource();
        if (isTriggered || isApplicable || isCostBased) {
            this.session.getOptimizerInformationCollector().addInformation(new PlanOptimizerInformation(optimizerName, isTriggered, Optional.of(isApplicable), Optional.empty(), Optional.of(isCostBased), statsSource == null ? Optional.empty() : Optional.of(statsSource)));
        }
        if (isTriggered && SystemSessionProperties.isVerboseOptimizerResults(this.session, optimizerName)) {
            String oldNodeStr = PlannerUtils.getPlanString(oldNode, this.session, types, this.metadata, false);
            String newNodeStr = PlannerUtils.getPlanString(planOptimizerResult.getPlanNode(), this.session, types, this.metadata, false);
            this.session.getOptimizerResultCollector().addOptimizerResult(optimizerName, oldNodeStr, newNodeStr);
        }
    }

    public static enum PlanStage {
        CREATED,
        OPTIMIZED,
        OPTIMIZED_AND_VALIDATED;

    }
}

