/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.analyzer.AnalyzerProvider;
import com.facebook.presto.sql.analyzer.BuiltInAnalyzerProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class AnalyzerProviderManager {
    private final Map<String, AnalyzerProvider> analyzerProviders = new HashMap<String, AnalyzerProvider>();

    @Inject
    public AnalyzerProviderManager(BuiltInAnalyzerProvider analyzerProvider) {
        this.addAnalyzerProvider(analyzerProvider);
    }

    public void addAnalyzerProvider(AnalyzerProvider analyzerProvider) {
        Objects.requireNonNull(analyzerProvider, "analyzerProvider is null");
        if (this.analyzerProviders.putIfAbsent(analyzerProvider.getType(), analyzerProvider) != null) {
            throw new IllegalArgumentException(String.format("Analyzer provider '%s' is already registered", analyzerProvider.getType()));
        }
    }

    public AnalyzerProvider getAnalyzerProvider(String analyzerType) {
        if (this.analyzerProviders.containsKey(analyzerType)) {
            return this.analyzerProviders.get(analyzerType);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_ANALYZER_TYPE, "Unsupported analyzer type: " + analyzerType);
    }
}

