/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;

public class JavaFeaturesConfig {
    private boolean topNSpillEnabled = true;
    private boolean aggregationSpillEnabled = true;
    private boolean distinctAggregationSpillEnabled = true;
    private boolean dedupBasedDistinctAggregationSpillEnabled;
    private boolean distinctAggregationLargeBlockSpillEnabled;
    private boolean orderByAggregationSpillEnabled = true;
    private boolean orderBySpillEnabled = true;
    private boolean windowSpillEnabled = true;
    private DataSize distinctAggregationLargeBlockSizeThreshold = new DataSize(50.0, DataSize.Unit.MEGABYTE);
    private DataSize topNOperatorUnspillMemoryLimit = new DataSize(4.0, DataSize.Unit.MEGABYTE);
    private DataSize aggregationOperatorUnspillMemoryLimit = new DataSize(4.0, DataSize.Unit.MEGABYTE);

    public boolean isOrderBySpillEnabled() {
        return this.orderBySpillEnabled;
    }

    @Config(value="experimental.order-by-spill-enabled")
    @ConfigDescription(value="Enable Order-by Operator Spilling if spill is enabled")
    public JavaFeaturesConfig setOrderBySpillEnabled(boolean orderBySpillEnabled) {
        this.orderBySpillEnabled = orderBySpillEnabled;
        return this;
    }

    public boolean isWindowSpillEnabled() {
        return this.windowSpillEnabled;
    }

    @Config(value="experimental.window-spill-enabled")
    @ConfigDescription(value="Enable Window Operator Spilling if spill is enabled")
    public JavaFeaturesConfig setWindowSpillEnabled(boolean windowSpillEnabled) {
        this.windowSpillEnabled = windowSpillEnabled;
        return this;
    }

    public boolean isOrderByAggregationSpillEnabled() {
        return this.orderByAggregationSpillEnabled;
    }

    @Config(value="experimental.order-by-aggregation-spill-enabled")
    @ConfigDescription(value="Spill order-by aggregations if aggregation spill is enabled")
    public JavaFeaturesConfig setOrderByAggregationSpillEnabled(boolean orderByAggregationSpillEnabled) {
        this.orderByAggregationSpillEnabled = orderByAggregationSpillEnabled;
        return this;
    }

    public DataSize getDistinctAggregationLargeBlockSizeThreshold() {
        return this.distinctAggregationLargeBlockSizeThreshold;
    }

    @Config(value="experimental.distinct-aggregation-large-block-size-threshold")
    @ConfigDescription(value="Block size threshold beyond which it will be spilled into a separate spill file")
    public JavaFeaturesConfig setDistinctAggregationLargeBlockSizeThreshold(DataSize distinctAggregationLargeBlockSizeThreshold) {
        this.distinctAggregationLargeBlockSizeThreshold = distinctAggregationLargeBlockSizeThreshold;
        return this;
    }

    public boolean isDistinctAggregationLargeBlockSpillEnabled() {
        return this.distinctAggregationLargeBlockSpillEnabled;
    }

    @Config(value="experimental.distinct-aggregation-large-block-spill-enabled")
    @ConfigDescription(value="Spill large block to a separate spill file")
    public JavaFeaturesConfig setDistinctAggregationLargeBlockSpillEnabled(boolean distinctAggregationLargeBlockSpillEnabled) {
        this.distinctAggregationLargeBlockSpillEnabled = distinctAggregationLargeBlockSpillEnabled;
        return this;
    }

    public boolean isDedupBasedDistinctAggregationSpillEnabled() {
        return this.dedupBasedDistinctAggregationSpillEnabled;
    }

    @Config(value="experimental.dedup-based-distinct-aggregation-spill-enabled")
    @ConfigDescription(value="Dedup input data for Distinct Aggregates before spilling")
    public JavaFeaturesConfig setDedupBasedDistinctAggregationSpillEnabled(boolean dedupBasedDistinctAggregationSpillEnabled) {
        this.dedupBasedDistinctAggregationSpillEnabled = dedupBasedDistinctAggregationSpillEnabled;
        return this;
    }

    public boolean isAggregationSpillEnabled() {
        return this.aggregationSpillEnabled;
    }

    @Config(value="experimental.aggregation-spill-enabled")
    @ConfigDescription(value="Spill aggregations if spill is enabled")
    public JavaFeaturesConfig setAggregationSpillEnabled(boolean aggregationSpillEnabled) {
        this.aggregationSpillEnabled = aggregationSpillEnabled;
        return this;
    }

    @Config(value="experimental.topn-spill-enabled")
    @ConfigDescription(value="Spill TopN if spill is enabled")
    public JavaFeaturesConfig setTopNSpillEnabled(boolean topNSpillEnabled) {
        this.topNSpillEnabled = topNSpillEnabled;
        return this;
    }

    public boolean isTopNSpillEnabled() {
        return this.topNSpillEnabled;
    }

    public boolean isDistinctAggregationSpillEnabled() {
        return this.distinctAggregationSpillEnabled;
    }

    @Config(value="experimental.distinct-aggregation-spill-enabled")
    @ConfigDescription(value="Spill distinct aggregations if aggregation spill is enabled")
    public JavaFeaturesConfig setDistinctAggregationSpillEnabled(boolean distinctAggregationSpillEnabled) {
        this.distinctAggregationSpillEnabled = distinctAggregationSpillEnabled;
        return this;
    }

    @Config(value="experimental.aggregation-operator-unspill-memory-limit")
    public JavaFeaturesConfig setAggregationOperatorUnspillMemoryLimit(DataSize aggregationOperatorUnspillMemoryLimit) {
        this.aggregationOperatorUnspillMemoryLimit = aggregationOperatorUnspillMemoryLimit;
        return this;
    }

    public DataSize getAggregationOperatorUnspillMemoryLimit() {
        return this.aggregationOperatorUnspillMemoryLimit;
    }

    public DataSize getTopNOperatorUnspillMemoryLimit() {
        return this.topNOperatorUnspillMemoryLimit;
    }

    @Config(value="experimental.topn-operator-unspill-memory-limit")
    public JavaFeaturesConfig setTopNOperatorUnspillMemoryLimit(DataSize aggregationOperatorUnspillMemoryLimit) {
        this.topNOperatorUnspillMemoryLimit = aggregationOperatorUnspillMemoryLimit;
        return this;
    }
}

