/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.MergeOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.TaskExchangeClientManager;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import java.util.List;
import java.util.Objects;

public class HttpRemoteSourceFactory
implements RemoteSourceFactory {
    private final BlockEncodingSerde blockEncodingSerde;
    private final TaskExchangeClientManager taskExchangeClientManager;
    private final OrderingCompiler orderingCompiler;

    public HttpRemoteSourceFactory(BlockEncodingSerde blockEncodingSerde, TaskExchangeClientManager taskExchangeClientManager, OrderingCompiler orderingCompiler) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.taskExchangeClientManager = Objects.requireNonNull(taskExchangeClientManager, "taskExchangeClientManager is null");
        this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
    }

    @Override
    public SourceOperatorFactory createRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types) {
        return new ExchangeOperator.ExchangeOperatorFactory(operatorId, planNodeId, this.taskExchangeClientManager, new PagesSerdeFactory(this.blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(session), SystemSessionProperties.isExchangeChecksumEnabled(session)));
    }

    @Override
    public SourceOperatorFactory createMergeRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
        return new MergeOperator.MergeOperatorFactory(operatorId, planNodeId, this.taskExchangeClientManager, new PagesSerdeFactory(this.blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(session), SystemSessionProperties.isExchangeChecksumEnabled(session)), this.orderingCompiler, types, outputChannels, sortChannels, sortOrder);
    }
}

