/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.GroupingOperationRewriter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.SqlPlannerContext;
import com.facebook.presto.sql.planner.SubqueryPlanner;
import com.facebook.presto.sql.planner.TranslateExpressionsUtil;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.WindowNodeUtil;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.facebook.presto.sql.planner.plan.UpdateNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Offset;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Update;
import com.facebook.presto.sql.tree.UpdateAssignment;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.IntervalYearMonthType;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;

class QueryPlanner {
    private final Analysis analysis;
    private final VariableAllocator variableAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> lambdaDeclarationToVariableMap;
    private final Metadata metadata;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;
    private final SqlPlannerContext sqlPlannerContext;
    private final SqlParser sqlParser;

    QueryPlanner(Analysis analysis, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> lambdaDeclarationToVariableMap, Metadata metadata, Session session, SqlPlannerContext sqlPlannerContext, SqlParser sqlParser) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToVariableMap, "lambdaDeclarationToVariableMap is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.analysis = analysis;
        this.variableAllocator = variableAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToVariableMap = lambdaDeclarationToVariableMap;
        this.metadata = metadata;
        this.session = session;
        this.subqueryPlanner = new SubqueryPlanner(analysis, variableAllocator, idAllocator, lambdaDeclarationToVariableMap, metadata, session, sqlParser);
        this.sqlPlannerContext = sqlPlannerContext;
        this.sqlParser = sqlParser;
    }

    public RelationPlan plan(Query query) {
        PlanBuilder builder = this.planQueryBody(query);
        List orderBy = this.analysis.getOrderByExpressions((Node)query);
        builder = this.handleSubqueries(builder, (Node)query, orderBy);
        List outputs = this.analysis.getOutputExpressions((Node)query);
        builder = this.handleSubqueries(builder, (Node)query, outputs);
        builder = this.project(builder, Iterables.concat((Iterable)orderBy, (Iterable)outputs));
        builder = this.sort(builder, query);
        builder = this.offset(builder, query.getOffset());
        builder = this.limit(builder, query);
        builder = this.project(builder, this.analysis.getOutputExpressions((Node)query));
        return new RelationPlan(builder.getRoot(), this.analysis.getScope((Node)query), QueryPlanner.computeOutputs(builder, this.analysis.getOutputExpressions((Node)query)));
    }

    public RelationPlan plan(QuerySpecification node) {
        PlanBuilder builder = this.planFrom(node);
        RelationPlan fromRelationPlan = builder.getRelationPlan();
        builder = this.filter(builder, this.analysis.getWhere(node), (Node)node);
        builder = this.aggregate(builder, node);
        builder = this.filter(builder, this.analysis.getHaving(node), (Node)node);
        builder = this.window(builder, node);
        List<Expression> outputs = this.analysis.getOutputExpressions((Node)node);
        builder = this.handleSubqueries(builder, (Node)node, (Iterable<Expression>)outputs);
        if (node.getOrderBy().isPresent()) {
            if (!this.analysis.isAggregation(node)) {
                builder = this.project(builder, (Iterable<Expression>)outputs, fromRelationPlan);
                outputs = QueryPlanner.toSymbolReferences(QueryPlanner.computeOutputs(builder, outputs));
                builder = this.planBuilderFor(builder, this.analysis.getScope((Node)node.getOrderBy().get()));
            } else {
                List orderByAggregates = this.analysis.getOrderByAggregates((OrderBy)node.getOrderBy().get());
                builder = this.project(builder, Iterables.concat(outputs, (Iterable)orderByAggregates));
                outputs = QueryPlanner.toSymbolReferences(QueryPlanner.computeOutputs(builder, outputs));
                List complexOrderByAggregatesToRemap = (List)orderByAggregates.stream().filter(expression -> !this.analysis.isColumnReference(expression)).collect(ImmutableList.toImmutableList());
                builder = this.planBuilderFor(builder, this.analysis.getScope((Node)node.getOrderBy().get()), complexOrderByAggregatesToRemap);
            }
            builder = this.window(builder, (OrderBy)node.getOrderBy().get());
        }
        List orderBy = this.analysis.getOrderByExpressions((Node)node);
        builder = this.handleSubqueries(builder, (Node)node, orderBy);
        builder = this.project(builder, Iterables.concat((Iterable)orderBy, outputs));
        builder = this.distinct(builder, node);
        builder = this.sort(builder, node);
        builder = this.offset(builder, node.getOffset());
        builder = this.limit(builder, node);
        builder = this.project(builder, outputs);
        return new RelationPlan(builder.getRoot(), this.analysis.getScope((Node)node), QueryPlanner.computeOutputs(builder, outputs));
    }

    public DeleteNode plan(Delete node) {
        RelationType descriptor = this.analysis.getOutputDescriptor((Node)node.getTable());
        TableHandle handle = this.analysis.getTableHandle(node.getTable());
        ColumnHandle rowIdHandle = this.metadata.getDeleteRowIdColumnHandle(this.session, handle);
        Type rowIdType = this.metadata.getColumnMetadata(this.session, handle, rowIdHandle).getType();
        ImmutableList.Builder outputVariablesBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Field field : descriptor.getAllFields()) {
            VariableReferenceExpression variable = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation(field.getNodeLocation()), (String)field.getName().get(), field.getType());
            outputVariablesBuilder.add((Object)variable);
            columns.put((Object)variable, (Object)this.analysis.getColumn(field));
            fields.add((Object)field);
        }
        Field rowIdField = Field.newUnqualified((Optional)node.getLocation(), Optional.empty(), (Type)rowIdType);
        VariableReferenceExpression rowIdVariable = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)node), "$rowId", rowIdField.getType());
        outputVariablesBuilder.add((Object)rowIdVariable);
        columns.put((Object)rowIdVariable, (Object)rowIdHandle);
        fields.add((Object)rowIdField);
        ImmutableList outputVariables = outputVariablesBuilder.build();
        TableScanNode tableScan = new TableScanNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), handle, (List)outputVariables, (Map)columns.build(), TupleDomain.all(), TupleDomain.all());
        Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType((List)fields.build())).build();
        RelationPlan relationPlan = new RelationPlan((PlanNode)tableScan, scope, (List<VariableReferenceExpression>)outputVariables);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToVariableMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        PlanBuilder builder = new PlanBuilder(translations, relationPlan.getRoot());
        if (node.getWhere().isPresent()) {
            builder = this.filter(builder, (Expression)node.getWhere().get(), (Node)node);
        }
        VariableReferenceExpression rowId = new VariableReferenceExpression(Optional.empty(), builder.translate((Expression)new FieldReference(relationPlan.getDescriptor().indexOf(rowIdField))).getName(), rowIdField.getType());
        ImmutableList deleteNodeOutputVariables = ImmutableList.of((Object)this.variableAllocator.newVariable("partialrows", (Type)BigintType.BIGINT), (Object)this.variableAllocator.newVariable("fragment", (Type)VarbinaryType.VARBINARY));
        return new DeleteNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), builder.getRoot(), rowId, (List<VariableReferenceExpression>)deleteNodeOutputVariables);
    }

    public UpdateNode plan(Update node) {
        RelationType descriptor = this.analysis.getOutputDescriptor((Node)node.getTable());
        TableHandle handle = this.analysis.getTableHandle(node.getTable());
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, handle);
        List updatedColumnMetadata = (List)this.analysis.getUpdatedColumns().orElseThrow(() -> new VerifyException("updated columns not set"));
        Set updatedColumnNames = (Set)updatedColumnMetadata.stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        List updatedColumns = (List)columnHandles.entrySet().stream().filter(entry -> updatedColumnNames.contains(entry.getKey())).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
        ColumnHandle rowIdHandle = this.metadata.getUpdateRowIdColumnHandle(this.session, handle, updatedColumns);
        Type rowIdType = this.metadata.getColumnMetadata(this.session, handle, rowIdHandle).getType();
        List targetColumnNames = (List)node.getAssignments().stream().map(assignment -> assignment.getName().getValue()).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder outputVariablesBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList.Builder fields = ImmutableList.builder();
        ImmutableList.Builder orderedColumnValuesBuilder = ImmutableList.builder();
        for (Field field : descriptor.getAllFields()) {
            String name = (String)field.getName().get();
            int index = targetColumnNames.indexOf(name);
            if (index < 0) continue;
            VariableReferenceExpression variable = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation(field.getNodeLocation()), (String)field.getName().get(), field.getType());
            outputVariablesBuilder.add((Object)variable);
            columns.put((Object)variable, (Object)this.analysis.getColumn(field));
            fields.add((Object)field);
            orderedColumnValuesBuilder.add((Object)((UpdateAssignment)node.getAssignments().get(index)).getValue());
        }
        ImmutableList orderedColumnValues = orderedColumnValuesBuilder.build();
        Field rowIdField = Field.newUnqualified((Optional)node.getLocation(), Optional.empty(), (Type)rowIdType);
        VariableReferenceExpression rowIdVariable = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)node), "$rowId", rowIdField.getType());
        outputVariablesBuilder.add((Object)rowIdVariable);
        columns.put((Object)rowIdVariable, (Object)rowIdHandle);
        fields.add((Object)rowIdField);
        ImmutableList outputVariables = outputVariablesBuilder.build();
        TableScanNode tableScan = new TableScanNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), handle, (List)outputVariables, (Map)columns.build(), TupleDomain.all(), TupleDomain.all());
        Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType((List)fields.build())).build();
        RelationPlan relationPlan = new RelationPlan((PlanNode)tableScan, scope, (List<VariableReferenceExpression>)outputVariables);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToVariableMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        PlanBuilder builder = new PlanBuilder(translations, relationPlan.getRoot());
        if (node.getWhere().isPresent()) {
            builder = this.filter(builder, (Expression)node.getWhere().get(), (Node)node);
        }
        builder = builder.appendProjections((Iterable<Expression>)orderedColumnValues, this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, this.sqlPlannerContext);
        PlanAndMappings planAndMappings = this.coerce(builder, (List<Expression>)orderedColumnValues, this.analysis, this.idAllocator, this.variableAllocator, this.metadata);
        builder = planAndMappings.getSubPlan();
        ImmutableList.Builder updatedColumnValuesBuilder = ImmutableList.builder();
        orderedColumnValues.forEach(columnValue -> updatedColumnValuesBuilder.add((Object)planAndMappings.get((Expression)columnValue)));
        VariableReferenceExpression rowId = new VariableReferenceExpression(Optional.empty(), builder.translate((Expression)new FieldReference(relationPlan.getDescriptor().indexOf(rowIdField))).getName(), rowIdField.getType());
        updatedColumnValuesBuilder.add((Object)rowId);
        ImmutableList outputs = ImmutableList.of((Object)this.variableAllocator.newVariable("partialrows", (Type)BigintType.BIGINT), (Object)this.variableAllocator.newVariable("fragment", (Type)VarbinaryType.VARBINARY));
        Optional<PlanNodeId> tableScanId = this.getIdForLeftTableScan(relationPlan.getRoot());
        Preconditions.checkArgument((boolean)tableScanId.isPresent(), (Object)"tableScanId not present");
        return new UpdateNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), builder.getRoot(), rowId, (List<VariableReferenceExpression>)updatedColumnValuesBuilder.build(), (List<VariableReferenceExpression>)outputs);
    }

    private Optional<PlanNodeId> getIdForLeftTableScan(PlanNode node) {
        if (node instanceof TableScanNode) {
            return Optional.of(node.getId());
        }
        List sources = node.getSources();
        if (sources.isEmpty()) {
            return Optional.empty();
        }
        return this.getIdForLeftTableScan((PlanNode)sources.get(0));
    }

    private static List<VariableReferenceExpression> computeOutputs(PlanBuilder builder, List<Expression> outputExpressions) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (Expression expression : outputExpressions) {
            outputs.add((Object)builder.translate(expression));
        }
        return outputs.build();
    }

    private PlanBuilder planQueryBody(Query query) {
        RelationPlan relationPlan = new RelationPlanner(this.analysis, this.variableAllocator, this.idAllocator, this.lambdaDeclarationToVariableMap, this.metadata, this.session, this.sqlParser).process((Node)query.getQueryBody(), this.sqlPlannerContext);
        return this.planBuilderFor(relationPlan);
    }

    private PlanBuilder planFrom(QuerySpecification node) {
        RelationPlan relationPlan = node.getFrom().isPresent() ? new RelationPlanner(this.analysis, this.variableAllocator, this.idAllocator, this.lambdaDeclarationToVariableMap, this.metadata, this.session, this.sqlParser).process((Node)node.getFrom().get(), this.sqlPlannerContext) : this.planImplicitTable();
        return this.planBuilderFor(relationPlan);
    }

    private PlanBuilder planBuilderFor(PlanBuilder builder, Scope scope, Iterable<? extends Expression> expressionsToRemap) {
        PlanBuilder newBuilder = this.planBuilderFor(builder, scope);
        Streams.stream(expressionsToRemap).forEach(expression -> newBuilder.getTranslations().put((Expression)expression, builder.translate((Expression)expression)));
        return newBuilder;
    }

    private PlanBuilder planBuilderFor(PlanBuilder builder, Scope scope) {
        return this.planBuilderFor(new RelationPlan(builder.getRoot(), scope, builder.getRoot().getOutputVariables()));
    }

    private PlanBuilder planBuilderFor(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToVariableMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        return new PlanBuilder(translations, relationPlan.getRoot());
    }

    private RelationPlan planImplicitTable() {
        Scope scope = Scope.create();
        return new RelationPlan((PlanNode)new ValuesNode(Optional.empty(), this.idAllocator.getNextId(), (List)ImmutableList.of(), (List)ImmutableList.of((Object)ImmutableList.of()), Optional.empty()), scope, (List<VariableReferenceExpression>)ImmutableList.of());
    }

    private PlanBuilder filter(PlanBuilder subPlan, Expression predicate, Node node) {
        if (predicate == null) {
            return subPlan;
        }
        Expression rewrittenBeforeSubqueries = subPlan.rewrite(predicate);
        subPlan = this.subqueryPlanner.handleSubqueries(subPlan, rewrittenBeforeSubqueries, node, this.sqlPlannerContext);
        Expression rewrittenAfterSubqueries = subPlan.rewrite(predicate);
        return subPlan.withNewRoot((PlanNode)new FilterNode(ExpressionTreeUtils.getSourceLocation(node), this.idAllocator.getNextId(), subPlan.getRoot(), this.rowExpression(rewrittenAfterSubqueries, this.sqlPlannerContext)));
    }

    private PlanBuilder project(PlanBuilder subPlan, Iterable<Expression> expressions, RelationPlan parentRelationPlan) {
        return this.project(subPlan, Iterables.concat(expressions, QueryPlanner.toSymbolReferences(parentRelationPlan.getFieldMappings())));
    }

    private PlanBuilder project(PlanBuilder subPlan, Iterable<Expression> expressions) {
        TranslationMap outputTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToVariableMap);
        Assignments.Builder projections = Assignments.builder();
        for (Expression expression : expressions) {
            VariableReferenceExpression variable;
            if (expression instanceof SymbolReference) {
                variable = PlannerUtils.toVariableReference(this.variableAllocator, expression);
                projections.put(variable, this.rowExpression(expression, this.sqlPlannerContext));
                outputTranslations.put(expression, variable);
                continue;
            }
            variable = PlannerUtils.newVariable(this.variableAllocator, expression, this.analysis.getTypeWithCoercions(expression));
            projections.put(variable, this.rowExpression(subPlan.rewrite(expression), this.sqlPlannerContext));
            outputTranslations.put(expression, variable);
        }
        return new PlanBuilder(outputTranslations, (PlanNode)new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), projections.build()));
    }

    private PlanAndMappings coerce(PlanBuilder subPlan, List<Expression> expressions, Analysis analysis, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, Metadata metadata) {
        Assignments.Builder assignments = Assignments.builder();
        assignments.putAll((Map)subPlan.getRoot().getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), java.util.function.Function.identity())));
        ImmutableMap.Builder mappings = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Type coercion = analysis.getCoercion(expression);
            if (coercion != null) {
                Type type = analysis.getType(expression);
                VariableReferenceExpression variable = PlannerUtils.newVariable(variableAllocator, expression, coercion);
                assignments.put(variable, this.rowExpression((Expression)new Cast(subPlan.rewrite(expression), coercion.getTypeSignature().toString(), false, metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(type, coercion)), this.sqlPlannerContext));
                mappings.put((Object)NodeRef.of((Node)expression), (Object)variable);
                continue;
            }
            mappings.put((Object)NodeRef.of((Node)expression), (Object)subPlan.translate(expression));
        }
        subPlan = subPlan.withNewRoot((PlanNode)new ProjectNode(idAllocator.getNextId(), subPlan.getRoot(), assignments.build()));
        return new PlanAndMappings(subPlan, (Map<NodeRef<Expression>, VariableReferenceExpression>)mappings.build());
    }

    private Map<VariableReferenceExpression, RowExpression> coerce(Iterable<? extends Expression> expressions, PlanBuilder subPlan, TranslationMap translations) {
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Type type = this.analysis.getType(expression);
            Type coercion = this.analysis.getCoercion(expression);
            VariableReferenceExpression variable = PlannerUtils.newVariable(this.variableAllocator, expression, (Type)MoreObjects.firstNonNull((Object)coercion, (Object)type));
            Expression rewritten = subPlan.rewrite(expression);
            if (coercion != null) {
                rewritten = new Cast(rewritten, coercion.getTypeSignature().toString(), false, this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(type, coercion));
            }
            projections.put((Object)variable, (Object)this.rowExpression(rewritten, this.sqlPlannerContext));
            translations.put(expression, variable);
        }
        return projections.build();
    }

    private PlanBuilder explicitCoercionFields(PlanBuilder subPlan, Iterable<Expression> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToVariableMap);
        Assignments.Builder projections = Assignments.builder();
        projections.putAll(this.coerce(uncoerced, subPlan, translations));
        for (Expression expression : alreadyCoerced) {
            if (expression instanceof SymbolReference) {
                projections.put(PlannerUtils.toVariableReference(this.variableAllocator, expression), this.rowExpression(expression, this.sqlPlannerContext));
                continue;
            }
            VariableReferenceExpression variable = PlannerUtils.newVariable(this.variableAllocator, expression, this.analysis.getType(expression));
            Expression rewritten = subPlan.rewrite(expression);
            projections.put(variable, this.rowExpression(rewritten, this.sqlPlannerContext));
            translations.put(expression, variable);
        }
        return new PlanBuilder(translations, (PlanNode)new ProjectNode(subPlan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), subPlan.getRoot(), projections.build(), ProjectNode.Locality.LOCAL));
    }

    private PlanBuilder explicitCoercionVariables(PlanBuilder subPlan, List<VariableReferenceExpression> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = subPlan.copyTranslations();
        Assignments assignments = Assignments.builder().putAll(this.coerce(uncoerced, subPlan, translations)).putAll((Map)alreadyCoerced.stream().collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), java.util.function.Function.identity()))).build();
        return new PlanBuilder(translations, (PlanNode)new ProjectNode(subPlan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), subPlan.getRoot(), assignments, ProjectNode.Locality.LOCAL));
    }

    private PlanBuilder aggregate(PlanBuilder subPlan, QuerySpecification node) {
        if (!this.analysis.isAggregation(node)) {
            return subPlan;
        }
        ImmutableSet groupByExpressions = ImmutableSet.copyOf((Collection)this.analysis.getGroupByExpressions(node));
        ImmutableList.Builder arguments = ImmutableList.builder();
        this.analysis.getAggregates(node).stream().map(FunctionCall::getArguments).flatMap(Collection::stream).filter(exp -> !(exp instanceof LambdaExpression)).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        this.analysis.getAggregates(node).stream().map(FunctionCall::getOrderBy).filter(Optional::isPresent).map(Optional::get).map(OrderBy::getSortItems).flatMap(Collection::stream).map(SortItem::getSortKey).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        this.analysis.getAggregates(node).stream().map(FunctionCall::getFilter).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        Iterable inputs = Iterables.concat((Iterable)groupByExpressions, (Iterable)arguments.build());
        subPlan = this.handleSubqueries(subPlan, (Node)node, inputs);
        if (!Iterables.isEmpty((Iterable)inputs)) {
            subPlan = this.project(subPlan, inputs);
        }
        TranslationMap argumentTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToVariableMap);
        ImmutableList.Builder aggregationArgumentsBuilder = ImmutableList.builder();
        for (Expression argument : arguments.build()) {
            VariableReferenceExpression variable = subPlan.translate(argument);
            argumentTranslations.put(argument, variable);
            aggregationArgumentsBuilder.add((Object)variable);
        }
        ImmutableList aggregationArguments = aggregationArgumentsBuilder.build();
        TranslationMap groupingTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToVariableMap);
        LinkedHashMap<VariableReferenceExpression, VariableReferenceExpression> groupingSetMappings = new LinkedHashMap<VariableReferenceExpression, VariableReferenceExpression>();
        for (Expression expression2 : groupByExpressions) {
            VariableReferenceExpression input = subPlan.translate(expression2);
            VariableReferenceExpression output = PlannerUtils.newVariable(this.variableAllocator, expression2, this.analysis.getTypeWithCoercions(expression2), "gid");
            groupingTranslations.put(expression2, output);
            groupingSetMappings.put(output, input);
        }
        Object columnOnlyGroupingSets = ImmutableList.of((Object)ImmutableSet.of());
        ImmutableList groupingSets = ImmutableList.of((Object)ImmutableList.of());
        if (node.getGroupBy().isPresent()) {
            Analysis.GroupingSetAnalysis groupingSetAnalysis = this.analysis.getGroupingSets(node);
            columnOnlyGroupingSets = this.enumerateGroupingSets(groupingSetAnalysis);
            if (((GroupBy)node.getGroupBy().get()).isDistinct()) {
                columnOnlyGroupingSets = (List)columnOnlyGroupingSets.stream().distinct().collect(ImmutableList.toImmutableList());
            }
            ImmutableList.Builder groupingSetBuilder = ImmutableList.builder();
            Iterator iterator = columnOnlyGroupingSets.iterator();
            while (iterator.hasNext()) {
                Set groupingSet = (Set)iterator.next();
                ImmutableList.Builder columns = ImmutableList.builder();
                groupingSetAnalysis.getComplexExpressions().stream().map(groupingTranslations::get).forEach(arg_0 -> ((ImmutableList.Builder)columns).add(arg_0));
                groupingSet.stream().map(field -> groupingTranslations.get((Expression)new FieldReference(field.getFieldIndex()))).forEach(arg_0 -> ((ImmutableList.Builder)columns).add(arg_0));
                groupingSetBuilder.add((Object)columns.build());
            }
            groupingSets = groupingSetBuilder.build();
        }
        Optional<Object> groupIdVariable = Optional.empty();
        if (groupingSets.size() > 1) {
            groupIdVariable = Optional.of(this.variableAllocator.newVariable("groupId", (Type)BigintType.BIGINT));
            GroupIdNode groupId = new GroupIdNode(subPlan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), subPlan.getRoot(), (List<List<VariableReferenceExpression>>)groupingSets, groupingSetMappings, (List<VariableReferenceExpression>)aggregationArguments, (VariableReferenceExpression)groupIdVariable.get());
            subPlan = new PlanBuilder(groupingTranslations, groupId);
        } else {
            Assignments.Builder assignments = Assignments.builder();
            aggregationArguments.stream().forEach(var -> assignments.put(var, (RowExpression)var));
            groupingSetMappings.forEach((key, value) -> assignments.put(key, (RowExpression)value));
            ProjectNode project = new ProjectNode(subPlan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), subPlan.getRoot(), assignments.build(), ProjectNode.Locality.LOCAL);
            subPlan = new PlanBuilder(groupingTranslations, (PlanNode)project);
        }
        TranslationMap aggregationTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToVariableMap);
        aggregationTranslations.copyMappingsFrom(groupingTranslations);
        ImmutableMap.Builder aggregationsBuilder = ImmutableMap.builder();
        boolean needPostProjectionCoercion = false;
        for (FunctionCall aggregate : this.analysis.getAggregates(node)) {
            Expression rewritten = argumentTranslations.rewrite((Expression)aggregate);
            VariableReferenceExpression newVariable = PlannerUtils.newVariable(this.variableAllocator, rewritten, this.analysis.getType((Expression)aggregate));
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
                needPostProjectionCoercion = true;
            }
            aggregationTranslations.put((Expression)aggregate, newVariable);
            FunctionCall rewrittenFunction = (FunctionCall)rewritten;
            FunctionHandle functionHandle = this.analysis.getFunctionHandle(aggregate);
            aggregationsBuilder.put((Object)newVariable, (Object)new AggregationNode.Aggregation(new CallExpression(ExpressionTreeUtils.getSourceLocation((Node)rewrittenFunction), aggregate.getName().getSuffix(), functionHandle, this.analysis.getType((Expression)aggregate), this.callArgumentsToRowExpression(functionHandle, rewrittenFunction.getArguments())), rewrittenFunction.getFilter().map(expression -> this.rowExpression((Expression)expression, this.sqlPlannerContext)), rewrittenFunction.getOrderBy().map(orderBy -> PlannerUtils.toOrderingScheme(orderBy, TypeProvider.viewOf(this.variableAllocator.getVariables()))), rewrittenFunction.isDistinct(), Optional.empty()));
        }
        ImmutableMap aggregations = aggregationsBuilder.build();
        ImmutableSet.Builder globalGroupingSets = ImmutableSet.builder();
        for (int i = 0; i < groupingSets.size(); ++i) {
            if (!((List)groupingSets.get(i)).isEmpty()) continue;
            globalGroupingSets.add((Object)i);
        }
        ImmutableList.Builder groupingKeys = ImmutableList.builder();
        groupingSets.stream().flatMap(Collection::stream).distinct().forEach(arg_0 -> ((ImmutableList.Builder)groupingKeys).add(arg_0));
        groupIdVariable.ifPresent(arg_0 -> ((ImmutableList.Builder)groupingKeys).add(arg_0));
        AggregationNode aggregationNode = new AggregationNode(subPlan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), subPlan.getRoot(), (Map)aggregations, AggregationNode.groupingSets((List)groupingKeys.build(), (int)groupingSets.size(), (Set)globalGroupingSets.build()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), groupIdVariable, Optional.empty());
        subPlan = new PlanBuilder(aggregationTranslations, (PlanNode)aggregationNode);
        if (needPostProjectionCoercion) {
            ImmutableList.Builder alreadyCoerced = ImmutableList.builder();
            alreadyCoerced.addAll((Iterable)groupByExpressions);
            groupIdVariable.map(ExpressionTreeUtils::createSymbolReference).ifPresent(arg_0 -> ((ImmutableList.Builder)alreadyCoerced).add(arg_0));
            subPlan = this.explicitCoercionFields(subPlan, (Iterable<Expression>)alreadyCoerced.build(), this.analysis.getAggregates(node));
        }
        return this.handleGroupingOperations(subPlan, node, groupIdVariable, (List<Set<FieldId>>)columnOnlyGroupingSets);
    }

    private List<Set<FieldId>> enumerateGroupingSets(Analysis.GroupingSetAnalysis groupingSetAnalysis) {
        ArrayList<Object> partialSets = new ArrayList<Object>();
        for (Set cube : groupingSetAnalysis.getCubes()) {
            partialSets.add(ImmutableList.copyOf((Collection)Sets.powerSet((Set)cube)));
        }
        for (List rollup : groupingSetAnalysis.getRollups()) {
            List sets = (List)IntStream.rangeClosed(0, rollup.size()).mapToObj(i -> ImmutableSet.copyOf(rollup.subList(0, i))).collect(ImmutableList.toImmutableList());
            partialSets.add(sets);
        }
        partialSets.addAll(groupingSetAnalysis.getOrdinarySets());
        if (partialSets.isEmpty()) {
            return ImmutableList.of((Object)ImmutableSet.of());
        }
        ArrayList<Set<FieldId>> allSets = new ArrayList<Set<FieldId>>();
        ((List)partialSets.get(0)).stream().map(ImmutableSet::copyOf).forEach(allSets::add);
        for (int i2 = 1; i2 < partialSets.size(); ++i2) {
            List groupingSets = (List)partialSets.get(i2);
            ImmutableList oldGroupingSetsCrossProduct = ImmutableList.copyOf(allSets);
            allSets.clear();
            for (Set existingSet : oldGroupingSetsCrossProduct) {
                for (Set groupingSet : groupingSets) {
                    ImmutableSet concatenatedSet = ImmutableSet.builder().addAll((Iterable)existingSet).addAll((Iterable)groupingSet).build();
                    allSets.add((Set<FieldId>)concatenatedSet);
                }
            }
        }
        return allSets;
    }

    private PlanBuilder handleGroupingOperations(PlanBuilder subPlan, QuerySpecification node, Optional<VariableReferenceExpression> groupIdVariable, List<Set<FieldId>> groupingSets) {
        if (this.analysis.getGroupingOperations(node).isEmpty()) {
            return subPlan;
        }
        TranslationMap newTranslations = subPlan.copyTranslations();
        Assignments.Builder projections = Assignments.builder();
        projections.putAll((Map)subPlan.getRoot().getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), java.util.function.Function.identity())));
        List descriptor = (List)groupingSets.stream().map(set -> (ImmutableSet)set.stream().map(FieldId::getFieldIndex).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
        for (GroupingOperation groupingOperation : this.analysis.getGroupingOperations(node)) {
            Expression rewritten = GroupingOperationRewriter.rewriteGroupingOperation(groupingOperation, descriptor, (Multimap<NodeRef<Expression>, FieldId>)this.analysis.getColumnReferenceFields(), groupIdVariable);
            Type coercion = this.analysis.getCoercion((Expression)groupingOperation);
            VariableReferenceExpression variable = PlannerUtils.newVariable(this.variableAllocator, rewritten, this.analysis.getTypeWithCoercions((Expression)groupingOperation));
            if (coercion != null) {
                rewritten = new Cast(rewritten, coercion.getTypeSignature().toString(), false, this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(this.analysis.getType((Expression)groupingOperation), coercion));
            }
            projections.put(variable, this.rowExpression(rewritten, this.sqlPlannerContext));
            newTranslations.put((Expression)groupingOperation, variable);
        }
        return new PlanBuilder(newTranslations, (PlanNode)new ProjectNode(subPlan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), subPlan.getRoot(), projections.build(), ProjectNode.Locality.LOCAL));
    }

    private PlanBuilder window(PlanBuilder subPlan, OrderBy node) {
        return this.window(subPlan, (List<FunctionCall>)ImmutableList.copyOf((Collection)this.analysis.getOrderByWindowFunctions(node)));
    }

    private PlanBuilder window(PlanBuilder subPlan, QuerySpecification node) {
        return this.window(subPlan, (List<FunctionCall>)ImmutableList.copyOf((Collection)this.analysis.getWindowFunctions(node)));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private PlanBuilder window(PlanBuilder subPlan, List<FunctionCall> windowFunctions) {
        if (windowFunctions.isEmpty()) {
            return subPlan;
        }
        for (FunctionCall windowFunction : windowFunctions) {
            block15: {
                block14: {
                    window = (Window)windowFunction.getWindow().get();
                    frameType = WindowFrame.Type.RANGE;
                    frameStartType = FrameBound.Type.UNBOUNDED_PRECEDING;
                    frameEndType = FrameBound.Type.CURRENT_ROW;
                    startValue = Optional.empty();
                    endValue = Optional.empty();
                    if (window.getFrame().isPresent()) {
                        frame = (WindowFrame)window.getFrame().get();
                        frameType = frame.getType();
                        frameStartType = frame.getStart().getType();
                        startValue = frame.getStart().getValue();
                        if (frame.getEnd().isPresent()) {
                            frameEndType = ((FrameBound)frame.getEnd().get()).getType();
                            endValue = ((FrameBound)frame.getEnd().get()).getValue();
                        }
                    }
                    inputsBuilder = ImmutableList.builder().addAll((Iterable)windowFunction.getArguments()).addAll((Iterable)window.getPartitionBy()).addAll(Iterables.transform(NodeUtils.getSortItemsFromOrderBy(window.getOrderBy()), (Function)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSortKey(), (Lcom/facebook/presto/sql/tree/SortItem;)Lcom/facebook/presto/sql/tree/Expression;)()));
                    if (startValue.isPresent()) {
                        inputsBuilder.add(startValue.get());
                    }
                    if (endValue.isPresent()) {
                        inputsBuilder.add(endValue.get());
                    }
                    inputs = inputsBuilder.build();
                    subPlan = subPlan.appendProjections((Iterable<Expression>)inputs, this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, this.sqlPlannerContext);
                    coercions = this.coerce(subPlan, (List<Expression>)inputs, this.analysis, this.idAllocator, this.variableAllocator, this.metadata);
                    subPlan = coercions.getSubPlan();
                    frameStart = Optional.empty();
                    frameEnd /* !! */  = Optional.empty();
                    sortKeyCoercedForFrameStartComparison = Optional.empty();
                    sortKeyCoercedForFrameEndComparison /* !! */  = Optional.empty();
                    if (!window.getFrame().isPresent() || ((WindowFrame)window.getFrame().get()).getType() != WindowFrame.Type.RANGE) break block14;
                    sortKeyCoercions = new HashMap<Type, VariableReferenceExpression>();
                    plan = this.planFrameBound(subPlan, coercions, startValue, window, sortKeyCoercions);
                    subPlan = plan.getSubPlan();
                    frameStart = plan.getFrameBoundSymbol();
                    sortKeyCoercedForFrameStartComparison = plan.getSortKeyCoercedForFrameBoundComparison();
                    plan = this.planFrameBound(subPlan, coercions, endValue, window, sortKeyCoercions);
                    subPlan = plan.getSubPlan();
                    frameEnd /* !! */  = plan.getFrameBoundSymbol();
                    sortKeyCoercedForFrameEndComparison /* !! */  = plan.getSortKeyCoercedForFrameBoundComparison();
                    break block15;
                }
                if (!window.getFrame().isPresent()) ** GOTO lbl-1000
                if (((WindowFrame)window.getFrame().get()).getType() == WindowFrame.Type.ROWS) ** GOTO lbl51
                if (((WindowFrame)window.getFrame().get()).getType() == WindowFrame.Type.GROUPS) {
lbl51:
                    // 2 sources

                    frameStart = ((WindowFrame)window.getFrame().get()).getStart().getValue().map((java.util.function.Function<Expression, VariableReferenceExpression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(com.facebook.presto.sql.tree.Expression ), (Lcom/facebook/presto/sql/tree/Expression;)Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)((PlanAndMappings)coercions));
                    frameEnd /* !! */  = ((WindowFrame)window.getFrame().get()).getEnd().flatMap((java.util.function.Function<FrameBound, Optional>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Lcom/facebook/presto/sql/tree/FrameBound;)Ljava/util/Optional;)()).map((java.util.function.Function<Expression, VariableReferenceExpression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(com.facebook.presto.sql.tree.Expression ), (Lcom/facebook/presto/sql/tree/Expression;)Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)((PlanAndMappings)coercions));
                } else if (window.getFrame().isPresent()) {
                    throw new IllegalArgumentException("unexpected window frame type: " + ((WindowFrame)window.getFrame().get()).getType());
                }
            }
            partitionByVariables = ImmutableList.builder();
            for (Object expression : window.getPartitionBy()) {
                partitionByVariables.add((Object)subPlan.translateToVariable((Expression)expression));
            }
            orderings = new LinkedHashMap<VariableReferenceExpression, SortOrder>();
            expression = NodeUtils.getSortItemsFromOrderBy(window.getOrderBy()).iterator();
            while (expression.hasNext()) {
                item = (SortItem)expression.next();
                variable = subPlan.translateToVariable(item.getSortKey());
                orderings.putIfAbsent(variable, PlannerUtils.toSortOrder(item));
            }
            frame = new WindowNode.Frame(WindowNodeUtil.toWindowType(frameType), WindowNodeUtil.toBoundType(frameStartType), frameStart, sortKeyCoercedForFrameStartComparison, WindowNodeUtil.toBoundType(frameEndType), frameEnd /* !! */ , sortKeyCoercedForFrameEndComparison /* !! */ , startValue.map((java.util.function.Function<Expression, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcom/facebook/presto/sql/tree/Expression;)Ljava/lang/String;)()), endValue.map((java.util.function.Function<Expression, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcom/facebook/presto/sql/tree/Expression;)Ljava/lang/String;)()));
            outputTranslations = subPlan.copyTranslations();
            rewritten = subPlan.rewrite((Expression)windowFunction);
            needCoercion = rewritten instanceof Cast;
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
            }
            if (rewritten instanceof SymbolReference) {
                if (!needCoercion) continue;
                subPlan = this.explicitCoercionVariables(subPlan, subPlan.getRoot().getOutputVariables(), (Iterable<? extends Expression>)ImmutableList.of((Object)windowFunction));
                continue;
            }
            returnType = this.analysis.getType((Expression)windowFunction);
            newVariable = PlannerUtils.newVariable(this.variableAllocator, rewritten, returnType);
            outputTranslations.put((Expression)windowFunction, newVariable);
            functionHandle = this.analysis.getFunctionHandle(windowFunction);
            function = new WindowNode.Function(Expressions.call(windowFunction.getName().toString(), functionHandle, returnType, this.callArgumentsToRowExpression(functionHandle, ((FunctionCall)rewritten).getArguments())), frame, windowFunction.isIgnoreNulls());
            orderByVariables = ImmutableList.builder();
            orderByVariables.addAll(orderings.keySet());
            orderingScheme = Optional.empty();
            if (!orderings.isEmpty()) {
                orderingScheme = Optional.of(new OrderingScheme((List)orderByVariables.build().stream().map((java.util.function.Function<VariableReferenceExpression, Ordering>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$window$14(java.util.LinkedHashMap com.facebook.presto.spi.relation.VariableReferenceExpression ), (Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)Lcom/facebook/presto/spi/plan/Ordering;)(orderings)).collect(ImmutableList.toImmutableList())));
            }
            subPlan = new PlanBuilder(outputTranslations, new WindowNode(subPlan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), subPlan.getRoot(), new WindowNode.Specification((List<VariableReferenceExpression>)partitionByVariables.build(), orderingScheme), (Map<VariableReferenceExpression, WindowNode.Function>)ImmutableMap.of((Object)newVariable, (Object)function), Optional.empty(), (Set<VariableReferenceExpression>)ImmutableSet.of(), 0));
            if (!needCoercion) continue;
            subPlan = this.explicitCoercionVariables(subPlan, subPlan.getRoot().getOutputVariables(), (Iterable<? extends Expression>)ImmutableList.of((Object)windowFunction));
        }
        return subPlan;
    }

    private FrameBoundPlanAndSymbols planFrameBound(PlanBuilder subPlan, PlanAndMappings coercions, Optional<Expression> frameOffset, Window window, Map<Type, VariableReferenceExpression> sortKeyCoercions) {
        Optional<FunctionHandle> frameBoundCalculationFunction = frameOffset.map(arg_0 -> ((Analysis)this.analysis).getFrameBoundCalculation(arg_0));
        if (!frameBoundCalculationFunction.isPresent()) {
            return new FrameBoundPlanAndSymbols(subPlan, Optional.empty(), Optional.empty());
        }
        VariableReferenceExpression offsetSymbol = coercions.get(frameOffset.get());
        Expression zeroOffset = this.zeroOfType(TypeProvider.viewOf(this.variableAllocator.getVariables()).get(offsetSymbol));
        FunctionHandle fail = this.metadata.getFunctionAndTypeManager().resolveFunction(Optional.empty(), Optional.empty(), QualifiedObjectName.valueOf((String)"presto.default.fail"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
        IfExpression predicate = new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference(offsetSymbol.getName()), zeroOffset), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"presto", (String[])new String[]{"default", "fail"}), (List)ImmutableList.of((Object)new Cast((Expression)new StringLiteral("Window frame offset value must not be negative or null"), VarcharType.VARCHAR.getTypeSignature().toString()))), BooleanType.BOOLEAN.getTypeSignature().toString()));
        subPlan = subPlan.withNewRoot((PlanNode)new FilterNode(ExpressionTreeUtils.getSourceLocation((Node)window), this.idAllocator.getNextId(), subPlan.getRoot(), this.rowExpression((Expression)predicate, this.sqlPlannerContext)));
        Expression sortKey = ((SortItem)Iterables.getOnlyElement((Iterable)((OrderBy)window.getOrderBy().get()).getSortItems())).getSortKey();
        VariableReferenceExpression sortKeyCoercedForFrameBoundCalculation = coercions.get(sortKey);
        Optional<Type> coercion = frameOffset.map(arg_0 -> ((Analysis)this.analysis).getSortKeyCoercionForFrameBoundCalculation(arg_0));
        if (coercion.isPresent()) {
            Type expectedType = coercion.get();
            VariableReferenceExpression alreadyCoerced = sortKeyCoercions.get(expectedType);
            if (alreadyCoerced != null) {
                sortKeyCoercedForFrameBoundCalculation = alreadyCoerced;
            } else {
                Cast cast = new Cast((Expression)new SymbolReference(coercions.get(sortKey).getName()), expectedType.getTypeSignature().toString(), false, this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(this.analysis.getType(sortKey), expectedType));
                sortKeyCoercedForFrameBoundCalculation = PlannerUtils.newVariable(this.variableAllocator, (Expression)cast, expectedType);
                sortKeyCoercions.put(expectedType, sortKeyCoercedForFrameBoundCalculation);
                subPlan = subPlan.withNewRoot((PlanNode)new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), Assignments.builder().putAll((Map)subPlan.getRoot().getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), java.util.function.Function.identity()))).put(sortKeyCoercedForFrameBoundCalculation, this.rowExpression((Expression)cast, this.sqlPlannerContext)).build()));
            }
        }
        FunctionHandle function = frameBoundCalculationFunction.get();
        FunctionMetadata functionMetadata = this.metadata.getFunctionAndTypeManager().getFunctionMetadata(function);
        QualifiedObjectName name = functionMetadata.getName();
        FunctionCall functionCall = new FunctionCall(QualifiedName.of((String)name.getCatalogName(), (String[])new String[]{name.getSchemaName(), name.getObjectName()}), (List)ImmutableList.of((Object)new SymbolReference(sortKeyCoercedForFrameBoundCalculation.getName()), (Object)new SymbolReference(offsetSymbol.getName())));
        VariableReferenceExpression frameBoundVariable = PlannerUtils.newVariable(this.variableAllocator, (Expression)functionCall, this.metadata.getFunctionAndTypeManager().getType(functionMetadata.getReturnType()));
        subPlan = subPlan.withNewRoot((PlanNode)new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), Assignments.builder().putAll((Map)subPlan.getRoot().getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), java.util.function.Function.identity()))).put(frameBoundVariable, this.rowExpression((Expression)functionCall, this.sqlPlannerContext)).build()));
        Optional<VariableReferenceExpression> sortKeyCoercedForFrameBoundComparison = Optional.of(coercions.get(sortKey));
        coercion = frameOffset.map(arg_0 -> ((Analysis)this.analysis).getSortKeyCoercionForFrameBoundComparison(arg_0));
        if (coercion.isPresent()) {
            Type expectedType = coercion.get();
            VariableReferenceExpression alreadyCoerced = sortKeyCoercions.get(expectedType);
            if (alreadyCoerced != null) {
                sortKeyCoercedForFrameBoundComparison = Optional.of(alreadyCoerced);
            } else {
                Cast cast = new Cast((Expression)new SymbolReference(coercions.get(sortKey).getName()), expectedType.getTypeSignature().toString(), false, this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(this.analysis.getType(sortKey), expectedType));
                VariableReferenceExpression castSymbol = PlannerUtils.newVariable(this.variableAllocator, (Expression)cast, expectedType);
                sortKeyCoercions.put(expectedType, castSymbol);
                subPlan = subPlan.withNewRoot((PlanNode)new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), Assignments.builder().putAll((Map)subPlan.getRoot().getOutputVariables().stream().collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), java.util.function.Function.identity()))).put(castSymbol, this.rowExpression((Expression)cast, this.sqlPlannerContext)).build()));
                sortKeyCoercedForFrameBoundComparison = Optional.of(castSymbol);
            }
        }
        return new FrameBoundPlanAndSymbols(subPlan, Optional.of(frameBoundVariable), sortKeyCoercedForFrameBoundComparison);
    }

    private Expression zeroOfType(Type type) {
        if (ExpressionAnalyzer.isNumericType(type)) {
            return new Cast((Expression)new LongLiteral("0"), type.getTypeSignature().toString());
        }
        if (type.equals((Object)IntervalDayTimeType.INTERVAL_DAY_TIME)) {
            return new IntervalLiteral("0", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY);
        }
        if (type.equals((Object)IntervalYearMonthType.INTERVAL_YEAR_MONTH)) {
            return new IntervalLiteral("0", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.YEAR);
        }
        throw new IllegalArgumentException("unexpected type: " + type);
    }

    private PlanBuilder handleSubqueries(PlanBuilder subPlan, Node node, Iterable<Expression> inputs) {
        for (Expression input : inputs) {
            subPlan = this.subqueryPlanner.handleSubqueries(subPlan, subPlan.rewrite(input), node, this.sqlPlannerContext);
        }
        return subPlan;
    }

    private PlanBuilder distinct(PlanBuilder subPlan, QuerySpecification node) {
        if (node.getSelect().isDistinct()) {
            return subPlan.withNewRoot((PlanNode)new AggregationNode(ExpressionTreeUtils.getSourceLocation((Node)node), this.idAllocator.getNextId(), subPlan.getRoot(), (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)subPlan.getRoot().getOutputVariables()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty()));
        }
        return subPlan;
    }

    private PlanBuilder sort(PlanBuilder subPlan, Query node) {
        return this.sort(subPlan, node.getOrderBy(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, QuerySpecification node) {
        return this.sort(subPlan, node.getOrderBy(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, Optional<OrderBy> orderBy, List<Expression> orderByExpressions) {
        if (!orderBy.isPresent() || SystemSessionProperties.isSkipRedundantSort(this.session) && this.analysis.isOrderByRedundant(orderBy.get())) {
            return subPlan;
        }
        OrderingScheme orderingScheme = PlannerUtils.toOrderingScheme((List)orderByExpressions.stream().map(subPlan::translate).collect(ImmutableList.toImmutableList()), (List)orderBy.get().getSortItems().stream().map(PlannerUtils::toSortOrder).collect(ImmutableList.toImmutableList()));
        SortNode planNode = new SortNode(ExpressionTreeUtils.getSourceLocation((Node)orderBy.get()), this.idAllocator.getNextId(), subPlan.getRoot(), orderingScheme, false);
        return subPlan.withNewRoot((PlanNode)planNode);
    }

    private PlanBuilder offset(PlanBuilder subPlan, Optional<Offset> offset) {
        if (!offset.isPresent()) {
            return subPlan;
        }
        return subPlan.withNewRoot(new OffsetNode(ExpressionTreeUtils.getSourceLocation((Node)offset.get()), this.idAllocator.getNextId(), subPlan.getRoot(), this.analysis.getOffset(offset.get())));
    }

    private PlanBuilder limit(PlanBuilder subPlan, Query node) {
        return this.limit(subPlan, node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, QuerySpecification node) {
        return this.limit(subPlan, node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, Optional<String> limit) {
        if (!limit.isPresent()) {
            return subPlan;
        }
        if (!limit.get().equalsIgnoreCase("all")) {
            try {
                long limitValue = Long.parseLong(limit.get());
                subPlan = subPlan.withNewRoot((PlanNode)new LimitNode(subPlan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), subPlan.getRoot(), limitValue, LimitNode.Step.FINAL));
            }
            catch (NumberFormatException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_LIMIT_CLAUSE, String.format("Invalid limit: %s", limit.get()));
            }
        }
        return subPlan;
    }

    private List<RowExpression> callArgumentsToRowExpression(FunctionHandle functionHandle, List<Expression> arguments) {
        return (List)arguments.stream().map(expression -> TranslateExpressionsUtil.toRowExpression(expression, this.metadata, this.session, TranslateExpressionsUtil.analyzeCallExpressionTypes(functionHandle, arguments, this.metadata, this.sqlParser, this.session, TypeProvider.viewOf(this.variableAllocator.getVariables())), this.sqlPlannerContext.getTranslatorContext())).collect(ImmutableList.toImmutableList());
    }

    private RowExpression rowExpression(Expression expression, SqlPlannerContext context) {
        return TranslateExpressionsUtil.toRowExpression(expression, this.metadata, this.session, this.sqlParser, this.variableAllocator, this.analysis, context.getTranslatorContext());
    }

    private static List<Expression> toSymbolReferences(List<VariableReferenceExpression> variables) {
        return (List)variables.stream().map(variable -> new SymbolReference(variable.getSourceLocation().map(location -> new NodeLocation(location.getLine(), location.getColumn())), variable.getName())).collect(ImmutableList.toImmutableList());
    }

    private static /* synthetic */ Ordering lambda$window$14(LinkedHashMap orderings, VariableReferenceExpression variable) {
        return new Ordering(variable, (SortOrder)orderings.get(variable));
    }

    private static class FrameBoundPlanAndSymbols {
        private final PlanBuilder subPlan;
        private final Optional<VariableReferenceExpression> frameBoundSymbol;
        private final Optional<VariableReferenceExpression> sortKeyCoercedForFrameBoundComparison;

        public FrameBoundPlanAndSymbols(PlanBuilder subPlan, Optional<VariableReferenceExpression> frameBoundSymbol, Optional<VariableReferenceExpression> sortKeyCoercedForFrameBoundComparison) {
            this.subPlan = subPlan;
            this.frameBoundSymbol = frameBoundSymbol;
            this.sortKeyCoercedForFrameBoundComparison = sortKeyCoercedForFrameBoundComparison;
        }

        public PlanBuilder getSubPlan() {
            return this.subPlan;
        }

        public Optional<VariableReferenceExpression> getFrameBoundSymbol() {
            return this.frameBoundSymbol;
        }

        public Optional<VariableReferenceExpression> getSortKeyCoercedForFrameBoundComparison() {
            return this.sortKeyCoercedForFrameBoundComparison;
        }
    }

    public static class PlanAndMappings {
        private final PlanBuilder subPlan;
        private final Map<NodeRef<Expression>, VariableReferenceExpression> mappings;

        public PlanAndMappings(PlanBuilder subPlan, Map<NodeRef<Expression>, VariableReferenceExpression> mappings) {
            this.subPlan = subPlan;
            this.mappings = mappings;
        }

        public PlanBuilder getSubPlan() {
            return this.subPlan;
        }

        public VariableReferenceExpression get(Expression expression) {
            return this.tryGet(expression).orElseThrow(() -> new IllegalArgumentException(String.format("No mapping for expression: %s (%s)", expression, System.identityHashCode(expression))));
        }

        public Optional<VariableReferenceExpression> tryGet(Expression expression) {
            VariableReferenceExpression result = this.mappings.get(NodeRef.of((Node)expression));
            if (result != null) {
                return Optional.of(result);
            }
            return Optional.empty();
        }
    }
}

