/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.DetermineJoinDistributionType;
import com.facebook.presto.sql.planner.plan.JoinNode;
import java.util.Optional;

public class ConfidenceBasedBroadcastUtil {
    private ConfidenceBasedBroadcastUtil() {
    }

    public static Optional<JoinNode> confidenceBasedBroadcast(JoinNode joinNode, Rule.Context context) {
        SourceInfo.ConfidenceLevel rightConfidence = context.getStatsProvider().getStats(joinNode.getRight()).confidenceLevel();
        SourceInfo.ConfidenceLevel leftConfidence = context.getStatsProvider().getStats(joinNode.getLeft()).confidenceLevel();
        if (rightConfidence.getConfidenceOrdinal() > leftConfidence.getConfidenceOrdinal()) {
            return Optional.of(joinNode.withDistributionType(JoinDistributionType.REPLICATED));
        }
        if (leftConfidence.getConfidenceOrdinal() > rightConfidence.getConfidenceOrdinal()) {
            return Optional.of(joinNode.flipChildren().withDistributionType(JoinDistributionType.REPLICATED));
        }
        return Optional.empty();
    }

    public static Optional<JoinNode> treatLowConfidenceZeroEstimationsAsUnknown(boolean probeSideLowConfidenceZero, boolean buildSideLowConfidenceZero, JoinNode joinNode, Rule.Context context) {
        if (buildSideLowConfidenceZero && probeSideLowConfidenceZero) {
            return Optional.of(joinNode.withDistributionType(JoinDistributionType.PARTITIONED));
        }
        if (buildSideLowConfidenceZero) {
            if (DetermineJoinDistributionType.isBelowMaxBroadcastSize(joinNode.flipChildren(), context) && !DetermineJoinDistributionType.mustPartition(joinNode)) {
                return Optional.of(joinNode.flipChildren().withDistributionType(JoinDistributionType.REPLICATED));
            }
            return Optional.of(joinNode.withDistributionType(JoinDistributionType.PARTITIONED));
        }
        if (probeSideLowConfidenceZero) {
            if (DetermineJoinDistributionType.isBelowMaxBroadcastSize(joinNode, context) && !DetermineJoinDistributionType.mustPartition(joinNode)) {
                return Optional.of(joinNode.withDistributionType(JoinDistributionType.REPLICATED));
            }
            return Optional.of(joinNode.withDistributionType(JoinDistributionType.PARTITIONED));
        }
        return Optional.empty();
    }
}

