/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class InlineProjectionsOnValues
implements Rule<ProjectNode> {
    private static final Capture<ValuesNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.values().capturedAs(CHILD)));
    private final FunctionAndTypeManager functionAndTypeManager;

    public InlineProjectionsOnValues(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isInlineProjectionsOnValues(session);
    }

    @Override
    public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
        ValuesNode source = (ValuesNode)captures.get(CHILD);
        List rows = source.getRows();
        List valuesOutputVariables = source.getOutputVariables();
        List projectOutputVariables = projectNode.getOutputVariables();
        List projectRowExpressions = (List)projectNode.getAssignments().getExpressions().stream().collect(ImmutableList.toImmutableList());
        RowExpressionDeterminismEvaluator determinismEvaluator = new RowExpressionDeterminismEvaluator(this.functionAndTypeManager);
        if (!projectRowExpressions.stream().allMatch(arg_0 -> ((DeterminismEvaluator)determinismEvaluator).isDeterministic(arg_0))) {
            return Rule.Result.empty();
        }
        if (!rows.stream().allMatch(row -> row.stream().allMatch(arg_0 -> ((DeterminismEvaluator)determinismEvaluator).isDeterministic(arg_0)))) {
            return Rule.Result.empty();
        }
        ImmutableList.Builder rowExpressionsListBuilder = ImmutableList.builder();
        for (List rowExpressions : rows) {
            Verify.verify((rowExpressions.size() == valuesOutputVariables.size() ? 1 : 0) != 0, (String)"Output variable does not match its value in ValuesNode", (Object[])new Object[0]);
            Map mapping = (Map)Streams.zip(valuesOutputVariables.stream(), rowExpressions.stream(), AbstractMap.SimpleImmutableEntry::new).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            List rowExpressionsInProject = (List)projectRowExpressions.stream().map(expression -> RowExpressionVariableInliner.inlineVariables(mapping, expression)).collect(ImmutableList.toImmutableList());
            rowExpressionsListBuilder.add((Object)rowExpressionsInProject);
        }
        ValuesNode updatedProject = new ValuesNode(source.getSourceLocation(), context.getIdAllocator().getNextId(), projectOutputVariables, (List)rowExpressionsListBuilder.build(), Optional.empty());
        return Rule.Result.ofPlanNode((PlanNode)updatedProject);
    }
}

