/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.eventlistener.PlanOptimizerInformation;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.sql.planner.StatsEquivalentPlanNodeWithLimit;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class HistoricalStatisticsEquivalentPlanMarkingOptimizer
implements PlanOptimizer {
    private static final Set<Class<? extends PlanNode>> LIMITING_NODES = ImmutableSet.of(TopNNode.class, LimitNode.class, DistinctLimitNode.class, TopNRowNumberNode.class);
    private static final List<Class<? extends PlanNode>> PRECOMPUTE_PLAN_NODES = ImmutableList.of(JoinNode.class, SemiJoinNode.class, AggregationNode.class);
    private final StatsCalculator statsCalculator;
    private boolean isEnabledForTesting;

    public HistoricalStatisticsEquivalentPlanMarkingOptimizer(StatsCalculator statsCalculator) {
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
    }

    @Override
    public void setEnabledForTesting(boolean isSet) {
        this.isEnabledForTesting = isSet;
    }

    @Override
    public boolean isEnabled(Session session) {
        return this.isEnabledForTesting || SystemSessionProperties.useHistoryBasedPlanStatisticsEnabled(session) || SystemSessionProperties.trackHistoryBasedPlanStatisticsEnabled(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        if (!this.isEnabled(session)) {
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        if (SystemSessionProperties.restrictHistoryBasedOptimizationToComplexQuery(session) && !PlanNodeSearcher.searchFrom(plan).where(node -> PRECOMPUTE_PLAN_NODES.stream().anyMatch(clazz -> clazz.isInstance(node))).matches()) {
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        long startTimeInNano = System.nanoTime();
        long timeoutInMilliseconds = SystemSessionProperties.getHistoryBasedOptimizerTimeoutLimit(session).toMillis();
        int historiesLimitingPlanNodeLimit = PlanNodeSearcher.searchFrom(plan).recurseOnlyWhen(node -> !LIMITING_NODES.contains(node.getClass())).where(node -> LIMITING_NODES.contains(node.getClass())).findAll().stream().mapToInt(node -> {
            int size = PlanNodeSearcher.searchFrom(node).count();
            return size * size;
        }).sum();
        if (historiesLimitingPlanNodeLimit > SystemSessionProperties.getHistoryCanonicalPlanNodeLimit(session)) {
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        PlanNode newPlan = SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator), plan, new Context());
        if (this.checkTimeOut(startTimeInNano, timeoutInMilliseconds)) {
            this.logOptimizerFailure(session);
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        boolean registrationSucceeded = false;
        if (SystemSessionProperties.enforceHistoryBasedOptimizerRegistrationTimeout(session)) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Boolean> future = executor.submit(() -> this.statsCalculator.registerPlan(newPlan, session, startTimeInNano, timeoutInMilliseconds));
            try {
                registrationSucceeded = future.get(timeoutInMilliseconds, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
            }
            finally {
                executor.shutdownNow();
            }
        } else {
            registrationSucceeded = this.statsCalculator.registerPlan(newPlan, session, startTimeInNano, timeoutInMilliseconds);
        }
        if (this.checkTimeOut(startTimeInNano, timeoutInMilliseconds) || !registrationSucceeded) {
            this.logOptimizerFailure(session);
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        return PlanOptimizerResult.optimizerResult(newPlan, true);
    }

    private boolean checkTimeOut(long startTimeInNano, long timeoutInMilliseconds) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeInNano) > timeoutInMilliseconds;
    }

    private void logOptimizerFailure(Session session) {
        session.getOptimizerInformationCollector().addInformation(new PlanOptimizerInformation(HistoricalStatisticsEquivalentPlanMarkingOptimizer.class.getSimpleName(), false, Optional.empty(), Optional.of(true), Optional.empty(), Optional.empty()));
    }

    private static class Context {
        private final Deque<PlanNode> limits = new ArrayDeque<PlanNode>();

        private Context() {
        }

        public Deque<PlanNode> getLimits() {
            return this.limits;
        }
    }

    private static class Rewriter
    extends SimplePlanRewriter<Context> {
        private final PlanNodeIdAllocator idAllocator;

        public Rewriter(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            if (!(node = context.defaultRewrite(node, context.get())).getStatsEquivalentPlanNode().isPresent()) {
                PlanNode nodeWithLimit = node;
                if (!context.get().getLimits().isEmpty()) {
                    nodeWithLimit = new StatsEquivalentPlanNodeWithLimit(this.idAllocator.getNextId(), node, context.get().getLimits().peekFirst());
                }
                node = node.assignStatsEquivalentPlanNode(Optional.of(nodeWithLimit));
            }
            return node;
        }

        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return this.visitLimitingNode((PlanNode)node, context);
        }

        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return this.visitLimitingNode((PlanNode)node, context);
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return this.visitLimitingNode(node, context);
        }

        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return this.visitLimitingNode((PlanNode)node, context);
        }

        private PlanNode visitLimitingNode(PlanNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            context.get().getLimits().addLast(node);
            PlanNode result = this.visitPlan(node, context);
            context.get().getLimits().removeLast();
            return result;
        }
    }
}

