/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.common.Utils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.optimizations.PropertyDerivations;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class PartitioningUtils {
    private PartitioningUtils() {
    }

    @Deprecated
    public static boolean areCompatiblePartitionings(Partitioning left, Partitioning right, Metadata metadata, Session session) {
        if (!left.getHandle().equals((Object)right.getHandle()) && !metadata.getCommonPartitioning(session, left.getHandle(), right.getHandle()).isPresent()) {
            return false;
        }
        return left.getArguments().equals(right.getArguments());
    }

    @Deprecated
    public static boolean areCompatiblePartitionings(Partitioning left, Partitioning right, Function<VariableReferenceExpression, Set<VariableReferenceExpression>> leftToRightMappings, Function<VariableReferenceExpression, Optional<ConstantExpression>> leftConstantMapping, Function<VariableReferenceExpression, Optional<ConstantExpression>> rightConstantMapping, Metadata metadata, Session session) {
        if (!left.getHandle().equals((Object)right.getHandle()) && !metadata.getCommonPartitioning(session, left.getHandle(), right.getHandle()).isPresent()) {
            return false;
        }
        if (left.getArguments().size() != right.getArguments().size()) {
            return false;
        }
        for (int i = 0; i < left.getArguments().size(); ++i) {
            RowExpression rightArgument;
            RowExpression leftArgument = (RowExpression)left.getArguments().get(i);
            if (PartitioningUtils.isPartitionedWith(leftArgument, leftConstantMapping, rightArgument = (RowExpression)right.getArguments().get(i), rightConstantMapping, leftToRightMappings)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRefinedPartitioningOver(Partitioning left, Partitioning right, Metadata metadata, Session session) {
        if (!left.getHandle().equals((Object)right.getHandle()) && !metadata.isRefinedPartitioningOver(session, left.getHandle(), right.getHandle())) {
            return false;
        }
        return left.getArguments().equals(right.getArguments());
    }

    public static boolean isRefinedPartitioningOver(Partitioning left, Partitioning right, Function<VariableReferenceExpression, Set<VariableReferenceExpression>> leftToRightMappings, Function<VariableReferenceExpression, Optional<ConstantExpression>> leftConstantMapping, Function<VariableReferenceExpression, Optional<ConstantExpression>> rightConstantMapping, Metadata metadata, Session session) {
        if (!metadata.isRefinedPartitioningOver(session, left.getHandle(), right.getHandle())) {
            return false;
        }
        List leftArguments = left.getArguments();
        List rightArguments = right.getArguments();
        if (leftArguments.size() != rightArguments.size()) {
            return false;
        }
        for (int i = 0; i < leftArguments.size(); ++i) {
            RowExpression rightArgument;
            RowExpression leftArgument = (RowExpression)leftArguments.get(i);
            if (PartitioningUtils.isPartitionedWith(leftArgument, leftConstantMapping, rightArgument = (RowExpression)rightArguments.get(i), rightConstantMapping, leftToRightMappings)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPartitionedWith(RowExpression leftArgument, Function<VariableReferenceExpression, Optional<ConstantExpression>> leftConstantMapping, RowExpression rightArgument, Function<VariableReferenceExpression, Optional<ConstantExpression>> rightConstantMapping, Function<VariableReferenceExpression, Set<VariableReferenceExpression>> leftToRightMappings) {
        if (leftArgument instanceof VariableReferenceExpression) {
            if (rightArgument instanceof VariableReferenceExpression) {
                Set<VariableReferenceExpression> mappedColumns = leftToRightMappings.apply((VariableReferenceExpression)leftArgument);
                return mappedColumns.contains(rightArgument);
            }
            if (rightArgument instanceof ConstantExpression) {
                Optional<ConstantExpression> leftConstant = leftConstantMapping.apply((VariableReferenceExpression)leftArgument);
                return leftConstant.isPresent() && leftConstant.get().equals((Object)rightArgument);
            }
            return false;
        }
        if (leftArgument instanceof ConstantExpression) {
            if (rightArgument instanceof ConstantExpression) {
                return leftArgument.equals((Object)rightArgument);
            }
            if (rightArgument instanceof VariableReferenceExpression) {
                Optional<ConstantExpression> rightConstant = rightConstantMapping.apply((VariableReferenceExpression)rightArgument);
                return rightConstant.isPresent() && rightConstant.get().equals((Object)leftArgument);
            }
            return false;
        }
        return false;
    }

    public static boolean isPartitionedOn(Partitioning partitioning, Collection<VariableReferenceExpression> columns, Set<VariableReferenceExpression> knownConstants) {
        for (RowExpression argument : partitioning.getArguments()) {
            if (argument instanceof ConstantExpression) continue;
            if (!(argument instanceof VariableReferenceExpression)) {
                return false;
            }
            if (knownConstants.contains(argument) || columns.contains(argument)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPartitionedOnExactly(Partitioning partitioning, Collection<VariableReferenceExpression> columns, Set<VariableReferenceExpression> knownConstants) {
        HashSet<VariableReferenceExpression> toCheck = new HashSet<VariableReferenceExpression>();
        for (RowExpression argument : partitioning.getArguments()) {
            if (argument instanceof ConstantExpression) continue;
            if (!(argument instanceof VariableReferenceExpression)) {
                return false;
            }
            if (knownConstants.contains(argument)) continue;
            toCheck.add((VariableReferenceExpression)argument);
        }
        return ImmutableSet.copyOf(columns).equals(toCheck);
    }

    public static boolean isEffectivelySinglePartition(Partitioning partitioning, Set<VariableReferenceExpression> knownConstants) {
        return PartitioningUtils.isPartitionedOn(partitioning, (Collection<VariableReferenceExpression>)ImmutableSet.of(), knownConstants);
    }

    public static boolean isRepartitionEffective(Partitioning partitioning, Collection<VariableReferenceExpression> keys, Set<VariableReferenceExpression> knownConstants) {
        Set keysWithoutConstants = (Set)keys.stream().filter(variable -> !knownConstants.contains(variable)).collect(ImmutableSet.toImmutableSet());
        Set nonConstantArgs = (Set)partitioning.getArguments().stream().filter(VariableReferenceExpression.class::isInstance).map(VariableReferenceExpression.class::cast).filter(variable -> !knownConstants.contains(variable)).collect(ImmutableSet.toImmutableSet());
        return !nonConstantArgs.equals(keysWithoutConstants);
    }

    public static Optional<Partitioning> translateVariableToRowExpression(Partitioning partitioning, Function<VariableReferenceExpression, Optional<RowExpression>> translator) {
        ImmutableList.Builder newArguments = ImmutableList.builder();
        for (RowExpression argument : partitioning.getArguments()) {
            if (argument instanceof ConstantExpression) {
                newArguments.add((Object)argument);
                continue;
            }
            if (argument instanceof VariableReferenceExpression) {
                Optional<RowExpression> newArgument = translator.apply((VariableReferenceExpression)argument);
                if (!newArgument.isPresent()) {
                    return Optional.empty();
                }
                newArguments.add((Object)newArgument.get());
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(new Partitioning(partitioning.getHandle(), (List)newArguments.build()));
    }

    public static Optional<Partitioning> translateToCoalesce(Partitioning left, Partitioning right, Metadata metadata, Session session) {
        Preconditions.checkArgument((boolean)PropertyDerivations.arePartitionHandlesCompatibleForCoalesce(left.getHandle(), right.getHandle(), metadata, session), (String)"incompatible partitioning handles: cannot coalesce %s and %s", (Object)left.getHandle(), (Object)right.getHandle());
        List leftArguments = left.getArguments();
        List rightArguments = right.getArguments();
        Preconditions.checkArgument((left.getArguments().size() == rightArguments.size() ? 1 : 0) != 0, (String)"incompatible number of partitioning arguments: %s != %s", (int)leftArguments.size(), (int)rightArguments.size());
        ImmutableList.Builder arguments = ImmutableList.builder();
        for (int i = 0; i < leftArguments.size(); ++i) {
            RowExpression leftArgument = (RowExpression)leftArguments.get(i);
            RowExpression rightArgument = (RowExpression)rightArguments.get(i);
            if (leftArgument instanceof ConstantExpression) {
                arguments.add((Object)leftArgument);
                continue;
            }
            if (rightArgument instanceof ConstantExpression) {
                arguments.add((Object)rightArgument);
                continue;
            }
            if (leftArgument instanceof VariableReferenceExpression && rightArgument instanceof VariableReferenceExpression) {
                VariableReferenceExpression leftVariable = (VariableReferenceExpression)leftArgument;
                VariableReferenceExpression rightVariable = (VariableReferenceExpression)rightArgument;
                Preconditions.checkArgument((boolean)leftVariable.getType().equals(rightVariable.getType()), (String)"incompatible types: %s != %s", (Object)leftVariable.getType(), (Object)rightVariable.getType());
                arguments.add((Object)new SpecialFormExpression(SpecialFormExpression.Form.COALESCE, leftVariable.getType(), (List)ImmutableList.of((Object)leftVariable, (Object)rightVariable)));
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(new Partitioning(metadata.isRefinedPartitioningOver(session, right.getHandle(), left.getHandle()) ? left.getHandle() : right.getHandle(), (List)arguments.build()));
    }

    public static Optional<Partitioning> translatePartitioningRowExpression(Partitioning partitioning, Map<VariableReferenceExpression, RowExpression> inputToOutputMappings, Map<VariableReferenceExpression, RowExpression> assignments) {
        ImmutableList.Builder newArguments = ImmutableList.builder();
        for (RowExpression argument : partitioning.getArguments()) {
            if (argument instanceof ConstantExpression) {
                newArguments.add((Object)argument);
                continue;
            }
            if (argument instanceof VariableReferenceExpression) {
                if (!inputToOutputMappings.containsKey(argument)) {
                    return Optional.empty();
                }
                newArguments.add((Object)inputToOutputMappings.get(argument));
                continue;
            }
            Preconditions.checkArgument((argument instanceof SpecialFormExpression && ((SpecialFormExpression)argument).getForm().equals((Object)SpecialFormExpression.Form.COALESCE) ? 1 : 0) != 0, (Object)String.format("Expect argument to be COALESCE but get %s", argument));
            ImmutableSet coalesceArguments = ImmutableSet.copyOf((Collection)((SpecialFormExpression)argument).getArguments());
            Preconditions.checkArgument((boolean)coalesceArguments.stream().allMatch(VariableReferenceExpression.class::isInstance), (Object)String.format("Expect arguments of COALESCE to be VariableReferenceExpression but get %s", coalesceArguments));
            VariableReferenceExpression translated = null;
            for (Map.Entry<VariableReferenceExpression, RowExpression> entry : assignments.entrySet()) {
                if (!(entry.getValue() instanceof SpecialFormExpression) || !((SpecialFormExpression)entry.getValue()).getForm().equals((Object)SpecialFormExpression.Form.COALESCE)) continue;
                ImmutableSet assignmentArguments = ImmutableSet.copyOf((Collection)((SpecialFormExpression)entry.getValue()).getArguments());
                if (!assignmentArguments.stream().allMatch(VariableReferenceExpression.class::isInstance) || !assignmentArguments.equals(coalesceArguments)) continue;
                translated = entry.getKey();
                break;
            }
            if (translated == null) {
                return Optional.empty();
            }
            newArguments.add(translated);
        }
        return Optional.of(new Partitioning(partitioning.getHandle(), (List)newArguments.build()));
    }

    public static PartitioningScheme translateOutputLayout(PartitioningScheme partitioningScheme, List<VariableReferenceExpression> newOutputLayout) {
        Objects.requireNonNull(newOutputLayout, "newOutputLayout is null");
        Utils.checkArgument((newOutputLayout.size() == partitioningScheme.getOutputLayout().size() ? 1 : 0) != 0);
        List oldOutputLayout = partitioningScheme.getOutputLayout();
        Partitioning newPartitioning = PartitioningUtils.translateVariable(partitioningScheme.getPartitioning(), variable -> (VariableReferenceExpression)newOutputLayout.get(oldOutputLayout.indexOf(variable)));
        Optional<VariableReferenceExpression> newHashSymbol = partitioningScheme.getHashColumn().map(oldOutputLayout::indexOf).map(newOutputLayout::get);
        return new PartitioningScheme(newPartitioning, newOutputLayout, newHashSymbol, partitioningScheme.isReplicateNullsAndAny(), partitioningScheme.getBucketToPartition());
    }

    public static Partitioning translateVariable(Partitioning partitioning, Function<VariableReferenceExpression, VariableReferenceExpression> translator) {
        return new Partitioning(partitioning.getHandle(), (List)partitioning.getArguments().stream().map(argument -> {
            if (argument instanceof VariableReferenceExpression) {
                return (RowExpression)translator.apply((VariableReferenceExpression)argument);
            }
            return argument;
        }).collect(ImmutableList.toImmutableList()));
    }
}

