/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConstantProperty;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.ActualProperties;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.MergeJoinNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SequenceNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PropertyDerivations {
    private PropertyDerivations() {
    }

    public static ActualProperties derivePropertiesRecursively(PlanNode node, Metadata metadata, Session session) {
        List inputProperties = (List)node.getSources().stream().map(source -> PropertyDerivations.derivePropertiesRecursively(source, metadata, session)).collect(ImmutableList.toImmutableList());
        return PropertyDerivations.deriveProperties(node, inputProperties, metadata, session);
    }

    public static ActualProperties deriveProperties(PlanNode node, List<ActualProperties> inputProperties, Metadata metadata, Session session) {
        ActualProperties output = (ActualProperties)node.accept((PlanVisitor)new Visitor(metadata, session), inputProperties);
        output.getNodePartitioning().ifPresent(partitioning -> Verify.verify((boolean)node.getOutputVariables().containsAll(partitioning.getVariableReferences()), (String)"Node-level partitioning properties contain columns not present in node's output", (Object[])new Object[0]));
        Verify.verify((boolean)node.getOutputVariables().containsAll(output.getConstants().keySet()), (String)"Node-level constant properties contain columns not present in node's output", (Object[])new Object[0]);
        Set localPropertyColumns = output.getLocalProperties().stream().flatMap(property -> property.getColumns().stream()).collect(Collectors.toSet());
        Verify.verify((boolean)node.getOutputVariables().containsAll(localPropertyColumns), (String)"Node-level local properties contain columns not present in node's output", (Object[])new Object[0]);
        return output;
    }

    public static ActualProperties streamBackdoorDeriveProperties(PlanNode node, List<ActualProperties> inputProperties, Metadata metadata, Session session) {
        return (ActualProperties)node.accept((PlanVisitor)new Visitor(metadata, session), inputProperties);
    }

    static boolean spillPossible(Session session, JoinType joinType) {
        if (!SystemSessionProperties.isSpillEnabled(session) || !SystemSessionProperties.isJoinSpillingEnabled(session)) {
            return false;
        }
        switch (joinType) {
            case INNER: 
            case LEFT: {
                return true;
            }
            case RIGHT: 
            case FULL: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown join type: " + joinType);
    }

    public static Optional<VariableReferenceExpression> filterIfMissing(Collection<VariableReferenceExpression> columns, VariableReferenceExpression column) {
        if (columns.contains(column)) {
            return Optional.of(column);
        }
        return Optional.empty();
    }

    public static Optional<VariableReferenceExpression> filterOrRewrite(Collection<VariableReferenceExpression> columns, List<EquiJoinClause> equalities, VariableReferenceExpression column) {
        if (columns.contains(column)) {
            return Optional.of(column);
        }
        for (EquiJoinClause equality : equalities) {
            if (equality.getLeft().equals((Object)column) && columns.contains(equality.getRight())) {
                return Optional.of(equality.getRight());
            }
            if (!equality.getRight().equals((Object)column) || !columns.contains(equality.getLeft())) continue;
            return Optional.of(equality.getLeft());
        }
        return Optional.empty();
    }

    public static boolean arePartitionHandlesCompatibleForCoalesce(PartitioningHandle a, PartitioningHandle b, Metadata metadata, Session session) {
        return a.equals((Object)b) || metadata.isRefinedPartitioningOver(session, a, b) || metadata.isRefinedPartitioningOver(session, b, a);
    }

    public static <T> Optional<Map<T, ConstantExpression>> extractFixedValuesToConstantExpressions(TupleDomain<T> tupleDomain) {
        if (!tupleDomain.getDomains().isPresent()) {
            return Optional.empty();
        }
        return Optional.of(((Map)tupleDomain.getDomains().get()).entrySet().stream().filter(entry -> ((Domain)entry.getValue()).isNullableSingleValue()).collect(TupleDomain.toLinkedMap(Map.Entry::getKey, entry -> new ConstantExpression(((Domain)entry.getValue()).getNullableSingleValue(), ((Domain)entry.getValue()).getType()))));
    }

    private static class Visitor
    extends InternalPlanVisitor<ActualProperties, List<ActualProperties>> {
        private final Metadata metadata;
        private final Session session;

        public Visitor(Metadata metadata, Session session) {
            this.metadata = metadata;
            this.session = session;
        }

        public ActualProperties visitPlan(PlanNode node, List<ActualProperties> inputProperties) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        @Override
        public ActualProperties visitExplainAnalyze(ExplainAnalyzeNode node, List<ActualProperties> inputProperties) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSingleStreamPartition()).build();
        }

        public ActualProperties visitOutput(OutputNode node, List<ActualProperties> inputProperties) {
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translateVariable(column -> PropertyDerivations.filterIfMissing(node.getOutputVariables(), column));
        }

        @Override
        public ActualProperties visitEnforceSingleRow(EnforceSingleRowNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitAssignUniqueId(AssignUniqueId node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ImmutableList.Builder newLocalProperties = ImmutableList.builder();
            newLocalProperties.addAll(properties.getLocalProperties());
            newLocalProperties.add((Object)new GroupingProperty((Collection)ImmutableList.of((Object)node.getIdVariable())));
            node.getSource().getOutputVariables().stream().forEach(column -> newLocalProperties.add((Object)new ConstantProperty(column)));
            if (properties.getNodePartitioning().isPresent()) {
                return ActualProperties.builderFrom(properties).local((List<? extends LocalProperty<VariableReferenceExpression>>)newLocalProperties.build()).build();
            }
            return ActualProperties.builderFrom(properties).global(ActualProperties.Global.partitionedOn(SystemPartitioningHandle.ARBITRARY_DISTRIBUTION, ImmutableList.of((Object)node.getIdVariable()), Optional.empty())).local((List<? extends LocalProperty<VariableReferenceExpression>>)newLocalProperties.build()).build();
        }

        @Override
        public ActualProperties visitApply(ApplyNode node, List<ActualProperties> inputProperties) {
            throw new IllegalArgumentException("Unexpected node: " + ((Object)((Object)node)).getClass().getName());
        }

        @Override
        public ActualProperties visitLateralJoin(LateralJoinNode node, List<ActualProperties> inputProperties) {
            throw new IllegalArgumentException("Unexpected node: " + ((Object)((Object)node)).getClass().getName());
        }

        public ActualProperties visitMarkDistinct(MarkDistinctNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitWindow(WindowNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            Optional<OrderingScheme> orderingScheme = node.getOrderingScheme();
            if (ImmutableSet.copyOf(node.getPartitionBy()).equals(node.getPrePartitionedInputs()) && (!orderingScheme.isPresent() || node.getPreSortedOrderPrefix() == orderingScheme.get().getOrderByVariables().size())) {
                return properties;
            }
            ImmutableList.Builder localProperties = ImmutableList.builder();
            if (!node.getPrePartitionedInputs().isEmpty()) {
                GroupingProperty prePartitionedProperty = new GroupingProperty(node.getPrePartitionedInputs());
                for (LocalProperty<VariableReferenceExpression> localProperty : properties.getLocalProperties()) {
                    if (!prePartitionedProperty.isSimplifiedBy(localProperty)) break;
                    localProperties.add(localProperty);
                }
            }
            if (!node.getPartitionBy().isEmpty()) {
                localProperties.add((Object)new GroupingProperty(node.getPartitionBy()));
            }
            orderingScheme.ifPresent(scheme -> scheme.getOrderByVariables().stream().map(column -> new SortingProperty(column, scheme.getOrdering(column))).forEach(arg_0 -> ((ImmutableList.Builder)localProperties).add(arg_0)));
            return ActualProperties.builderFrom(properties).local(LocalProperties.normalizeAndPrune(localProperties.build())).build();
        }

        @Override
        public ActualProperties visitGroupId(GroupIdNode node, List<ActualProperties> inputProperties) {
            HashMap<VariableReferenceExpression, VariableReferenceExpression> inputToOutputMappings = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
            for (Map.Entry<VariableReferenceExpression, VariableReferenceExpression> setMapping : node.getGroupingColumns().entrySet()) {
                if (!node.getCommonGroupingColumns().contains(setMapping.getKey())) continue;
                inputToOutputMappings.putIfAbsent(setMapping.getValue(), setMapping.getKey());
            }
            for (VariableReferenceExpression argument : node.getAggregationArguments()) {
                inputToOutputMappings.putIfAbsent(argument, argument);
            }
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translateVariable(column -> Optional.ofNullable(inputToOutputMappings.get(column)));
        }

        public ActualProperties visitAggregation(AggregationNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ActualProperties translated = properties.translateVariable(variable -> node.getGroupingKeys().contains(variable) ? Optional.of(variable) : Optional.empty());
            return ActualProperties.builderFrom(translated).local(LocalProperties.grouped(node.getGroupingKeys())).build();
        }

        @Override
        public ActualProperties visitRowNumber(RowNumberNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitTopNRowNumber(TopNRowNumberNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ImmutableList.Builder localProperties = ImmutableList.builder();
            localProperties.add((Object)new GroupingProperty(node.getPartitionBy()));
            for (VariableReferenceExpression column : node.getOrderingScheme().getOrderByVariables()) {
                localProperties.add((Object)new SortingProperty((Object)column, node.getOrderingScheme().getOrdering(column)));
            }
            return ActualProperties.builderFrom(properties).local((List<? extends LocalProperty<VariableReferenceExpression>>)localProperties.build()).build();
        }

        public ActualProperties visitTopN(TopNNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            List localProperties = (List)node.getOrderingScheme().getOrderByVariables().stream().map(column -> new SortingProperty(column, node.getOrderingScheme().getOrdering(column))).collect(ImmutableList.toImmutableList());
            return ActualProperties.builderFrom(properties).local(localProperties).build();
        }

        public ActualProperties visitSort(SortNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            List localProperties = (List)node.getOrderingScheme().getOrderByVariables().stream().map(column -> new SortingProperty(column, node.getOrderingScheme().getOrdering(column))).collect(ImmutableList.toImmutableList());
            return ActualProperties.builderFrom(properties).local(localProperties).build();
        }

        public ActualProperties visitLimit(LimitNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        public ActualProperties visitDistinctLimit(DistinctLimitNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            return ActualProperties.builderFrom(properties).local(LocalProperties.grouped(node.getDistinctVariables())).build();
        }

        @Override
        public ActualProperties visitStatisticsWriterNode(StatisticsWriterNode node, List<ActualProperties> context) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSingleStreamPartition()).build();
        }

        @Override
        public ActualProperties visitTableFinish(TableFinishNode node, List<ActualProperties> inputProperties) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSingleStreamPartition()).build();
        }

        @Override
        public ActualProperties visitDelete(DeleteNode node, List<ActualProperties> inputProperties) {
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translateVariable(symbol -> Optional.empty());
        }

        @Override
        public ActualProperties visitJoin(JoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties probeProperties = inputProperties.get(0);
            ActualProperties buildProperties = inputProperties.get(1);
            List<VariableReferenceExpression> outputVariableReferences = node.getOutputVariables();
            boolean unordered = PropertyDerivations.spillPossible(this.session, node.getType());
            switch (node.getType()) {
                case INNER: {
                    probeProperties = probeProperties.translateVariable(column -> PropertyDerivations.filterOrRewrite(outputVariableReferences, node.getCriteria(), column));
                    buildProperties = buildProperties.translateVariable(column -> PropertyDerivations.filterOrRewrite(outputVariableReferences, node.getCriteria(), column));
                    HashMap<VariableReferenceExpression, ConstantExpression> constants = new HashMap<VariableReferenceExpression, ConstantExpression>();
                    constants.putAll(probeProperties.getConstants());
                    constants.putAll(buildProperties.getConstants());
                    if (node.isCrossJoin()) {
                        return ActualProperties.builder().global(probeProperties).local((List<? extends LocalProperty<VariableReferenceExpression>>)ImmutableList.of()).constants(constants).build();
                    }
                    return ActualProperties.builderFrom(probeProperties).constants(constants).unordered(unordered).build();
                }
                case LEFT: {
                    return ActualProperties.builderFrom(probeProperties.translateVariable(column -> PropertyDerivations.filterIfMissing(outputVariableReferences, column))).unordered(unordered).build();
                }
                case RIGHT: {
                    buildProperties = buildProperties.translateVariable(column -> PropertyDerivations.filterIfMissing(node.getOutputVariables(), column));
                    return ActualProperties.builderFrom(buildProperties.translateVariable(column -> PropertyDerivations.filterIfMissing(outputVariableReferences, column))).local((List<? extends LocalProperty<VariableReferenceExpression>>)ImmutableList.of()).unordered(true).build();
                }
                case FULL: {
                    if (probeProperties.isSingleNode()) {
                        return ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build();
                    }
                    if (probeProperties.getNodePartitioning().isPresent() && buildProperties.getNodePartitioning().isPresent() && PropertyDerivations.arePartitionHandlesCompatibleForCoalesce(probeProperties.getNodePartitioning().get().getHandle(), buildProperties.getNodePartitioning().get().getHandle(), this.metadata, this.session)) {
                        return ActualProperties.builder().global(ActualProperties.Global.partitionedOnCoalesce(probeProperties.getNodePartitioning().get(), buildProperties.getNodePartitioning().get(), this.metadata, this.session)).build();
                    }
                    return ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build();
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + node.getType());
        }

        @Override
        public ActualProperties visitSemiJoin(SemiJoinNode node, List<ActualProperties> inputProperties) {
            return inputProperties.get(0);
        }

        @Override
        public ActualProperties visitSpatialJoin(SpatialJoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties probeProperties = inputProperties.get(0);
            ActualProperties buildProperties = inputProperties.get(1);
            List<VariableReferenceExpression> outputs = node.getOutputVariables();
            switch (node.getType()) {
                case INNER: {
                    probeProperties = probeProperties.translateVariable(column -> PropertyDerivations.filterIfMissing(outputs, column));
                    buildProperties = buildProperties.translateVariable(column -> PropertyDerivations.filterIfMissing(outputs, column));
                    HashMap<VariableReferenceExpression, ConstantExpression> constants = new HashMap<VariableReferenceExpression, ConstantExpression>();
                    constants.putAll(probeProperties.getConstants());
                    constants.putAll(buildProperties.getConstants());
                    return ActualProperties.builderFrom(probeProperties).constants(constants).build();
                }
                case LEFT: {
                    return ActualProperties.builderFrom(probeProperties.translateVariable(column -> PropertyDerivations.filterIfMissing(outputs, column))).build();
                }
            }
            throw new IllegalArgumentException("Unsupported spatial join type: " + (Object)((Object)node.getType()));
        }

        @Override
        public ActualProperties visitIndexJoin(IndexJoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties probeProperties = inputProperties.get(0);
            ActualProperties indexProperties = inputProperties.get(1);
            switch (node.getType()) {
                case INNER: {
                    return ActualProperties.builderFrom(probeProperties).constants((Map<VariableReferenceExpression, ConstantExpression>)ImmutableMap.builder().putAll(probeProperties.getConstants()).putAll(indexProperties.getConstants()).build()).build();
                }
                case SOURCE_OUTER: {
                    return ActualProperties.builderFrom(probeProperties).constants(probeProperties.getConstants()).build();
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        @Override
        public ActualProperties visitIndexSource(IndexSourceNode node, List<ActualProperties> context) {
            return ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build();
        }

        @Override
        public ActualProperties visitMergeJoin(MergeJoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties leftProperties = inputProperties.get(0);
            ActualProperties rightProperties = inputProperties.get(1);
            List<VariableReferenceExpression> outputVariableReferences = node.getOutputVariables();
            switch (node.getType()) {
                case INNER: {
                    leftProperties = leftProperties.translateVariable(column -> PropertyDerivations.filterOrRewrite(outputVariableReferences, node.getCriteria(), column));
                    rightProperties = rightProperties.translateVariable(column -> PropertyDerivations.filterOrRewrite(outputVariableReferences, node.getCriteria(), column));
                    HashMap<VariableReferenceExpression, ConstantExpression> constants = new HashMap<VariableReferenceExpression, ConstantExpression>();
                    constants.putAll(leftProperties.getConstants());
                    constants.putAll(rightProperties.getConstants());
                    return ActualProperties.builderFrom(leftProperties).constants(constants).build();
                }
                case LEFT: {
                    return ActualProperties.builderFrom(leftProperties.translateVariable(column -> PropertyDerivations.filterIfMissing(outputVariableReferences, column))).build();
                }
                case RIGHT: {
                    rightProperties = rightProperties.translateVariable(column -> PropertyDerivations.filterIfMissing(node.getOutputVariables(), column));
                    return ActualProperties.builderFrom(rightProperties.translateVariable(column -> PropertyDerivations.filterIfMissing(outputVariableReferences, column))).local((List<? extends LocalProperty<VariableReferenceExpression>>)ImmutableList.of()).unordered(true).build();
                }
                case FULL: {
                    if (leftProperties.isSingleNode()) {
                        return ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build();
                    }
                    if (leftProperties.getNodePartitioning().isPresent() && rightProperties.getNodePartitioning().isPresent() && PropertyDerivations.arePartitionHandlesCompatibleForCoalesce(leftProperties.getNodePartitioning().get().getHandle(), rightProperties.getNodePartitioning().get().getHandle(), this.metadata, this.session)) {
                        return ActualProperties.builder().global(ActualProperties.Global.partitionedOnCoalesce(leftProperties.getNodePartitioning().get(), rightProperties.getNodePartitioning().get(), this.metadata, this.session)).build();
                    }
                    return ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).build();
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + node.getType());
        }

        @Override
        public ActualProperties visitExchange(ExchangeNode node, List<ActualProperties> inputProperties) {
            Preconditions.checkArgument((!node.getScope().isRemote() || inputProperties.stream().noneMatch(ActualProperties::isNullsAndAnyReplicated) ? 1 : 0) != 0, (Object)"Null-and-any replicated inputs should not be remotely exchanged");
            Sets.SetView entries = null;
            for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                List<VariableReferenceExpression> inputVariables = node.getInputs().get(sourceIndex);
                HashMap<VariableReferenceExpression, VariableReferenceExpression> inputToOutput = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
                for (int i = 0; i < node.getOutputVariables().size(); ++i) {
                    inputToOutput.put(inputVariables.get(i), node.getOutputVariables().get(i));
                }
                ActualProperties translated = inputProperties.get(sourceIndex).translateVariable(variable -> Optional.ofNullable(inputToOutput.get(variable)));
                entries = entries == null ? translated.getConstants().entrySet() : Sets.intersection(entries, translated.getConstants().entrySet());
            }
            Preconditions.checkState((entries != null ? 1 : 0) != 0);
            Map<VariableReferenceExpression, ConstantExpression> constants = entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ImmutableList.Builder localProperties = ImmutableList.builder();
            if (node.getOrderingScheme().isPresent()) {
                node.getOrderingScheme().get().getOrderByVariables().stream().map(column -> new SortingProperty(column, node.getOrderingScheme().get().getOrdering(column))).forEach(arg_0 -> ((ImmutableList.Builder)localProperties).add(arg_0));
            }
            if (node.getScope().isLocal()) {
                ActualProperties.Builder builder = ActualProperties.builder();
                builder.local((List<? extends LocalProperty<VariableReferenceExpression>>)localProperties.build());
                builder.constants(constants);
                if (inputProperties.stream().anyMatch(ActualProperties::isCoordinatorOnly)) {
                    builder.global(ActualProperties.Global.coordinatorSingleStreamPartition());
                } else if (inputProperties.stream().anyMatch(ActualProperties::isSingleNode)) {
                    builder.global(ActualProperties.Global.coordinatorSingleStreamPartition());
                }
                return builder.build();
            }
            switch (node.getType()) {
                case GATHER: {
                    boolean coordinatorOnly = node.getPartitioningScheme().getPartitioning().getHandle().isCoordinatorOnly();
                    return ActualProperties.builder().global(coordinatorOnly ? ActualProperties.Global.coordinatorSingleStreamPartition() : ActualProperties.Global.singleStreamPartition()).local((List<? extends LocalProperty<VariableReferenceExpression>>)localProperties.build()).constants(constants).build();
                }
                case REPARTITION: {
                    return ActualProperties.builder().global(ActualProperties.Global.partitionedOn(node.getPartitioningScheme().getPartitioning(), Optional.of(node.getPartitioningScheme().getPartitioning())).withReplicatedNulls(node.getPartitioningScheme().isReplicateNullsAndAny())).constants(constants).build();
                }
                case REPLICATE: {
                    return ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).constants(constants).build();
                }
            }
            throw new UnsupportedOperationException("not yet implemented");
        }

        public ActualProperties visitFilter(FilterNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            HashMap<VariableReferenceExpression, ConstantExpression> constants = new HashMap<VariableReferenceExpression, ConstantExpression>(properties.getConstants());
            TupleDomain tupleDomain = new RowExpressionDomainTranslator(this.metadata).fromPredicate(this.session.toConnectorSession(), node.getPredicate(), DomainTranslator.BASIC_COLUMN_EXTRACTOR).getTupleDomain();
            constants.putAll((Map)PropertyDerivations.extractFixedValuesToConstantExpressions(tupleDomain).orElse((Map<ImmutableMap, ConstantExpression>)ImmutableMap.of()));
            return ActualProperties.builderFrom(properties).constants(constants).build();
        }

        public ActualProperties visitProject(ProjectNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ActualProperties translatedProperties = properties.translateRowExpression(node.getAssignments().getMap());
            HashMap<VariableReferenceExpression, ConstantExpression> constants = new HashMap<VariableReferenceExpression, ConstantExpression>();
            for (Map.Entry assignment : node.getAssignments().entrySet()) {
                RowExpression expression = (RowExpression)assignment.getValue();
                VariableReferenceExpression output = (VariableReferenceExpression)assignment.getKey();
                Object value = new RowExpressionInterpreter(expression, this.metadata.getFunctionAndTypeManager(), this.session.toConnectorSession(), ExpressionOptimizer.Level.OPTIMIZED).optimize();
                if (value instanceof VariableReferenceExpression) {
                    ConstantExpression existingConstantValue = (ConstantExpression)constants.get(value);
                    if (existingConstantValue == null) continue;
                    constants.put(output, new ConstantExpression(((VariableReferenceExpression)value).getSourceLocation(), value, expression.getType()));
                    continue;
                }
                if (value instanceof RowExpression) continue;
                constants.put(output, new ConstantExpression(value, expression.getType()));
            }
            constants.putAll(translatedProperties.getConstants());
            return ActualProperties.builderFrom(translatedProperties).constants(constants).build();
        }

        @Override
        public ActualProperties visitTableWriter(TableWriterNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            if (properties.isCoordinatorOnly()) {
                return ActualProperties.builder().global(ActualProperties.Global.coordinatorSingleStreamPartition()).build();
            }
            return ActualProperties.builder().global(properties.isSingleNode() ? ActualProperties.Global.singleStreamPartition() : ActualProperties.Global.arbitraryPartition()).build();
        }

        @Override
        public ActualProperties visitTableWriteMerge(TableWriterMergeNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitSample(SampleNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitUnnest(UnnestNode node, List<ActualProperties> inputProperties) {
            ImmutableSet passThroughInputs = ImmutableSet.copyOf(node.getReplicateVariables());
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translateVariable(arg_0 -> Visitor.lambda$visitUnnest$24((Set)passThroughInputs, arg_0));
        }

        public ActualProperties visitValues(ValuesNode node, List<ActualProperties> context) {
            return ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build();
        }

        @Override
        public ActualProperties visitSequence(SequenceNode node, List<ActualProperties> context) {
            return context.get(context.size() - 1);
        }

        public ActualProperties visitTableScan(TableScanNode node, List<ActualProperties> inputProperties) {
            TableLayout layout = this.metadata.getLayout(this.session, node.getTable());
            ImmutableBiMap assignments = ImmutableBiMap.copyOf((Map)node.getAssignments()).inverse();
            ActualProperties.Builder properties = ActualProperties.builder();
            HashMap<ColumnHandle, ConstantExpression> globalConstants = new HashMap<ColumnHandle, ConstantExpression>();
            ((Map)PropertyDerivations.extractFixedValuesToConstantExpressions(node.getCurrentConstraint()).orElse((Map<ImmutableMap, ConstantExpression>)ImmutableMap.of())).entrySet().stream().filter(entry -> !((ConstantExpression)entry.getValue()).isNull()).forEach(entry -> {
                ConstantExpression cfr_ignored_0 = (ConstantExpression)globalConstants.put((ColumnHandle)entry.getKey(), (ConstantExpression)entry.getValue());
            });
            Map<VariableReferenceExpression, ConstantExpression> symbolConstants = globalConstants.entrySet().stream().filter(arg_0 -> Visitor.lambda$visitTableScan$27((Map)assignments, arg_0)).collect(Collectors.toMap(arg_0 -> Visitor.lambda$visitTableScan$28((Map)assignments, arg_0), Map.Entry::getValue));
            properties.constants(symbolConstants);
            properties.global(this.deriveGlobalProperties(layout, (Map<ColumnHandle, VariableReferenceExpression>)assignments, globalConstants));
            ImmutableList constantAppendedLocalProperties = ImmutableList.builder().addAll(globalConstants.keySet().stream().map(ConstantProperty::new).iterator()).addAll(layout.getLocalProperties()).build();
            properties.local(LocalProperties.translate(constantAppendedLocalProperties, arg_0 -> Visitor.lambda$visitTableScan$29((Map)assignments, arg_0)));
            return properties.build();
        }

        @Override
        public ActualProperties visitRemoteSource(RemoteSourceNode node, List<ActualProperties> inputProperties) {
            if (node.getOrderingScheme().isPresent()) {
                return ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).unordered(false).build();
            }
            if (node.isEnsureSourceOrdering()) {
                return ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build();
            }
            return ActualProperties.builder().build();
        }

        private ActualProperties.Global deriveGlobalProperties(TableLayout layout, Map<ColumnHandle, VariableReferenceExpression> assignments, Map<ColumnHandle, ConstantExpression> constants) {
            Optional streamPartitioning = layout.getStreamPartitioningColumns().flatMap(columns -> Visitor.translateToNonConstantSymbols(columns, assignments, constants));
            if (SystemSessionProperties.planWithTableNodePartitioning(this.session) && layout.getTablePartitioning().isPresent()) {
                TableLayout.TablePartitioning tablePartitioning = layout.getTablePartitioning().get();
                ImmutableSet assignmentsAndConstants = ImmutableSet.builder().addAll(assignments.keySet()).addAll(constants.keySet()).build();
                if (assignmentsAndConstants.containsAll(tablePartitioning.getPartitioningColumns())) {
                    List arguments = (List)tablePartitioning.getPartitioningColumns().stream().map(column -> assignments.containsKey(column) ? (RowExpression)assignments.get(column) : (RowExpression)constants.get(column)).collect(ImmutableList.toImmutableList());
                    return ActualProperties.Global.partitionedOn(tablePartitioning.getPartitioningHandle(), arguments, streamPartitioning);
                }
            }
            if (streamPartitioning.isPresent()) {
                return ActualProperties.Global.streamPartitionedOn((List)streamPartitioning.get());
            }
            return ActualProperties.Global.arbitraryPartition();
        }

        private static Optional<List<VariableReferenceExpression>> translateToNonConstantSymbols(Set<ColumnHandle> columnHandles, Map<ColumnHandle, VariableReferenceExpression> assignments, Map<ColumnHandle, ConstantExpression> globalConstants) {
            Set constantsStrippedColumns = (Set)columnHandles.stream().filter(column -> !globalConstants.containsKey(column)).collect(ImmutableSet.toImmutableSet());
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ColumnHandle column2 : constantsStrippedColumns) {
                VariableReferenceExpression translated = assignments.get(column2);
                if (translated == null) {
                    return Optional.empty();
                }
                builder.add((Object)translated);
            }
            return Optional.of(ImmutableList.copyOf((Collection)builder.build()));
        }

        private static /* synthetic */ Optional lambda$visitTableScan$29(Map assignments, ColumnHandle column) {
            return Optional.ofNullable(assignments.get(column));
        }

        private static /* synthetic */ VariableReferenceExpression lambda$visitTableScan$28(Map assignments, Map.Entry entry) {
            return (VariableReferenceExpression)assignments.get(entry.getKey());
        }

        private static /* synthetic */ boolean lambda$visitTableScan$27(Map assignments, Map.Entry entry) {
            return assignments.containsKey(entry.getKey());
        }

        private static /* synthetic */ Optional lambda$visitUnnest$24(Set passThroughInputs, VariableReferenceExpression column) {
            if (passThroughInputs.contains(column)) {
                return Optional.of(column);
            }
            return Optional.empty();
        }
    }
}

