/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class WindowNodeUtil {
    private WindowNodeUtil() {
    }

    public static WindowNode.Frame.WindowType toWindowType(WindowFrame.Type type) {
        switch (type) {
            case RANGE: {
                return WindowNode.Frame.WindowType.RANGE;
            }
            case ROWS: {
                return WindowNode.Frame.WindowType.ROWS;
            }
            case GROUPS: {
                return WindowNode.Frame.WindowType.GROUPS;
            }
        }
        throw new UnsupportedOperationException(String.format("unrecognized window frame type %s", type));
    }

    public static WindowNode.Frame.BoundType toBoundType(FrameBound.Type type) {
        switch (type) {
            case UNBOUNDED_PRECEDING: {
                return WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING;
            }
            case PRECEDING: {
                return WindowNode.Frame.BoundType.PRECEDING;
            }
            case CURRENT_ROW: {
                return WindowNode.Frame.BoundType.CURRENT_ROW;
            }
            case FOLLOWING: {
                return WindowNode.Frame.BoundType.FOLLOWING;
            }
            case UNBOUNDED_FOLLOWING: {
                return WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING;
            }
        }
        throw new UnsupportedOperationException(String.format("unrecognized frame bound type %s", type));
    }

    public static Set<VariableReferenceExpression> extractWindowFunctionUniqueVariables(WindowNode.Function function) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (RowExpression argument : function.getFunctionCall().getArguments()) {
            builder.addAll(VariablesExtractor.extractAll(argument));
        }
        return builder.build();
    }
}

