/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MergeJoinNode
extends InternalPlanNode {
    private final JoinType type;
    private final PlanNode left;
    private final PlanNode right;
    private final List<EquiJoinClause> criteria;
    private final Optional<RowExpression> filter;
    private final List<VariableReferenceExpression> outputVariables;
    private final Optional<VariableReferenceExpression> leftHashVariable;
    private final Optional<VariableReferenceExpression> rightHashVariable;

    @JsonCreator
    public MergeJoinNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") JoinType type, @JsonProperty(value="left") PlanNode left, @JsonProperty(value="right") PlanNode right, @JsonProperty(value="criteria") List<EquiJoinClause> criteria, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="filter") Optional<RowExpression> filter, @JsonProperty(value="leftHashVariable") Optional<VariableReferenceExpression> leftHashVariable, @JsonProperty(value="rightHashVariable") Optional<VariableReferenceExpression> rightHashVariable) {
        this(sourceLocation, id, Optional.empty(), type, left, right, criteria, outputVariables, filter, leftHashVariable, rightHashVariable);
    }

    public MergeJoinNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, JoinType type, PlanNode left, PlanNode right, List<EquiJoinClause> criteria, List<VariableReferenceExpression> outputVariables, Optional<RowExpression> filter, Optional<VariableReferenceExpression> leftHashVariable, Optional<VariableReferenceExpression> rightHashVariable) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.type = Objects.requireNonNull(type, "type is null");
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
        this.criteria = ImmutableList.copyOf((Collection)Objects.requireNonNull(criteria, "criteria is null"));
        this.outputVariables = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.leftHashVariable = Objects.requireNonNull(leftHashVariable, "leftHashVariable is null");
        this.rightHashVariable = Objects.requireNonNull(rightHashVariable, "rightHashVariable is null");
    }

    @JsonProperty
    public JoinType getType() {
        return this.type;
    }

    @JsonProperty
    public PlanNode getLeft() {
        return this.left;
    }

    @JsonProperty
    public PlanNode getRight() {
        return this.right;
    }

    @JsonProperty
    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public Optional<RowExpression> getFilter() {
        return this.filter;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getLeftHashVariable() {
        return this.leftHashVariable;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getRightHashVariable() {
        return this.rightHashVariable;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new MergeJoinNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), this.type, newChildren.get(0), newChildren.get(1), this.criteria, this.outputVariables, this.filter, this.leftHashVariable, this.rightHashVariable);
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new MergeJoinNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.type, this.left, this.right, this.criteria, this.outputVariables, this.filter, this.leftHashVariable, this.rightHashVariable);
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitMergeJoin(this, context);
    }
}

