/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class StatisticAggregationsDescriptor<T> {
    private final Map<String, T> grouping;
    private final Map<TableStatisticType, T> tableStatistics;
    private final List<ColumnStatisticsDescriptor<T>> columnStatistics;

    public static <T> StatisticAggregationsDescriptor<T> empty() {
        return StatisticAggregationsDescriptor.builder().build();
    }

    @JsonCreator
    public StatisticAggregationsDescriptor(@JsonProperty(value="grouping") Map<String, T> grouping, @JsonProperty(value="tableStatistics") Map<TableStatisticType, T> tableStatistics, @JsonProperty(value="columnStatistics") List<ColumnStatisticsDescriptor<T>> columnStatistics) {
        this.grouping = ImmutableMap.copyOf(Objects.requireNonNull(grouping, "grouping is null"));
        this.tableStatistics = ImmutableMap.copyOf(Objects.requireNonNull(tableStatistics, "tableStatistics is null"));
        this.columnStatistics = Objects.requireNonNull(columnStatistics, "columnStatistics is null");
    }

    public StatisticAggregationsDescriptor(Map<String, T> grouping, Map<TableStatisticType, T> tableStatistics, Map<ColumnStatisticMetadata, T> columnStatistics) {
        this(grouping, tableStatistics, (List<ColumnStatisticsDescriptor<T>>)ImmutableList.builder().addAll(columnStatistics.entrySet().stream().map((? super T e) -> new ColumnStatisticsDescriptor((ColumnStatisticMetadata)e.getKey(), e.getValue())).iterator()).build());
    }

    @JsonProperty
    public Map<String, T> getGrouping() {
        return this.grouping;
    }

    @JsonProperty
    public Map<TableStatisticType, T> getTableStatistics() {
        return this.tableStatistics;
    }

    @JsonProperty
    public List<ColumnStatisticsDescriptor<T>> getColumnStatistics() {
        return this.columnStatistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticAggregationsDescriptor that = (StatisticAggregationsDescriptor)o;
        return Objects.equals(this.grouping, that.grouping) && Objects.equals(this.tableStatistics, that.tableStatistics) && Objects.equals(this.columnStatistics, that.columnStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.grouping, this.tableStatistics, this.columnStatistics);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("grouping", this.grouping).add("tableStatistics", this.tableStatistics).add("columnStatistics", this.columnStatistics).toString();
    }

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    public <T2> StatisticAggregationsDescriptor<T2> map(Function<T, T2> mapper) {
        return new StatisticAggregationsDescriptor<T2>(StatisticAggregationsDescriptor.map(this.getGrouping(), mapper), StatisticAggregationsDescriptor.map(this.getTableStatistics(), mapper), StatisticAggregationsDescriptor.map((Map)this.getColumnStatistics().stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticsDescriptor::getMetadata, ColumnStatisticsDescriptor::getItem)), mapper));
    }

    private static <K, V1, V2> Map<K, V2> map(Map<K, V1> input, Function<V1, V2> mapper) {
        return (Map)input.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> mapper.apply(entry.getValue())));
    }

    public static class ColumnStatisticsDescriptor<T> {
        private final ColumnStatisticMetadata metadata;
        private final T item;

        @JsonCreator
        public ColumnStatisticsDescriptor(@JsonProperty(value="metadata") ColumnStatisticMetadata metadata, @JsonProperty(value="item") T item) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.item = Objects.requireNonNull(item, "item is null");
        }

        @JsonProperty
        public T getItem() {
            return this.item;
        }

        @JsonProperty
        public ColumnStatisticMetadata getMetadata() {
            return this.metadata;
        }

        public int hashCode() {
            return Objects.hash(this.metadata, this.item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ColumnStatisticsDescriptor)) {
                return false;
            }
            ColumnStatisticsDescriptor other = (ColumnStatisticsDescriptor)o;
            return this.metadata.equals((Object)other.metadata) && this.item.equals(other.item);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("metadata", (Object)this.metadata).add("item", this.item).toString();
        }
    }

    public static class Builder<T> {
        private final ImmutableMap.Builder<String, T> grouping = ImmutableMap.builder();
        private final ImmutableMap.Builder<TableStatisticType, T> tableStatistics = ImmutableMap.builder();
        private final ImmutableMap.Builder<ColumnStatisticMetadata, T> columnStatistics = ImmutableMap.builder();

        public void addGrouping(String column, T key) {
            this.grouping.put((Object)column, key);
        }

        public void addTableStatistic(TableStatisticType type, T key) {
            this.tableStatistics.put((Object)type, key);
        }

        public void addColumnStatistic(ColumnStatisticMetadata statisticMetadata, T key) {
            this.columnStatistics.put((Object)statisticMetadata, key);
        }

        public StatisticAggregationsDescriptor<T> build() {
            return new StatisticAggregationsDescriptor(this.grouping.build(), this.tableStatistics.build(), this.columnStatistics.build());
        }
    }
}

