/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StatisticsWriterNode
extends InternalPlanNode {
    private final PlanNode source;
    private final TableHandle tableHandle;
    private final VariableReferenceExpression rowCountVariable;
    private final boolean rowCountEnabled;
    private final StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor;

    @JsonCreator
    public StatisticsWriterNode(@JsonProperty(value="sourceLocation") Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="tableHandle") TableHandle tableHandle, @JsonProperty(value="rowCountVariable") VariableReferenceExpression rowCountVariable, @JsonProperty(value="rowCountEnabled") boolean rowCountEnabled, @JsonProperty(value="descriptor") StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor) {
        this(sourceLocation, id, Optional.empty(), source, tableHandle, rowCountVariable, rowCountEnabled, descriptor);
    }

    public StatisticsWriterNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, TableHandle tableHandle, VariableReferenceExpression rowCountVariable, boolean rowCountEnabled, StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.source = Objects.requireNonNull(source, "source is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.rowCountVariable = Objects.requireNonNull(rowCountVariable, "rowCountVariable is null");
        this.rowCountEnabled = rowCountEnabled;
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public TableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public StatisticAggregationsDescriptor<VariableReferenceExpression> getDescriptor() {
        return this.descriptor;
    }

    @JsonProperty
    public VariableReferenceExpression getRowCountVariable() {
        return this.rowCountVariable;
    }

    @JsonProperty
    public boolean isRowCountEnabled() {
        return this.rowCountEnabled;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return ImmutableList.of((Object)this.rowCountVariable);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new StatisticsWriterNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), (PlanNode)Iterables.getOnlyElement(newChildren), this.tableHandle, this.rowCountVariable, this.rowCountEnabled, this.descriptor);
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new StatisticsWriterNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.tableHandle, this.rowCountVariable, this.rowCountEnabled, this.descriptor);
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitStatisticsWriterNode(this, context);
    }
}

